<?php

/**
 * Created by JetBrains PhpStorm.
 * User: thomas
 * Date: 10/29/15
 * Time: 10:26 PM
 * To change this template use File | Settings | File Templates.
 */
class Crud_pdo extends PDO
{
    //class crud extends PDO{
    private $engine;
    private $host;
    private $database;
    private $user;
    private $pass;
    protected $error_msg = array();
    protected $beginCommit;

    private $result;

    public function __construct()
    {
        $this->engine = 'mysql';
        $this->host = 'localhost';
        $this->database = 'ds_manado_00';
        $this->user = 'admin';
        $this->pass = 'mayanet619955';

        $dns = $this->engine . ':dbname=' . $this->database . ";host=" . $this->host;
        parent::__construct($dns, $this->user, $this->pass);
        //        $pdo = new PDO("mysql:host=$host;dbname=$db", $user, $pass);
        //        $pdo = new PDO($dns, $this->user, $this->pass);
        $this->set_error($this->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION));
        //        $this->set_error($this->error_msg);
    }


    /*
    * Insert values into the table
    */
    public function insert($table, $rows = null)
    {
        $command = 'INSERT INTO ' . $table;
        $row = null;
        $value = null;
        foreach ($rows as $key => $nilainya) {
            $row .= "," . $key;
            $value .= ", :" . $key;
        }

        $command .= "(" . substr($row, 1) . ")";
        $command .= "VALUES(" . substr($value, 1) . ")";


        $stmt = parent::prepare($command);
        $x = $stmt->execute($rows);
        if ($x) {
            $rowcount = $stmt->rowCount();

            return $rowcount;
        }
        else {
            // $this->set_error($query->errorInfo());
            $this->set_error($stmt->errorInfo()[2] . " on: " . __FUNCTION__ . " $table");

            return false;
        }
    }

    /*
    * Delete records from the database.
    */
    public function delete($tabel, $where = null)
    {
        $command = 'DELETE FROM ' . $tabel;

        $list = Array();
        $parameter = null;
        foreach ($where as $key => $value) {
            $list[] = "$key = :$key";
            $parameter .= ', ":' . $key . '":"' . $value . '"';
        }
        $command .= ' WHERE ' . implode(' AND ', $list);

        $json = "{" . substr($parameter, 1) . "}";
        $param = json_decode($json, true);

        $query = parent::prepare($command);
        $query->execute($param);
        $rowcount = $query->rowCount();

        return $rowcount;
    }

    /*
    * Uddate Record
    */
    public function update($tabel, $fild = null, $where = null)
    {
        $update = 'UPDATE ' . $tabel . ' SET ';
        $set = null;
        $value = null;
        foreach ($fild as $key => $values) {
            $set .= ', ' . $key . ' = :' . $key;
            $value .= ', ":' . $key . '":"' . $values . '"';
        }
        $update .= substr(trim($set), 1);
        $json = '{' . substr($value, 1) . '}';
        $param = json_decode($json, true);

        if ($where != null) {
            $update .= ' WHERE ' . $where;
        }

        $query = parent::prepare($update);
        $query->execute($param);
        $rowcount = $query->rowCount();

        return $rowcount;
    }


    /*
    * Selects information from the database.
    */
    public function select($table, $rows, $where = null, $order = null, $limit = null)
    {
        $command = 'SELECT ' . $rows . ' FROM ' . $table;
        if ($where != null) $command .= ' WHERE ' . $where;
        if ($order != null) $command .= ' ORDER BY ' . $order;
        if ($limit != null) $command .= ' LIMIT ' . $limit;

        $query = parent::prepare($command);
        $x = $query->execute();

        if ($x) {
            $posts = array();
            while ($row = $query->fetch(PDO::FETCH_ASSOC)) {
                $posts[] = $row;
            }

            // return $this->result = json_encode(array('post' => $posts));
            return $this->result = $posts;
        }
        else {
            // $this->set_error($query->errorInfo());
            $this->set_error($query->errorInfo()[2]);

            return false;
        }
    }

    /*
    * Returns the result set
    */
    public function getResult()
    {
        $jData = count($this->result);
        if ($jData > 0) {
            return $this->result;
        }
        else {
            return array();
        }
    }

    /**/
    // Fungsi untuk menampung error selama pengoperasian
    //    protected function set_error($msg)
    public function set_error($msg)
    {
        if (is_array($msg)) {
            foreach ($msg as $val) {
                $this->error_msg[] = $msg;
            }
        }
        else $this->error_msg[] = $msg;
    }

    // Fungsi untuk memunculkan pesan error selama pengoperasian
    function display_errors($open = '-', $close = '<br/><br/>')
    {
        if (count($this->error_msg) == 0) return false;
        $str = '';
        foreach ($this->error_msg as $val) {
            $str .= $val . $close . "<b>detile:</b><br>" . $open;
        }

        $html_msg = '
					<div style="border: 1px solid red; font-size: 9pt; font-family: monospace; color: red; padding: .5em; margin: 8px; -moz-border-radius:4px;border-radius:4px;-webkit-border-radius:4px;background-color: #FFE2E2;">
						<span style="font-weight: bold">Error Message:</span><br>' . $str . '
					</div>';
        echo $html_msg;

    }

    // commit
    public function autoCommit($xx)
    {
        try {

            $this->beginTransaction();

            $xx;

            $this->commit();
        } catch (Exception $e) {

            $this->rollBack();
            //    echo "Failed: " . $e->getMessage();
            $this->set_error($e->getMessage());
            //            $db->display_errors("line: " . __LINE__ . " on file:" . __FILE__);
        }

    }

}
