<?php

session_start();

include_once "cli_path.php";

$start_time = begin_time();

class CProgress
{

    private $entries = array();

    function __construct($entries)
    {

        $this->entries = $entries;
        echo "<script>";
        if (sizeof($this->entries) > 0) {
            foreach ($this->entries as $e) {
                echo "
                        top.document.getElementById('progress').innerHTML+=\"<div>$e <span id='prog_$e' style='width:800px;border:1px #666666 solid;display:block;background:#cccccc;height:28px;'></span></div>\";
                ";
            }
        }
        else {
            echo "
                    top.document.getElementById('progress').innerHTML+='Tidak ada yang mau diukur.';
                ";
        }
        echo "</script>";
        flush();
        ob_flush();
    }

}

$env = php_sapi_name();

function addOutput($text, $replace = false)
{
    global $env;

    switch ($env) {
        case "apache2handler": //===berarti web,bukan CLI

            echo "<script>\n";

            if ($replace) {
                echo "top.document.getElementById('detail').innerHTML='" . addslashes("$text") . "'+'<br>';\n";
            }
            else {
                echo "top.document.getElementById('detail').innerHTML+='" . addslashes("$text") . "'+'<br>';\n";
            }

            echo "var objDiv = top.document.getElementById('detail');";
            echo "objDiv.scrollTop = objDiv.scrollHeight;";

            echo "</script>\n";
            flush();
            ob_flush();
            break;
        case "cli":
            //echo "run from CLI<br>";
            fwrite(STDOUT, $text . "\n");
            break;
        default:
            //echo "run from unidentified environment<br>";
            break;
    }
}

function updateProgress($progName, $into)
{
    global $env;

    switch ($env) {
        case "apache2handler": //===berarti web,bukan CLI

            echo "<script>\n";
            if ($into > 0) {
                $divLength = ($into * 8);
                //echo "top.document.getElementById('prog_$progName').innerHTML=\"<div style'width:".$divLength."px;height:10px;color:blue;'>X</div>\";";
                echo "top.document.getElementById('prog_$progName').innerHTML=\"<div style=\'width:" . $divLength . "px;height:28px;background:#0056cd;color:white;\'>$into %</div>\";";
            }

            echo "</script>\n";
            flush();
            ob_flush();
            break;
        case "cli":
            //echo "run from CLI<br>";
            fwrite(STDOUT, $into . "%\n");
            break;
        default:
            //echo "run from unidentified environment<br>";
            break;
    }
}

function updateTime($sTime)
{
    global $env;
    switch ($env) {
        case "apache2handler": //===berarti web,bukan CLI

            echo "<script>\n";

            echo "top.document.getElementById('sTime').innerHTML='" . addslashes("$sTime") . "';\n";

            echo "</script>\n";
            flush();
            ob_flush();
            break;
        case "cli":
            //echo "run from CLI<br>";
            fwrite(STDOUT, $sTime . "\n");
            break;
    }
}

addOutput(date("H:i:s") . " proses dimulai");

$r = New Reporting();
$t = New Transaksi();
$j = New Jurnal();
$m = New Mutasi();
$d = New Data();
$ff = New Fifo();
$v = New Validasi();
$c = New Crud();

//header("refresh:10"); // refresh per 10 detik

$db1 = New _01_DBclass();
!$db1->connect() ? die($db1->display_errors()) : "";
$cb_id_pusat = CB_ID_PUSAT;
$get_id = $_GET['id'] = 156;

if ((isset($_GET['id'])) && ($_GET['id'] > 0)) {
    addOutput("ada GET ID nya :) " . $_GET['id']);
    //  commit pembuka
    $db1->beginCommit();

    //    $id = "id='$get_id' and ";
    $id = "id='$get_id'";
    $sinkron = "";
}
else {
    //    $id = "id>'68151' and ";
    $sinkron = "sinkron='0'";
}

// region cabang_alt
$cb = new Cabang();
$arrCb = $cb->callCabang(array("nama" => "pusat"));
//            arrPrint($arrCb);
$cabang_alt = $arrCb['id'];
// endregion cabang_alt
//  region waktu eksekusi awal
$mtime = microtime();
$mtime = explode(" ", $mtime);
$mtime = $mtime[1] + $mtime[0];
$starttime = $mtime;
//cekHere("$starttime - $mtime");
//  endregion waktu eksekusi awal
//  region transaksi
$tbl = "transaksi";
//$id = "id>='79397' and ";
//$jenis = "jenis='776r' and ";
$conditional = "where $jenis $id $sinkron order by id asc limit 1";
//mati_disini("$conditional");
$sql = "SHOW COLUMNS FROM $tbl";
$arrColumns = $db1->get_columns($sql);

//  transaksi
$q = "select * from $tbl $conditional";
//die($q);

addOutput("$q");
$x = $db1->select($q);
$rows = $db1->select($q, true);
if ($rows > 0) {
    $l = $db1->get_row($x);
    $transaksi_id_0 = $transaksi_id = $l->id;
    foreach ($arrColumns as $colm_name) {
        $arrTransaksi[$colm_name] = $l->$colm_name;
    }
    addOutput("ID: " . $l->id . "<hr>");
    //  transaksi data
    $arrTransaksiData = $t->getTransaksiChild($transaksi_id);
}
else {
    addOutput("Tak kenal ID-nya<hr>");
    $arrTransaksi = array();
    $arrTransaksiData = array();
}
cekHere("transaksi_id = $transaksi_id_0");
//  endregion transaksi
//  region switch diluar kommit
$transaksi_jenis_0 = $arrTransaksi['jenis'];
$cabang_id = $arrTransaksi['cabang_id'];
$transaksi_nomer = $arrTransaksi['nomer'];
switch ($transaksi_jenis_0) {
    case "776r":
        //  region update transaksi yang diambil

        $pr = new CProgress(array(
            "indeksFIFO_bahan", //"indeksFIFO_produk",
            "updateFIFO_bahan",
            "updateFIFO_produk",
            "updateChildTransaksi_produk",
            "updateChildTransaksi_bahan"
        ));
        $arrUpdate = array();
        //  region cek kebutuhan bahan dengan bahan yang tersedia
        $arrTransaksiChildProduk = $t->getTransaksiChild($transaksi_id, "and produk_jenis='produk'");
        $arrTransaksiChildBahan = $t->getTransaksiChild($transaksi_id, "and produk_jenis='bahan'");
        if (count($arrTransaksiChildProduk) > 0) {
            foreach ($arrTransaksiChildProduk as $arrTransaksiChildProdukData) {
                $produk_id = $arrTransaksiChildProdukData['produk_id'];
                $produk_ord_jml = $arrTransaksiChildProdukData['produk_ord_jml'];
                $arrKomposisi = $d->getProdukKomposisi($produk_id);

                foreach ($arrKomposisi as $arrKomposisiData) {
                    $produk_id_komposisi = $arrKomposisiData['produk_dasar_id'];
                    $produk_jml_komposisi = $arrKomposisiData['jml'];
                    $produk_dasar_butuh = $produk_jml_komposisi * $produk_ord_jml;

                    $arrProdukDasarButuh[$produk_id_komposisi] += $produk_dasar_butuh;
                }
            }
            //            print_r($arrProdukDasarButuh);
        }
        if (count($arrTransaksiChildBahan) > 0) {
            foreach ($arrTransaksiChildBahan as $arrTransaksiChildBahanData) {
                $produk_id = $arrTransaksiChildBahanData['produk_id'];
                $produk_qtt = $arrTransaksiChildBahanData['produk_ord_jml'];

                $arrBahanKebutuhan[$produk_id] = $produk_qtt;
            }
            $arrBahanKurangId = array();
            $arrBahanKurangNama = array();
            $arrBahanKurangQtt = array();
            foreach ($arrBahanKebutuhan as $produk_id => $produk_qtt) {
                $bahan_nama = $d->getBahanData($produk_id)['nama'];

                $bahan_qtt_komposisi = $arrProdukDasarButuh[$produk_id];
                if ($produk_qtt != $bahan_qtt_komposisi) {
                    $arrBahanDasarBeda[] = $produk_id;
                }

                $q_1 = "select produk_nama, unit_af from rek_cache_pembantu_barang where produk_id='$produk_id' and cabang_id='$cabang_id' and periode='forever'";
                $x_1 = $db1->select($q_1);
                $r_1 = $db1->select($q_1, true);
                if ($r_1 > 0) {
                    $l_1 = $db1->get_row($x_1);
                    $bahan_cache = $l_1->unit_af;
                }
                else {
                    $bahan_cache = 0;
                }
                if ($bahan_cache < $produk_qtt) {
                    $kekurangan = $produk_qtt - $bahan_cache;
                    $arrBahanKurangId[] = $produk_id;
                    $arrBahanKurangNama[] = $bahan_nama;
                    $arrBahanKurangQtt[] = $kekurangan;
                }
            }
            if (count($arrBahanKurangId) > 0) {
                foreach ($arrBahanKurangId as $x => $bahan_id) {
                    $bahan_nama = $arrBahanKurangNama[$x];
                    $kekurangan = $arrBahanKurangQtt[$x];
                    if ($hasil == "") {
                        $hasil = "$bahan_nama kurang $kekurangan";
                    }
                    else {
                        $hasil = "$hasil, $bahan_nama kurang $kekurangan";
                    }
                    //                    createLog("order produksi (id: $transaksi_id) nomor $transaksi_nomer, kurang bahan ($bahan_id) $bahan_nama: $kekurangan", "dev");
                    //                    cekHere("log: order produksi (id: $transaksi_id_0) nomor $transaksi_nomer_0, kurang bahan ($bahan_id) $bahan_nama: $kekurangan");
                }
                $msg = "tr_id: $transaksi_id, nomer: $transaksi_nomer, order produksi kekurangan bahan";
                createLog("$msg", "dev");

                $arrUpdate = array(
                    "status" => "4",
                    "sinkron" => "9"
                );
                $t->setTransaksionalId($transaksi_id);
                $t->setTransaksional($arrUpdate, false);
                addOutput("kekurangan bahan [$hasil]");
                die("kekurangan bahan [$hasil]");
            }
            elseif (count($arrBahanDasarBeda) > 0) {
                $msg = "tr_id: $transaksi_id, nomer: $transaksi_nomer, qtt bahan dasar berbeda dengan qtt bahan dasar dari komposisi";
                createLog("$msg", "dev", "$transaksi_id");

                $arrUpdate = array(
                    //                    "status" => "4",
                    "sinkron" => "11"
                );
                $t->setTransaksionalId($transaksi_id);
                $t->setTransaksional($arrUpdate, false);
                addOutput("array komposisi bahan qtt != array transaksi data bahan qtt");
            }
        }
        //  endregion cek kebutuhan bahan dengan bahan yang tersedia
        //        mati_disini("($transaksi_jenis_0) stoppp dulu..");

        $count_produk = count($arrTransaksiChildProduk);
        $count_bahan = count($arrTransaksiChildBahan);

        if ($transaksi_status == 1) {
            addOutput(__LINE__ . "<br>order produksi sudah tidak valid untuk transaksi: $transaksi_id_0, $transaksi_nomer_0");
            die();
        }
        elseif (($count_produk == 0) && ($count_bahan == 0)) {
            $arrUpdate = array(
                "sinkron" => "9"
            );
            $t->setTransaksionalId($transaksi_id);
            $t->setTransaksional($arrUpdate, false);
            addOutput("$transaksi_id_0 # order produksi kosong");
            die();
        }
        else {
            $dtime_now = dtimeNow();
            $arrUpdate = array(
                "status" => "2",
                "approvals_dtime" => $dtime_now,
            );
            $t->setTransaksionalId($transaksi_id_0);
            $t->setTransaksional($arrUpdate, false);
        }
        //  endregion update transaksi yang diambil
        //  region ketemu trash 1, sinkron 1
        $transaksi_trash = $arrTransaksi['trash'];
        if ($transaksi_trash == 1) {
            $arrUpdate = array(
                "sinkron" => "1",
            );
            $t->setTransaksionalId($transaksi_id_0);
            $t->setTransaksional($arrUpdate, false);
        }
        //  endregion ketemu trash 1, sinkron 1
        break;
    case "583r":
        $transaksi_id = $arrTransaksi['id'];
        $referensi_id = $arrTransaksi['referensi_id'];
        $status_c = $arrTransaksi['status'];
        $trash_c = $arrTransaksi['trash'];
        if (($status_c != 1) && ($trash_c == 1)) {
            //  dibatalkan dari ui, sinkron dinyatakn 1
            $msg = "tr_id: $transaksi_id, nomer: $transaksi_nomer, sudah dibatalkan dari ui";
            createLog("$msg", "dev", "$transaksi_id");

            $q_1 = "update transaksi set sinkron='1' where id='$transaksi_id'";
            $x_1 = $db1->run_sql($q_1, true);
            !$x_1 ? die($db1->display_errors(__FILE__ . " on line " . __LINE__)) : "";
            addOutput(__LINE__ . " tr_id: $transaksi_id, nomer: $transaksi_nomer, dibatalkan di UI");
            die();
        }
        else {
            //  dieksekusi di cli
            $arrTransaksiChildRef = $t->getTransaksiChild($transaksi_id);
            if (count($arrTransaksiChildRef) > 0) {
                foreach ($arrTransaksiChildRef as $arrTransaksiChildRefData) {
                    $produk_nama = $arrTransaksiChildRefData['produk_nama'];
                    $produk_id = $arrTransaksiChildRefData['produk_id'];
                    $produk_qtt = $arrTransaksiChildRefData['produk_ord_jml'];

                    $arrProdukTransaksiData[$produk_id] += $produk_qtt;
                    $arrProdukTransaksiNama[$produk_id] = $produk_nama;
                }
                foreach ($arrProdukTransaksiData as $produk_id => $produk_qtt_1) {
                    $q = "select * from rek_cache_pembantu_produk where produk_id='$produk_id' and cabang_id='$cb_id_pusat' and periode='forever'";
                    $x = $db1->select($q);
                    $r = $db1->select($q, true);
                    if ($r > 0) {
                        $l = $db1->get_row($x);
                        $produk_qtt_cache = $l->unit_af;
                    }
                    else {
                        $produk_qtt_cache = 0;
                    }
                    $arrProdukStokQtt[$produk_id] = $produk_qtt_cache;
                    if ($produk_qtt_cache < $produk_qtt_1) {
                        $arrProdukKurang[] = $produk_id;
                    }
                }
                if (count($arrProdukKurang) > 0) {
                    foreach ($arrProdukKurang as $produk_id) {
                        $produk_nama = $arrProdukTransaksiNama[$produk_id];
                        $produk_distribusi_qtt = $arrProdukTransaksiData[$produk_id];
                        $produk_stok_qtt = $arrProdukStokQtt[$produk_id];
                        $kekurangan = $produk_distribusi_qtt - $produk_stok_qtt;

                        if ($hasil == "") {
                            $hasil = "$produk_id $produk_nama ($kekurangan)";
                        }
                        else {
                            $hasil = "$hasil, $produk_id $produk_nama ($kekurangan)";
                        }
                    }
                    $msg = "tr_id: $transaksi_id, nomer: $transaksi_nomer, stok produk distribusi kurang, $hasil";
                    createLog("$msg", "dev", "$transaksi_id");

                    $q_1 = "update transaksi set sinkron='9' where id='$transaksi_id'";
                    $x_1 = $db1->run_sql($q_1, true);
                    !$x_1 ? die($db1->display_errors(__FILE__ . " on line " . __LINE__)) : "";
                    mati_disini(__LINE__ . " stop kurang produk");
                }
            }
        }


        break;
    case "582":
        $transaksi_id = $arrTransaksi['id'];
        $referensi_id = $arrTransaksi['referensi_id'];
        $transaksi_cabang_id = $arrTransaksi['cabang_id'];

        //        if ($transaksi_cabang_id == 0) {
        //            $msg = "tr_id: $transaksi_id, nomer: $transaksi_nomer, cabang_id terdeteksi 0, transaksi tidak bisa dilanjutkan.";
        //            createLog("$msg", "dev", "$transaksi_id");
        //
        //            $q_1 = "update transaksi set sinkron='11' where id='$transaksi_id'";
        //            $x_1 = $db1->run_sql($q_1, true);
        //            !$x_1 ? die($db1->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        //            mati_disini();
        //        }

        $arrTransaksiChildRef = $t->getTransaksiChild($transaksi_id);
        if (count($arrTransaksiChildRef) > 0) {
            foreach ($arrTransaksiChildRef as $arrTransaksiChildRefData) {
                $produk_nama = $arrTransaksiChildRefData['produk_nama'];
                $produk_id = $arrTransaksiChildRefData['produk_id'];
                $produk_qtt = $arrTransaksiChildRefData['produk_ord_jml'];

                $arrProdukTransaksiData[$produk_id] += $produk_qtt;
                $arrProdukTransaksiNama[$produk_id] = $produk_nama;
            }
            foreach ($arrProdukTransaksiData as $produk_id => $produk_qtt_1) {
                $q = "select * from rek_cache_pembantu_produk where produk_id='$produk_id' and cabang_id='$cabang_id' and periode='forever'";
                $x = $db1->select($q);
                $r = $db1->select($q, true);
                if ($r > 0) {
                    $l = $db1->get_row($x);
                    $produk_qtt_cache = $l->unit_af;
                }
                else {
                    $produk_qtt_cache = 0;
                }
                $arrProdukStokQtt[$produk_id] = $produk_qtt_cache;
                if ($produk_qtt_cache < $produk_qtt_1) {
                    $arrProdukKurang[] = $produk_id;
                }
            }
            if (count($arrProdukKurang) > 0) {
                foreach ($arrProdukKurang as $produk_id) {
                    $produk_nama = $arrProdukTransaksiNama[$produk_id];
                    $produk_distribusi_qtt = $arrProdukTransaksiData[$produk_id];
                    $produk_stok_qtt = $arrProdukStokQtt[$produk_id];
                    $kekurangan = $produk_distribusi_qtt - $produk_stok_qtt;

                    if ($hasil == "") {
                        $hasil = "$produk_id $produk_nama (jml: $produk_distribusi_qtt, stok: $produk_stok_qtt, kurang: $kekurangan)";
                    }
                    else {
                        $hasil = "$hasil, $produk_id $produk_nama (jml: $produk_distribusi_qtt, stok: $produk_stok_qtt, kurang: $kekurangan)";
                    }
                }
                $msg = "tr_id: $transaksi_id, nomer: $transaksi_nomer, stok produk untuk penjualan kurang (cabang $cabang_id), $hasil";
                createLog("$msg", "dev", "$transaksi_id");

                $q_1 = "update transaksi set sinkron='9' where id='$transaksi_id'";
                $x_1 = $db1->run_sql($q_1, true);
                !$x_1 ? die($db1->display_errors(__FILE__ . " on line " . __LINE__)) : "";
                addOutput("$msg");
                mati_disini("$msg");
            }
        }
        break;
    case "967":
        $transaksi_id = $arrTransaksi['id'];
        $referensi_id = $arrTransaksi['referensi_id'];

        $arrTransaksiChildRef = $t->getTransaksiChild($transaksi_id);
        if (count($arrTransaksiChildRef) > 0) {
            foreach ($arrTransaksiChildRef as $arrTransaksiChildRefData) {
                $produk_nama = $arrTransaksiChildRefData['produk_nama'];
                $produk_id = $arrTransaksiChildRefData['produk_id'];
                $produk_qtt = $arrTransaksiChildRefData['produk_ord_jml'];

                $arrProdukTransaksiData[$produk_id] += $produk_qtt;
                $arrProdukTransaksiNama[$produk_id] = $produk_nama;
            }
            foreach ($arrProdukTransaksiData as $produk_id => $produk_qtt_1) {
                $q = "select * from rek_cache_pembantu_barang where produk_id='$produk_id' and cabang_id='$cb_id_pusat' and periode='forever'";
                $x = $db1->select($q);
                $r = $db1->select($q, true);
                if ($r > 0) {
                    $l = $db1->get_row($x);
                    $produk_qtt_cache = $l->unit_af;
                }
                else {
                    $produk_qtt_cache = 0;
                }
                $arrProdukStokQtt[$produk_id] = $produk_qtt_cache;
                if ($produk_qtt_cache < $produk_qtt_1) {
                    $arrProdukKurang[] = $produk_id;
                }
            }
            if (count($arrProdukKurang) > 0) {
                foreach ($arrProdukKurang as $produk_id) {
                    $produk_nama = $arrProdukTransaksiNama[$produk_id];
                    $produk_distribusi_qtt = $arrProdukTransaksiData[$produk_id];
                    $produk_stok_qtt = $arrProdukStokQtt[$produk_id];
                    $kekurangan = $produk_distribusi_qtt - $produk_stok_qtt;

                    if ($hasil == "") {
                        $hasil = "$produk_id $produk_nama ($kekurangan)";
                    }
                    else {
                        $hasil = "$hasil, $produk_id $produk_nama ($kekurangan)";
                    }
                }
                $msg = "tr_id: $transaksi_id, nomer: $transaksi_nomer, stok bahan untuk return pembelian kurang, $hasil";
                createLog("$msg", "dev", "$transaksi_id");

                $q_1 = "update transaksi set sinkron='9' where id='$transaksi_id'";
                $x_1 = $db1->run_sql($q_1, true);
                !$x_1 ? die($db1->display_errors(__FILE__ . " on line " . __LINE__)) : "";
                addOutput($msg);
                die();
            }
        }
        break;
    case "983":
        $transaksi_id = $arrTransaksi['id'];
        $referensi_id = $arrTransaksi['referensi_id'];

        $arrTransaksiChildRef = $t->getTransaksiChild($transaksi_id);
        if (count($arrTransaksiChildRef) > 0) {
            foreach ($arrTransaksiChildRef as $arrTransaksiChildRefData) {
                $produk_nama = $arrTransaksiChildRefData['produk_nama'];
                $produk_id = $arrTransaksiChildRefData['produk_id'];
                $produk_qtt = $arrTransaksiChildRefData['produk_ord_jml'];

                $arrProdukTransaksiData[$produk_id] += $produk_qtt;
                $arrProdukTransaksiNama[$produk_id] = $produk_nama;
            }
            foreach ($arrProdukTransaksiData as $produk_id => $produk_qtt_1) {
                $q = "select * from rek_cache_pembantu_produk where produk_id='$produk_id' and cabang_id='$cabang_id' and periode='forever'";
                $x = $db1->select($q);
                $r = $db1->select($q, true);
                if ($r > 0) {
                    $l = $db1->get_row($x);
                    $produk_qtt_cache = $l->unit_af;
                }
                else {
                    $produk_qtt_cache = 0;
                }
                $arrProdukStokQtt[$produk_id] = $produk_qtt_cache;
                if ($produk_qtt_cache < $produk_qtt_1) {
                    $arrProdukKurang[] = $produk_id;
                }
            }
            if (count($arrProdukKurang) > 0) {
                foreach ($arrProdukKurang as $produk_id) {
                    $produk_nama = $arrProdukTransaksiNama[$produk_id];
                    $produk_distribusi_qtt = $arrProdukTransaksiData[$produk_id];
                    $produk_stok_qtt = $arrProdukStokQtt[$produk_id];
                    $kekurangan = $produk_distribusi_qtt - $produk_stok_qtt;

                    if ($hasil == "") {
                        $hasil = "$produk_id $produk_nama ($kekurangan)";
                    }
                    else {
                        $hasil = "$hasil, $produk_id $produk_nama ($kekurangan)";
                    }
                }
                $msg = "tr_id: $transaksi_id, nomer: $transaksi_nomer, stok produk untuk return distribusi kurang dari cabang $cabang_id, $hasil";
                createLog("$msg", "dev", "$transaksi_id");

                $q_1 = "update transaksi set sinkron='9' where id='$transaksi_id'";
                $x_1 = $db1->run_sql($q_1, true);
                !$x_1 ? die($db1->display_errors(__FILE__ . " on line " . __LINE__)) : "";
                addOutput(__LINE__ . " # terdeteksi stok kurang");
                die();
            }
        }
        break;
    case "982":
        //  cek nota penjualannya
        $transaksi_id = $arrTransaksi['id'];
        $transaksi_nilai_982 = $arrTransaksi['transaksi_nilai'];
        $transaksi_pembayaran_982 = $arrTransaksi['pembayaran'];
        $transaksi_id_982r = $arrTransaksi['referensi_id'];
        $transaksi_id_582 = $t->getTransaksiData($transaksi_id_982r)['referensi_id'];
        $transaksi_status_jenis = $t->getTransaksiData($transaksi_id_582)['jenis'];
        $transaksi_status_582 = $t->getTransaksiData($transaksi_id_582)['status'];
        $transaksi_child_982 = $t->getTransaksiChild($transaksi_id);

        //        $q = "select after_saldo from rek_cache where rekening='kas' and periode='forever' and cabang_id='$cabang_id'";
        $q = "select rekening,after_saldo from rek_cache where periode='forever' and cabang_id='$cabang_id'";
        $x = $db1->select($q);
        //        $l = $db1->get_row($x);
        //        $kas_cabang = $l->after_saldo;
        while ($l = $db1->get_row($x)) {
            $rekening = $l->rekening;
            $after_saldo = $l->after_saldo;
            $arrRekeningCabang[$rekening] = $after_saldo;
        }
        $kas_cabang = isset($arrRekeningCabang['kas']) ? $arrRekeningCabang['kas'] : 0;
        if ($transaksi_status_582 == 1) {
            //  berarti piutang nota ini sudah dibayar lunas, cek kas dulu

            if ($kas_cabang < $transaksi_nilai_982) {
                $msg = "tr_id: $transaksi_id, nomer: $transaksi_nomer, return penjualan (tunai) gagal karena kas kurang cabang $cabang_id";
                createLog("$msg", "dev", "$transaksi_id");

                $q_1 = "update transaksi set sinkron='9' where id='$transaksi_id'";
                //                $x_1 = $db1->run_sql($q_1, true);
                //                !$x_1 ? die($db1->display_errors(__FILE__ . " on line " . __LINE__)) : "";
                //                mati_disini(__LINE__ . " # terdeteksi kas kurang<br>$msg<br>$q_1");
            }
        }

        //  region validasi hpp + pembayaran
        $hpp_neraca_cabang = $arrRekeningCabang['hpp'];
        $piutang_dagang_neraca_cabang = $arrRekeningCabang['piutang dagang'];
        if ($transaksi_pembayaran == "kredit") {
            $validasi_tk2 = $piutang_dagang_neraca_cabang - $transaksi_nilai_982;
        }
        if (count($transaksi_child_982) > 0) {
            $produk_hpp_nilai_total = 0;
            foreach ($transaksi_child_982 as $transaksi_child_982Data) {
                $produk_hpp = $transaksi_child_982Data['hpp'];
                $produk_qtt = $transaksi_child_982Data['produk_ord_jml'];

                $produk_hpp_nilai = $produk_hpp * $produk_qtt;
                $produk_hpp_nilai_total += $produk_hpp_nilai;
            }
            if ($hpp_neraca_cabang < $produk_hpp_nilai_total) {
                $selisih = $hpp_neraca_cabang - $produk_hpp_nilai_total;
                $msg = "tr_id: $transaksi_id, nomer: $transaksi_nomer, hpp neraca cabang $cabang_id kurang dari hpp nota return penjualan ($hpp_neraca_cabang < $produk_hpp_nilai_total # $selisih)";
            }
            elseif ($validasi_tk2 < 0) {
                $msg = "tr_id: $transaksi_id, nomer: $transaksi_nomer, piutang dagang neraca cabang $cabang_id kurang dari piutang dagang nota ($piutang_dagang_neraca_cabang < $transaksi_nilai_982)";
            }
            createLog("$msg", "dev", "$transaksi_id");

            $q_1 = "update transaksi set sinkron='9' where id='$transaksi_id'";
            //            $x_1 = $db1->run_sql($q_1, true);
            //            !$x_1 ? die($db1->display_errors(__FILE__ . " on line " . __LINE__)) : "";
            //            addOutput(__LINE__ . " <br>$msg<br>$q_1");
        }
        else {
            addOutput("# setooopp cekcus #");
            die();
        }
        //  endregion validasi hpp + pembayaran
        //        mati_disini(__LINE__ . " # stop 982 (status: $transaksi_status_582) $transaksi_status_jenis [$kas_cabang][$transaksi_nilai_982]<br>$msg");

        break;
    case "749":
        $customer_id = $arrTransaksi['customers_id'];
        $customer_nama = $arrTransaksi['customers_nama'];
        $nilai_pembayaran = $arrTransaksi['diskon_nilai'];
        $nilai_transaksi = $arrTransaksi['transaksi_nilai'];
        $referensi_id = $arrTransaksi['referensi_id'];

        //  region cek piutang customer
        $q = "select * from rek_cache_pembantu_piutang_customer where customer_id='$customer_id' and cabang_id='$cabang_id' and periode='forever'";
        $x = $db1->select($q);
        $r = $db1->select($q, true);
        if ($r > 0) {
            $l = $db1->get_row($x);
            $nilai_piutang = $l->nilai_af;
        }
        else {
            $nilai_piutang = 0;
        }
        //  endregion cek piutang customer
        //        $nilai_piutang = 0;
        addOutput(__LINE__ . "<br>nilai bayar: $nilai_pembayaran > saldo piutang: $nilai_piutang");

        //  region cek transaksi 582, sinkron harus sudah 1
        $sinkron_582 = $t->getTransaksiData($referensi_id)['sinkron'];
        //  endregion cek transaksi 582, sinkron harus sudah 1

        if ($nilai_pembayaran > $nilai_piutang) {
            $msg = "tr_id: $transaksi_id, nomer: $transaksi_nomer, nilai pembayaran lebih besar dari nilai piutang customer $customer_id $customer_nama";
            createLog("$msg", "dev", "$transaksi_id");

            $q_1 = "update transaksi set sinkron='9' where id='$transaksi_id'";
            $x_1 = $db1->run_sql($q_1, true);
            !$x_1 ? die($db1->display_errors(__FILE__ . " on line " . __LINE__)) : "";
            addOutput(__LINE__ . "<br>$msg");
            die();
        }
        elseif ($nilai_pembayaran > $nilai_transaksi) {
            $msg = "tr_id: $transaksi_id, nomer: $transaksi_nomer, nilai pembayaran lebih besar dari transaksi nilai customer $customer_id $customer_nama";
            createLog("$msg", "dev", "$transaksi_id");

            $q_1 = "update transaksi set sinkron='9' where id='$transaksi_id'";
            $x_1 = $db1->run_sql($q_1, true);
            !$x_1 ? die($db1->display_errors(__FILE__ . " on line " . __LINE__)) : "";
            addOutput(__LINE__ . "<br>$msg");
            die();
        }
        break;
    case "467":
        $pr = new CProgress(array(
            //"membaca",
            "menulis"
        ));
        $premi_nilai = $arrTransaksi['diskon_nilai'];
        $transaksi_status = $arrTransaksi['status'];
        $transaksi_trash = $arrTransaksi['trash'];
        $transaksi_id = $arrTransaksi['id'];
        if ($cabang_id == CB_ID_PUSAT) {
            if (($premi_nilai > 0) && ($transaksi_status == 2)) {
                $msg = "tr_id: $transaksi_id, nomer: $transaksi_nomer, belum dilakukan otorisasi premi";
                createLog("$msg", "dev", "$transaksi_id");

                $q_1 = "update transaksi set sinkron='9' where id='$transaksi_id'";
                $x_1 = $db1->run_sql($q_1, true);
                !$x_1 ? die($db1->display_errors(__FILE__ . " on line " . __LINE__)) : "";
                addOutput(__LINE__ . "<br>$q_1");
                die();
            }
            elseif (($transaksi_trash == 1)) {
                $msg = "tr_id: $transaksi_id, nomer: $transaksi_nomer, premi dibatalkan di ui";
                createLog("$msg", "dev", "$transaksi_id");

                $q_1 = "update transaksi set sinkron='1' where id='$transaksi_id'";
                $x_1 = $db1->run_sql($q_1, true);
                !$x_1 ? die($db1->display_errors(__FILE__ . " on line " . __LINE__)) : "";
                addOutput(__LINE__ . "<br>$q_1");
                die();
            }
        }
        break;
    case "334":
        $transaksi_id_0 = $arrTransaksi['id'];
        $arrProdukAsal = $t->getTransaksiChild($transaksi_id_0, "and parent_id = 0");
        if (count($arrTransaksiChildRef) > 0) {
            foreach ($arrTransaksiChildRef as $arrTransaksiChildRefData) {
                $produk_nama = $arrTransaksiChildRefData['produk_nama'];
                $produk_id = $arrTransaksiChildRefData['produk_id'];
                $produk_qtt = $arrTransaksiChildRefData['produk_ord_jml'];
                $produk_jenis = $arrTransaksiChildRefData['produk_jenis'];

                $arrProdukTransaksiData[$produk_id] += $produk_qtt;
                $arrProdukTransaksiNama[$produk_id] = $produk_nama;
                $arrProdukJenis[$produk_jenis] = $produk_jenis;
            }
            foreach ($arrProdukJenis as $produk_jenis) {
                switch ($produk_jenis) {
                    case "bahan":
                        $tbl = "rek_cache_pembantu_bahan";
                        $cabang_id_x = $cb_id_pusat;
                        break;
                    case "produk":
                        $tbl = "rek_cache_pembantu_produk";
                        $cabang_id_x = $cabang_id;
                        break;
                    default:
                        $msg = "tr_id: $transaksi_id, nomer: $transaksi_nomer, produk jenis perubahan grade tidak diketahui transaksi gagal, cabang $cabang_id_x";
                        createLog("$msg", "dev", "$transaksi_id");

                        $q_1 = "update transaksi set sinkron='9' where id='$transaksi_id'";
                        $x_1 = $db1->run_sql($q_1, true);
                        !$x_1 ? die($db1->display_errors(__FILE__ . " on line " . __LINE__)) : "";

                        addOutput("produk jenis perubahan grade tidak diketahui transaksi gagal.");
                        die();
                        break;
                }
                foreach ($arrProdukTransaksiData as $produk_id => $produk_qtt_1) {
                    $q = "select * from $tbl where produk_id='$produk_id' and cabang_id='$cabang_id_x' and periode='forever'";
                    $x = $db1->select($q);
                    $r = $db1->select($q, true);
                    if ($r > 0) {
                        $l = $db1->get_row($x);
                        $produk_qtt_cache = $l->unit_af;
                    }
                    else {
                        $produk_qtt_cache = 0;
                    }
                    if ($produk_qtt_cache < $produk_qtt_1) {
                        $arrProdukKurang[] = $produk_id;
                    }
                }
                if (count($arrProdukKurang) > 0) {
                    $msg = "tr_id: $transaksi_id, nomer: $transaksi_nomer, stok untuk transaksi perubahan grade $produk_jenis kurang, cabang $cabang_id_x";
                    createLog("$msg", "dev", "$transaksi_id");

                    $q_1 = "update transaksi set sinkron='9' where id='$transaksi_id'";
                    $x_1 = $db1->run_sql($q_1, true);
                    !$x_1 ? die($db1->display_errors(__FILE__ . " on line " . __LINE__)) : "";
                    addOutput(__LINE__ . " stok kurang untuk perubahan grade $produk_jenis");
                    die();
                }
            }
        }
        break;
    case "488":
        $transaski_id = $arrTransaksi['id'];
        $transaski_nilai = $arrTransaksi['transaksi_nilai'];
        $transaski_net = $arrTransaksi['transaksi_net'];
        $transaksi_nomer = $arrTransaksi['nomer'];
        $transaksi_status = $arrTransaksi['status'];

        //        if($transaski_nilai == 0){
        //            $pending = 1;
        //            $keterangan = "hutang kontainer salah/tidak valid (nilai: $transaksi_nilai, net: $transaksi_net";
        //        }
        //        elseif($transaski_net == 0){
        //            $pending = 1;
        //            $keterangan = "hutang kontainer salah/tidak valid (nilai: $transaksi_nilai, net: $transaksi_net";
        //        }
        //        elseif($transaski_nilai != $transaski_net){
        if ($transaski_nilai != $transaski_net) {
            $pending = 1;
            $keterangan = "hutang kontainer salah/tidak valid (nilai: $transaksi_nilai, net: $transaksi_net";
        }
        //        elseif($transaski_net == 0){
        //            $pending = 1;
        //            $keterangan = "hutang kontainer salah/tidak valid (nilai: $transaksi_nilai, net: $transaksi_net";
        //        }
        //        elseif($transaski_nilai != $transaski_net){
        //            $pending = 1;
        //            $keterangan = "hutang kontainer salah/tidak valid (nilai: $transaksi_nilai, net: $transaksi_net";
        //        }
        elseif ($transaksi_status == 2) {
            $pending = 1;
            $keterangan = "hutang kontainer belum diotorisasi manager cabang";
        }
        else {
            $pending = 0;
        }

        if ($pending == 1) {
            $msg = "tr_id: $transaksi_id, nomer: $transaksi_nomer, $keterangan)";
            createLog("$msg", "dev", "$transaksi_id");

            $q_1 = "update transaksi set sinkron='11' where id='$transaksi_id'";
            $x_1 = $db1->run_sql($q_1, true);
            !$x_1 ? die($db1->display_errors(__FILE__ . " on line " . __LINE__)) : "";
            addOutput(__LINE__ . "<br>$msg");
            die();
        }
        break;
    case "759":
        $transaksi_id = $arrTransaksi['id'];
        $referensi_id_759r = $arrTransaksi['referensi_id'];
        $arrTransaksiData759r = $t->getTransaksiData($referensi_id_759r);
        $last_info = $arrTransaksiData759r['last_info'];
        if ($last_info == "khusus") {
            $msg = "tr_id: $transaksi_id, nomer: $transaksi_nomer, setoran khusus sementara diskip, dan hanya bisa menggunakan cli khusus.";
            createLog("$msg", "dev", "$transaksi_id");

            //            $q_1 = "update transaksi set sinkron='11' where id='$transaksi_id'";
            //            $x_1 = $db1->run_sql($q_1, true);
            //            !$x_1 ? die($db1->display_errors(__FILE__ . " on line " . __LINE__)) : "";
            //            mati_disini(__LINE__ . " setoran khusus sementara diskip, dan hanya bisa menggunakan cli khusus.");
        }
        break;
}
//  endregion switch diluar kommit


if ((isset($_GET['id'])) && ($_GET['id'] > 0)) {
    //  commit pembuka
        $db1->beginCommit();
}
else {
    //  commit pembuka
    $db1->beginCommit();
}

// transaksi mesinnya disini ni jangan yg lain


if ($rows > 0) {
    //  region transaksi data
    $transaksi_id = $arrTransaksi['id'];
    $referensi_id = $arrTransaksi['referensi_id'];
    $transaksi_jenis = $arrTransaksi['jenis'];
    $cabang_id = $arrTransaksi['cabang_id'];
    $cabang_nama = $arrTransaksi['cabang_nama'];
    $supplier_id = $arrTransaksi['suppliers_id'];
    $supplier_nama = $arrTransaksi['suppliers_nama'];
    $approvals_id = $arrTransaksi['approvals_id'];
    $approvals_nama = $arrTransaksi['approvals_nama'];
    $transaksi_oleh_id = $oleh_id = $arrTransaksi['oleh_id'];
    $transaksi_oleh_nama = $oleh_nama = $arrTransaksi['oleh_nama'];
    $customer_id = $arrTransaksi['customers_id'];
    $customer_nama = $arrTransaksi['customers_nama'];
    $transaksi_nomer_original = $transaksi_nomer = $arrTransaksi['nomer'];
    $transaksi_inv = $arrTransaksi['inv'];
    $transaksi_nilai = $arrTransaksi['transaksi_nilai'];
    $transaksi_pembayaran = $arrTransaksi['pembayaran'];
    $transaksi_keterangan = $arrTransaksi['keterangan'];
    $transaksi_grand_net = $transaksi_net = $arrTransaksi['transaksi_net'];
    $transaksi_premi = $transaksi_diskon = $arrTransaksi['diskon_nilai'];
    $transaksi_ppn = round($arrTransaksi['ppn_nilai'], 2);
    $transaksi_trash = $arrTransaksi['trash'];
    $transaksi_status = $arrTransaksi['status'];
    $transaksi_jenis_konversi = $arrTransaksi['transaksi_jenis'];
    $transaksi_pembayaran_tunai = $arrTransaksi['pembayaran_tunai'];
    $transaksi_pembayaran_sys = $arrTransaksi['pembayaran_sys'];
    $transaksi_bank_id = $arrTransaksi['bank_id'];
    $transaksi_bank_nama = $arrTransaksi['bank_nama'];
    $transaksi_bank_rekening_id = $arrTransaksi['bank_rekening_id'];
    $transaksi_bank_rekening_nama = $arrTransaksi['bank_rekening_nama'];
    $transaksi_bank_rekening_id_from = $arrTransaksi['bank_rekening_id_from'];
    $transaksi_bank_rekening_nama_from = $arrTransaksi['bank_rekening_nama_from'];
    $transaksi_deposit = $arrTransaksi['deposit_nilai'];
    $transaksi_last_info = $arrTransaksi['last_info'];
    $transaksi_deposit_nilai_in = $arrTransaksi['deposit_nilai_in'];
    //    $transaksi_ekspedisi_id = $arrTransaksi['ekspedisi_id'];
    //    $transaksi_ekspedisi_nama = $arrTransaksi['ekspedisi_nama'];
    $gudang_id = $arrTransaksi['gudang_id'];
    $gudang_nama = $arrTransaksi['gudang_nama'];
    $transaksi_auto_pemindahan = $arrTransaksi['auto_pemindahan'];
    $transaksi_cabang_id_tujuan = $arrTransaksi['cabang_id_tujuan'];
    $transaksi_cabang_nama_tujuan = $arrTransaksi['cabang_nama_tujuan'];
    $transaksi_ekspedisi_id = $arrTransaksi['ekspedisi_id'];
    $transaksi_ekspedisi_nama = $arrTransaksi['ekspedisi_nama'];
    $transaksi_kontainer_size = $arrTransaksi['kontainer_size'];
    $transaksi_kontainer_harga = $arrTransaksi['kontainer_harga'];
    $transaksi_kontainer_no = $arrTransaksi['kontainer_no'];
    $transaksi_kapal_nama = $arrTransaksi['kapal_nama'];
    $transaksi_muatan = $arrTransaksi['muatan'];
//    $transaksi_jenis_jenis = $arrTransaksi['transaksi_jenis'];
//    $transaksi_jenis_jenis = $arrTransaksi['tipe']==1 ? "jasa" : "supplies";
    $transaksi_jenis_jenis = $arrTransaksi['tipe'] == 1 ? "jasa" : "produk";

    $transaksi_nomer = strlen($transaksi_inv) > 0 ? "$transaksi_nomer" : "$transaksi_nomer";
    //  endregion transaksi data

    cekHere("***jenis: $transaksi_jenis -- $transaksi_id -- $cabang_id -- $transaksi_pembayaran -- nilai: $transaksi_nilai -- premi/diskon: $transaksi_premi -- pph: $transaksi_ppn -- net: $transaksi_net<br>$transaksi_last_info");

    switch ($transaksi_jenis) {

        //  case pembelian
        case "467":

            if ($transaksi_status == 2) {
                if ($transaksi_id > 0) {
                    $arrTransaksiUpdate = array(
                        "sinkron" => "9",
                    );
                    $t->setTransaksionalId($transaksi_id);
                    $t->setTransaksional($arrTransaksiUpdate, false);

                    $msg = "tr_id: $transaksi_id nomer: $transaksi_nomer belum dilakukan otorisasi permi.";
                    createLog("$msg", "dev");
                }
            }
            else {
                if ($cabang_id > 0) {
                    $f_kali = 1;
                    $pembelian_jenis = "produk";
                    $log = "$oleh_nama menerima distribusi produk dari $transaksi_nomer";

                    $arrTransaksi_583 = $t->getTransaksi(583, "and referensi_id='$referensi_id' and sinkron=1 order by id desc limit 1");
                    if (count($arrTransaksi_583) > 0) {
                        foreach ($arrTransaksi_583 as $arrData583) {
                            $transaksi_id_583 = $arrData583['id'];
                        }
                    }
                    //                        cekHere("=== $transaksi_id_583 ===");
                    $transaksi_idx = $referensi_id > 0 ? "$transaksi_id_583" : mati_disini(__LINE__ . "<hr>referensi id tidak terdeteksi");

                    $t->setFKali($f_kali);
                    $t->setCabangId($cabang_id);
                }
                else {
                    $pembelian_jenis = "produk";
                    $f_kali = $transaksi_jenis == 967 ? "-1" : "1";
                    $log467 = "$oleh_nama menerima barang dari $transaksi_nomer a/n $supplier_nama $sms";
                    $log967 = "$oleh_nama menyetujui Return pembelian $transaksi_nomer";
                    $log = $transaksi_jenis == 967 ? "$log967" : "$log467";
                    $transaksi_idx = $referensi_id > 0 ? $referensi_id : $transaksi_id;
                }
                $transaksi_net_premi = $transaksi_nilai + $transaksi_premi + $transaksi_ppn;
                cekHere(__FILE__ . " $transaksi_net_premi = $transaksi_nilai + $transaksi_premi line " . __LINE__);
                // region persiapan set jurnal
                $j->setFKali($f_kali);
                $j->setPembelianJenis("$pembelian_jenis");
                $j->setPpn($transaksi_ppn);
                $j->setCabangId($cabang_id);
                $j->setTransaksiPembayaran($transaksi_pembayaran);
                // endregion persiapan set jurnal
                //cekHere();
                //  region persipana mutasi
                $arrProduk = array();
                $m->setFKali($f_kali);
                $m->setSupplier($supplier_id);
                $m->setTransaksiId($transaksi_id);
                $m->setTransaksiNomer($transaksi_nomer);
                $m->setTransaksiNilai($transaksi_net);
                $m->setPersediaanJenis($pembelian_jenis);
                $m->setCabangId($cabang_id);
                $m->setTransaksiJenis($transaksi_jenis);
                //  endregion persipana mutasi

                $arrTransaksiChild = $t->getTransaksiChild($transaksi_idx, "and trash='0'");
                //                print_r($arrTransaksiChild);
                $item_nilai_total = 0;
                $total_premi = 0;
                $produk_qtt_total = 0;
                $jmlData = count($arrTransaksiChild);
                $_cacheCounter = 0;
                //                cekHere("thomass " . __LINE__);
                if (sizeof($arrTransaksiChild) > 0) {
                    foreach ($arrTransaksiChild as $arrData) {
                        $_cacheCounter++;
                        updateProgress("menulis", hitungPersentase($_cacheCounter, $jmlData));

                        $id = $arrData['id'];
                        $produk_id = $arrData['produk_id'];
                        $produk_qtt = $arrData['produk_ord_jml'];
                        $harga = $arrData['produk_ord_hrg'];
                        $premi = 0;
                        $nama = $arrData['produk_nama'];
                        $total_premi += $premi;
                        $produk_qtt_total += $produk_qtt;
                        $new_harga = $harga + $premi;
                        $item_nilai = $produk_qtt * $new_harga;
                        $item_nilai_total += $item_nilai;
                        cekHEre(" $new_harga = $harga + $premi;");
                        addOutput("@@ $item_nilai = $produk_qtt * $new_harga");
                        $arrIdQtt[$id] = $produk_qtt;
                    }
                }
                else {
                    cekHijau("transaksi_data tidak ditemukan");
                    // matiHere("transaksi_data tidak ditemukan");
                }


                $item_harga_total_ppn = $item_nilai_total + $transaksi_ppn;
                addOutput("## $item_harga_total_ppn = $item_nilai_total - $transaksi_ppn ##");
                //  region memvalidasi data transaksi supaya balance
                if (round($item_harga_total_ppn, 2) != round($transaksi_net, 2)) {
                    //                    $t->setTransaksiRepair($transaksi_id,$transaksi_jenis,$cabang_id);
                    addOutput(__LINE__ . "<hr>transaksi gagal! $item_harga_total_ppn != $transaksi_net - " . __LINE__ . " " . __FILE__);
                    //                    die();
                    mati_disini(__LINE__ . "<hr>transaksi gagal! $item_harga_total_ppn != $transaksi_net - ppn: $transaksi_ppn line: " . __LINE__ . " " . __FILE__);
                }
                else {
                    //  eksekutor jurnal dan mutasi
                    //                    cekHere();
                    //  region jurnal
                    $j->setJurnal($transaksi_jenis, $transaksi_id, $transaksi_nomer, $transaksi_net_premi);
                    //  endregion jurnal

                    //  region mutasi
                    if ($cabang_id == CB_ID_PUSAT) {
                        $arrWajib_pajak = array(
                            "jenis" => "supplier",
                            "nama" => $supplier_nama,
                            "id" => $supplier_id
                        );
                        //                        arrPrint($arrWajib_pajak);
                        //                        matiHere($supplier_id);
                        $arrSupplierData = $d->getSupplierData($supplier_id);
                        $supplier_npwp = $arrSupplierData['npwp'];
                        $m->setWajibPajak($arrWajib_pajak);
                        $m->setNpwp($supplier_npwp);
                        $m->setPpnJenis("in");
                        $m->setPpn($transaksi_ppn);
                    }
                    $m->setPembayaran($transaksi_jenis, $transaksi_pembayaran);

                    //                    $arrTransaksiChild = array();
                    //                    $arrTransaksiChild = $t->getTransaksiChild($transaksi_idx);

                    cekHijau("tr nilai $transaksi_net_premi " . __FILE__ . " line " . __LINE__);
                    $m->setTransaksiNilai($transaksi_net_premi);
                    $item_nilai_total = 0;
                    $jmlData = count($arrTransaksiChild);
                    $_cacheCounter = 0;
                    foreach ($arrTransaksiChild as $arrData) {

                        $_cacheCounter++;
                        updateProgress("menulis", hitungPersentase($_cacheCounter, $jmlData));
                        $produk_id = $arrData['produk_id'];
                        $produk_qtt = $arrData['produk_ord_jml'];
                        $harga = $arrData['produk_ord_hrg'];
                        $premi = 0;
                        $nama = $arrData['produk_nama'];
                        $ppn = $arrData['ppn'];
                        //                            $new_harga = ($harga + $premi) - $ppn;
                        $new_harga = $harga + $premi;
                        $item_nilai = $produk_qtt * $new_harga;
                        $item_nilai_total += $item_nilai;

                        //                        region arrProduk asli
                        $arrProduk = array(
                            "id" => "$produk_id",
                            "qtt" => "$produk_qtt",
                            "hpp" => "$new_harga",
                            "harga" => "$new_harga",
                            "nama" => "$nama"
                        );
                        arrPrint($arrProduk);
                        $m->setProduk($arrProduk);
                        $m->setPersediaan($transaksi_jenis);

                        if ($cabang_id > 0) {
                            //  region fifo cabang
                            $arrFifo = array(
                                "produk_id" => $produk_id,
                                "produk_nama" => $nama,
                                "unit" => $produk_qtt,
                                "hpp" => $new_harga,
                                "jml_nilai" => $item_nilai,
                            );
                            $ff->setFifoJenis("produk");
                            $ff->setCabangId($cabang_id);
                            $ff->setProdukId($produk_id);
                            $ff->setTransaksiId($transaksi_id);
                            $ff->setTransaksiJenis($transaksi_jenis);
                            $ff->setFifo($arrFifo);
                            //  endregion fifo cabang
                            //  region transaksi data dan cache produk cabang
                            $arrChilddata = array(
                                "produk_id" => "$produk_id",
                                "produk_nama" => "$nama",
                                "produk_ord_hrg" => "$harga",
                                "produk_ord_jml" => "$produk_qtt",
                                "produk_ord_diskon" => "0",
                                "hpp" => "$harga",
                                "produk_jenis" => "produk",
                            );
                            $t->setTransaksiChildData($arrChilddata);
                            $t->setTransaksiChild($transaksi_id);
                            $t->setFKali(1);
                            $t->setCabangId($cabang_id);
                            //                                $t->setProdukCache($arrChilddata);
                            //  endregion transaksi data dan cache produk cabang
                            //  region validasi produk cache
                            $d->setTransaksiIdPending($transaksi_id);
                            $d->setCabangIdCache($cabang_id);
                            $stok_pending = $d->getStokPending("582r", $produk_id);
                            $stok_cache = $t->getProdukCache($produk_id, $cabang_id)['persediaan'];
                            $stok_last = $d->getProdukStok($produk_id, $cabang_id)['unit_af'];
                            $stok_validasi = $stok_pending + $stok_cache;
                            //                            if($stok_last != $stok_validasi){
                            //                                mati_disini(__LINE__ . "<hr>qtt: $produk_qtt<hr>" . __FILE__ . "<hr>stok mutasi != stok pending + sok cache ($stok_last != $stok_pending + $stok_cache)<hr>$produk_id - $nama");
                            //                            }
                            //                    cekHere("$stok_pending + $stok_cache == $stok_last");
                            //  endregion validasi produk cache
                        }
                        else {
                            //  region fifo pusat dan cache bahan pusat
                            switch ($transaksi_jenis) {
                                case "467":
                                    //  region set fifo bahan pusat
                                    $arrFifo = array(
                                        "produk_id" => $produk_id,
                                        "produk_nama" => $nama,
                                        "unit" => $produk_qtt,
                                        "hpp" => $new_harga,
                                        "jml_nilai" => $item_nilai,
                                    );
                                    $ff->setFifoJenis("produk");
                                    $ff->setCabangId($cabang_id);
                                    $ff->setProdukId($produk_id);
                                    $ff->setTransaksiId($transaksi_id);
                                    $ff->setTransaksiJenis($transaksi_jenis);
                                    $ff->setFifo($arrFifo);
                                    //  endregion set fifo bahan pusat
                                    //  region set cache bahan
                                    $arrChilddata_new = array(
                                        "produk_id" => "$produk_id",
                                        "produk_nama" => "$nama",
                                        //                                        "produk_keterangan" => "$nama",
                                        "produk_ord_hrg" => "$harga",
                                        "produk_ord_jml" => "$produk_qtt",
                                        "produk_ord_diskon" => "$premi",
                                        "hpp" => "$harga",
                                        "produk_jenis" => "bahan",
                                        "ppn" => "$ppn",
                                    );
                                    //                                    $arrData
                                    //                                    arrPrint($arrData);
                                    //                                    arrPrint($arrChilddata);
                                    $arrDiff = array_diff($arrData, $arrChilddata_new);
                                    //                                    arrPrint($arrDiff);
                                    $arrUpd = array_merge($arrData, $arrDiff);
                                    //                                    arrPrint($arrUpd);
                                    $arrBlock = array(
                                        "id",
                                        "transaksi_id",
                                        "rekening_id_asal",
                                        "rekening_id_tujuan",
                                        "bulan",
                                        "tahun",
                                        "angsuran",
                                        "parent_id",
                                        "trash",
                                        "administrasi",
                                        "transaksi_jenis",
                                        "bunga",
                                        "uang_muka"
                                    );
                                    $arrChilddata = $arrDiff_key = array_diff_key($arrUpd, array_flip($arrBlock));
                                    //                                    $arrOpen = array(
                                    //                                        "produk_jenis", "produk_id", "produk_nama", "produk_keterangan",
                                    //                                        "produk_folders", "produk_kode"
                                    //                                    );
                                    //                                    $arrDiff_key = array_intersect_key($arrUpd,array_flip($arrOpen));
                                    arrPrint($arrChilddata);

                                    cekHijau("$transaksi_id");
                                    $t->setFKali(1);
                                    $t->setCabangId($cabang_id);
                                    $t->setTransaksiChildData($arrChilddata);
                                    $t->setTransaksiChild($transaksi_id);

                                    //                                    $produk_qtt_real = $t->getBahanCacheReal($cabang_id, $produk_id);
                                    $produk_qtt_real = $t->getProdukCacheReal($cabang_id, $produk_id);

                                    //                                    $t->setConditionalCache("id='$produk_id'");
                                    $t->setConditionalCache("produk_id='$produk_id' and cabang_id='$cabang_id'");
                                    $arrCacheData = array(
                                        "id" => "$produk_id",
                                        "nama" => "$nama",
                                        "persediaan" => "$produk_qtt",
                                        "persediaan_real" => "$produk_qtt_real",
                                        "sinkron" => "1",
                                        "hpp" => "$harga",
                                        // kalau hanya update harus tau hasil dari mutasi realnya lhoo
                                    );
                                    cekHere("@#@#@# $transaksi_nomer ** $supplier_id");
                                    $t->setSuppliersId($supplier_id);
                                    $t->setTransaksionalId($transaksi_id);
                                    $t->setTransaksiJenis($transaksi_jenis);
                                    $t->setTransaksiNomer($transaksi_nomer);
                                    $t->setUpdateProdukCache($arrCacheData);
                                    //                                    $t->setUpdateBahanCache($arrCacheData);
                                    // region transaksi mini
                                    //                                    $m->setPersediaanMini($transaksi_jenis);
                                    // endregion transaksi mini

                                    //  endregion set cache bahan
                                    break;
                                default:
                                    addOutput(__LINE__ . " tr_id: $transaksi_id, jenis transaksi tidak diketahui");
                                    die();
                                    break;
                            }
                            //  endregion fifo pusat dan cache bahan pusat
                        }
                    }
                    //  endregion mutasi


                    //  region stok fifo dgn persediaan
                    $fifo_nilai = $ff->getFifoNilai($cabang_id);
                    $persediaan_cache = $m->getPersediaanCache($cabang_id);

                    addOutput("@@---fifo: $fifo_nilai---@@---cache: $persediaan_cache---@@---cabang id: $cabang_id");

                    $item_nilai_total = $item_nilai_total + $transaksi_ppn;
                    if ($item_nilai_total != $transaksi_net) {
                        addOutput(__LINE__ . " " . __FILE__ . "<hr>nilai transaksi dan transaksi data tidak sama <hr>$item_nilai_total != $transaksi_net");
                        mati_disini(__LINE__ . " " . __FILE__ . "<hr>nilai transaksi dan transaksi data tidak sama <hr>$item_nilai_total != $transaksi_net");
                        die();
                    }
                    elseif ($fifo_nilai != $persediaan_cache) {
                        $selisih = $fifo_nilai - $persediaan_cache;
                        addOutput("selisih: $selisih");
                        addOutput(__LINE__ . " " . __FILE__ . "<hr>nilai persediaan salah");
                        mati_disini(__LINE__ . " " . __FILE__ . "<hr>nilai persediaan salah");
                        die();
                    }
                    //  endregion stok fifo dgn persediaan

                }
                //  endregion memvalidasi data transaksi supaya balance
                //                cekHere(__LINE__);
                //                mati_disini(__LINE__);
                //  region validasi rekening
                if ($cabang_id > 0) {
                    $q = "select after_saldo from rek_cache where rekening='hutang dagang ke pusat' and cabang_id>0 and periode='forever'";
                    $x = $db1->select($q);
                    $hutang_ke_pusat = 0;
                    while ($l = $db1->get_row($x)) {
                        $after_saldo = $l->after_saldo;
                        $hutang_ke_pusat += $after_saldo;
                    }
                    $q7 = "select after_saldo from rek_cache where rekening='piutang cabang' and cabang_id='" . CB_ID_PUSAT . "' and periode='forever'";
                    $x7 = $db1->select($q7);
                    $l7 = $db1->get_row($x7);
                    $piutang_cabang = $l7->after_saldo;

                    if ($piutang_cabang != $hutang_ke_pusat) {
                        addOutput(__LINE__ . "<hr>nilai distribusi tidak sama dengan nilai transaksi");
                        mati_disini(__LINE__ . "<hr>nilai distribusi tidak sama dengan nilai transaksi");
                        die();
                    }
                }
                //  endregion validasi rekening
                //  region update transaksi yang sudah diambil
                $arrTransaksiUpdate = array(
                    "sinkron" => "1"
                );
                $t->setTransaksionalId($transaksi_id);
                $t->setTransaksional($arrTransaksiUpdate, false);
                //  endregion update transaksi yang sudah diambil

                $sukses = 1;
                //endregion
                //                mati_disini();
            }

            break;
        //  case return pembelian
        case "967":
            if ($transaksi_trash == 0) {
                $transaksi_pembayaran = "hutang";
                $pembelian_jenis = "produk";
                $f_kali = $transaksi_jenis == 967 ? "-1" : "1";
                $transaksi_idx = $transaksi_id;
                $arrTransaksiChild = $t->getTransaksiChild($transaksi_idx);

                //  region hapus transaksi data lama
                $t->setTransaksiDelete($transaksi_id);
                //  endregion hapus transaksi data lama

                $arrProdukFifo_2 = array();
                $arrBahanRequest = array();
                $fifo_lama = 0;
                foreach ($arrTransaksiChild as $arrData) {
                    $produk_id = $arrData['produk_id'];
                    $produk_qtt = $arrData['produk_ord_jml'];
                    $harga = $arrData['produk_ord_hrg'];
                    $premi = $arrData['produk_ord_diskon'];
                    $nama = $arrData['produk_nama'];
                    $new_harga = $harga + $premi;

                    $arrBahanNama[$produk_id] = $nama;
                    $arrBahanPremi[$produk_id] = $premi;
                    $arrBahanRequest[$produk_id] += $produk_qtt;

                    //  region fifo pusat
                    if ($fifo_lama == 1) {
                        for ($i = 1; $i <= $produk_qtt; $i++) {
                            $ff->setFifoJenis("produk");
                            $ff->setUnitNeed(1);
                            $arrProdukFifo_2[] = $ff->getFifo(0, $produk_id);
                        }
                    }
                    else {
                        $arrBahanData[$produk_id] = array(
                            "produk_id" => $produk_id,
                            "produk_qtt" => $produk_qtt,
                        );
                    }
                    //  endregion fifo pusat
                }
                if ($fifo_lama == 1) {
                    if (count($arrProdukFifo_2) > 0) {
                        $bahan_nilai_total_3 = 0;
                        foreach ($arrProdukFifo_2 as $arrProdukFifo_2Data) {
                            $bahan_nilai_total_2 = 0;
                            foreach ($arrProdukFifo_2Data as $bahan_id => $arrProdukFifo_2Data2) {
                                $bahan_nilai_total = 0;
                                foreach ($arrProdukFifo_2Data2 as $arrProdukFifo_2Data3) {
                                    $bahan_qtt = $arrProdukFifo_2Data3['unit'];
                                    $bahan_hpp = $arrProdukFifo_2Data3['hpp'];
                                    $bahan_nilai = $bahan_qtt * $bahan_hpp;
                                    $bahan_nilai_total += $bahan_nilai;

                                    $arrBahanFifo[$bahan_id][$bahan_hpp] += $bahan_qtt;
                                }
                                $bahan_nilai_total_2 += $bahan_nilai_total;
                            }
                            $bahan_nilai_total_3 += $bahan_nilai_total_2;
                        }
                    }
                }
                else {
                    $ff->setFifoJenis("produk");
                    $arrBahanFifo = $ff->getFifoNonProduksi($arrBahanData, "produk", 0, 0);
                    $bahan_nilai_total_3 = $arrBahanFifo['total'];
                }

                //  region insert ke transaksi data
                foreach ($arrBahanFifo as $bahan_id => $arrBahanFifoData) {
                    if (is_numeric($bahan_id)) {
                        foreach ($arrBahanFifoData as $bahan_hpp => $bahan_qtt) {
                            $bahan_nama = $arrBahanNama[$bahan_id];
                            $bahan_premi = $arrBahanPremi[$bahan_id];
                            $arrTransaksiChildNew = array(
                                "produk_jenis" => "produk",
                                "produk_id" => "$bahan_id",
                                "produk_nama" => "$bahan_nama",
                                "produk_ord_hrg" => "$bahan_hpp",
                                "produk_ord_jml" => "$bahan_qtt",
                                "hpp" => "$bahan_hpp",
                                "produk_ord_diskon" => "$bahan_premi",
                            );
                            arrPrint($arrTransaksiChildNew);
                            $t->setTransaksiChildData($arrTransaksiChildNew);
                            $t->setTransaksiChild($transaksi_id);
                        }
                    }
                }
                //  endregion insert ke transaksi data

                $transaksi_nilai_premi = $transaksi_nilai + $transaksi_premi;
                $selisih_persediaan_fifo = $bahan_nilai_total_3 - $transaksi_nilai_premi;
                $selisih_persediaan_fifo_x = $selisih_persediaan_fifo;

                addOutput("*** $selisih_persediaan_fifo = $bahan_nilai_total_3 - $transaksi_nilai_premi ***");

                // region set jurnal
                $j->setFKali($f_kali);
                $j->setPembelianJenis("$pembelian_jenis");
                $j->setPpn($transaksi_ppn);
                $j->setCabangId($cabang_id);
                $j->setTransaksiPembayaran($transaksi_pembayaran);
                $j->setSelisihFifo($selisih_persediaan_fifo);
                $j->setPersediaanNilai($bahan_nilai_total_3);
                $j->setJurnal($transaksi_jenis, $transaksi_id, $transaksi_nomer, $transaksi_net);
                // endregion set jurnal

                //  region mutasi
                $arrProduk = array();
                $m->setFKali($f_kali);
                $m->setSupplier($supplier_id);
                $m->setTransaksiId($transaksi_id);
                $m->setTransaksiNomer($transaksi_nomer);
                $m->setTransaksiNilai($transaksi_net);
                $m->setPersediaanJenis($pembelian_jenis);
                $m->setCabangId($cabang_id);

                $item_nilai_total = 0;
                $total_premi = 0;
                $produk_qtt_total = 0;

                if ($cabang_id == CB_ID_PUSAT) {
                    $arrWajib_pajak = array(
                        "jenis" => "supplier",
                        "nama" => $supplier_nama,
                        "id" => $supplier_id
                    );
                    $supplier_npwp = $d->getSupplierData($supplier_id)['npwp'];
                    $m->setWajibPajak($arrWajib_pajak);
                    $m->setNpwp($supplier_npwp);
                    $m->setPpnJenis("in");
                    $m->setPpn($transaksi_ppn);
                }
                $m->setPembayaran($transaksi_jenis, $transaksi_pembayaran);

                if ($selisih_persediaan_fifo != 0) {
                    //  rekening selisih persediaan karena fifo
                    //                        cekHere("rekening selisih persediaan karena fifo");
                    if ($selisih_persediaan_fifo > 0) {
                        $selisih_persediaan_fifo = $selisih_persediaan_fifo;
                        $m->setFKali(1);
                        //                            cekHere("qwerty");
                    }
                    elseif ($selisih_persediaan_fifo < 0) {
                        $selisih_persediaan_fifo = $selisih_persediaan_fifo * -1;
                        $m->setFKali(-1);
                    }
                    else {
                        $selisih_persediaan_fifo = 0;
                        $m->setFKali(0);
                    }
                    //                        $m->setTransaksiNilai($selisih_persediaan_fifo);
                    $m->setSelisihPersediaanFifo($transaksi_jenis, $selisih_persediaan_fifo);
                }
                $item_nilai_total = 0;
                $total_premi = 0;
                $produk_qtt_total = 0;


                $arrTransaksiChild = $t->getTransaksiChild($transaksi_id);
                $item_nilai_total = 0;
                foreach ($arrTransaksiChild as $arrData) {
                    $produk_id = $arrData['produk_id'];
                    $produk_qtt = $arrData['produk_ord_jml'];
                    $harga = $arrData['produk_ord_hrg'];
                    $premi = $arrData['produk_ord_diskon'];
                    $nama = $arrData['produk_nama'];
                    $pph = $arrData['ppn'];
                    $new_harga = $harga + $premi;
                    $item_nilai = $produk_qtt * $harga;
                    $item_nilai_total += $item_nilai;

                    $arrProduk = array(
                        "id" => "$produk_id",
                        "qtt" => "$produk_qtt",
                        "hpp" => "$harga",
                        "harga" => "$harga",
                        "nama" => "$nama"
                    );
                    $m->setProduk($arrProduk);
                    $m->setPersediaan($transaksi_jenis);
                }
                //  endregion mutasi

                //  region update transaksi yang sudah diambil
                $arrTransaksiUpdate = array(
                    "sinkron" => "1"
                );
                $t->setTransaksionalId($transaksi_id);
                $t->setTransaksional($arrTransaksiUpdate, false);
                //  endregion update transaksi yang sudah diambil
                //  region stok fifo dgn persediaan
                $fifo_nilai = $ff->getFifoNilai($cabang_id);
                $persediaan_cache = $m->getPersediaanCache($cabang_id);

                addOutput("@@---fifo: $fifo_nilai---@@---cache: $persediaan_cache---@@---cabang id: $cabang_id");

                if ($item_nilai_total != ($transaksi_nilai + $transaksi_premi)) {
                    $selisih_calc = $item_nilai_total - ($transaksi_nilai + $transaksi_premi);
                    //                            $selisih_persediaan_fifo_f = $selisih_persediaan_fifo < 0 ? $selisih_persediaan_fifo * -1 : $selisih_persediaan_fifo ;
                    addOutput("## $selisih_calc *** $selisih_persediaan_fifo_x ##");
                    if ($selisih_calc != $selisih_persediaan_fifo_x) {
                        addOutput(__LINE__ . " " . __FILE__ . "<hr>nilai transaksi dan transaksi data tidak sama <hr>$item_nilai_total != $transaksi_net");
                        die();
                    }
                }
                elseif ($fifo_nilai != $persediaan_cache) {
                    $selisih = $fifo_nilai - $persediaan_cache;
                    addOutput("selisih: $selisih");
                    addOutput(__LINE__ . " " . __FILE__ . "<hr>nilai persediaan salah");
                    die();
                }
                //  endregion stok fifo dgn persediaan
                //                    }
                //  endregion memvalidasi data transaksi supaya balance
                //  region update cache sinkron
                $arrUpdateCacheSinkron = array(
                    "sinkron" => "1",
                );
                $produk_jenis = "bahan";
                $t->setProdukCacheSinkron($arrUpdateCacheSinkron, $produk_jenis, $cabang_id, $referensi_id);
                //  endregion update cache sinkron
            }
            //  region update transaksi yang sudah diambil
            $arrTransaksiUpdate = array(
                "sinkron" => "1"
            );
            $t->setTransaksionalId($transaksi_id);
            $t->setTransaksional($arrTransaksiUpdate, false);
            //  endregion update transaksi yang sudah diambil

            $sukses = 1;


            //                mati_disini("$transaksi_jenis; tId: $transaksi_id; rId: $referensi_id -> testing hooooo");
            break;


        //  case pembelian barang supplies and equipment
        case "461":
            cekHere(":: $transaksi_jenis :: $transaksi_jenis_jenis ::");
            if ($transaksi_status == 2) {
                if ($transaksi_id > 0) {
                    $arrTransaksiUpdate = array(
                        "sinkron" => "9",
                    );
                    $t->setTransaksionalId($transaksi_id);
                    $t->setTransaksional($arrTransaksiUpdate, false);

                    $msg = "tr_id: $transaksi_id nomer: $transaksi_nomer belum dilakukan otorisasi permi.";
                    createLog("$msg", "dev");
                }
            }
            else {
                //  region cli po barang
                if ($cabang_id == CB_ID_PUSAT) {
                    $pembelian_jenis = "supplies";
                    $f_kali = -1;
                    $transaksi_jenis = "888";
                    $transaksi_idx = $transaksi_id;
                }
                else {
                    mati_disini("CABANG ID terdeteksi NOL (0) atau -2 dst...");
                }

                $transaksi_net_premi = $transaksi_nilai - $transaksi_premi + $transaksi_ppn;
                cekHere(":: $transaksi_net_premi = $transaksi_nilai - $transaksi_premi + $transaksi_ppn ::");


                //  region build transaksi
                $t->setCabangId($cabang_id);
                $arrTransaksi = array(
                    "oleh_id" => "$transaksi_oleh_id",
                    "oleh_nama" => "$transaksi_oleh_nama",
                    "suppliers_id" => "$supplier_id",
                    "suppliers_nama" => "$supplier_nama",
                    "cabang_id" => "$cabang_id",
                    "cabang_nama" => "$cabang_nama",
                    "transaksi_nilai" => "$transaksi_nilai",
                    "transaksi_net" => "$transaksi_net",
                    "diskon_jenis" => "premi",
//                    "diskon_persen" => $diskon_supplier,
                    "diskon_nilai" => $transaksi_diskon,
                    "ppn_nilai" => $transaksi_ppn,
//                    "ppn_persen" => $ppn_persen, // skip QC tambahkan fied ini
                    "status" => "1",
                    "sinkron" => "1",
//                    "referensi_id" => "$ref_id",

                );
                if ($ref_id <= 0) {
                    //            echo toAlert("refId ".$ref_id);
                    $t->setInv(true);
                }
                else {
                    $arrTransaksi["inv"] = "$ref_inv";

                    $t->setInv(false);
                }
                $t->setTransaksiNilai($transaksi_net);
                $t->setTransaksiJenis($transaksi_jenis);
                $t->setTransaksional($arrTransaksi);
                $transaksi_id = $t->getTransaksionalId();
                $transaksi_nomer = $t->getTransaksiData($transaksi_id)['nomer'];
                //  endregion build transaksi


                // region persiapan set jurnal
                $j->setFKali($f_kali);
                $j->setPembelianJenis("$pembelian_jenis");
                $j->setPpn($transaksi_ppn);
                $j->setCabangId($cabang_id);
                $j->setPersediaanNilai($transaksi_nilai);
                $j->setTransaksiPembayaran($transaksi_pembayaran);
                $j->setJurnalType($transaksi_jenis_jenis);
                // endregion persiapan set jurnal

                //  region persipana mutasi
                $arrProduk = array();
                $m->setFKali($f_kali);
                $m->setSupplier($supplier_id);
                $m->setTransaksiId($transaksi_id);
                $m->setTransaksiNomer($transaksi_nomer);
                $m->setTransaksiNilai($transaksi_net);
                $m->setPersediaanJenis($pembelian_jenis);
                $m->setCabangId($cabang_id);
                $m->setTransaksiJenis($transaksi_jenis);
                $m->setTransaksiType($transaksi_jenis_jenis);
                //  endregion persipana mutasi

                $arrTransaksiChild = $t->getTransaksiChild($transaksi_idx, "and trash='0'");

                $item_nilai_total = 0;
                $total_premi = 0;
                $produk_qtt_total = 0;
                $jmlData = count($arrTransaksiChild);
                $_cacheCounter = 0;

                if (sizeof($arrTransaksiChild) > 0) {
                    foreach ($arrTransaksiChild as $arrData) {
                        $id = $arrData['id'];
                        $produk_id = $arrData['produk_id'];
                        $produk_qtt = $arrData['produk_ord_jml'];
                        $harga = $arrData['produk_ord_hrg'];
                        $premi = $arrData['produk_ord_diskon'];
                        $nama = $arrData['produk_nama'];
                        $ppn = $arrData['ppn'];
                        $total_premi += $premi;
                        $produk_qtt_total += $produk_qtt;
                        $new_harga = $harga + $premi + $ppn;
                        $item_nilai = $produk_qtt * $new_harga;
                        $item_nilai_total += $item_nilai;


                        $arrIdQtt[$id] = $produk_qtt;
                    }
                }
                else {
                    cekHijau("transaksi_data tidak ditemukan");
                    matiHere("transaksi_data tidak ditemukan");
                }

                $item_harga_total_ppn = $item_nilai_total;// + $transaksi_ppn;


                cekMerah(":: MULAI... ::");

                //  region memvalidasi data transaksi supaya balance
                if (round($item_harga_total_ppn, 2) != round($transaksi_net, 2)) {
                    addOutput(__LINE__ . "<hr>transaksi gagal! $item_harga_total_ppn != $transaksi_net - " . __LINE__ . " " . __FILE__);
                    mati_disini(__LINE__ . "<hr>transaksi gagal! $item_harga_total_ppn != $transaksi_net - ppn: $transaksi_ppn line: " . __LINE__ . " " . __FILE__);
                }
                else {

                    //  region jurnal stok/persediaan
                    $j->setJurnal($transaksi_jenis, $transaksi_id, $transaksi_nomer, $transaksi_net_premi);
                    //  endregion jurnal stok/persediaan
                    cekMerah(":: JURNAL OKE ::");
//                    mati_disini("SETOPP...");


                    //  region mutasi stok/persediaan
                    if ($cabang_id == CB_ID_PUSAT) {
                        $arrWajib_pajak = array(
                            "jenis" => "supplier",
                            "nama" => $supplier_nama,
                            "id" => $supplier_id
                        );
                        $arrSupplierData = $d->getSupplierData($supplier_id);
                        $supplier_npwp = $arrSupplierData['npwp'];
                        $m->setWajibPajak($arrWajib_pajak);
                        $m->setNpwp($supplier_npwp);
                        $m->setPpnJenis("in");
                        $m->setPpn($transaksi_ppn);
                    }
                    $m->setTransaksiNilai($transaksi_net_premi);
//                    $m->setPembayaran($transaksi_jenis, $transaksi_pembayaran);


                    cekHijau("[f_kali: $f_kali] tr nilai $transaksi_net_premi " . __FILE__ . " line " . __LINE__);
                    cekMerah("$transaksi_pembayaran, OKE");
//mati_disini("SETOPPP...");

                    $m->setTransaksiNilai($transaksi_net_premi);
                    $item_nilai_total = 0;
                    $jmlData = count($arrTransaksiChild);
                    $_cacheCounter = 0;
                    $arrBahanData = array();
                    foreach ($arrTransaksiChild as $arrData) {
                        $produk_id = $arrData['produk_id'];
                        $produk_qtt = $arrData['produk_ord_jml'];
                        $harga = $arrData['produk_ord_hrg'];
                        $premi = $arrData['produk_ord_diskon'];
                        $nama = $arrData['produk_nama'];
                        $ppn = $arrData['ppn'];
                        $produk_keterangan = $arrData['produk_keterangan'];
                        $produk_satuan = $arrData['satuan'];

                        $new_harga = $harga - $premi;
                        $item_nilai = $produk_qtt * $new_harga;
                        $item_nilai_total += $item_nilai;

                        $arrProduk = array(
                            "id" => "$produk_id",
                            "qtt" => "$produk_qtt",
                            "hpp" => "$new_harga",
                            "harga" => "$new_harga",
                            "nama" => "$nama"
                        );
                        arrPrint($arrProduk);
                        $m->setProduk($arrProduk);
                        $m->setPersediaan($transaksi_jenis);

                        //  region build transaksi child 888
                        $arrTransaksiChildData = array(
                            "produk_id" => "$produk_id",
                            "produk_nama" => "$nama",
                            "produk_keterangan" => "$produk_keterangan",
//                            "produk_folders" => "$produk_folders",
                            "satuan" => "$produk_satuan",
                            "ppn" => "$ppn",
//                            "hpp" => "$produk_hpp",
                            "produk_ord_hrg" => "$harga",
                            "produk_ord_jml" => "$produk_qtt",
                            "produk_jenis" => "supplies",
                        );
                        arrPrint($arrTransaksiChildData);
                        $t->setTransaksiChildData($arrTransaksiChildData);
                        $t->setTransaksiChild($transaksi_id);
                        //  endregion build transaksi child 888

                        //  region fifo pusat dan cache bahan pusat

                        //  region set fifo bahan pusat
                        $arrBahanData[$produk_id] = array(
                            "produk_id" => $produk_id,
                            "produk_qtt" => $produk_qtt,
                        );
                        //  endregion set fifo bahan pusat

                        //  region set cache bahan
                        $arrChilddata_new = array(
                            "produk_id" => "$produk_id",
                            "produk_nama" => "$nama",
                            "produk_ord_hrg" => "$harga",
                            "produk_ord_jml" => "$produk_qtt",
                            "produk_ord_diskon" => "$premi",
                            "hpp" => "$harga",
                            "produk_jenis" => "produk",
                            "ppn" => "$ppn",
                        );
                        $arrDiff = array_diff($arrData, $arrChilddata_new);
                        $arrUpd = array_merge($arrData, $arrDiff);
                        $arrBlock = array(
                            "id",
                            "transaksi_id",
                            "rekening_id_asal",
                            "rekening_id_tujuan",
                            "bulan",
                            "tahun",
                            "angsuran",
                            "parent_id",
                            "trash",
                            "administrasi",
                            "transaksi_jenis",
                            "bunga",
                            "uang_muka"
                        );
                        $arrChilddata = $arrDiff_key = array_diff_key($arrUpd, array_flip($arrBlock));
                        cekHijau("$transaksi_id");

                        $t->setFKali(1);
                        $t->setCabangId($cabang_id);
                        $t->setTransaksiChildData($arrChilddata);
//                                    $t->setTransaksiChild($transaksi_id);

                        $produk_qtt_real = $t->getProdukCacheReal($cabang_id, $produk_id);

                        $t->setConditionalCache("produk_id='$produk_id' and cabang_id='$cabang_id'");
                        $arrCacheData = array(
                            "id" => "$produk_id",
                            "nama" => "$nama",
                            "persediaan" => "$produk_qtt",
                            "persediaan_real" => "$produk_qtt_real",
                            "sinkron" => "1",
                            // kalau hanya update harus tau hasil dari mutasi realnya lhoo
                        );
                        $arrProduk = array(
                            "produk_id" => "$produk_id",
                            "produk_qtt" => $produk_qtt,
                            "produk_nama" => $nama,
                        );
                        $m->setProduk($arrProduk);
                        $m->setSupplierId($supplier_id);
                        $m->setTransaksiId($transaksi_id);
                        $m->setTransaksiJenis($transaksi_jenis);
                        $m->setTransaksiNomer($transaksi_nomer);
                        $m->setPersediaanCacheUI($produk_id, "supplies", $cabang_id, "0");
                        //  endregion set cache bahan

                        //  endregion fifo pusat dan cache bahan pusat

                    }
                    //  endregion mutasi stok/persediaan
                    cekMerah("KURANGI - PERSEDIAAN OK...");


                    $ff->setFifoJenis("supplies");
                    $arrBahanFifo = $ff->getFifoNonProduksi($arrBahanData, "supplies", $cabang_id, 0);
                    $bahan_nilai_total_3 = $arrBahanFifo['total'];
cekMerah("FIFO sudah dicabut");


                    //  region cache sinkron menjadi 1
                    $m->setPersediaanCacheUISinkron($transaksi_id, "supplies");
                    //  endregion cache sinkron menjadi 1


                    //  region masuk ke biaya
                    $f_kali = 1;
                    $m->setFKali($f_kali);
                    $m->setCabangId($cabang_id);
                    $m->setTransaksiNilai($transaksi_net);
                    $m->setTransaksiJenis($transaksi_jenis);
                    $m->setTransaksiNomer($transaksi_nomer);
                    $m->setTransaksiId($transaksi_id);
                    $m->setTransaksiType($transaksi_jenis_jenis);
                    $m->setBiaya($transaksi_jenis);
                    //  endregion masuk ke biaya
                    cekMerah("masuk BIAYA OKE...");
//                    mati_disini("SETOOPPP...");
                }
                //  endregion memvalidasi data transaksi supaya balance

                //  region update transaksi yang sudah diambil
                $arrTransaksiUpdate = array(
                    "sinkron" => "1"
                );
                $t->setTransaksionalId($transaksi_id);
                $t->setTransaksional($arrTransaksiUpdate, false);
                //  endregion update transaksi yang sudah diambil
                //  endregion cli po barang


                $sukses = 1;

            }

            break;


        //  case return pembelian barang supplies and equipment
        case "961":
            if ($transaksi_trash == 0) {
                $transaksi_pembayaran = "hutang";
                $pembelian_jenis = "supplies";
                $f_kali = $transaksi_jenis == "961" ? "-1" : "1";
                $transaksi_idx = $transaksi_id;
                $arrTransaksiChild = $t->getTransaksiChild($transaksi_idx);

                //  region hapus transaksi data lama
                $t->setTransaksiDelete($transaksi_id);
                //  endregion hapus transaksi data lama

                $arrProdukFifo_2 = array();
                $arrBahanRequest = array();
                $fifo_lama = 0;
                foreach ($arrTransaksiChild as $arrData) {
                    $produk_id = $arrData['produk_id'];
                    $produk_qtt = $arrData['produk_ord_jml'];
                    $harga = $arrData['produk_ord_hrg'];
                    $premi = $arrData['produk_ord_diskon'];
                    $nama = $arrData['produk_nama'];
                    $new_harga = $harga + $premi;

                    $arrBahanNama[$produk_id] = $nama;
                    $arrBahanPremi[$produk_id] = $premi;
                    $arrBahanRequest[$produk_id] += $produk_qtt;

                    //  region fifo pusat
                    if ($fifo_lama == 1) {
                        for ($i = 1; $i <= $produk_qtt; $i++) {
                            $ff->setFifoJenis("produk");
                            $ff->setUnitNeed(1);
                            $arrProdukFifo_2[] = $ff->getFifo(0, $produk_id);
                        }
                    }
                    else {
                        $arrBahanData[$produk_id] = array(
                            "produk_id" => $produk_id,
                            "produk_qtt" => $produk_qtt,
                        );
                    }
                    //  endregion fifo pusat
                }
                if ($fifo_lama == 1) {
                    if (count($arrProdukFifo_2) > 0) {
                        $bahan_nilai_total_3 = 0;
                        foreach ($arrProdukFifo_2 as $arrProdukFifo_2Data) {
                            $bahan_nilai_total_2 = 0;
                            foreach ($arrProdukFifo_2Data as $bahan_id => $arrProdukFifo_2Data2) {
                                $bahan_nilai_total = 0;
                                foreach ($arrProdukFifo_2Data2 as $arrProdukFifo_2Data3) {
                                    $bahan_qtt = $arrProdukFifo_2Data3['unit'];
                                    $bahan_hpp = $arrProdukFifo_2Data3['hpp'];
                                    $bahan_nilai = $bahan_qtt * $bahan_hpp;
                                    $bahan_nilai_total += $bahan_nilai;

                                    $arrBahanFifo[$bahan_id][$bahan_hpp] += $bahan_qtt;
                                }
                                $bahan_nilai_total_2 += $bahan_nilai_total;
                            }
                            $bahan_nilai_total_3 += $bahan_nilai_total_2;
                        }
                    }
                }
                else {
                    $ff->setFifoJenis("supplies");
                    $arrBahanFifo = $ff->getFifoNonProduksi($arrBahanData, "supplies", $cabang_id, 0);
                    $bahan_nilai_total_3 = $arrBahanFifo['total'];
                }

                //  region insert ke transaksi data
                foreach ($arrBahanFifo as $bahan_id => $arrBahanFifoData) {
                    if (is_numeric($bahan_id)) {
                        foreach ($arrBahanFifoData as $bahan_hpp => $bahan_qtt) {
                            $bahan_nama = $arrBahanNama[$bahan_id];
                            $bahan_premi = $arrBahanPremi[$bahan_id];
                            $arrTransaksiChildNew = array(
                                "produk_jenis" => "produk",
                                "produk_id" => "$bahan_id",
                                "produk_nama" => "$bahan_nama",
                                "produk_ord_hrg" => "$bahan_hpp",
                                "produk_ord_jml" => "$bahan_qtt",
                                "hpp" => "$bahan_hpp",
                                "produk_ord_diskon" => "$bahan_premi",
                            );
//                            arrPrint($arrTransaksiChildNew);
                            $t->setTransaksiChildData($arrTransaksiChildNew);
                            $t->setTransaksiChild($transaksi_id);
                        }
                    }
                }
                //  endregion insert ke transaksi data

                $transaksi_nilai_premi = $transaksi_nilai + $transaksi_premi;
                $selisih_persediaan_fifo = $bahan_nilai_total_3 - $transaksi_nilai_premi;
                $selisih_persediaan_fifo_x = $selisih_persediaan_fifo;

                addOutput("*** $selisih_persediaan_fifo = $bahan_nilai_total_3 - $transaksi_nilai_premi ***");
                cekHere("*** $selisih_persediaan_fifo = $bahan_nilai_total_3 - $transaksi_nilai_premi ***");

                // region set jurnal
                $j->setFKali($f_kali);
                $j->setPembelianJenis("$pembelian_jenis");
                $j->setPpn($transaksi_ppn);
                $j->setCabangId($cabang_id);
                $j->setTransaksiPembayaran($transaksi_pembayaran);
                $j->setSelisihFifo($selisih_persediaan_fifo);
                $j->setPersediaanNilai($bahan_nilai_total_3);
                $j->setJurnal($transaksi_jenis, $transaksi_id, $transaksi_nomer, $transaksi_net);
                // endregion set jurnal

                cekBiru(":: JURNAL OKE... ::");

                //  region mutasi
                $arrProduk = array();
                $m->setFKali($f_kali);
                $m->setSupplier($supplier_id);
                $m->setTransaksiId($transaksi_id);
                $m->setTransaksiNomer($transaksi_nomer);
                $m->setTransaksiNilai($transaksi_net);
                $m->setPersediaanJenis($pembelian_jenis);
                $m->setCabangId($cabang_id);

                $item_nilai_total = 0;
                $total_premi = 0;
                $produk_qtt_total = 0;

                if ($cabang_id == CB_ID_PUSAT) {
                    $arrWajib_pajak = array(
                        "jenis" => "supplier",
                        "nama" => $supplier_nama,
                        "id" => $supplier_id
                    );
                    $supplier_npwp = $d->getSupplierData($supplier_id)['npwp'];
                    $m->setWajibPajak($arrWajib_pajak);
                    $m->setNpwp($supplier_npwp);
                    $m->setPpnJenis("in");
                    $m->setPpn($transaksi_ppn);
                }
                $m->setPembayaran($transaksi_jenis, $transaksi_pembayaran);

                if ($selisih_persediaan_fifo != 0) {
                    //  rekening selisih persediaan karena fifo
                    //                        cekHere("rekening selisih persediaan karena fifo");
                    if ($selisih_persediaan_fifo > 0) {
                        $selisih_persediaan_fifo = $selisih_persediaan_fifo;
                        $m->setFKali(1);
                        //                            cekHere("qwerty");
                    }
                    elseif ($selisih_persediaan_fifo < 0) {
                        $selisih_persediaan_fifo = $selisih_persediaan_fifo * -1;
                        $m->setFKali(-1);
                    }
                    else {
                        $selisih_persediaan_fifo = 0;
                        $m->setFKali(0);
                    }
                    //                        $m->setTransaksiNilai($selisih_persediaan_fifo);
                    $m->setSelisihPersediaanFifo($transaksi_jenis, $selisih_persediaan_fifo);
                }
                $item_nilai_total = 0;
                $total_premi = 0;
                $produk_qtt_total = 0;


                $arrTransaksiChild = $t->getTransaksiChild($transaksi_id);
                $item_nilai_total = 0;
                foreach ($arrTransaksiChild as $arrData) {
                    $produk_id = $arrData['produk_id'];
                    $produk_qtt = $arrData['produk_ord_jml'];
                    $harga = $arrData['produk_ord_hrg'];
                    $premi = $arrData['produk_ord_diskon'];
                    $nama = $arrData['produk_nama'];
                    $pph = $arrData['ppn'];
                    $new_harga = $harga + $premi;
                    $item_nilai = $produk_qtt * $harga;
                    $item_nilai_total += $item_nilai;

                    $arrProduk = array(
                        "id" => "$produk_id",
                        "qtt" => "$produk_qtt",
                        "hpp" => "$harga",
                        "harga" => "$harga",
                        "nama" => "$nama"
                    );
                    $m->setProduk($arrProduk);
                    $m->setPersediaan($transaksi_jenis);
                }
                //  endregion mutasi

                cekBiru(":: MUTASI OKE... :: [$item_nilai_total] ::");

                //  region update transaksi yang sudah diambil
                $arrTransaksiUpdate = array(
                    "sinkron" => "1"
                );
                arrPrint($arrTransaksiUpdate);
                $t->setTransaksionalId($transaksi_id);
                $t->setTransaksional($arrTransaksiUpdate, false);
                //  endregion update transaksi yang sudah diambil

                //  region stok fifo dgn persediaan
                $fifo_nilai = $ff->getFifoNilai($cabang_id);
                $persediaan_cache = $m->getPersediaanCache($cabang_id);

                addOutput("@@---fifo: $fifo_nilai---@@---cache: $persediaan_cache---@@---cabang id: $cabang_id");

                if ($item_nilai_total != ($transaksi_nilai + $transaksi_premi)) {
                    $selisih_calc = $item_nilai_total - ($transaksi_nilai + $transaksi_premi);

                    addOutput("## $selisih_calc *** $selisih_persediaan_fifo_x ##");

                    if ($selisih_calc != $selisih_persediaan_fifo_x) {
                        addOutput(__LINE__ . " " . __FILE__ . "<hr>nilai transaksi dan transaksi data tidak sama <hr>$item_nilai_total != $transaksi_net");
                        die();
                    }
                }
                elseif ($fifo_nilai != $persediaan_cache) {
                    $selisih = $fifo_nilai - $persediaan_cache;
                    addOutput("selisih: $selisih");
                    addOutput(__LINE__ . " " . __FILE__ . "<hr>nilai persediaan salah");
                    die();
                }
                //  endregion stok fifo dgn persediaan


                //  region update cache sinkron
                $arrUpdateCacheSinkron = array(
                    "sinkron" => "1",
                );
                $produk_jenis = "bahan";
                $t->setProdukCacheSinkron($arrUpdateCacheSinkron, $produk_jenis, $cabang_id, $referensi_id);
                //  endregion update cache sinkron
            }

            //  region update transaksi yang sudah diambil
            $arrTransaksiUpdate = array(
                "sinkron" => "1"
            );
            $t->setTransaksionalId($transaksi_id);
            $t->setTransaksional($arrTransaksiUpdate, false);
            //  endregion update transaksi yang sudah diambil

            $sukses = 1;


            //                mati_disini("$transaksi_jenis; tId: $transaksi_id; rId: $referensi_id -> testing hooooo");
            break;
        //  case penggunaan barang supplies and equipment
        case "761":
            if (($transaksi_trash == 0) && ($transaksi_status == 1)) {
//            if (($transaksi_trash == 0)) {
                $f_kali = "-1";
                $f_kali_2 = "1";
                $transaksi_jenis_terima = "761t";// terima di gudang produksi
                $persediaan_jenis = "supplies";
                $persediaan_jenis_terima = "supplies_produksi";
                $arrTransaksiChild = $t->getTransaksiChild($transaksi_id);

                //  region hapus transaksi data lama
                $t->setTransaksiDelete($transaksi_id);
                //  endregion hapus transaksi data lama

                $arrProdukFifo_2 = array();
                $arrBahanRequest = array();
                $fifo_lama = 0;

                foreach ($arrTransaksiChild as $arrData) {
                    $produk_id = $arrData['produk_id'];
                    $produk_qtt = $arrData['produk_ord_jml'];
                    $harga = $arrData['produk_ord_hrg'];
                    $premi = $arrData['produk_ord_diskon'];
                    $nama = $arrData['produk_nama'];
                    $new_harga = $harga - $premi;

                    $arrBahanNama[$produk_id] = $nama;
                    $arrBahanPremi[$produk_id] = $premi;
                    $arrBahanRequest[$produk_id] += $produk_qtt;

                    //  region fifo pusat
                    if ($fifo_lama == 1) {
                        for ($i = 1; $i <= $produk_qtt; $i++) {
                            $ff->setFifoJenis("produk");
                            $ff->setUnitNeed(1);
                            $arrProdukFifo_2[] = $ff->getFifo(0, $produk_id);
                        }
                    }
                    else {
                        $arrBahanData[$produk_id] = array(
                            "produk_id" => $produk_id,
                            "produk_qtt" => $produk_qtt,
                        );
                    }
                    //  endregion fifo pusat
                }
                if ($fifo_lama == 1) {
                    if (count($arrProdukFifo_2) > 0) {
                        $bahan_nilai_total_3 = 0;
                        foreach ($arrProdukFifo_2 as $arrProdukFifo_2Data) {
                            $bahan_nilai_total_2 = 0;
                            foreach ($arrProdukFifo_2Data as $bahan_id => $arrProdukFifo_2Data2) {
                                $bahan_nilai_total = 0;
                                foreach ($arrProdukFifo_2Data2 as $arrProdukFifo_2Data3) {
                                    $bahan_qtt = $arrProdukFifo_2Data3['unit'];
                                    $bahan_hpp = $arrProdukFifo_2Data3['hpp'];
                                    $bahan_nilai = $bahan_qtt * $bahan_hpp;
                                    $bahan_nilai_total += $bahan_nilai;

                                    $arrBahanFifo[$bahan_id][$bahan_hpp] += $bahan_qtt;
                                }
                                $bahan_nilai_total_2 += $bahan_nilai_total;
                            }
                            $bahan_nilai_total_3 += $bahan_nilai_total_2;
                        }
                    }
                }
                else {
                    $ff->setFifoJenis("supplies");
                    $arrBahanFifo = $ff->getFifoNonProduksi($arrBahanData, "supplies", $cabang_id, 0);
                    $bahan_nilai_total_3 = $arrBahanFifo['total'];
                }

                //  region insert ke transaksi data
                foreach ($arrBahanFifo as $bahan_id => $arrBahanFifoData) {
                    if (is_numeric($bahan_id)) {
                        foreach ($arrBahanFifoData as $bahan_hpp => $bahan_qtt) {
                            $bahan_nama = $arrBahanNama[$bahan_id];
                            $bahan_premi = $arrBahanPremi[$bahan_id];
                            $arrTransaksiChildNew = array(
                                "produk_jenis" => "supplies",
                                "produk_id" => "$bahan_id",
                                "produk_nama" => "$bahan_nama",
                                "produk_ord_hrg" => "$bahan_hpp",
                                "produk_ord_jml" => "$bahan_qtt",
                                "hpp" => "$bahan_hpp",
                                "produk_ord_diskon" => "$bahan_premi",
                            );
                            arrPrint($arrTransaksiChildNew);
                            $t->setTransaksiChildData($arrTransaksiChildNew);
                            $t->setTransaksiChild($transaksi_id);
                        }
                    }
                }
                //  endregion insert ke transaksi data

                $transaksi_nilai_premi = $transaksi_nilai - $transaksi_premi;
                $selisih_persediaan_fifo = $bahan_nilai_total_3 - $transaksi_nilai_premi;
                $selisih_persediaan_fifo_x = $selisih_persediaan_fifo;
                $transaksi_net = $bahan_nilai_total_3;

                //  region persediaan keluar GUDANG SUPPLIES
                // region set jurnal
                $j->setFKali($f_kali);
                $j->setCabangId($cabang_id);
                $j->setJurnal($transaksi_jenis, $transaksi_id, $transaksi_nomer, $transaksi_net);
                // endregion set jurnal

                cekBiru(":: JURNAL OKE... ::");

                //  region mutasi
                $arrProduk = array();
                $m->setFKali($f_kali);
//                $m->setSupplier($supplier_id);
                $m->setTransaksiId($transaksi_id);
                $m->setTransaksiNomer($transaksi_nomer);
                $m->setTransaksiNilai($transaksi_net);
                $m->setPersediaanJenis($persediaan_jenis);
                $m->setCabangId($cabang_id);

//                cekBiru(":: SIAP-2 PERSEDIAAN OKE... :: $transaksi_id");

                $arrTransaksiChild = array();
                $arrTransaksiChild = $t->getTransaksiChild($transaksi_id, "and trash='0'");

                $item_nilai_total = 0;
                foreach ($arrTransaksiChild as $arrData) {
                    $produk_id = $arrData['produk_id'];
                    $produk_qtt = $arrData['produk_ord_jml'];
                    $harga = $arrData['produk_ord_hrg'];
                    $premi = $arrData['produk_ord_diskon'];
                    $nama = $arrData['produk_nama'];
                    $pph = $arrData['ppn'];

                    $new_harga = $harga - $premi;
                    $item_nilai = $produk_qtt * $harga;
                    $item_nilai_total += $item_nilai;
//                    cekHijau("AYEE...");

                    $arrProduk = array(
                        "id" => "$produk_id",
                        "qtt" => "$produk_qtt",
                        "hpp" => "$harga",
                        "harga" => "$harga",
                        "nama" => "$nama"
                    );

                    $m->setProduk($arrProduk);
                    $m->setPersediaan($transaksi_jenis);
                }

                cekBiru(":: MUTASI PERSEDIAAN OKE... :: [$item_nilai_total] ::");

                //  region masuk sebagai biaya
//                $m->setFKali(1);
//                $m->setBiaya($transaksi_jenis);
                //  endregion masuk sebagai biaya

                //  endregion mutasi
                //  endregion persediaan keluar GUDANG SUPPLIES

                cekMerah(":: PERSEDIAAN KELUAR GUDANG PR SUKSES ::");
//mati_disini("SETOOPPP...");

                //  region persediaan masuk GUDANG PRODUKSI
                //  region mutasi
                $arrProduk = array();
                $m->setFKali($f_kali_2);
//                $m->setSupplier($supplier_id);
                $m->setTransaksiId($transaksi_id);
                $m->setTransaksiNomer($transaksi_nomer);
                $m->setTransaksiNilai($transaksi_net);
                $m->setPersediaanJenis($persediaan_jenis_terima);
                $m->setCabangId($cabang_id);

                cekBiru(":: SIAP-2 PERSEDIAAN MASUK PRODUKSI... ::");

//                $arrTransaksiChild = $t->getTransaksiChild($transaksi_id);
                $item_nilai_total = 0;
                foreach ($arrTransaksiChild as $arrData) {
                    $produk_id = $arrData['produk_id'];
                    $produk_qtt = $arrData['produk_ord_jml'];
                    $harga = $arrData['produk_ord_hrg'];
                    $premi = $arrData['produk_ord_diskon'];
                    $nama = $arrData['produk_nama'];
                    $pph = $arrData['ppn'];

                    $new_harga = $harga - $premi;
                    $item_nilai = $produk_qtt * $new_harga;
                    $item_nilai_total += $item_nilai;


                    $arrProduk = array(
                        "id" => "$produk_id",
                        "qtt" => "$produk_qtt",
                        "hpp" => "$harga",
                        "harga" => "$harga",
                        "nama" => "$nama"
                    );
                    $m->setProduk($arrProduk);
                    $m->setPersediaan($transaksi_jenis_terima);

                    //  region fifo supplies produksi
                    $arrFifo = array(
                        "produk_id" => $produk_id,
                        "produk_nama" => $nama,
                        "unit" => $produk_qtt,
                        "hpp" => $new_harga,
                        "jml_nilai" => $item_nilai,
                    );
                    $ff->setFifoJenis($persediaan_jenis_terima);
                    $ff->setCabangId($cabang_id);
                    $ff->setProdukId($produk_id);
                    $ff->setTransaksiId($transaksi_id);
                    $ff->setTransaksiJenis($transaksi_jenis_terima);
                    $ff->setFifo($arrFifo);
                    //  endregion fifo supplies produksi
                    cekBiru(":: LANJUT ke CACHE...");
                    //  region masuk cache supplies produksi
                    $arrProduk = array(
                        "produk_id" => $produk_id,
                        "produk_qtt" => $produk_qtt,
                        "produk_nama" => $nama,
                    );
                    $m->setProduk($arrProduk);
                    $m->setTransaksiId($transaksi_id);
                    $m->setTransaksiJenis($transaksi_jenis_terima);
                    $m->setTransaksiNomer($transaksi_nomer);
                    $m->setPersediaanCacheUI($produk_id, $persediaan_jenis_terima, $cabang_id, "0");
//cekBiru("$m->setPersediaanCacheUI($produk_id, $persediaan_jenis_terima, $cabang_id, \"0\");");
                    //  endregion masuk cache supplies produksi
                }

                cekBiru(":: MUTASI PERSEDIAAN OKE... :: [$item_nilai_total] ::");

                //  endregion mutasi
                //  endregion persediaan masuk GUDANG PRODUKSI

                cekMerah(":: PERSEDIAAN MASUK GUDANG PRODUKSI SUKSES ::");
            }

            //  region cache sinkron menjadi 1
            $m->setPersediaanCacheUISinkron($transaksi_id, "supplies");
            $m->setPersediaanCacheUISinkron($transaksi_id, "supplies_produksi");
            //  endregion cache sinkron menjadi 1

            //  region update transaksi yang sudah diambil
            $arrTransaksiUpdate = array(
                "sinkron" => "1"
            );
            $t->setTransaksionalId($transaksi_id);
            $t->setTransaksional($arrTransaksiUpdate, false);
            //  endregion update transaksi yang sudah diambil

            $sukses = 1;

            break;
        //  case produksi
        case "776r":
            if ($transaksi_trash == 0) {


                //  region versi baru

                $transaksi_jenis = "776";
                $arrTransaksiChild = $arrTransaksiData;
                if (count($arrTransaksiChild) > 0) {
                    $execFIFO_rslts = execFIFO_produksi($transaksi_id, $transaksi_jenis) or die("Eksekusi FIFO bahan dan produk tidak berhasil!");
                    $transaksi_nilai = $execFIFO_rslts['akumNilaiSemuaProduk'];
                    $arrHppProduk = $execFIFO_rslts['akumNilaiSemuaProduk'];
                    $rsltQueries_bahan = $execFIFO_rslts['rsltQueries_bahan'];
                    $rsltQueries_produk = $execFIFO_rslts['rsltQueries_produk'];
                }
                else {
//                    addOutput("data rincian order produksi kosong");
                    mati_disini("data rincian order produksi kosong");
                    die();
                    $transaksi_nilai = 0;
                }
                //  region cek produk order dan produk jadi
                $count_produk_order = count($arrCek['produk']);
                $count_produk_jadi = count($arrCekProduk);

                if ($count_produk_order != $count_produk_jadi) {
//                    addOutput("jumlah produk order dengan produk jadi tidak sama.");
                    mati_disini("jumlah produk order dengan produk jadi tidak sama.");
                    die();
                }
                //  endregion cek produk order dan produk jadi

                cekMerah("FIFO BAHAN, FIFO PRODUK HASIL OKE...");

                $transaksi_nilai < 1 ? mati_disini(__LINE__ . " transaksi nilai: 0") : "";

                //  region number nota
//                $t->setOlehId($transaksi_oleh_id);
//                $transaksi_inv_f = $transaksi_inv > 0 ? "-$transaksi_inv" : "";
//                $transaksi_nomer_f = "$transaksi_nomer$transaksi_inv_f";
//                $t->setGudangId($gudang_id);
//                $t->setCabangId($cabang_id);
//                $t->setNumberingTambahan($transaksi_jenis);
//                $counters_gudang = $t->getNumberingTambahan();
//                $counters_gudang = explode("-", $counters_gudang);
//
//                addOutput(__LINE__ . "$transaksi_nomer_f");
                //  endregion number nota

                //  region transaksi
                $arrTransaksi = array(
//                    "nomer" => "$transaksi_nomer_f",
                    "oleh_id" => "$transaksi_oleh_id",
                    "oleh_nama" => "$transaksi_oleh_nama",
                    "transaksi_nilai" => "$transaksi_nilai",
                    "transaksi_net" => "$transaksi_nilai",
                    "referensi_id" => "$transaksi_id",
//                    "inv" => "$transaksi_inv",
                    "sinkron" => "1",
                    "cabang_id" => "$cabang_id",
//                    "gudang_id" => "$gudang_id",
//                    "gudang_nama" => "$gudang_nama",
//                    "counters_gudang_id" => $counters_gudang[0],
//                    "counters_gudang_id_all" => $counters_gudang[1],
                );
//                arrPrint($arrTransaksi);

                $f_kali = 1;
                $t->setFKali($f_kali);
                $t->setTransaksiNilai($transaksi_nilai);
                $t->setInv(true);
                $t->setTransaksiJenis($transaksi_jenis);
                $t->setCabangId($cabang_id);
                $t->setTransaksional($arrTransaksi, true);
                $insertID = $transaksional_id = $t->getTransaksionalId();
                $transaksi_nomer = $t->getTransaksiData($transaksional_id)['nomer'];


                $jmlData = count($rsltQueries_bahan);
                $_dataCounter = 0;
                foreach ($rsltQueries_bahan as $q) {
                    $_dataCounter++;
                    $execQ = mysql_query($q) or die(mysql_error() . " " . __FILE__ . " line " . __LINE__);
                    updateProgress("updateFIFO_bahan", hitungPersentase($_dataCounter, $jmlData));
                }

                $jmlData = count($rsltQueries_produk);
                $_dataCounter = 0;
                foreach ($rsltQueries_produk as $q) {
                    $_dataCounter++;
                    $q = str_replace("{TRID}", $insertID, $q);
                    $execQ = mysql_query($q) or die(mysql_error() . " " . __FILE__ . " line " . __LINE__);
                    updateProgress("updateFIFO_produk", hitungPersentase($_dataCounter, $jmlData));
                }

                $cntPro = 0;
//                addOutput("Memproses transaksi...");
//                addOutput("Mengiterasi daftar produk...");

                $jmlData = count($execFIFO_rslts['productList']);
                $_dataCounter = 0;
                foreach ($execFIFO_rslts['productList'] as $pSpec) {
                    $_dataCounter++;
                    updateProgress("updateChildTransaksi_produk", hitungPersentase($_dataCounter, $jmlData));

                    $pID = $pSpec['produk_id'];
                    $produk_nama = $d->getProdukData($pID)['nama'];
                    $arrChilddata = array(
                        "produk_id" => "$pID",
                        "produk_nama" => "$produk_nama",
                        "produk_ord_hrg" => ($pSpec['hpp']),
                        "hpp" => ($pSpec['hpp']),
                        "produk_ord_jml" => $pSpec['jml'],
                        "produk_jenis" => "produk",
                    );
//                    arrPrint($arrChilddata);
                    $t->setTransaksiChildData($arrChilddata);
                    $t->setTransaksiChild($transaksional_id);

                    //region mutasi produk
                    $m->setFKali(1);
                    $m->setPersediaanJenis("produk_produksi");
                    $m->setTransaksiId($transaksional_id);
                    $m->setTransaksiNomer($transaksi_nomer);
                    $arrProduk_2 = array(
                        "id" => $pID,
                        "qtt" => $pSpec['jml'],
                        "hpp" => ($pSpec['hpp']),
                        "harga" => ($pSpec['hpp']),
                        "nama" => $produk_nama,
                    );
                    $m->setProduk($arrProduk_2);

                    //  region gudang
                    $arrAuthor = array(
                        "author_id" => "$transaksi_oleh_id",
                        "author_nama" => "$transaksi_oleh_nama",
                    );
//                    $arrGudangData = array(
//                        "gudang_id" => "$gudang_id",
//                        "gudang_nama" => "$gudang_nama",
//                    );
//                    $m->setGudangJenis("produksi");
                    $m->setAuthor($arrAuthor);
//                    $m->setGudang($arrGudangData);

                    //  endregion gudang

                    $m->setPersediaan($transaksi_jenis);

//                    $m->setProdukCacheGudang($transaksi_jenis);

                    //endregion mutasi produk
                    //  region penambahan cache produk
                    $arrProduk = array(
                        "produk_id" => $pID,
                        "produk_qtt" => $pSpec['jml'],
                        "produk_nama" => $produk_nama,
                    );
                    $m->setProduk($arrProduk);
                    $m->setTransaksiId($transaksional_id);
                    $m->setTransaksiJenis($transaksi_jenis);
                    $m->setTransaksiNomer($transaksi_nomer);
                    $m->setCabangId($cabang_id);
                    $m->setPersediaanCacheUI($pID, "produk_produksi", $cabang_id, "0");
                    //  endregion penambahan cache produk

                    // region create fifo produk
                    $produk_jml_nilai = ($pSpec['jml'] * $pSpec['hpp']);
                    $arrFifo = array(
                        "produk_id" => $pID,
                        "produk_nama" => $produk_nama,
                        "unit" => $pSpec['jml'],
                        "hpp" => ($pSpec['hpp']),
                        "jml_nilai" => $produk_jml_nilai,
                    );
                    $ff->setCabangId(CB_ID_PUSAT);
                    $ff->setTransaksiId($transaksional_id);
                    $ff->setTransaksiJenis(776);
                    $ff->setFifoJenis("produk_produksi");
                    $ff->setFifo($arrFifo);
                    // endregion create fifo produk

                    $total_produk_in += ($pSpec['jml'] * $pSpec['hpp']);


                    $cntPro++;
                    //echo "iterasi fifo produk ke#$cntPro<br>";
                    //echo "total nilai produk masuk sekarang: $total_produk_in<br>";
                    //createLog("memproduksi $p_nama dengan hpp: $produk_hpp_0, sebanyak $produk_qtt_0", "data", $transaksional_id);
                    //
                }

                cekMerah("URUSAN PRODUK HASIL PRODUKSI SELESAI...");
//mati_disini("SETOP... [$transaksi_nomer]");

                $cntBah = 0;
                addOutput("Mengiterasi daftar bahan...");
                $jmlData = count($execFIFO_rslts['bahanList']);
                $_dataCounter = 0;
                foreach ($execFIFO_rslts['bahanList'] as $bSpec) {
                    $_dataCounter++;
                    updateProgress("updateChildTransaksi_bahan", hitungPersentase($_dataCounter, $jmlData));

                    $bID = $bSpec['bahan_id'];
                    $bahan_qtt_0 = $bSpec['diambil'];
                    $arrChilddata = array(
                        "produk_id" => $bID,
                        "produk_nama" => $bSpec['nama'],
                        "produk_ord_hrg" => ($bSpec['hpp']),
                        "produk_ord_jml" => $bSpec['diambil'],
                        "produk_jenis" => "bahan",
                        "parent_id" => $bSpec['produk_id'],
                    );
                    $t->setTransaksiChildData($arrChilddata);
                    $t->setTransaksiChild($transaksional_id);

                    $arrProduk = array(
                        "id" => $bID,
                        "qtt" => $bSpec['diambil'],
                        "hpp" => $bSpec['hpp'],
                        "harga" => ($bSpec['hpp']),
                        "nama" => $bSpec['nama']
                    );
                    $m->setFKali(-1);
                    $m->setTransaksiId($transaksional_id);
                    $m->setPersediaanJenis("supplies_produksi");
                    $m->setProduk($arrProduk);
                    $m->setPersediaan($transaksi_jenis);

                    $total_bahan_ot += ($bSpec['hpp'] * $bSpec['diambil']);
                    $cntBah++;
                }
                //  endregion transaksi

                cekMerah("PERSEDIAAN BAHAN SELESAI...");

                //  region jurnal
                $j->setFKali($f_kali);
                $j->setJurnal($transaksi_jenis, $transaksional_id, $transaksi_nomer_f, $transaksi_nilai);
                //  endregion jurnal

                cekMerah("JURNAL SELESAI...");
//mati_disini();
                // region validasi transaksi_net
                if ($transaksi_nilai != $total_bahan_ot) {
                    addOutput("transaksi gagal! transaksi_nilai: $transaksi_nilai != sum bahan: $total_bahan_ot @line: " . __LINE__ . " " . __FILE__);
                    die();
                }
                elseif ($transaksi_nilai != $total_produk_in) {
                    addOutput("transaksi gagal! $transaksi_nilai != $total_produk_in " . __LINE__ . " " . __FILE__);
                    die();
                }
                elseif ($total_bahan_ot != $total_produk_in) {
                    addOutput("transaksi gagal! $total_bahan_ot != $total_produk_in " . __LINE__ . " " . __FILE__);
                    die();
                }
                // endregion validasi transaksi_net

                //  region update 776r transaksi (selesai proses)
                $arrUpdate = array();
                $arrUpdate = array(
                    "status" => "1",
                    "sinkron" => "1",
                );
                //                    $t->setTransaksionalId($transaksi_id);
                //                    $t->setTransaksional($arrUpdate, false);
                $c->setTbl("transaksi");
                $c->setConditional("where id='$transaksi_id' and sinkron='0'");
                $c->setCreate($arrUpdate, false);
                //  endregion update 776r transaksi (selesai proses)

                //  region update cache sinkron
                $produk_jenis = "produk_produksi";
                $m->setPersediaanCacheUISinkron($transaksional_id, $produk_jenis);

                $produk_jenis = "supplies_produksi";
                $m->setPersediaanCacheUISinkron($transaksi_id, $produk_jenis);
                //  endregion update cache sinkron

                //  endregion versi baru


                $sukses = 1;
            }
            else {
                $msg = "tr_id: $transaksi_id nomer: $transaksi_nomer telah dibatalkan (cabang $cabang_id).";
                createLog("$msg", "dev", "$transaksi_id");

                $arrTransaksiUpdate = array(
                    "sinkron" => "1",
                );
                $t->setTransaksionalId($transaksi_id);
                $t->setTransaksional($arrTransaksiUpdate, false);
            }


            break;
        //  case pemindahan produk gudang produksi ke distribusi
        case "722":
            $arrTransaksiChild = $t->getTransaksiChild($transaksi_id);
            if (count($arrTransaksiChild) < 1) {
                mati_disini(__LINE__ . " transaksi_child transaksi_id:$transaksi_id tidak terdeteksi");
            }
            $t->setTransaksiDelete($transaksi_id);


            //  region mengambil fifo produk per-gudang produksi
            $produk_hpp_total_total_2 = 0;
            foreach ($arrTransaksiChild as $arrTransaksiChildData) {
                $produk_id = $arrTransaksiChildData['produk_id'];
                $produk_nama = $arrTransaksiChildData['produk_nama'];
                $produk_qtt = $arrTransaksiChildData['produk_ord_jml'];

                $arrProdukNama[$produk_id] = $produk_nama;

                $ff->setFifoJenis("produk_produksi");
                $ff->setUnitNeed(1);
//                $ff->setGudangId($gudang_id);
                $produk_hpp_total_total = 0;
                for ($i = 1; $i <= $produk_qtt; $i++) {
                    $arrFifoGudang = $ff->getFifo($cabang_id, $produk_id);
                    $produk_hpp_total = 0;
                    if (count($arrFifoGudang[$produk_id]) > 0) {
                        foreach ($arrFifoGudang[$produk_id] as $arrProdukData) {
                            $produk_hpp = $arrProdukData["hpp"];
                            $arrHppProduk[$produk_id][$produk_hpp] += 1;
                            $produk_hpp_total += $produk_hpp;
                            //                                cekHere("@@ $produk_hpp @@");
                        }
                    }
                    $produk_hpp_total_total += $produk_hpp_total;
                }
                $produk_hpp_total_total_2 += $produk_hpp_total_total;
            }
            //  endregion mengambil fifo produk per-gudang produksi
            cekMerah("FIFO AMBIL PRODUKSI SUKSES");

            //  region jurnal
            $j->setFKali(-1);
            $j->setJurnal($transaksi_jenis, $transaksi_id, $transaksi_nomer, $produk_hpp_total_total_2);
            //  endregion jurnal
            cekMerah("JURNAL SUKSES");

            //  region mutasi gudang asal produksi
            $m->setFKali(-1);
            $m->setPersediaanJenis("produk_produksi");
            $m->setTransaksiNomer($transaksi_nomer);
            $m->setTransaksiId($transaksi_id);
            foreach ($arrHppProduk as $produk_id => $arrHppQtt) {
                $produk_nama = $arrProdukNama[$produk_id];
                foreach ($arrHppQtt as $produk_hpp => $produk_qtt) {

                    //  region replace transaksi data 722
                    $arrProdukData = array(
                        "produk_id" => $produk_id,
                        "produk_nama" => $produk_nama,
                        "produk_ord_jml" => $produk_qtt,
                        "produk_ord_hrg" => $produk_hpp,
                        "hpp" => $produk_hpp,
                        "produk_jenis" => "produk",
                    );
                    $t->setTransaksiChildData($arrProdukData);
                    $t->setTransaksiChild($transaksi_id);
                    //  endregion replace transaksi data 722

                    //  region mutasi real keluar dari gudang_id
                    $arrAuthor = array(
                        "author_id" => "$transaksi_oleh_id",
                        "author_nama" => "$transaksi_oleh_nama",
                    );
//                    $arrGudangData = array(
//                        "gudang_id" => "$gudang_id",
//                        "gudang_nama" => "$gudang_nama",
//                    );
                    $arrProduk = array(
                        "id" => $produk_id,
                        "nama" => $produk_nama,
                        "qtt" => $produk_qtt,
                        "hpp" => $produk_hpp,
                    );
                    $m->setProduk($arrProduk);
//                    $m->setGudangJenis("produksi");
                    $m->setAuthor($arrAuthor);
//                    $m->setGudang($arrGudangData);
                    $m->setPersediaan($transaksi_jenis);
                    //  endregion mutasi real keluar dari gudang_id
                }
            }
            //  endregion mutasi gudang asal produksi
            cekMerah("PERSEDIAAN PRODUKSI SUSKES");
//mati_disini();

            //  region mutasi masuk gudang distribusi/ siap jual
            $m->setFKali(1);
            $m->setPersediaanJenis("produk");
            $m->setTransaksiNomer($transaksi_nomer);
            $m->setTransaksiId($transaksi_id);
            foreach ($arrHppProduk as $produk_id => $arrHppQtt) {
                $produk_nama = $arrProdukNama[$produk_id];
                foreach ($arrHppQtt as $produk_hpp => $produk_qtt) {
                    //  region masuk ke fifo distribusi
                    $produk_jml_nilai = $produk_qtt * $produk_hpp;
                    $arrFifo = array(
                        "produk_id" => $produk_id,
                        "produk_nama" => $produk_nama,
                        "unit" => $produk_qtt,
                        "hpp" => $produk_hpp,
                        "jml_nilai" => $produk_jml_nilai,
                    );
                    $ff->setCabangId($cabang_id);
                    $ff->setTransaksiId($transaksi_id);
                    $ff->setTransaksiJenis($transaksi_jenis);
                    $ff->setFifoJenis("produk");
                    $ff->setGudangId(0); // fifo masing-masing gudang, bila gudang_id > 0
                    $ff->setFifo($arrFifo);
                    //  endregion masuk ke fifo distribusi

                    //  region mutasi real masuk ke distribusi
                    $arrAuthor = array(
                        "author_id" => "$transaksi_oleh_id",
                        "author_nama" => "$transaksi_oleh_nama",
                    );
                    $arrGudangData = array(
                        "gudang_id" => "0",
                        "gudang_nama" => "",
                    );
                    $arrProduk = array(
                        "id" => $produk_id,
                        "nama" => $produk_nama,
                        "qtt" => $produk_qtt,
                        "hpp" => $produk_hpp,
                    );
                    $m->setProduk($arrProduk);
                    $m->setGudangJenis("distribusi");
                    $m->setAuthor($arrAuthor);
                    $m->setGudang($arrGudangData);
                    $m->setPersediaan($transaksi_jenis);
                    //  endregion mutasi real masuk ke distribusi

                    //  region mutasi cache masuk ke distribusi
                    $arrProduk = array(
                        "produk_id" => "$produk_id",
                        "produk_qtt" => $produk_qtt,
                        "produk_nama" => $produk_nama,
                    );
                    $m->setFKali(1);
                    $m->setProduk($arrProduk);
                    $m->setCabangId($cabang_id);
                    $m->setTransaksiId($transaksi_id);
                    $m->setTransaksiJenis($transaksi_jenis);
                    $m->setTransaksiNomer($transaksi_nomer);
                    $m->setPersediaanCacheUI($produk_id, "produk", $cabang_id, "0");
                    //  endregion mutasi cache masuk ke distribusi
                }
            }
            //  endregion mutasi masuk gudang distribusi/ siap jual

            cekMerah("FIFO MASUK SIAP PENJUALAN SUKSES");
            cekMerah("PERSEDIAAN MASUK SIAP PENJUALAN SUKSES");
            cekMerah("PERSEDIAAN CACHE UI MASUK SIAP PENJUALAN SUKSES");
//mati_disini();

            //  region update cache gudang yang diambil referensi_id
            $produk_jenis = "produk_produksi";
            $m->setPersediaanCacheUISinkron($referensi_id, $produk_jenis);

            $produk_jenis = "produk";
            $m->setPersediaanCacheUISinkron($transaksi_id, $produk_jenis);
            //  endregion update cache gudang yang diambil referensi_id

            //  region update transaksi
            $arrTransaksiUpdate = array(
                "sinkron" => "1",
            );
            $t->setTransaksionalId($transaksi_id);
            $t->setTransaksional($arrTransaksiUpdate, false);
            //  endregion update transaksi


            $sukses = 1;
            break;
        //  case return pemindahan produk gudang produksi ke distribusi
        case "922":
            $arrTransaksiChild = $t->getTransaksiChild($transaksi_id);
            if (count($arrTransaksiChild) < 1) {
                mati_disini(__LINE__ . " transaksi_child transaksi_id:$transaksi_id tidak terdeteksi");
            }
            $t->setTransaksiDelete($transaksi_id);
            $transaksi_jenis_terima = "922t";// terima di gudang produksi

            //  region mengambil fifo produk per-gudang produksi
            $produk_hpp_total_total_2 = 0;
            foreach ($arrTransaksiChild as $arrTransaksiChildData) {
                $produk_id = $arrTransaksiChildData['produk_id'];
                $produk_nama = $arrTransaksiChildData['produk_nama'];
                $produk_qtt = $arrTransaksiChildData['produk_ord_jml'];

                $arrProdukNama[$produk_id] = $produk_nama;

//                $ff->setFifoJenis("produk_produksi");
                $ff->setFifoJenis("produk");
                $ff->setUnitNeed(1);
//                $ff->setGudangId($gudang_id);
                $produk_hpp_total_total = 0;
                for ($i = 1; $i <= $produk_qtt; $i++) {
                    $arrFifoGudang = $ff->getFifo($cabang_id, $produk_id);
                    $produk_hpp_total = 0;
                    if (count($arrFifoGudang[$produk_id]) > 0) {
                        foreach ($arrFifoGudang[$produk_id] as $arrProdukData) {
                            $produk_hpp = $arrProdukData["hpp"];
                            $arrHppProduk[$produk_id][$produk_hpp] += 1;
                            $produk_hpp_total += $produk_hpp;
                            //                                cekHere("@@ $produk_hpp @@");
                        }
                    }
                    $produk_hpp_total_total += $produk_hpp_total;
                }
                $produk_hpp_total_total_2 += $produk_hpp_total_total;
            }
            //  endregion mengambil fifo produk per-gudang produksi
            cekMerah("FIFO AMBIL PRODUKSI SUKSES");

            //  region jurnal
            $j->setFKali(-1);
            $j->setJurnal($transaksi_jenis, $transaksi_id, $transaksi_nomer, $produk_hpp_total_total_2);
            //  endregion jurnal
            cekMerah("JURNAL SUKSES");

            //  region mutasi gudang asal produksi
            $m->setFKali(-1);
//            $m->setPersediaanJenis("produk_produksi");
            $m->setPersediaanJenis("produk");
            $m->setTransaksiNomer($transaksi_nomer);
            $m->setTransaksiId($transaksi_id);
            foreach ($arrHppProduk as $produk_id => $arrHppQtt) {
                $produk_nama = $arrProdukNama[$produk_id];
                foreach ($arrHppQtt as $produk_hpp => $produk_qtt) {

                    //  region replace transaksi data 722
                    $arrProdukData = array(
                        "produk_id" => $produk_id,
                        "produk_nama" => $produk_nama,
                        "produk_ord_jml" => $produk_qtt,
                        "produk_ord_hrg" => $produk_hpp,
                        "hpp" => $produk_hpp,
                        "produk_jenis" => "produk",
                    );
                    $t->setTransaksiChildData($arrProdukData);
                    $t->setTransaksiChild($transaksi_id);
                    //  endregion replace transaksi data 722

                    //  region mutasi real keluar dari gudang_id
                    $arrAuthor = array(
                        "author_id" => "$transaksi_oleh_id",
                        "author_nama" => "$transaksi_oleh_nama",
                    );
//                    $arrGudangData = array(
//                        "gudang_id" => "$gudang_id",
//                        "gudang_nama" => "$gudang_nama",
//                    );
                    $arrProduk = array(
                        "id" => $produk_id,
                        "nama" => $produk_nama,
                        "qtt" => $produk_qtt,
                        "hpp" => $produk_hpp,
                    );
                    $m->setProduk($arrProduk);
//                    $m->setGudangJenis("produksi");
                    $m->setAuthor($arrAuthor);
//                    $m->setGudang($arrGudangData);
                    $m->setPersediaan($transaksi_jenis);
                    //  endregion mutasi real keluar dari gudang_id
                }
            }
            //  endregion mutasi gudang asal produksi
            cekMerah("PERSEDIAAN PRODUKSI SUSKES");
//mati_disini();

            //  region mutasi masuk gudang distribusi/ siap jual
            $m->setFKali(1);
            $m->setPersediaanJenis("produk_produksi");
            $m->setTransaksiNomer($transaksi_nomer);
            $m->setTransaksiId($transaksi_id);
            foreach ($arrHppProduk as $produk_id => $arrHppQtt) {
                $produk_nama = $arrProdukNama[$produk_id];
                foreach ($arrHppQtt as $produk_hpp => $produk_qtt) {
                    //  region masuk ke fifo distribusi
                    $produk_jml_nilai = $produk_qtt * $produk_hpp;
                    $arrFifo = array(
                        "produk_id" => $produk_id,
                        "produk_nama" => $produk_nama,
                        "unit" => $produk_qtt,
                        "hpp" => $produk_hpp,
                        "jml_nilai" => $produk_jml_nilai,
                    );
                    $ff->setCabangId($cabang_id);
                    $ff->setTransaksiId($transaksi_id);
                    $ff->setTransaksiJenis($transaksi_jenis_terima);
                    $ff->setFifoJenis("produk_produksi");
                    $ff->setGudangId(0); // fifo masing-masing gudang, bila gudang_id > 0
                    $ff->setFifo($arrFifo);
                    //  endregion masuk ke fifo distribusi

                    //  region mutasi real masuk ke distribusi
                    $arrAuthor = array(
                        "author_id" => "$transaksi_oleh_id",
                        "author_nama" => "$transaksi_oleh_nama",
                    );
//                    $arrGudangData = array(
//                        "gudang_id" => "0",
//                        "gudang_nama" => "",
//                    );
                    $arrProduk = array(
                        "id" => $produk_id,
                        "nama" => $produk_nama,
                        "qtt" => $produk_qtt,
                        "hpp" => $produk_hpp,
                    );
                    $m->setProduk($arrProduk);
//                    $m->setGudangJenis("distribusi");
                    $m->setAuthor($arrAuthor);
//                    $m->setGudang($arrGudangData);
                    $m->setPersediaan($transaksi_jenis_terima);
                    //  endregion mutasi real masuk ke distribusi

                    //  region mutasi cache masuk ke distribusi
                    $arrProduk = array(
                        "produk_id" => "$produk_id",
                        "produk_qtt" => $produk_qtt,
                        "produk_nama" => $produk_nama,
                    );
                    $m->setFKali(1);
                    $m->setProduk($arrProduk);
                    $m->setCabangId($cabang_id);
                    $m->setTransaksiId($transaksi_id);
                    $m->setTransaksiJenis($transaksi_jenis_terima);
                    $m->setTransaksiNomer($transaksi_nomer);
                    $m->setPersediaanCacheUI($produk_id, "produk_produksi", $cabang_id, "0");
                    //  endregion mutasi cache masuk ke distribusi
                }
            }
            //  endregion mutasi masuk gudang distribusi/ siap jual

            cekMerah("FIFO MASUK SIAP PENJUALAN SUKSES");
            cekMerah("PERSEDIAAN MASUK SIAP PENJUALAN SUKSES");
            cekMerah("PERSEDIAAN CACHE UI MASUK SIAP PENJUALAN SUKSES");
//mati_disini();

            //  region update cache gudang yang diambil referensi_id
            $produk_jenis = "produk_produksi";
            $m->setPersediaanCacheUISinkron($transaksi_id, $produk_jenis);

            $produk_jenis = "produk";
            $m->setPersediaanCacheUISinkron($referensi_id, $produk_jenis);
            //  endregion update cache gudang yang diambil referensi_id

            //  region update transaksi
            $arrTransaksiUpdate = array(
                "sinkron" => "1",
            );
            $t->setTransaksionalId($transaksi_id);
            $t->setTransaksional($arrTransaksiUpdate, false);
            //  endregion update transaksi


            $sukses = 1;
            break;
        //  case return penggunaan barang supplies and equipment
        case "921":
            if (($transaksi_trash == 0) && ($transaksi_status == 1)) {
//            if (($transaksi_trash == 0)) {
                $f_kali = "-1";
                $f_kali_2 = "1";
//                $transaksi_jenis_terima = "761t";// terima di gudang produksi
                $transaksi_jenis_terima = "921t";// terima di gudang produksi
//                $persediaan_jenis = "supplies";
//                $persediaan_jenis_terima = "supplies_produksi";
                $persediaan_jenis = "supplies_produksi";
                $persediaan_jenis_terima = "supplies";
                $arrTransaksiChild = $t->getTransaksiChild($transaksi_id);

                //  region hapus transaksi data lama
                $t->setTransaksiDelete($transaksi_id);
                //  endregion hapus transaksi data lama

                $arrProdukFifo_2 = array();
                $arrBahanRequest = array();
                $fifo_lama = 0;

                foreach ($arrTransaksiChild as $arrData) {
                    $produk_id = $arrData['produk_id'];
                    $produk_qtt = $arrData['produk_ord_jml'];
                    $harga = $arrData['produk_ord_hrg'];
                    $premi = $arrData['produk_ord_diskon'];
                    $nama = $arrData['produk_nama'];
                    $new_harga = $harga - $premi;

                    $arrBahanNama[$produk_id] = $nama;
                    $arrBahanPremi[$produk_id] = $premi;
                    $arrBahanRequest[$produk_id] += $produk_qtt;

                    //  region fifo pusat
                    if ($fifo_lama == 1) {
                        for ($i = 1; $i <= $produk_qtt; $i++) {
                            $ff->setFifoJenis("produk");
                            $ff->setUnitNeed(1);
                            $arrProdukFifo_2[] = $ff->getFifo(0, $produk_id);
                        }
                    }
                    else {
                        $arrBahanData[$produk_id] = array(
                            "produk_id" => $produk_id,
                            "produk_qtt" => $produk_qtt,
                        );
                    }
                    //  endregion fifo pusat
                }
                if ($fifo_lama == 1) {
                    if (count($arrProdukFifo_2) > 0) {
                        $bahan_nilai_total_3 = 0;
                        foreach ($arrProdukFifo_2 as $arrProdukFifo_2Data) {
                            $bahan_nilai_total_2 = 0;
                            foreach ($arrProdukFifo_2Data as $bahan_id => $arrProdukFifo_2Data2) {
                                $bahan_nilai_total = 0;
                                foreach ($arrProdukFifo_2Data2 as $arrProdukFifo_2Data3) {
                                    $bahan_qtt = $arrProdukFifo_2Data3['unit'];
                                    $bahan_hpp = $arrProdukFifo_2Data3['hpp'];
                                    $bahan_nilai = $bahan_qtt * $bahan_hpp;
                                    $bahan_nilai_total += $bahan_nilai;

                                    $arrBahanFifo[$bahan_id][$bahan_hpp] += $bahan_qtt;
                                }
                                $bahan_nilai_total_2 += $bahan_nilai_total;
                            }
                            $bahan_nilai_total_3 += $bahan_nilai_total_2;
                        }
                    }
                }
                else {
                    $ff->setFifoJenis("$persediaan_jenis");
                    $arrBahanFifo = $ff->getFifoNonProduksi($arrBahanData, "$persediaan_jenis", $cabang_id, 0);
                    $bahan_nilai_total_3 = $arrBahanFifo['total'];
                }

                //  region insert ke transaksi data
                foreach ($arrBahanFifo as $bahan_id => $arrBahanFifoData) {
                    if (is_numeric($bahan_id)) {
                        foreach ($arrBahanFifoData as $bahan_hpp => $bahan_qtt) {
                            $bahan_nama = $arrBahanNama[$bahan_id];
                            $bahan_premi = $arrBahanPremi[$bahan_id];
                            $arrTransaksiChildNew = array(
                                "produk_jenis" => "supplies",
                                "produk_id" => "$bahan_id",
                                "produk_nama" => "$bahan_nama",
                                "produk_ord_hrg" => "$bahan_hpp",
                                "produk_ord_jml" => "$bahan_qtt",
                                "hpp" => "$bahan_hpp",
                                "produk_ord_diskon" => "$bahan_premi",
                            );
                            arrPrint($arrTransaksiChildNew);
                            $t->setTransaksiChildData($arrTransaksiChildNew);
                            $t->setTransaksiChild($transaksi_id);
                        }
                    }
                }
                //  endregion insert ke transaksi data

                $transaksi_nilai_premi = $transaksi_nilai - $transaksi_premi;
                $selisih_persediaan_fifo = $bahan_nilai_total_3 - $transaksi_nilai_premi;
                $selisih_persediaan_fifo_x = $selisih_persediaan_fifo;
                $transaksi_net = $bahan_nilai_total_3;

                //  region persediaan keluar GUDANG SUPPLIES PRODUKSI
                // region set jurnal
                $j->setFKali($f_kali);
                $j->setCabangId($cabang_id);
                $j->setJurnal($transaksi_jenis, $transaksi_id, $transaksi_nomer, $transaksi_net);
                // endregion set jurnal

                cekBiru(":: JURNAL OKE... ::");

                //  region mutasi
                $arrProduk = array();
                $m->setFKali($f_kali);
//                $m->setSupplier($supplier_id);
                $m->setTransaksiId($transaksi_id);
                $m->setTransaksiNomer($transaksi_nomer);
                $m->setTransaksiNilai($transaksi_net);
                $m->setPersediaanJenis($persediaan_jenis);
                $m->setCabangId($cabang_id);

//                cekBiru(":: SIAP-2 PERSEDIAAN OKE... :: $transaksi_id");

                $arrTransaksiChild = array();
                $arrTransaksiChild = $t->getTransaksiChild($transaksi_id, "and trash='0'");

                $item_nilai_total = 0;
                foreach ($arrTransaksiChild as $arrData) {
                    $produk_id = $arrData['produk_id'];
                    $produk_qtt = $arrData['produk_ord_jml'];
                    $harga = $arrData['produk_ord_hrg'];
                    $premi = $arrData['produk_ord_diskon'];
                    $nama = $arrData['produk_nama'];
                    $pph = $arrData['ppn'];

                    $new_harga = $harga - $premi;
                    $item_nilai = $produk_qtt * $harga;
                    $item_nilai_total += $item_nilai;
//                    cekHijau("AYEE...");

                    $arrProduk = array(
                        "id" => "$produk_id",
                        "qtt" => "$produk_qtt",
                        "hpp" => "$harga",
                        "harga" => "$harga",
                        "nama" => "$nama"
                    );

                    $m->setProduk($arrProduk);
                    $m->setPersediaan($transaksi_jenis);
                }

                cekBiru(":: MUTASI PERSEDIAAN OKE... :: [$item_nilai_total] ::");

                //  region masuk sebagai biaya
//                $m->setFKali(1);
//                $m->setBiaya($transaksi_jenis);
                //  endregion masuk sebagai biaya

                //  endregion mutasi
                //  endregion persediaan keluar GUDANG SUPPLIES PRODUKSI

                cekMerah(":: PERSEDIAAN KELUAR GUDANG PR SUKSES ::");


                //  region persediaan masuk GUDANG PURCHASING
                //  region mutasi
                $arrProduk = array();
                $m->setFKali($f_kali_2);
//                $m->setSupplier($supplier_id);
                $m->setTransaksiId($transaksi_id);
                $m->setTransaksiNomer($transaksi_nomer);
                $m->setTransaksiNilai($transaksi_net);
                $m->setPersediaanJenis($persediaan_jenis_terima);
                $m->setCabangId($cabang_id);

                cekBiru(":: SIAP-2 PERSEDIAAN MASUK PRODUKSI... ::");

//                $arrTransaksiChild = $t->getTransaksiChild($transaksi_id);
                $item_nilai_total = 0;
                foreach ($arrTransaksiChild as $arrData) {
                    $produk_id = $arrData['produk_id'];
                    $produk_qtt = $arrData['produk_ord_jml'];
                    $harga = $arrData['produk_ord_hrg'];
                    $premi = $arrData['produk_ord_diskon'];
                    $nama = $arrData['produk_nama'];
                    $pph = $arrData['ppn'];

                    $new_harga = $harga - $premi;
                    $item_nilai = $produk_qtt * $new_harga;
                    $item_nilai_total += $item_nilai;


                    $arrProduk = array(
                        "id" => "$produk_id",
                        "qtt" => "$produk_qtt",
                        "hpp" => "$harga",
                        "harga" => "$harga",
                        "nama" => "$nama"
                    );
                    $m->setProduk($arrProduk);
                    $m->setPersediaan($transaksi_jenis_terima);

                    //  region fifo supplies produksi
                    $arrFifo = array(
                        "produk_id" => $produk_id,
                        "produk_nama" => $nama,
                        "unit" => $produk_qtt,
                        "hpp" => $new_harga,
                        "jml_nilai" => $item_nilai,
                    );
                    $ff->setFifoJenis($persediaan_jenis_terima);
                    $ff->setCabangId($cabang_id);
                    $ff->setProdukId($produk_id);
                    $ff->setTransaksiId($transaksi_id);
                    $ff->setTransaksiJenis($transaksi_jenis_terima);
                    $ff->setFifo($arrFifo);
                    //  endregion fifo supplies produksi
                    cekBiru(":: LANJUT ke CACHE...");

                    //  region masuk cache supplies produksi
                    $arrProduk = array(
                        "produk_id" => $produk_id,
                        "produk_qtt" => $produk_qtt,
                        "produk_nama" => $nama,
                    );
                    $m->setProduk($arrProduk);
                    $m->setTransaksiId($transaksi_id);
                    $m->setTransaksiJenis($transaksi_jenis_terima);
                    $m->setTransaksiNomer($transaksi_nomer);
                    $m->setPersediaanCacheUI($produk_id, $persediaan_jenis_terima, $cabang_id, "0");
//cekBiru("$m->setPersediaanCacheUI($produk_id, $persediaan_jenis_terima, $cabang_id, \"0\");");
                    //  endregion masuk cache supplies produksi
                }

                cekBiru(":: MUTASI PERSEDIAAN OKE... :: [$item_nilai_total] ::");

                //  endregion mutasi
                //  endregion persediaan masuk GUDANG PURCHASING

                cekMerah(":: PERSEDIAAN MASUK GUDANG PRODUKSI SUKSES ::");
            }

            //  region cache sinkron menjadi 1
            $m->setPersediaanCacheUISinkron($transaksi_id, "supplies");
            $m->setPersediaanCacheUISinkron($referensi_id, "supplies_produksi");
            //  endregion cache sinkron menjadi 1

            //  region update transaksi yang sudah diambil
            $arrTransaksiUpdate = array(
                "sinkron" => "1"
            );
            $t->setTransaksionalId($transaksi_id);
            $t->setTransaksional($arrTransaksiUpdate, false);
            //  endregion update transaksi yang sudah diambil

            $sukses = 1;

            break;
        //  case pembayaran biaya
        case "462":

            //  region jurnal
            $j->setFKali(-1);
            $j->setTransaksiPembayaran($transaksi_pembayaran);
            $j->setCabangId($cabang_id);
            $j->setJurnal($transaksi_jenis, $transaksi_id, $transaksi_nomer, $transaksi_net);
            //  endregion jurnal
            cekHere("::: CEK JURNAL OKE... :::");
//mati_disini();
            //  region mutasi
            $arrRekeningKasPembantuTujuan = array(
                "jenis" => "$transaksi_pembayaran_sys",
                "jenis_id" => "$transaksi_bank_rekening_id",
                "jenis_nama" => "$transaksi_bank_rekening_nama",
                "bank_id" => "$transaksi_bank_id",
                "bank_nama" => "$transaksi_bank_nama",
            );
            $m->setFKali(-1);
            $m->setCabangId($cabang_id);
            $m->setTransaksiJenis($transaksi_jenis);
            $m->setTransaksiNomer($transaksi_nomer);
            $m->setTransaksiId($transaksi_id);
            $m->setPembayaranPembantu($arrRekeningKasPembantuTujuan);
            $m->setTransaksiNilai($transaksi_net);
            $m->setKas($transaksi_jenis);

            $arrTransaksiChild = $t->getTransaksiChild($transaksi_id, "and trash='0'");
            foreach ($arrTransaksiChild as $arrData) {
                $produk_id = $arrData['produk_id'];
                $harga = $arrData['produk_ord_hrg'];
                $nama = $arrData['produk_nama'];

                $item_nilai = $harga;
                $item_nilai_total += $item_nilai;
                $arrBiaya_data = array(
                    "jenis" => "biaya",
                    "nama" => $nama,
                    "id" => $produk_id,
                );
                $m->setWajibPajak($arrBiaya_data);
                $m->setTransaksiNilai($item_nilai);
                $m->setHutang($transaksi_jenis);
            }
            //  endregion mutasi

            //  region update transaksi yang sudah diambil
            $arrTransaksiUpdate = array(
                "sinkron" => "1"
            );
            $t->setTransaksionalId($transaksi_id);
            $t->setTransaksional($arrTransaksiUpdate, false);
            //  endregion update transaksi yang sudah diambil

            $sukses = 1;
            break;

        //  region bypass transaksi
        case "722r":
        case "945r":
        case "235":
        case "461r":
        case "466":
        case "671r":
        case "582r":
        case "334r":
        case "961r":
        case "967r":
        case "982r":
        case "983r":
        case "759r":
        case "761r":
        case "769":
        case "779":

            //  region update transaksi yang sudah diambil
            $arrTransaksiUpdate = array(
                "sinkron" => "1"
            );
            $t->setTransaksionalId($transaksi_id);
            $t->setTransaksional($arrTransaksiUpdate, false);
            //  endregion update transaksi yang sudah diambil

            break;
        default:

            addOutput(__LINE__ . __FILE__ . "transaksi jenis tidak terdeteksi");
            die();
            break;
        //  endregion bypass transaksi
    }
    if ($sukses == 1) {
        //  region membuat log untuk kirim email
        createLog("transaksi_id: $transaksi_id jenis: $transaksi_jenis nomer: $transaksi_nomer berhasil dibuat", "data", "$transaksi_id");
        //  endregion membuat log untuk kirim email
    }

    stop_time($start_time, "CLI $transaksi_jenis-$transaksi_id $transaksi_nomer_original", "cli_ilm");
}
else {
    addOutput("----- DONE -----");
    cekHere("----- DONE -----");
    $conditional_1 = "where sinkron='9' and trash='0'";
    $tbl_1 = "transaksi";
    $q = "select * from $tbl_1 $conditional_1";
    $x = $db1->select($q);
    $r = $db1->select($q, true);
    if ($r > 0) {
        //  update sinkron 9 ke 0
        $q_1 = "update $tbl_1 set sinkron='0' where sinkron='9'";
        $x_1 = $db1->run_sql($q_1, true);
        !$x_1 ? die($db1->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        addOutput("$q_1");

        //  membuat log
        $msg = "transaksi yang di-skip: $r, sudah diupdate.";
        //            createLog("$msg", "dev");
    }
    else {
        //  membuat log
        $msg = "eksekusi transaksi dengan cli selesai.";
        //            createLog("$msg", "dev");
    }
}


if ($rows > 0) {
    $arrCabangId = array("0", "$cabang_id");
    foreach ($arrCabangId as $cabang_id_1) {
        $v->setCabangId($cabang_id_1);
        $cek_neraca = $v->getPastiBalance();
        if ($cek_neraca == 0) {
            addOutput(__LINE__ . "<hr>neraca cabang $cabang_id_1, tidak balance");
            matiHere(__LINE__ . "<hr>neraca cabang $cabang_id_1, tidak balance");
            die();
        }
    }
}

//  region viewer fifo
$currentFifoValues = getFIFOBahanValues($t->getCabang_id());
$currentFifoPValues = getFIFOProdukValues($t->getCabang_id());
$currentCacheValues = getCacheBahanValues($t->getCabang_id());
$currentCachePValues = getCacheProdukValues($t->getCabang_id());


addOutput("<hr style='color:#009900;'>");
addOutput("cache bahan akhir di tabel : <strong>" . $currentCacheValues . "</strong>");
addOutput("cache produk akhir di tabel : <strong>" . $currentCachePValues . "</strong>");
addOutput("FIFO bahan akhir di tabel : <strong>" . $currentFifoValues['total'] . "</strong>");
addOutput("FIFO produk akhir di tabel : <strong>" . $currentFifoPValues['total'] . "</strong>");
addOutput("<hr style='color:#009900;'>");


cekBiru("( " . round($currentFifoPValues[total], 2) . " != " . round($currentCachePValues, 2) . ")");
if (round($currentFifoPValues['total'], 2) != round($currentCachePValues, 2)) {
    addOutput("CACHE PRODUK vs. PRODUK TIDAK BALANCE!" . $currentFifoValues['total'] . " vs $currentCacheValues");
    die();
}

if (round($currentFifoValues['total'], 2) != round($currentCacheValues, 2)) {
    addOutput("CACHE BAHAN vs. BAHAN TIDAK BALANCE!" . $currentFifoValues['total'] . " vs $currentCacheValues");
    die();
}
/*
  if ($currentFifoValues['total'] != $currentFifoPValues['total']) {
  cekHere("FIFO BAHAN vs. PRODUK tidak sama!<br>" . $currentFifoValues['total'] . " vs. " . $currentFifoPValues['total']);
  } */

//  endregion viewer fifo
//  region cek sinkron transaksi
$arrTransaksiBaca = $t->getTransaksiData($transaksi_id);
$sinkron_baca = $arrTransaksiBaca['sinkron'];
addOutput("#### <span style='font-size:25px;font-weight:bold;'>SINKRON SETELAH EKSEKUSI: $sinkron_baca</span> ####");
//  endregion cek sinkron transaksi
//  region waktu eksekusi akhir
$mtime = microtime();
$mtime = explode(" ", $mtime);
$mtime = $mtime[1] + $mtime[0];
$endtime = $mtime;
$totaltime = ($endtime - $starttime);
$totaltime_f = number_format($totaltime, 2);
$arrGrandTotalTime[] = $totaltime;
if (count($arrGrandTotalTime) > 0) {
    $grandtotaltime = 0;
    foreach ($arrGrandTotalTime as $time) {
        $grandtotaltime += $time;
    }
    $grandtotaltime_mnt = $grandtotaltime / 60;
    $grandtotaltime_mnt_f = number_format($grandtotaltime_mnt, 3);
}

addOutput("lama eksekusi: $totaltime_f detik $transaksi_jenis");
//addOutput("lama total eksekusi : $grandtotaltime_mnt_f menit");
//  endregion waktu eksekusi akhir


updateTime($totaltime_f . " detik");

mati_disini("setopp dulu, belum sampai commit...$transaksi_jenis... $transaksi_id ---**");

if ((isset($_GET['id'])) && ($_GET['id'] > 0)) {
    //  addOutput

    addOutput("clear: stop dulu ya :) belum commit - $totaltime_f");
//    die();
}
else {
    //  addOutput
    //    addOutput("clear: stop dulu ya :) belum commit - $totaltime_f");
    addOutput("MENCOBA UNTUK MENG-COMMIT!");
}



//  commit penutup

if ($db1->endCommit()) {
    addOutput("commit berhasil!");
}
else {
    addOutput("commit GAGAL!");
    die();
}
?>