<?php


class GoogleCalendarApi
{
    public function GetAccessToken($client_id, $redirect_uri, $client_secret, $code)
    {
        $url = 'https://accounts.google.com/o/oauth2/token';

        $curlPost = 'client_id=' . $client_id . '&redirect_uri=' . $redirect_uri . '&client_secret=' . $client_secret . '&code=' . $code . '&grant_type=authorization_code';
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $curlPost);
        $data = json_decode(curl_exec($ch), true);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        if ($http_code != 200) throw new Exception('Error : Failed to receieve access token');

        return $data;
    }

    public function GetUserCalendarTimezone($access_token)
    {
        $url_settings = 'https://www.googleapis.com/calendar/v3/users/me/settings/timezone';

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url_settings);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Authorization: Bearer ' . $access_token));
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        $data = json_decode(curl_exec($ch), true); //echo '<pre>';print_r($data);echo '</pre>';
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        if ($http_code != 200) throw new Exception('Error : Failed to get timezone');

        return $data['value'];
    }

    public function GetCalendarsList($access_token)
    {
        $url_parameters = array();

        $url_parameters['fields'] = 'items(id,summary,timeZone)';
        $url_parameters['minAccessRole'] = 'owner';

        $url_calendars = 'https://www.googleapis.com/calendar/v3/users/me/calendarList?' . http_build_query($url_parameters);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url_calendars);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Authorization: Bearer ' . $access_token));
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        $data = json_decode(curl_exec($ch), true); //echo '<pre>';print_r($data);echo '</pre>';
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        if ($http_code != 200) throw new Exception('Error : Failed to get calendars list');

        return $data['items'];
    }

    public function CreateCalendarEvent($calendar_id, $summary, $all_day, $event_time, $event_timezone, $access_token)
    {
        $url_events = 'https://www.googleapis.com/calendar/v3/calendars/' . $calendar_id . '/events';

        $curlPost = array('summary' => $summary);
        if ($all_day == 1) {
            $curlPost['start'] = array('date' => $event_time['event_date']);
            $curlPost['end'] = array('date' => $event_time['event_date']);
        }
        else {
            $curlPost['start'] = array('dateTime' => $event_time['start_time'], 'timeZone' => $event_timezone);
            $curlPost['end'] = array('dateTime' => $event_time['end_time'], 'timeZone' => $event_timezone);
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url_events);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Authorization: Bearer ' . $access_token,
            'Content-Type: application/json'
        ));
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($curlPost));
        $data = json_decode(curl_exec($ch), true);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        if ($http_code != 200) throw new Exception('Error : Failed to create event');

        return $data['id'];
    }

    public function SendEventToSan($summary, $all_day, $event_time, $event_timezone, $access_token)
    {
        require_once('../../../assets/autoload.php');
        $db0 = New _00_DBclass();
        $db0->connect();
        $tl = new Timeline();

        $empl_id = sesId();
        $empl_nama = sesNama();
        $sesCb_id = sesCabangId();

        $sesTimeline = $_SESSION['timeline'];
        $sesCust = $sesTimeline['customer'];
        // arrPrint();
        //         $posting = base64_encode(serialize($_POST));
        //         $arrDetile = unserialize(base64_decode($posting))['event_details'];
        $arrDetile = $_POST['event_details'];
        $judul = $arrDetile['title'];
        $arrTime = $arrDetile['event_time'];
        $start = $arrTime['start_time'];
        $stop = $arrTime['end_time'];

        $deskripsi = "<b>$judul</b>  <br> $start <br>s/d</br> $stop";
        //        $deskripsi = serialize($_POST);

        $arrData['customers_id'] = $cust_id = $sesCust['id'];
        $arrData['customers_nama'] = $cust_nama = $sesCust['nama'];
        $arrData['employee_id'] = $empl_id;
        $arrData['employee_nama'] = $empl_nama;
        $arrData['kategori'] = "#appointment";
        $arrData['latitude'] = 0;
        $arrData['longitude'] = 0;
        $arrData['ipadd'] = $_SERVER['REMOTE_ADDR'];
        $arrData['devices'] = $_SERVER['HTTP_USER_AGENT'];
        $arrData['deskripsi'] = $deskripsi;

        // matiHere();
        $tl->add_timeline($arrData);

        $data = json_encode($arrData);

        return $arrData;
    }


}

?>