<?php
session_start();

// Holds the Google application Client Id, Client Secret and Redirect Url
require_once('settings.php');

// Holds the various APIs involved as a PHP class. Download this class at the end of the tutorial
require_once('google-login.php');

// Google passes a parameter 'code' in the Redirect Url
if(isset($_GET['code'])) {
    try {
        $capi = new GoogleCalendarApi();

        // Get the access token
        $data = $capi->GetAccessToken(APPLICATION_ID, APPLICATION_REDIRECT_URL, APPLICATION_SECRET, $_GET['code']);

        // Access Token
        $access_token = $data['access_token'];

        // The rest of the code to add event to Calendar will come here
    }
    catch(Exception $e) {
        echo $e->getMessage();
        exit();
    }
}

?>