<?php
session_start();
header('Content-type: application/json');

require_once('google-calendar-api.php');

try {
	// Get event details
	$event = $_POST['event_details'];
    $output = array();

	$capi = new GoogleCalendarApi();

	// Get user calendar timezone
	$user_timezone = $capi->GetUserCalendarTimezone($_SESSION['access_token']);

	// Create event on primary calendar
	$event_id = $capi->CreateCalendarEvent('primary', $event['title'], $event['all_day'], $event['event_time'], $user_timezone, $_SESSION['access_token']);

    if($event_id){
        $sendToSan = $capi->SendEventToSan($event['title'], $event['all_day'], $event['event_time'], $user_timezone, $_SESSION['access_token']);

        if($sendToSan){
            $output[event_id] = $event_id;
            $output[san_stat] = $sendToSan;
        }
    }else{
        die();
    }





//	echo json_encode($data);
	echo json_encode($output);
//	echo json_encode([ 'event_id' => $event_id ]);


}
catch(Exception $e) {
	header('bad request', true, 400);
    echo json_encode(array( 'error' => 1, 'message' => $e->getMessage() ));
}

?>