<?php

echo "\n";

// require the class
require_once './src/BlakeGardner/MacAddress.php';

// import the class
use BlakeGardner\MacAddress;

// get the mac address of the eth0 interface
echo "Current MAC address: ";
var_dump(MacAddress::getCurrentMacAddress('eth0'));
echo "\n";

// generate a random mac address
echo "Randomly generated MAC address: ";
var_dump(MacAddress::generateMacAddress());
echo "\n";

// validate an MAC address
echo "Validating MAC address: ";
var_dump(MacAddress::validateMacAddress('00-B0-D0-86-BB-F7'));
echo "\n";

// set a randomly generated MAC address on the eth0 interface
echo "Setting a randomly generated MAC address: ";
var_dump(MacAddress::setFakeMacAddress('eth0'));
echo "\n";

// set a specific MAC address on the eth0 interface
echo "Setting a specific MAC address: ";
var_dump(MacAddress::setFakeMacAddress('eth0', '00:E4:01:2C:79:DA'));
echo "\n";

function returnmacaddress()
{
    // This code is under the GNU Public Licence
    // Written by michael_stankiewicz {don't spam} at yahoo {no spam} dot com
    // Tested only on linux, please report bugs

    // WARNING: the commands 'which' and 'arp' should be executable
    // by the apache user; on most linux boxes the default configuration
    // should work fine

    // get the arp executable path
    $location = 'which arp';
    $location = rtrim($location);
    // Execute the arp command and store the output in $arpTable
    $arpTable = '$location -n';
    // Split the output so every line is an entry of the $arpSplitted array
    $arpSplitted = split("\n", $arpTable);
    // get the remote ip address (the ip address of the client, the browser)
    $remoteIp = $_SERVER['REMOTE_ADDR'];
    $remoteIp = str_replace(".", "\\.", $remoteIp);
    // Cicle the array to find the match with the remote ip address
    foreach ($arpSplitted as $value) {
        // Split every arp line, this is done in case the format of the arp
        // command output is a bit different than expected
        $valueSplitted = split(" ", $value);
        foreach ($valueSplitted as $spLine) {
            if (preg_match("/$remoteIp/", $spLine)) {
                $ipFound = true;
            }
            // The ip address has been found, now rescan all the string
            // to get the mac address
            if ($ipFound) {
                // Rescan all the string, in case the mac address, in the string
                // returned by arp, comes before the ip address
                // (you know, Murphy's laws)
                reset($valueSplitted);
                foreach ($valueSplitted as $spLine) {
                    if (preg_match("/[0-9a-f][0-9a-f][:-]" . "[0-9a-f][0-9a-f][:-]" . "[0-9a-f][0-9a-f][:-]" . "[0-9a-f][0-9a-f][:-]" . "[0-9a-f][0-9a-f][:-]" . "[0-9a-f][0-9a-f]/i", $spLine)) {
                        return $spLine;
                    }
                }
            }
            $ipFound = false;
        }
    }

    return false;
}

echo "<hr>";
//print_r(returnmacaddress());

$computerId = $_SERVER['HTTP_USER_AGENT'] . $_SERVER['LOCAL_ADDR'] . $_SERVER['LOCAL_PORT'] . $_SERVER['REMOTE_ADDR'];
echo "<hr>$computerId";

echo "<hr> thomas";
include_once "getUserDetails.php";
