<?php


function isValidDate($postedDate)
{
    if (ereg("^[0-9]{4}-[01][0-9]-[0-3][0-9]$", $postedDate)) {
        list($year, $month, $day) = explode('-', $postedDate);

        return (checkdate($month, $day, $year));
    }
    else {
        return (false);
    }
}

$arrBln = array(
    "0" => "---", "01" => "jan", "02" => "feb", "03" => "mar", "04" => "apr", "05" => "may", "06" => "jun",
    "07" => "jul", "08" => "aug", "09" => "sep", "10" => "oct", "11" => "nov", "12" => "dec"
);
$arrCompactBln = array(
    "01" => "jan", "02" => "feb", "03" => "mar", "04" => "apr", "05" => "may", "06" => "jun", "07" => "jul",
    "08" => "aug", "09" => "sep", "10" => "oct", "11" => "nov", "12" => "dec"
);
$arrTgl["0"] = "---";

for ($x = 1; $x <= 31; $x++) {
    $tglStr = $x;
    if (strlen($x) == 1) {
        $x = "0" . $x;
    }

    $arrTgl[$x] = $tglStr;
    $arrCompactTgl[$x] = $tglStr;
}

$arrThn = array("");
$arrThn[0] = "----";
for ($cntthn = 2009; $cntthn <= 2036; $cntthn++) {
    $arrThn[$cntthn] = $cntthn;
}
$arDay = array("Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu");

for ($x = 0; $x <= 23; $x++) {
    if (strlen($x) == 1) {
        $arrJam[$x] = "0" . $x;
    }
    else {
        $arrJam[$x] = $x;
    }
}

for ($x = 0; $x <= 59; $x++) {
    if (strlen($x) == 1) {
        $arrMnt[$x] = "0" . $x;
    }
    else {
        $arrMnt[$x] = $x;
    }
}
$arrNamaHari = array(
    "sunday" => "Minggu", "monday" => "Senin", "tuesday" => "Selasa", "wednesday" => "Rabu", "thursday" => "Kamis",
    "friday" => "Jumat", "saturday" => "Sabtu"
);

for ($x = 0; $x <= 23; $x++) {
    if (strlen($x) == 1) {
        $arJam[$x] = "0" . $x;
    }
    else {
        $arJam[$x] = $x;
    }
}

for ($x = 0; $x <= 59; $x++) {
    if (strlen($x) == 1) {
        $arMnt[$x] = "0" . $x;
    }
    else {
        $arMnt[$x] = $x;
    }
}
$arAlarmType = array("1" => "Harian", "2" => "Mingguan", "3" => "Bulanan");

function getDayName($tgl)
{
    $tmp = date('l', strtotime($tgl));

    //return $arrNamaHari[$tmp];
    return $tmp;
}

# Transform hours like "1:45" into the total number of minutes, "105".
function hoursToMinutes($hours)
{
    if (strstr($hours, ':')) {
        # Split hours and minutes.
        $separatedData = split(':', $hours);

        $minutesInHours = $separatedData[0] * 60;
        $minutesInDecimals = $separatedData[1];

        $totalMinutes = $minutesInHours + $minutesInDecimals;
    }
    else {
        $totalMinutes = $hours * 60;
    }

    return $totalMinutes;
}

# Transform minutes like "105" into hours like "1:45".
function minutesToHours($minutes)
{
    $hours = floor($minutes / 60);
    $decimalMinutes = $minutes - floor($minutes / 60) * 60;

    # Put it together.
    $hoursMinutes = sprintf("%d:%02.0f", $hours, $decimalMinutes);

    return $hoursMinutes;
}

function getDayDifference($tgl1, $tgl2)
{
    $day_diff = (strtotime($tgl2) - strtotime($tgl1)) / 86400; // dias de cartelera

    return $day_diff;
}

function getTimeDifference($start, $end)
{
    $day_diff = getDayDifference($start, $end);
    if ($day_diff > 0) {

    }
    else {

    }
}


/**
 * Function to calculate date or time difference.
 * Function to calculate date or time difference. Returns an array or
 * false on error.
 * @author       J de Silva                             <giddomains@gmail.phpom>
 * @copyright    Copyright &copy; 2005, J de Silva
 * @link         http://www.gidnetwork.phpom/b-16.html    Get the date / time difference with PHP
 * @param        string $start
 * @param        string $end
 * @return       array
 */
function get_time_difference($start, $end)
{
    $uts['start'] = strtotime($start);
    $uts['end'] = strtotime($end);
    if ($uts['start'] !== -1 && $uts['end'] !== -1) {
        if ($uts['end'] >= $uts['start']) {
            $diff = $uts['end'] - $uts['start'];
            if ($days = intval((floor($diff / 86400)))) $diff = $diff % 86400;
            if ($hours = intval((floor($diff / 3600)))) $diff = $diff % 3600;
            if ($minutes = intval((floor($diff / 60)))) $diff = $diff % 60;
            $diff = intval($diff);

            return (array('days' => $days, 'hours' => $hours, 'minutes' => $minutes, 'seconds' => $diff));
        }
        else {
            trigger_error("Ending date/time is earlier than the start date/time", E_USER_WARNING);
        }
    }
    else {
        trigger_error("Invalid date/time data detected", E_USER_WARNING);
    }

    return (false);
}

function timeDiff($firstTime, $lastTime)
{

    // convert to unix timestamps
    $firstTime = strtotime($firstTime);
    $lastTime = strtotime($lastTime);

    // perform subtraction to get the difference (in seconds) between times
    $timeDiff = $lastTime - $firstTime;

    // return the difference
    return $timeDiff;
}


function indHari($x)
{
    $hari = array("Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jum'at", "Sabtu");

    return $hari[$x];
}

function indBulan($x)
{
    $bulan = array(
        "01" => "jan", "02" => "feb", "03" => "mar", "04" => "apr", "05" => "may", "06" => "jun", "07" => "jul",
        "08" => "aug", "09" => "sep", "10" => "oct", "11" => "nov", "12" => "dec", "1" => "jan", "2" => "feb",
        "3"  => "mar", "4" => "apr", "5" => "may", "6" => "jun", "7" => "jul", "8" => "aug", "9" => "sep"
    );

    return $bulan[$x];
}

function indBulanInv($bln)
{
    $bln = strtolower($bln);
    $bulan = array(
        "01" => "jan", "02" => "feb", "03" => "mar", "04" => "apr", "05" => "may", "06" => "jun", "07" => "jul",
        "08" => "aug", "09" => "sep", "10" => "oct", "11" => "nov", "12" => "dec"
    );

    return array_search($bln, $bulan);
}

function indBulanFull($x)
{
    $bulan = array(
        "01" => "Januari", "02" => "Februari", "03" => "Maret", "04" => "April", "05" => "Mei", "06" => "Juni",
        "07" => "Juli", "08" => "Agustus", "09" => "September", "10" => "Oktober", "11" => "November",
        "12" => "Desember", "1" => "Januari", "2" => "Februari", "3" => "Maret", "4" => "April", "5" => "Mei",
        "6"  => "Juni", "7" => "Juli", "8" => "Agustus", "9" => "September"
    );

    return $bulan[$x];
}

function createTimeDescription($time)
{
    $dulu = $time;
    $sekarang = date("Y-m-d H:i:s");
    $jeda = timeDiff($dulu, $sekarang);
    $strJam = substr($dulu, 11, 8);

    $jedaMenit = intval($jeda / 60);
    $jedaJam = intval($jeda / 3600);
    $jedaHari = intval($jeda / 86400);
    $jedaBulan = intval($jeda / 2592000);
    $jedaTahun = intval($jeda / 31104000);
    if ($jedaMenit < 60) {
        if ($jedaMenit > 1) {
            $time = "$jedaMenit menit yang lalu ";
        }
        else {
            $time = "semenit yang lalu ";
        }
    }
    elseif ($jedaJam < 24) {
        if ($jedaJam > 1) {
            $time = "$jedaJam jam yang lalu ";
        }
        else {
            $time = "sejam yang lalu ";
        }

    }
    elseif ($jedaHari < 30) {
        if ($jedaHari > 1) {
            $time = "$jedaHari hari yang lalu, $strJam ";
        }
        else {
            $time = "kemarin, $strJam ";
        }
    }
    elseif ($jedaBulan < 12) {
        if ($jedaBulan > 1) {
            $time = "$jedaBulan bulan yang lalu, $strJam ";
        }
        else {
            $time = "sebulan yang lalu, $strJam ";
        }

    }
    elseif ($jedaTahun < 100) {
        if ($jedaTahun > 1) {
            $time = "$jedaTahun tahun yang lalu, $strJam ";
        }
        else {
            $time = "setahun yang lalu, $strJam ";
        }

        //$time="long time ago";
    }

    return $time;
}


function reverseDate($tanggal)
{
    $arr = explode("-", $tanggal);
    $arr = array_reverse($arr);
    $strTanggal = implode($arr, "-");

    return $strTanggal;
}

function translateDate($tanggal)
{
    global $arrBln;
    $arr = explode("-", $tanggal);
    $tmp = $arr[1];
    $arr[1] = $arrBln[$tmp];
    $strTanggal = implode($arr, "-");

    return $strTanggal;
}

function translateMonthYear($month)
{
    global $arrBln;
    $arr = explode("-", $month);

    //$strTanggal = implode($arr, "-");
    $strTanggal = $arrBln[$arr[1]] . " " . $arr[0];

    return $strTanggal;
}


function getPrevMonthString($thn, $bln)
{
    return date('Y-m', mktime(1, 1, 1, $bln - 1, 1, $thn));
}

function getPrevMonthPair($thn, $bln)
{
    //return date('Y-m', mktime(1, 1, 1, $bln-1, 1, $thn));
    $thnR = date('Y', mktime(1, 1, 1, $bln - 1, 1, $thn));
    $blnR = date('m', mktime(1, 1, 1, $bln - 1, 1, $thn));

    return array('thn' => $thnR, 'bln' => $blnR);
}

function getTempo($s, $format = "date")
{
    $today_Y = date("Y"); // tahun 2012
    $today_n = date("n"); // bulan 1-31
    $today_j = date("j"); // tanggal 1-31
    $today_H = date("H"); // jam 00-23
    $today_i = date("i"); // menit 00-5
    $today_s = date("s"); // second 00-59

    $now_mkt = mktime($today_H, $today_i, $today_s, $today_n, $today_j, $today_Y);
    $dateTempo = $now_mkt + $s;
    if ($format == "date") {

        $tempo = date('Y-m-d H:i:s', $dateTempo);
    }
    else {
        $tempo = $dateTempo;
    }

    return $tempo;

}

// thomas convert tangal to time stamp
function dtimeToSecond($dateTime)
{
    $date_time_jm = date('H', strtotime($dateTime));
    $date_time_mn = date('i', strtotime($dateTime));
    $date_time_dt = date('s', strtotime($dateTime));
    $date_time_bl = date('n', strtotime($dateTime));
    $date_time_hr = date('j', strtotime($dateTime));
    $date_time_th = date('Y', strtotime($dateTime));

    //    cekHere("$dateTime :: $date_time_jm, $date_time_mn, $date_time_dt, $date_time_bl, $date_time_hr, $date_time_th");

    $orders_dtime_mkt = mktime($date_time_jm, $date_time_mn, $date_time_dt, $date_time_bl, $date_time_hr, $date_time_th);

    //    return $orders_dtime_mkt;
    return $orders_dtime_mkt;
}

function dayToSecond($jml_hari)
{
    $jam = $jml_hari * 24;
    $menit = $jam * 60;
    $detik = $menit * 60;

    return $detik;
}

function secondToDay($jml_detik)
{
    $menit = $jml_detik / 60;
    $jam = $menit / 60;
    $hari = $jam / 24;

    return floor($hari);
}

function jatuhTempo($dateTime, $tempo)
{

    $date_time_jm = date('H', strtotime($dateTime));
    $date_time_mn = date('i', strtotime($dateTime));
    $date_time_dt = date('s', strtotime($dateTime));
    $date_time_bl = date('n', strtotime($dateTime));
    $date_time_hr = date('j', strtotime($dateTime));
    $date_time_th = date('Y', strtotime($dateTime));

    $orders_dtime_mkt = mktime($date_time_jm, $date_time_mn, $date_time_dt, $date_time_bl, $date_time_hr, $date_time_th);
    $akan_jatuh_tempo = $orders_dtime_mkt + $tempo;

    return $akan_jatuh_tempo;
}

function umurHour($dateTime, $format = "H")
{
    $hh = $format;
    $today_Y = date("Y"); // tahun 2012
    $today_n = date("n"); // bulan 1-31
    $today_j = date("j"); // tanggal 1-31
    $today_H = date("H"); // jam 00-23
    $today_i = date("i"); // menit 00-5
    $today_s = date("s"); // second 00-59

    $date_time_jm = date('H', strtotime($dateTime));
    $date_time_mn = date('i', strtotime($dateTime));
    $date_time_dt = date('s', strtotime($dateTime));
    $date_time_bl = date('n', strtotime($dateTime));
    $date_time_hr = date('j', strtotime($dateTime));
    $date_time_th = date('Y', strtotime($dateTime));

    $orders_dtime_mkt = mktime($date_time_jm, $date_time_mn, $date_time_dt, $date_time_bl, $date_time_hr, $date_time_th);

    $now_mkt = mktime($today_H, $today_i, $today_s, $today_n, $today_j, $today_Y);
    $umur_dt = $now_mkt - $orders_dtime_mkt; // detik

    $umur_mn = floor($umur_dt % 3600 / 60); // menit
    $umur_jm = floor($umur_dt / 3600); // jam
    if ($hh == "H") {
        return $umur_jm;
    }
    elseif ($hh == "H:i") {

        $jam = "$umur_jm:$umur_mn";

        return $jam;
    }
}

function umurDay($dateTime)
{
    $umurDmlJam = umurHour($dateTime);

    $umurDmlHari = floor($umurDmlJam / 24);

    return $umurDmlHari;
}

function wibTowit($dtime)
{
    //    $original_datetime = '04/01/2013 03:08 PM';
    $original_datetime = $dtime;
    $original_timezone = new DateTimeZone('Asia/Bangkok');

    // Instantiate the DateTime object, setting it's date, time and time zone.
    $datetime = new DateTime($original_datetime, $original_timezone);

    // Set the DateTime object's time zone to convert the time appropriately.
    $target_timezone = new DateTimeZone('Asia/Hong_Kong');
    $datetime->setTimeZone($target_timezone);

    // Outputs a date/time string based on the time zone you've set on the object.
    $triggerOn = $datetime->format('Y-m-d H:i:s');

    return $triggerOn;
}

function btn_harian()
{
    global $Mode, $mm, $mn, $smo, $cm, $date_now_use, $date_now, $tempo, $oId;

    $time_now = dtimeToSecond($date_now_use);
    $time = $time_now;
    $tempo_s = dayToSecond($tempo);
    $date_awal = getTempo(-$tempo_s, "date");
    $date_sebelum = date("Y-m-d", mktime(0, 0, 0, date("n", $time), date("j", $time) - 1, date("Y", $time)));
    $date_sesudah = date("Y-m-d", mktime(0, 0, 0, date("n", $time), date("j", $time) + 1, date("Y", $time)));
    $disabled = $date_sesudah >= $date_now ? "disabled" : "";

    //    $strPilih_tanggal_2 = "<link rel=\"stylesheet\" href='../../assets/suport/bootstrap-datepicker-1.5.0-dist/css/bootstrap-datepicker.css'>";
    //    $strPilih_tanggal_2 .= "<script src='../../assets/suport/autocomplete/jquery-1.8.2.min.js'></script>";
    //    $strPilih_tanggal_2 .= "<script src='../../assets/suport/bootstrap-datepicker-1.5.0-dist/js/bootstrap-datepicker.js'></script>";
    //
    //    $strPilih_tanggal_2 .= "<script type=\"text/javascript\">
    //                    // When the document is ready
    //                    $(document).ready(function () {
    //
    //                    $('#example1').datepicker({
    //                            format: \"yyyy/mm/dd\"
    //                    });
    //
    //                });
    //            </script>";

    $strPer_hari = "$strPilih_tanggal_2 <div class='btn-group btn-group-justified'>";
    $strPer_hari .= "<a href='$_SERVER[PHP_SELF]?Mode=$Mode$cm$mm$smo$mn$oId&req_dtime=$date_sebelum' class='btn btn-primary'><span class='glyphicon glyphicon-menu-left'></span> Sebelum $date_sebelum</a>";
    $strPer_hari .= "<a href='$_SERVER[PHP_SELF]?Mode=$Mode$cm$mm$smo$mn$oId&req_dtime=$date_now' class='btn btn-info'>Hari ini $date_now</a>";
    //    $strPer_hari .= "<input  type='text' placeholder='pilih tanggal' class='btn btn-warning' name='req_dtime' value='$reg_dtime' id='example1'>";
    //    $strPer_hari .= "<a href='#' class='btn btn-success' id='example1'><span class='glyphicon glyphicon-calendar'>&nbsp;</span>jump</a>";
    $strPer_hari .= "<a $disabled href='$_SERVER[PHP_SELF]?Mode=$Mode$cm$mm$smo$mn$oId&req_dtime=$date_sesudah' class='btn btn-primary'>Sesudah $date_sesudah <span class='glyphicon glyphicon-menu-right'></span></a>";
    $strPer_hari .= "</div>";

    return $strPer_hari;
}

function btn_bulanan()
{
    global $Mode, $mm, $mn, $smo, $cm, $date_now_use, $date_now, $date_bl, $oId;


    //                $time = time();
    $time_now = dtimeToSecond($date_now_use);
    $time = $time_now;

    $date_sebelum = date("Y-m", mktime(0, 0, 0, date("n", $time) - 1, date("j", $time), date("Y", $time)));
    $date_sesudah = date("Y-m", mktime(0, 0, 0, date("n", $time) + 1, date("j", $time), date("Y", $time)));
    $disabled = $date_now_use >= $date_bl ? "disabled" : "";
    $strPer_hari = "<div class='btn-group btn-group-justified'>";
    $strPer_hari .= "<a href='$_SERVER[PHP_SELF]?Mode=$Mode$cm$mm$smo$mn$oId&req_dtime=$date_sebelum' class='btn btn-primary'><span class='glyphicon glyphicon-menu-left'></span> Sebelum $date_sebelum</a>";
    $strPer_hari .= "<a $disabled href='$_SERVER[PHP_SELF]?Mode=$Mode$cm$mm$smo$mn$oId&req_dtime=$date_bl' class='btn btn-success'>Bulan ini $date_bl</a>";
    $strPer_hari .= "<a $disabled href='$_SERVER[PHP_SELF]?Mode=$Mode$cm$mm$smo$mn$oId&req_dtime=$date_sesudah' class='btn btn-primary'>Sesudah $date_sesudah <span class='glyphicon glyphicon-menu-right'></span></a>";
    $strPer_hari .= "</div>";

    return $strPer_hari;
}

?>