<?php
/**
 * Created by thomas Maya Graha Kencana.
 * Date: 10/28/11
 * Time: 8:19 PM
 */
function unformatAngkaKoma($angka)
{
    $var = $angka;
    $var = str_replace(",", "", $var);
    // $var = number_format($var,2);
    // $var = str_replace(".", "", $angka);

    return $var;
}

function formatAngkaInter($angka)
{

}

function formatAngka($angka = 0, $lang = 0)
{
    //    $angka = empty($angka) ? $angka : 0;
    $desi = explode(".", $angka);
    if ($desi[1] == 0) {
        $jml_desi = 1;
    }
    else {

        $jml_desi = count($desi) + 1;
    }
    $tampil_desi = $jml_desi > 2 ? 2 : $jml_desi - 1;
    //echo "$jml_desi --" . $desi[1];
    if ($angka > 0) {
        if ($lang == 0) {
            $angkaku = number_format($angka, "$tampil_desi", ",", ".");
        }
        else {
            $angkaku = number_format($angka, "$tampil_desi", ".", ",");
        }
    }
    else {
        $angkaku = 0;
    }


    return $angkaku;
}

function formatAngkaDesimal($angka, $desimal = 1)
{
    $angkaku = number_format($angka, "$desimal", ",", ".");

    return $angkaku;
}

function formatAngka_int($angka)
{

    return (int)$angka;
}

function formatAngkaClean($angka)
{
    $var = $angka > 0 ? number_format($angka, 0, '.', '') : 0;

    return $var;
}

function kekata($x)
{
    $x = abs($x);
    $angka = array(
        "",
        "satu",
        "dua",
        "tiga",
        "empat",
        "lima",
        "enam",
        "tujuh",
        "delapan",
        "sembilan",
        "sepuluh",
        "sebelas",
    );
    $temp = "";
    if ($x < 12) {
        $temp = " " . $angka[$x];
    }
    else if ($x < 20) {
        $temp = kekata($x - 10) . " belas";
    }
    else if ($x < 100) {
        $temp = kekata($x / 10) . " puluh" . kekata($x % 10);
    }
    else if ($x < 200) {
        $temp = " seratus" . kekata($x - 100);
    }
    else if ($x < 1000) {
        $temp = kekata($x / 100) . " ratus" . kekata($x % 100);
    }
    else if ($x < 2000) {
        $temp = " seribu" . kekata($x - 1000);
    }
    else if ($x < 1000000) {
        $temp = kekata($x / 1000) . " ribu" . kekata($x % 1000);
    }
    else if ($x < 1000000000) {
        $temp = kekata($x / 1000000) . " juta" . kekata($x % 1000000);
    }
    else if ($x < 1000000000000) {
        $temp = kekata($x / 1000000000) . " milyar" . kekata(fmod($x, 1000000000));
    }
    else if ($x < 1000000000000000) {
        $temp = kekata($x / 1000000000000) . " trilyun" . kekata(fmod($x, 1000000000000));
    }

    return $temp;
}

function kekataEng($x)
{
    $x = abs($x);
    $angka = array(
        "",
        "satu",
        "dua",
        "tiga",
        "empat",
        "lima",
        "enam",
        "tujuh",
        "delapan",
        "sembilan",
        "sepuluh",
        "sebelas",
    );
    $temp = "";
    if ($x < 12) {
        $temp = " " . $angka[$x];
    }
    else if ($x < 20) {
        $temp = kekata($x - 10) . " belas";
    }
    else if ($x < 100) {
        $temp = kekata($x / 10) . " puluh" . kekata($x % 10);
    }
    else if ($x < 200) {
        $temp = " seratus" . kekata($x - 100);
    }
    else if ($x < 1000) {
        $temp = kekata($x / 100) . " ratus" . kekata($x % 100);
    }
    else if ($x < 2000) {
        $temp = " seribu" . kekata($x - 1000);
    }
    else if ($x < 1000000) {
        $temp = kekata($x / 1000) . " ribu" . kekata($x % 1000);
    }
    else if ($x < 1000000000) {
        $temp = kekata($x / 1000000) . " juta" . kekata($x % 1000000);
    }
    else if ($x < 1000000000000) {
        $temp = kekata($x / 1000000000) . " milyar" . kekata(fmod($x, 1000000000));
    }
    else if ($x < 1000000000000000) {
        $temp = kekata($x / 1000000000000) . " trilyun" . kekata(fmod($x, 1000000000000));
    }

    return $temp;
}

function tkoma($x)
{
    //    echo "$x";
    $str = stristr($x, ".");
    $ex = explode('.', $x);
    //print_r($ex);
    if (($ex[1] / 10) >= 1) {
        $a = abs($ex[1]);
    }

    $string = array(
        "nol",
        "satu",
        "dua",
        "tiga",
        "empat",
        "lima",
        "enam",
        "tujuh",
        "delapan",
        "sembilan",
        "sepuluh",
        "sebelas",
    );
    $temp = "";

    $a2 = $ex[1] / 10;
    $pjg = strlen($str);
    $i = 1;


    if ($a >= 1 && $a < 12) {
        $temp .= " " . $string[$a];
    }
    else if ($a > 12 && $a < 20) {
        $temp .= kekata($a - 10) . " belas";
    }
    else if ($a > 20 && $a < 100) {
        $temp .= kekata($a / 10) . " puluh" . kekata($a % 10);
    }
    else {
        if ($a2 < 1) {

            while ($i < $pjg) {
                $char = substr($str, $i, 1);
                $i++;
                $temp .= " " . $string[$char];
            }
        }
    }

    return $temp;
}

function tkomaEng($x)
{
    //    echo "$x";
    $str = stristr($x, ".");
    $ex = explode('.', $x);
    //print_r($ex);
    if (($ex[1] / 10) >= 1) {
        $a = abs($ex[1]);
    }

    $string = array(
        "nol",
        "satu",
        "dua",
        "tiga",
        "empat",
        "lima",
        "enam",
        "tujuh",
        "delapan",
        "sembilan",
        "sepuluh",
        "sebelas",
    );
    $temp = "";

    $a2 = $ex[1] / 10;
    $pjg = strlen($str);
    $i = 1;


    if ($a >= 1 && $a < 12) {
        $temp .= " " . $string[$a];
    }
    else if ($a > 12 && $a < 20) {
        $temp .= kekata($a - 10) . " belas";
    }
    else if ($a > 20 && $a < 100) {
        $temp .= kekata($a / 10) . " puluh" . kekata($a % 10);
    }
    else {
        if ($a2 < 1) {

            while ($i < $pjg) {
                $char = substr($str, $i, 1);
                $i++;
                $temp .= " " . $string[$char];
            }
        }
    }

    return $temp;
}

function terbilang($x, $style = 4)
{
    $x = $x * 1;
    if ($x < 0) {
        $hasil = "minus " . trim(kekata($x));
    }
    else {
        $poin = trim(tkoma($x));
        $hasil = trim(kekata($x));
    }
    //$poin = "99";
    if ($poin) {
        $hasil = $hasil . " koma " . $poin . " rupiah";
    }
    else {
        $hasil = $hasil . " rupiah";
    }

    switch ($style) {
        case 1:
            $hasil = strtoupper($hasil);
            break;
        case 2:
            $hasil = strtolower($hasil);
            break;
        case 3:
            $hasil = ucwords($hasil);
            break;
        default:
            $hasil = ucfirst($hasil);
            break;
    }

    return $hasil;
}

function terbilangEng_($num, $c = 0)
{
    $ZERO = 'zero';
    $MINUS = 'minus';
    $lowName = array(
        /* zero is shown as "" since it is never used in combined forms */
        /* 0 .. 19 */
        "",
        "one",
        "two",
        "three",
        "four",
        "five",
        "six",
        "seven",
        "eight",
        "nine",
        "ten",
        "eleven",
        "twelve",
        "thirteen",
        "fourteen",
        "fifteen",
        "sixteen",
        "seventeen",
        "eighteen",
        "nineteen",
    );

    $tys = array(
        /* 0, 10, 20, 30 ... 90 */
        "",
        "",
        "twenty",
        "thirty",
        "forty",
        "fifty",
        "sixty",
        "seventy",
        "eighty",
        "ninety",
    );

    $groupName = array(
        /* We only need up to a quintillion, since a long is about 9 * 10 ^ 18 */
        /* American: unit, hundred, thousand, million, billion, trillion, quadrillion, quintillion */
        "",
        "hundred",
        "thousand",
        "million",
        "billion",
        "trillion",
        "quadrillion",
        "quintillion",
    );

    $divisor = array(
        /* How many of this group is needed to form one of the succeeding group. */
        /* American: unit, hundred, thousand, million, billion, trillion, quadrillion, quintillion */
        100,
        10,
        1000,
        1000,
        1000,
        1000,
        1000,
        1000,
    );

    $num = str_replace(",", "", $num);
    $num = number_format($num, 2, '.', '');
    $cents = substr($num, strlen($num) - 2, strlen($num) - 1);
    $num = (int)$num;

    $s = "";

    if ($num == 0) $s = $ZERO;
    $negative = ($num < 0);
    if ($negative) $num = -$num;
    // Work least significant digit to most, right to left.
    // until high order part is all 0s.
    for ($i = 0; $num > 0; $i++) {
        $remdr = (int)($num % $divisor[$i]);
        $num = $num / $divisor[$i];
        // check for 1100 .. 1999, 2100..2999, ... 5200..5999
        // but not 1000..1099,  2000..2099, ...
        // Special case written as fifty-nine hundred.
        // e.g. thousands digit is 1..5 and hundreds digit is 1..9
        // Only when no further higher order.
        if ($i == 1 /* doing hundreds */ && 1 <= $num && $num <= 5) {
            if ($remdr > 0) {
                $remdr = ($num * 10);
                $num = 0;
            } // end if
        } // end if
        if ($remdr == 0) {
            continue;
        }
        $t = "";
        if ($remdr < 20) {
            $t = $lowName[$remdr];
        }
        else if ($remdr < 100) {
            $units = (int)$remdr % 10;
            $tens = (int)$remdr / 10;
            $t = $tys [$tens];
            if ($units != 0) {
                $t .= "-" . $lowName[$units];
            }
        }
        else {
            $t = terbilangEng_($remdr, 0);
        }
        $s = $t . " " . $groupName[$i] . " " . $s;
        $num = (int)$num;
    } // end for
    $s = trim($s);
    if ($negative) {
        $s = $MINUS . " " . $s;
    }

    if ($c == 1) $s .= " and $cents/100";

    return $s;

}// end num2words
function terbilangEng($num, $style = 4)
{

    $satuan = array(
        1  => "one",
        2  => "two",
        3  => "three",
        4  => "four",
        5  => "five",
        6  => "six",
        7  => "seven",
        8  => "eight",
        9  => "nine",
        10 => "ten",
        11 => "eleven",
        12 => "twelve",
        13 => "thirteen",
        14 => "fourteen",
        15 => "fifteen",
        16 => "sixteen",
        17 => "seventeen",
        18 => "eighteen",
        19 => "nineteen",
    );
    $puluhan = array(
        1 => "ten",
        2 => "twenty",
        3 => "thirty",
        4 => "forty",
        5 => "fifty",
        6 => "sixty",
        7 => "seventy",
        8 => "eighty",
        9 => "ninety",
    );
    $ribuan = array(
        "hundred",
        "thousand",
        "million",
        "billion",
        "trillion",
        "quadrillion",
    ); //limit t quadrillion
    $num = number_format($num, 2, ".", ",");
    $num_arr = explode(".", $num);
    $wholenum = $num_arr[0];
    $decnum = $num_arr[1];
    $whole_arr = array_reverse(explode(",", $wholenum));
    krsort($whole_arr);
    $rettxt = "";
    foreach ($whole_arr as $key => $i) {
        if ($i < 20) {
            $rettxt .= $satuan[$i];
        }
        elseif ($i < 100) {
            $rettxt .= $puluhan[substr($i, 0, 1)];
            $rettxt .= " " . $satuan[substr($i, 1, 1)];
        }
        else {
            $rettxt .= $satuan[substr($i, 0, 1)] . " " . $ribuan[0];
            $rettxt .= " " . $puluhan[substr($i, 1, 1)];
            $rettxt .= " " . $satuan[substr($i, 2, 1)];
        }
        if ($key > 0) {
            $rettxt .= " " . $ribuan[$key] . " ";
        }
    }

    $rettxt .= " dollars ";

    if ($decnum > 0) {
        $rettxt .= " and ";
        if ($decnum < 20) {
            $rettxt .= $satuan[$decnum];
        }
        elseif ($decnum < 100) {
            $rettxt .= $puluhan[substr($decnum, 0, 1)];
            $rettxt .= " " . $satuan[substr($decnum, 1, 1)];
        }
        $rettxt .= " cents";
    }


    return $rettxt;

}

function terbilang2($x, $style = 4)
{
    if ($x < 0) {
        $hasil = "minus " . trim(kekata($x));
    }
    else {
        $hasil = trim(kekata($x)) . " rupiah";
    }
    switch ($style) {
        case 1:
            $hasil = strtoupper($hasil);
            break;
        case 2:
            $hasil = strtolower($hasil);
            break;
        case 3:
            $hasil = ucwords($hasil);
            break;
        default:
            $hasil = ucfirst($hasil);
            break;
    }

    /*
     * strtolower()
     * 1=uppercase,
     * 2= lowercase,
     * 3= uppercase untuk huruf pertama tiap kata
     * 4=uppercase untuk huruf pertama
     */

    return $hasil;
}

function convert_number_to_words($number, $style = 4)
{
    $hyphen = '-';
    $conjunctions = ' ';
    $conjunction = ' and ';
    $separator = ', ';
    $negative = 'negative ';
    $decimal = ' point ';
    $dictionary = array(
        0                   => 'zero',
        1                   => 'one',
        2                   => 'two',
        3                   => 'three',
        4                   => 'four',
        5                   => 'five',
        6                   => 'six',
        7                   => 'seven',
        8                   => 'eight',
        9                   => 'nine',
        10                  => 'ten',
        11                  => 'eleven',
        12                  => 'twelve',
        13                  => 'thirteen',
        14                  => 'fourteen',
        15                  => 'fifteen',
        16                  => 'sixteen',
        17                  => 'seventeen',
        18                  => 'eighteen',
        19                  => 'nineteen',
        20                  => 'twenty',
        30                  => 'thirty',
        40                  => 'fourty',
        50                  => 'fifty',
        60                  => 'sixty',
        70                  => 'seventy',
        80                  => 'eighty',
        90                  => 'ninety',
        100                 => 'hundred',
        1000                => 'thousand',
        1000000             => 'million',
        1000000000          => 'billion',
        1000000000000       => 'trillion',
        1000000000000000    => 'quadrillion',
        1000000000000000000 => 'quintillion',
    );
    $number = number_format($number, 2, '.', '');

    if (!is_numeric($number)) {
        return false;
    }
    if (($number >= 0 && (int)$number < 0) || (int)$number < 0 - PHP_INT_MAX) {
        // overflow
        trigger_error('convert_number_to_words only accepts numbers between -' . PHP_INT_MAX . ' and ' . PHP_INT_MAX, E_USER_WARNING);

        return false;
    }
    if ($number < 0) {
        return $negative . convert_number_to_words(abs($number));
    }
    $string = $fraction = null;
    if (strpos($number, '.') !== false) {
        list($number, $fraction) = explode('.', $number);
    }
    switch (true) {
        case $number < 21:
            $string = $dictionary[$number];
            break;
        case $number < 100:
            $tens = ((int)($number / 10)) * 10;
            $units = $number % 10;
            $string = $dictionary[$tens];
            if ($units) {
                $string .= $hyphen . $dictionary[$units];
            }
            break;
        case $number < 1000:
            $hundreds = $number / 100;
            $remainder = $number % 100;
            $string = $dictionary[$hundreds] . ' ' . $dictionary[100];
            if ($remainder) {
                $string .= $conjunction . convert_number_to_words($remainder);
            }
            break;
        default:
            $baseUnit = pow(1000, floor(log($number, 1000)));
            $numBaseUnits = (int)($number / $baseUnit);
            $remainder = $number % $baseUnit;
            $string = convert_number_to_words($numBaseUnits) . ' ' . $dictionary[$baseUnit];
            if ($remainder) {
                $string .= $remainder < 100 ? $conjunction : $separator;
                $string .= convert_number_to_words($remainder);
            }
            break;
    }
    if (null !== $fraction && is_numeric($fraction)) {
        if ($fraction > 0) { // membuabg output point zero-zero

            $string .= $decimal;
            $words = array();

            foreach (str_split((string)$fraction) as $number) {
                $words[] = $dictionary[$number];
            }
            $string .= implode(' ', $words);
        }

    }

    switch ($style) {
        case 1:
            $string = strtoupper($string);
            break;
        case 2:
            $string = strtolower($string);
            break;
        case 3:
            $string = ucwords($string);
            break;
        default:
            $string = ucfirst($string);
            break;
    }

    return $string;
}

function unFormatAngka($angka)
{
    $unf = str_replace(".", "", $angka);
    $unf = str_replace(",", ".", $unf);

    return $unf;
}

function formatNumbering($numbering, $arrKomponen)
{
    //    $arrKomponen = array($arrKomponen);
    $explNumb = explode("-", $numbering);
    foreach ($arrKomponen as $v) {

        if ($hasil == "") {

            $hasil = $explNumb[$v];
        }
        else {

            $hasil = "$hasil-" . $explNumb[$v];
        }

    }
    $numbering_f = $hasil;


    return $numbering_f;
}

function formatNumberingText($numbering, $arrKomponen, $arrPartText, $cabCode)
{
    $explNumb = explode("-", $numbering);
    $x = 0;
    $numbering_f = "";

    foreach ($arrKomponen as $v) {
        if ($hasil == "") {
            $hasil = "<span class=\"no-padding no-margin col-xs-2 text-center\">";
            $hasil .= "<span style=\"font-size: 8px; border-bottom: 1px #33333347 solid;\" class=\"no-padding no-margin col-xs-12 text-center\">" . $arrPartText[$x] . "</span>";
            $hasil .= "<span style=\"line-height: 1;\" class=\"no-padding no-margin col-xs-12 text-center text-bold text-uppercase\">" . $cabCode . $explNumb[$v] . "</span>";
            $hasil .= "</span>";
        }
        else {
            $hasil = "$hasil" . "<span style='padding-left:1px; padding-right: 1px;' class=\"col-xs-2 text-center\">";
            $hasil .= "<span style=\"font-size: 8px; border-bottom: 1px #33333347 solid;padding-left:1px; padding-right: 1px;\" class=\"col-xs-12 text-right\">" . $arrPartText[$x] . "</span>";
            $hasil .= "<span style=\"line-height: 1;\" class=\"no-padding no-margin col-xs-12 text-right text-bold text-uppercase\">" . $explNumb[$v] . "</span>";
            $hasil .= "</span>";
        }
        $x++;
    }
    $numbering_f = $hasil;

    return $numbering_f;
}

function fileSizeConvert($bytes)
{
    $bytes = floatval($bytes);
    $arBytes = array(
        0 => array(
            "UNIT"  => "TB",
            "VALUE" => pow(1024, 4),
        ),
        1 => array(
            "UNIT"  => "GB",
            "VALUE" => pow(1024, 3),
        ),
        2 => array(
            "UNIT"  => "MB",
            "VALUE" => pow(1024, 2),
        ),
        3 => array(
            "UNIT"  => "KB",
            "VALUE" => 1024,
        ),
        4 => array(
            "UNIT"  => "B",
            "VALUE" => 1,
        ),
    );

    $result = "";
    foreach ($arBytes as $arItem) {
        if ($bytes >= $arItem["VALUE"]) {
            $result = $bytes / $arItem["VALUE"];
            $result = str_replace(".", ",", strval(round($result, 2))) . " " . $arItem["UNIT"];
            break;
        }
    }

    return $result;
}

function convTime($fr, $to, $val)
{
    // $arrMast = array(
    //     "Y" => 0.0001140771,
    //     "M" => 0.0013689254,
    //     "w" => 0.005952381,
    //     "D" => 0.0416666667,
    //     "H" => 1,
    //     "i" => 60,
    //     "s" => 3600,
    //     "ms" => 3600000,
    //     "us" => 3600000000,
    // );

    // $arrMast = array(
    //     "Y" => 0.0027378508,
    //     "M" => 0.0328542094,
    //     "w" => 0.1428571429,
    //     "D" => 1,
    //     "H" => 24,
    //     "i" => 1440,
    //     "s" => 86400,
    //     "ms" => 86400000,
    //     "us" => 86400000000,
    // );

    $arrMast = array(
        "Y"  => 0.0191649555,
        "M"  => 0.2299794661,
        "w"  => 1,
        "D"  => 7,
        "H"  => 168,
        "i"  => 10080,
        "s"  => 604800,
        "ms" => 604800000,
        "us" => 604800000000,
    );

    $mast = $arrMast[$fr];
    $slave = $arrMast[$to];

    $var = $slave / $mast;

    $var_c = $var * $val;

    // cekHijau("val: $val dr($fr): $mast ==== jd($to): $slave ===== $var_c");
    return $var_c;

}

function convVolume($fr, $to, $val)
{
    $arrMast = array(
        "km"  => 0.000000000001,
        "hm"  => 0.000000001,
        "dam" => 0.000001,
        "m"   => 0.001,
        "dm"  => 1,
        // "in" => 39.37007874,
        "cm"  => 1000,
        "mm"  => 1000000,
    );

    $mast = $arrMast[$fr];
    $slave = $arrMast[$to];

    $var = $slave / $mast;

    $var_c = $var * $val;

    // cekHijau("val: $val dr($fr): $mast ==== jd($to): $slave ===== $var_c");
    return $var_c;

}

function convDistance($fr, $to, $val)
{
    $arrMast = array(
        "km"  => 0.001,
        "hm"  => 0.01,
        "dam" => 0.1,
        "m"   => 1,
        "dm"  => 10,
        "in"  => 39.37007874,
        "cm"  => 100,
        "mm"  => 1000,
    );

    $mast = $arrMast[$fr];
    $slave = $arrMast[$to];

    $var = $slave / $mast;

    $var_c = $var * $val;

    // cekHijau("val: $val dr($fr): $mast ==== jd($to): $slave ===== $var_c");
    return $var_c;

}

function convWeight($fr, $to, $val)
{
    $arrMast = array(
        "kg"  => 0.001,
        "hg"  => 0.01,
        "dag" => 0.1,
        "g"   => 1,
        "dg"  => 10,
        "cg"  => 100,
        "mg"  => 1000,
    );

    $mast = $arrMast[$fr];
    $slave = $arrMast[$to];

    $var = $slave / $mast;

    $var_c = $var * $val;

    // cekHijau("val: $val dr($fr): $mast ==== jd($to): $slave ===== $var_c");
    return $var_c;

}

function conv_mm_m($nilai)
{
    $var = convDistance("mm", "m", $nilai);

    return $var;
}

function conv_g_kg($nilai)
{
    $var = convWeight("g", "kg", $nilai);

    return $var;
}

function conv_mmc_dmc($nilai)
{
    $var = convVolume("mm", "dm", $nilai);

    return $var;
}

function conv_mmc_mc($nilai)
{
    $var = convVolume("mm", "m", $nilai);

    return $var;
}

// region start pembulatan bilangan
// harus ada key untuk memanggil hasilnya
// $angka_hasil = pembulatan_puluhan($angka)["hasil"];
function membilang($angka)
{
    $expTransaksi_net = explode(".", $angka);
    $integer = $expTransaksi_net[0];
    $desimal = "0." . $expTransaksi_net[1];

    $satuan = substr($integer, -1);
    $puluhan = substr($integer, -2);
    $ribuan = substr($integer, -3);

    $var['int'] = $integer * 1;
    $var['satuan'] = $satuan * 1;
    $var['puluhan'] = $puluhan * 1;
    $var['ribuan'] = $ribuan * 1;
    $var['desimal'] = $desimal * 1;

    return $var;
}

function pembulatan_koma($angka)
{
    $arr = membilang($angka);
    // arrPrint($arr);
    $pecahan = $arr['desimal'];
    if ($pecahan >= 0.5) {
        $faktor = (1 - $pecahan);
        $pembulatan = $angka + $faktor;
    }
    else {
        $faktor = -$pecahan;
        $pembulatan = $angka + $faktor;
    }

    // cekHijau("$pembulatan = 10 - $pecahan");

    $var["pecahan"] = $pecahan;
    $var["faktor"] = $faktor;
    $var["hasil"] = $pembulatan;

    return $var;
}

function pembulatan_puluhan($angka)
{
    $arr = membilang($angka);
    // arrPrint($arr);
    $pecahan = $arr['satuan'] + $arr['desimal'];
    if ($pecahan >= 5) {
        $faktor = (10 - $pecahan);
        $pembulatan = $angka + $faktor;
    }
    else {
        $faktor = -$pecahan;
        $pembulatan = $angka + $faktor;
    }

    // cekHijau("$pembulatan = 10 - $pecahan");

    $var["pecahan"] = $pecahan;
    $var["faktor"] = $faktor;
    $var["hasil"] = $pembulatan;

    return $var;
}

function pembulatan_ratusan($angka)
{
    $arr = membilang($angka);
    // arrPrint($arr);
    $pecahan = $arr['puluhan'] + $arr['desimal'];
    if ($pecahan >= 50) {
        $faktor = (100 - $pecahan);
        $pembulatan = $angka + $faktor;
    }
    else {
        $faktor = -$pecahan;
        $pembulatan = $angka + $faktor;
    }

    // cekHijau("$pembulatan = 10 - $pecahan");

    $var["pecahan"] = $pecahan;
    $var["faktor"] = $faktor;
    $var["hasil"] = $pembulatan;

    return $var;
}

function pembulatan_ribuan($angka)
{
    $arr = membilang($angka);
    // arrPrint($arr);
    $pecahan = $arr['ribuan'] + $arr['desimal'];
    if ($pecahan >= 500) {
        $faktor = (1000 - $pecahan);
        $pembulatan = $angka + $faktor;
    }
    else {
        $faktor = -$pecahan;
        $pembulatan = $angka + $faktor;
    }

    // cekHijau("$pembulatan = 1000 - $pecahan");

    $var["pecahan"] = $pecahan;
    $var["faktor"] = $faktor;
    $var["hasil"] = $pembulatan;

    return $var;
}

// endregion stop

function valas_icon($valas_code = true)
{
    $arr = array(
        "USD" => "fa-usd",
    );
    if ($valas_code === true) {
        cekHere("$valas_code");
        return $arr;
    }
    else {
        $v_icon = $arr[$valas_code];

        $var = "<i class='fa $v_icon'></i>";
        return $var;
    }
}

?>
