# SQL-Front 5.1  (Build 4.16)

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE */;
/*!40101 SET SQL_MODE='' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES */;
/*!40103 SET SQL_NOTES='ON' */;


# Host: 192.168.1.47    Database: ds_mgk_4
# ------------------------------------------------------
# Server version 5.5.34-0ubuntu0.13.04.1

#
# Source for table acc_neraca
#

DROP TABLE IF EXISTS `acc_neraca`;
CREATE TABLE `acc_neraca` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rekening_id` int(11) NOT NULL DEFAULT '0',
  `rekening` varchar(255) DEFAULT NULL,
  `nilai` decimal(16,2) NOT NULL DEFAULT '0.00',
  `jenis` varchar(255) DEFAULT NULL,
  `prioritas` tinyint(1) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tanggal` tinyint(2) NOT NULL DEFAULT '0',
  `dtime` datetime DEFAULT NULL,
  `neraca_x` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table acc_rekening
#

DROP TABLE IF EXISTS `acc_rekening`;
CREATE TABLE `acc_rekening` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(255) DEFAULT NULL,
  `prioritas` tinyint(2) NOT NULL DEFAULT '0' COMMENT '1=wajib muncul, 2=muncul kalau ada nilai',
  `jenis` varchar(250) DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` mediumint(4) NOT NULL DEFAULT '0',
  `trash` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table access
#

DROP TABLE IF EXISTS `access`;
CREATE TABLE `access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `acc_type` varchar(255) DEFAULT NULL,
  `per_employee_id` int(11) NOT NULL DEFAULT '0',
  `acc_level` varchar(255) DEFAULT NULL,
  `acc_group` int(11) NOT NULL DEFAULT '0',
  `dtime` datetime DEFAULT NULL,
  `author` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=latin1;

#
# Source for table adjusment_cache
#

DROP TABLE IF EXISTS `adjusment_cache`;
CREATE TABLE `adjusment_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `jmlTambah` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jmlKurang` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml` decimal(14,2) DEFAULT NULL,
  `tgl` varchar(2) DEFAULT NULL,
  `bln` varchar(2) DEFAULT NULL,
  `thn` varchar(2) DEFAULT NULL,
  `dtime` datetime DEFAULT NULL,
  `pembayaran` tinytext NOT NULL,
  `labels` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table adjusment_nilai
#

DROP TABLE IF EXISTS `adjusment_nilai`;
CREATE TABLE `adjusment_nilai` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(250) DEFAULT '0',
  `jml_stock` int(11) NOT NULL DEFAULT '0',
  `hpp_old` decimal(14,2) NOT NULL DEFAULT '0.00',
  `hpp_new` decimal(14,2) NOT NULL DEFAULT '0.00',
  `hpp_gap` decimal(14,2) NOT NULL DEFAULT '0.00',
  `nilai_adj_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `nilai_adj_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `nilai_adj_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `nilai_adj_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `transaksi_id` int(11) NOT NULL DEFAULT '0',
  `transaksi_no` varchar(250) DEFAULT '0',
  `transaksi_jenis` varchar(255) NOT NULL DEFAULT '',
  `keterangan` varchar(250) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table cabang
#

DROP TABLE IF EXISTS `cabang`;
CREATE TABLE `cabang` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(255) DEFAULT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(32) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `trash` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

#
# Source for table client
#

DROP TABLE IF EXISTS `client`;
CREATE TABLE `client` (
  `cl_id` int(11) NOT NULL AUTO_INCREMENT,
  `cl_name` varchar(128) NOT NULL,
  `cl_type` varchar(16) DEFAULT NULL,
  `cl_iplist` varchar(512) NOT NULL,
  `cl_memberof` bigint(20) NOT NULL,
  `cl_customerID` int(11) DEFAULT NULL,
  `cl_addr` varchar(255) NOT NULL,
  `cl_city` varchar(255) NOT NULL,
  `cl_tlp` varchar(255) NOT NULL,
  `cl_wilayah` int(11) DEFAULT NULL,
  `cl_email` varchar(255) NOT NULL,
  `cl_forward_active` char(1) NOT NULL,
  `cl_selling_mode` varchar(128) NOT NULL,
  `cl_allow_trading` char(1) DEFAULT NULL,
  `cl_allow_kuliner` char(1) DEFAULT NULL,
  `cl_distribution_mode` varchar(128) NOT NULL,
  `cl_skip_inv` char(1) NOT NULL,
  `cl_max_workstation` int(11) NOT NULL,
  `cl_notification_mode` varchar(128) DEFAULT NULL,
  `cl_active` char(1) DEFAULT NULL,
  PRIMARY KEY (`cl_id`),
  KEY `cl_wilayah` (`cl_wilayah`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table counters
#

DROP TABLE IF EXISTS `counters`;
CREATE TABLE `counters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(45) DEFAULT NULL,
  `nilai` varchar(45) NOT NULL DEFAULT '1',
  `last_dtime` datetime DEFAULT NULL,
  `dev` varchar(45) DEFAULT NULL,
  `dev_info` varchar(45) DEFAULT NULL,
  `employee_id` int(11) NOT NULL,
  PRIMARY KEY (`id`,`employee_id`)
) ENGINE=InnoDB AUTO_INCREMENT=617 DEFAULT CHARSET=latin1;

#
# Source for table harga
#

DROP TABLE IF EXISTS `harga`;
CREATE TABLE `harga` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `cabang_id` int(11) NOT NULL DEFAULT '0',
  `harga_lama` decimal(14,2) NOT NULL DEFAULT '0.00',
  `harga_baru` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jenis_harga` varchar(255) NOT NULL DEFAULT '',
  `hpp_lama` decimal(10,2) NOT NULL DEFAULT '0.00',
  `hpp_baru` decimal(10,2) NOT NULL DEFAULT '0.00',
  `komisi_lama` decimal(10,2) NOT NULL DEFAULT '0.00',
  `komisi_baru` decimal(10,2) NOT NULL DEFAULT '0.00',
  `laba_lama` decimal(10,2) NOT NULL DEFAULT '0.00',
  `laba_baru` decimal(10,2) NOT NULL DEFAULT '0.00',
  `alasan` tinytext NOT NULL,
  `dtime` datetime DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `author` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table images
#

DROP TABLE IF EXISTS `images`;
CREATE TABLE `images` (
  `idimage` int(11) NOT NULL AUTO_INCREMENT,
  `idprod` int(11) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '0',
  `idangg` int(11) NOT NULL DEFAULT '0',
  `namafile` text,
  `isi` tinytext,
  `tabel` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`idimage`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=latin1;

#
# Source for table inputs_temp
#

DROP TABLE IF EXISTS `inputs_temp`;
CREATE TABLE `inputs_temp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inputs_dtime` datetime DEFAULT NULL,
  `supplier_id` int(11) NOT NULL,
  `supplier_nama` varchar(45) DEFAULT NULL,
  `inputs_no` varchar(45) DEFAULT NULL,
  `nilai` decimal(10,2) NOT NULL DEFAULT '0.00',
  `status` tinyint(3) NOT NULL DEFAULT '0',
  `approval_dtime` datetime DEFAULT NULL,
  `approval_id` int(11) NOT NULL DEFAULT '0',
  `trash` tinyint(3) NOT NULL DEFAULT '0',
  `laporan` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table inputs_temp_data
#

DROP TABLE IF EXISTS `inputs_temp_data`;
CREATE TABLE `inputs_temp_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inputs_temp_id` int(11) NOT NULL DEFAULT '0',
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_jml` int(11) NOT NULL DEFAULT '0',
  `produk_hrg` int(11) NOT NULL DEFAULT '0',
  `produk_komisi` int(11) NOT NULL DEFAULT '0',
  `produk_hpp` int(11) NOT NULL DEFAULT '0',
  `produk_laba` int(11) NOT NULL DEFAULT '0',
  `inputs_dtime` datetime DEFAULT NULL,
  `supplier_id` int(11) NOT NULL,
  `supplier_nama` varchar(45) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table jurnal
#

DROP TABLE IF EXISTS `jurnal`;
CREATE TABLE `jurnal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `jenis` varchar(32) NOT NULL DEFAULT '',
  `j_jurnal` varchar(32) DEFAULT NULL,
  `transaksi_id` int(11) NOT NULL DEFAULT '0',
  `nilai_debet` int(11) NOT NULL DEFAULT '0',
  `nilai_kredit` int(11) NOT NULL DEFAULT '0',
  `dtime` datetime DEFAULT NULL,
  `author` int(11) NOT NULL DEFAULT '0',
  `keterangan` varchar(250) NOT NULL DEFAULT '0',
  `localID` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table kas_cache
#

DROP TABLE IF EXISTS `kas_cache`;
CREATE TABLE `kas_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `jmlPembPiutang` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jmlPembHutang` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jmlRusak` int(11) NOT NULL DEFAULT '0',
  `jmlPerbaikan` int(11) NOT NULL DEFAULT '0',
  `jmlPenjualan` int(11) NOT NULL DEFAULT '0',
  `jmlReturnPenjualan` int(11) NOT NULL DEFAULT '0',
  `jmlTambah` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jmlKurang` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml` decimal(14,2) DEFAULT NULL,
  `tgl` varchar(2) DEFAULT NULL,
  `bln` varchar(2) DEFAULT NULL,
  `thn` varchar(2) DEFAULT NULL,
  `dtime` datetime DEFAULT NULL,
  `pembayaran` tinytext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

#
# Source for table kas_mutasi
#

DROP TABLE IF EXISTS `kas_mutasi`;
CREATE TABLE `kas_mutasi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `anggota_id` int(11) NOT NULL DEFAULT '0',
  `ks_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_after` decimal(14,2) NOT NULL DEFAULT '0.00',
  `dtime` datetime DEFAULT NULL,
  `transaksi_id` int(11) NOT NULL DEFAULT '0',
  `transaksi_no` varchar(255) DEFAULT NULL,
  `keterangan` tinytext,
  `author` int(11) NOT NULL DEFAULT '0',
  `jenis` varchar(255) NOT NULL DEFAULT '',
  `pembayaran` varchar(255) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=latin1;

#
# Source for table kirim_email
#

DROP TABLE IF EXISTS `kirim_email`;
CREATE TABLE `kirim_email` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `jam` time DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `jenis` varchar(255) DEFAULT NULL,
  `ipadd` varchar(255) DEFAULT NULL,
  `msg` text,
  `n_email` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=396 DEFAULT CHARSET=latin1;

#
# Source for table komisi
#

DROP TABLE IF EXISTS `komisi`;
CREATE TABLE `komisi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(255) DEFAULT NULL,
  `anggota_id` int(11) NOT NULL DEFAULT '0',
  `anggota_nama` varchar(255) NOT NULL DEFAULT '',
  `ks_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_after` decimal(14,2) NOT NULL DEFAULT '0.00',
  `dtime` datetime DEFAULT NULL,
  `orders_id` int(11) NOT NULL DEFAULT '0',
  `transaksi_id` int(11) NOT NULL DEFAULT '0',
  `transaksi_no` varchar(255) DEFAULT NULL,
  `keterangan` tinytext,
  `author` int(11) NOT NULL DEFAULT '0',
  `jenis` varchar(255) NOT NULL DEFAULT '',
  `pembayaran` varchar(255) DEFAULT '',
  `jml_items` int(11) DEFAULT NULL,
  `r_komisi` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table komisi_bl
#

DROP TABLE IF EXISTS `komisi_bl`;
CREATE TABLE `komisi_bl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date DEFAULT NULL,
  `bulan` int(11) NOT NULL DEFAULT '0',
  `tahun` int(11) NOT NULL DEFAULT '0',
  `anggota_id` int(11) NOT NULL DEFAULT '0',
  `anggota_nama` varchar(255) NOT NULL DEFAULT '',
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(255) DEFAULT NULL,
  `jml_transaksi` int(11) NOT NULL DEFAULT '0',
  `jml_items` int(11) NOT NULL DEFAULT '0',
  `ks_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_after` decimal(14,2) NOT NULL DEFAULT '0.00',
  `status` int(11) NOT NULL DEFAULT '0',
  `omset_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `omset_in` decimal(14,2) DEFAULT '0.00',
  `omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `omset_after` decimal(12,2) NOT NULL DEFAULT '0.00',
  `last_dtime` datetime DEFAULT NULL,
  `r_komisi` tinyint(1) NOT NULL DEFAULT '0',
  `bl_x` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table komisi_cache
#

DROP TABLE IF EXISTS `komisi_cache`;
CREATE TABLE `komisi_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `anggota_id` int(11) NOT NULL DEFAULT '0',
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `jmlPenjualan` int(11) NOT NULL DEFAULT '0',
  `jmlReturnPenjualan` int(11) NOT NULL DEFAULT '0',
  `jmlTambah` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jmlKurang` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml` decimal(14,2) DEFAULT NULL,
  `tgl` varchar(2) DEFAULT NULL,
  `bln` varchar(2) DEFAULT NULL,
  `thn` varchar(2) DEFAULT NULL,
  `dtime` datetime DEFAULT NULL,
  `pembayaran` tinytext NOT NULL,
  `labels` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table komisi_hr
#

DROP TABLE IF EXISTS `komisi_hr`;
CREATE TABLE `komisi_hr` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date DEFAULT NULL,
  `bulan` int(11) NOT NULL DEFAULT '0',
  `tahun` int(11) NOT NULL DEFAULT '0',
  `anggota_id` int(11) NOT NULL DEFAULT '0',
  `anggota_nama` varchar(255) NOT NULL DEFAULT '',
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(255) DEFAULT NULL,
  `jml_transaksi` int(11) NOT NULL DEFAULT '0',
  `jml_items` int(11) NOT NULL DEFAULT '0',
  `ks_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_after` decimal(14,2) NOT NULL DEFAULT '0.00',
  `status` int(11) NOT NULL DEFAULT '0',
  `omset_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `omset_in` decimal(14,2) DEFAULT '0.00',
  `omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `omset_after` decimal(12,2) NOT NULL DEFAULT '0.00',
  `last_dtime` datetime DEFAULT NULL,
  `r_komisi` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table komisi_laba
#

DROP TABLE IF EXISTS `komisi_laba`;
CREATE TABLE `komisi_laba` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `jml_laba_bruto_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_laba_bruto_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_laba_bruto_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_laba_bruto_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_laba_netto_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_laba_netto_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_laba_netto_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_laba_netto_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `transaksi_id` int(11) NOT NULL DEFAULT '0',
  `transaksi_no` varchar(250) DEFAULT '0',
  `transaksi_jenis` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

#
# Source for table komisi_laba_cache
#

DROP TABLE IF EXISTS `komisi_laba_cache`;
CREATE TABLE `komisi_laba_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `last_dtime` datetime DEFAULT NULL,
  `jml_laba_bruto_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_laba_netto_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

#
# Source for table komisi_seller
#

DROP TABLE IF EXISTS `komisi_seller`;
CREATE TABLE `komisi_seller` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `anggota_id` int(11) NOT NULL DEFAULT '0',
  `anggota_nama` varchar(255) NOT NULL DEFAULT '',
  `ks_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_after` decimal(14,2) NOT NULL DEFAULT '0.00',
  `dtime` datetime DEFAULT NULL,
  `orders_id` int(11) NOT NULL DEFAULT '0',
  `transaksi_id` int(11) NOT NULL DEFAULT '0',
  `transaksi_no` varchar(255) DEFAULT NULL,
  `keterangan` tinytext,
  `author` int(11) NOT NULL DEFAULT '0',
  `jenis` varchar(255) NOT NULL DEFAULT '',
  `pembayaran` varchar(255) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table komisi_seller_bl
#

DROP TABLE IF EXISTS `komisi_seller_bl`;
CREATE TABLE `komisi_seller_bl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `seller_id` int(11) NOT NULL DEFAULT '0',
  `seller_nama` varchar(250) DEFAULT '0',
  `jml_stock_be` int(11) NOT NULL DEFAULT '0',
  `jml_stock_in` int(11) NOT NULL DEFAULT '0',
  `jml_stock_ot` int(11) NOT NULL DEFAULT '0',
  `jml_stock_af` int(11) NOT NULL DEFAULT '0',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_transaksi_be` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_in` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_ot` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_af` int(11) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table komisi_seller_hr
#

DROP TABLE IF EXISTS `komisi_seller_hr`;
CREATE TABLE `komisi_seller_hr` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `seller_id` int(11) NOT NULL DEFAULT '0',
  `seller_nama` varchar(250) DEFAULT '0',
  `jml_stock_be` int(11) NOT NULL DEFAULT '0',
  `jml_stock_in` int(11) NOT NULL DEFAULT '0',
  `jml_stock_ot` int(11) NOT NULL DEFAULT '0',
  `jml_stock_af` int(11) NOT NULL DEFAULT '0',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_transaksi_be` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_in` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_ot` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_af` int(11) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table komisi_seller_produk_bl
#

DROP TABLE IF EXISTS `komisi_seller_produk_bl`;
CREATE TABLE `komisi_seller_produk_bl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(250) DEFAULT '0',
  `seller_id` int(11) NOT NULL DEFAULT '0',
  `seller_nama` varchar(250) DEFAULT '0',
  `jml_stock_be` int(11) NOT NULL DEFAULT '0',
  `jml_stock_in` int(11) NOT NULL DEFAULT '0',
  `jml_stock_ot` int(11) NOT NULL DEFAULT '0',
  `jml_stock_af` int(11) NOT NULL DEFAULT '0',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_transaksi_be` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_in` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_ot` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_af` int(11) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table log
#

DROP TABLE IF EXISTS `log`;
CREATE TABLE `log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `per_employee_id` int(11) NOT NULL DEFAULT '0',
  `deskripsi` text,
  `ipadd` varchar(32) DEFAULT NULL,
  `jenis` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4776 DEFAULT CHARSET=latin1;

#
# Source for table log_kirim_notif
#

DROP TABLE IF EXISTS `log_kirim_notif`;
CREATE TABLE `log_kirim_notif` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `jam` time DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `judul` varchar(255) DEFAULT NULL,
  `jenis` varchar(255) DEFAULT NULL,
  `ipadd` varchar(255) DEFAULT NULL,
  `msg` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=170 DEFAULT CHARSET=latin1;

#
# Source for table misc
#

DROP TABLE IF EXISTS `misc`;
CREATE TABLE `misc` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fungsi` varchar(255) DEFAULT NULL,
  `nilai` varchar(255) DEFAULT NULL,
  `untuk` varchar(255) DEFAULT NULL,
  `parent` int(11) NOT NULL DEFAULT '0',
  `items` int(11) NOT NULL DEFAULT '0',
  `dtime` datetime DEFAULT NULL,
  `trash` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2023214 DEFAULT CHARSET=latin1;

#
# Source for table mlm_komisi_bl
#

DROP TABLE IF EXISTS `mlm_komisi_bl`;
CREATE TABLE `mlm_komisi_bl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date DEFAULT NULL,
  `bulan` int(11) NOT NULL DEFAULT '0',
  `tahun` int(11) NOT NULL DEFAULT '0',
  `anggota_id` int(11) NOT NULL DEFAULT '0',
  `anggota_nama` varchar(255) NOT NULL DEFAULT '',
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(255) DEFAULT NULL,
  `jml_transaksi` int(11) NOT NULL DEFAULT '0',
  `jml_items` int(11) NOT NULL DEFAULT '0',
  `ks_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_after` decimal(14,2) NOT NULL DEFAULT '0.00',
  `status` int(11) NOT NULL DEFAULT '0',
  `omset_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `omset_in` decimal(14,2) DEFAULT '0.00',
  `omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `omset_after` decimal(12,2) NOT NULL DEFAULT '0.00',
  `last_dtime` datetime DEFAULT NULL,
  `bl_x` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

#
# Source for table mlm_komisi_cache
#

DROP TABLE IF EXISTS `mlm_komisi_cache`;
CREATE TABLE `mlm_komisi_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `anggota_id` int(11) NOT NULL DEFAULT '0',
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `jmlPenjualan` int(11) NOT NULL DEFAULT '0',
  `jmlReturnPenjualan` int(11) NOT NULL DEFAULT '0',
  `jmlTambah` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jmlKurang` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml` decimal(14,2) DEFAULT NULL,
  `tgl` varchar(2) DEFAULT NULL,
  `bln` varchar(2) DEFAULT NULL,
  `thn` varchar(2) DEFAULT NULL,
  `dtime` datetime DEFAULT NULL,
  `pembayaran` tinytext NOT NULL,
  `labels` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

#
# Source for table mlm_komisi_co
#

DROP TABLE IF EXISTS `mlm_komisi_co`;
CREATE TABLE `mlm_komisi_co` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date DEFAULT NULL,
  `bulan` int(11) NOT NULL DEFAULT '0',
  `tahun` int(11) NOT NULL DEFAULT '0',
  `anggota_id` int(11) NOT NULL DEFAULT '0',
  `anggota_nama` varchar(255) NOT NULL DEFAULT '',
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(255) DEFAULT NULL,
  `jml_transaksi` int(11) NOT NULL DEFAULT '0',
  `jml_items` int(11) NOT NULL DEFAULT '0',
  `ks_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_after` decimal(14,2) NOT NULL DEFAULT '0.00',
  `status` int(11) NOT NULL DEFAULT '0',
  `omset_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `omset_in` decimal(14,2) DEFAULT '0.00',
  `omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `omset_after` decimal(12,2) NOT NULL DEFAULT '0.00',
  `last_dtime` datetime DEFAULT NULL,
  `order_id` int(11) NOT NULL DEFAULT '0',
  `downline_id` int(11) NOT NULL DEFAULT '0',
  `downline_nama` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;

#
# Source for table mlm_komisi_th
#

DROP TABLE IF EXISTS `mlm_komisi_th`;
CREATE TABLE `mlm_komisi_th` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date DEFAULT NULL,
  `bulan` int(11) NOT NULL DEFAULT '0',
  `tahun` int(11) NOT NULL DEFAULT '0',
  `anggota_id` int(11) NOT NULL DEFAULT '0',
  `anggota_nama` varchar(255) NOT NULL DEFAULT '',
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(255) DEFAULT NULL,
  `jml_transaksi` int(11) NOT NULL DEFAULT '0',
  `jml_items` int(11) NOT NULL DEFAULT '0',
  `ks_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_after` decimal(14,2) NOT NULL DEFAULT '0.00',
  `status` int(11) NOT NULL DEFAULT '0',
  `omset_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `omset_in` decimal(14,2) DEFAULT '0.00',
  `omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `omset_after` decimal(12,2) NOT NULL DEFAULT '0.00',
  `last_dtime` datetime DEFAULT NULL,
  `th_x` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

#
# Source for table mlm_komisi_upline_downline
#

DROP TABLE IF EXISTS `mlm_komisi_upline_downline`;
CREATE TABLE `mlm_komisi_upline_downline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date DEFAULT NULL,
  `bulan` int(11) NOT NULL DEFAULT '0',
  `tahun` int(11) NOT NULL DEFAULT '0',
  `anggota_id` int(11) NOT NULL DEFAULT '0',
  `anggota_nama` varchar(255) NOT NULL DEFAULT '',
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(255) DEFAULT NULL,
  `jml_transaksi` int(11) NOT NULL DEFAULT '0',
  `jml_items` int(11) NOT NULL DEFAULT '0',
  `ks_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_after` decimal(14,2) NOT NULL DEFAULT '0.00',
  `status` int(11) NOT NULL DEFAULT '0',
  `omset_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `omset_in` decimal(14,2) DEFAULT '0.00',
  `omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `omset_after` decimal(12,2) NOT NULL DEFAULT '0.00',
  `last_dtime` datetime DEFAULT NULL,
  `order_id` int(11) NOT NULL DEFAULT '0',
  `downline_id` int(11) NOT NULL DEFAULT '0',
  `downline_nama` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;

#
# Source for table modal_cache
#

DROP TABLE IF EXISTS `modal_cache`;
CREATE TABLE `modal_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nilai` decimal(14,2) NOT NULL DEFAULT '0.00',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tanggal` date DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `neraca_x` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table modal_mutasi
#

DROP TABLE IF EXISTS `modal_mutasi`;
CREATE TABLE `modal_mutasi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ks_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_after` decimal(14,2) NOT NULL DEFAULT '0.00',
  `dtime` datetime DEFAULT NULL,
  `transaksi_id` int(11) NOT NULL DEFAULT '0',
  `transaksi_no` varchar(255) DEFAULT NULL,
  `keterangan` tinytext,
  `author` int(11) NOT NULL DEFAULT '0',
  `jenis` varchar(255) NOT NULL DEFAULT '',
  `pembayaran` varchar(255) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table order_netto_hr
#

DROP TABLE IF EXISTS `order_netto_hr`;
CREATE TABLE `order_netto_hr` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `jml_stock_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_stock_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_stock_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_stock_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `last_dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table order_netto_produk_bl
#

DROP TABLE IF EXISTS `order_netto_produk_bl`;
CREATE TABLE `order_netto_produk_bl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(250) DEFAULT '0',
  `jml_stock_be` int(11) NOT NULL DEFAULT '0',
  `jml_stock_in` int(11) NOT NULL DEFAULT '0',
  `jml_stock_ot` int(11) NOT NULL DEFAULT '0',
  `jml_stock_af` int(11) NOT NULL DEFAULT '0',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_transaksi_be` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_in` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_ot` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_af` int(11) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `bl_x` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table order_netto_produk_co
#

DROP TABLE IF EXISTS `order_netto_produk_co`;
CREATE TABLE `order_netto_produk_co` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(250) DEFAULT '0',
  `jml_stock_be` int(11) NOT NULL DEFAULT '0',
  `jml_stock_in` int(11) NOT NULL DEFAULT '0',
  `jml_stock_ot` int(11) NOT NULL DEFAULT '0',
  `jml_stock_af` int(11) NOT NULL DEFAULT '0',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_transaksi_be` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_in` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_ot` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_af` int(11) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `co_x` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table order_netto_produk_hr
#

DROP TABLE IF EXISTS `order_netto_produk_hr`;
CREATE TABLE `order_netto_produk_hr` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(250) DEFAULT '0',
  `jml_stock_be` int(11) NOT NULL DEFAULT '0',
  `jml_stock_in` int(11) NOT NULL DEFAULT '0',
  `jml_stock_ot` int(11) NOT NULL DEFAULT '0',
  `jml_stock_af` int(11) NOT NULL DEFAULT '0',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_transaksi_be` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_in` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_ot` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_af` int(11) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `hr_x` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table order_netto_produk_seller_bl
#

DROP TABLE IF EXISTS `order_netto_produk_seller_bl`;
CREATE TABLE `order_netto_produk_seller_bl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(250) DEFAULT '0',
  `seller_id` int(11) NOT NULL DEFAULT '0',
  `seller_nama` varchar(250) DEFAULT '0',
  `jml_stock_be` int(11) NOT NULL DEFAULT '0',
  `jml_stock_in` int(11) NOT NULL DEFAULT '0',
  `jml_stock_ot` int(11) NOT NULL DEFAULT '0',
  `jml_stock_af` int(11) NOT NULL DEFAULT '0',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_transaksi_be` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_in` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_ot` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_af` int(11) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `bl_x` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table order_netto_produk_seller_co
#

DROP TABLE IF EXISTS `order_netto_produk_seller_co`;
CREATE TABLE `order_netto_produk_seller_co` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(250) DEFAULT '0',
  `seller_id` int(11) NOT NULL DEFAULT '0',
  `seller_nama` varchar(250) DEFAULT '0',
  `jml_stock_be` int(11) NOT NULL DEFAULT '0',
  `jml_stock_in` int(11) NOT NULL DEFAULT '0',
  `jml_stock_ot` int(11) NOT NULL DEFAULT '0',
  `jml_stock_af` int(11) NOT NULL DEFAULT '0',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_transaksi_be` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_in` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_ot` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_af` int(11) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `co_x` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table order_netto_produk_seller_hr
#

DROP TABLE IF EXISTS `order_netto_produk_seller_hr`;
CREATE TABLE `order_netto_produk_seller_hr` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(250) DEFAULT '0',
  `seller_id` int(11) NOT NULL DEFAULT '0',
  `seller_nama` varchar(250) DEFAULT '0',
  `jml_stock_be` int(11) NOT NULL DEFAULT '0',
  `jml_stock_in` int(11) NOT NULL DEFAULT '0',
  `jml_stock_ot` int(11) NOT NULL DEFAULT '0',
  `jml_stock_af` int(11) NOT NULL DEFAULT '0',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_transaksi_be` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_in` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_ot` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_af` int(11) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `hr_x` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table order_netto_produk_seller_th
#

DROP TABLE IF EXISTS `order_netto_produk_seller_th`;
CREATE TABLE `order_netto_produk_seller_th` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(250) DEFAULT '0',
  `seller_id` int(11) NOT NULL DEFAULT '0',
  `seller_nama` varchar(250) DEFAULT '0',
  `jml_stock_be` int(11) NOT NULL DEFAULT '0',
  `jml_stock_in` int(11) NOT NULL DEFAULT '0',
  `jml_stock_ot` int(11) NOT NULL DEFAULT '0',
  `jml_stock_af` int(11) NOT NULL DEFAULT '0',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_transaksi_be` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_in` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_ot` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_af` int(11) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `th_x` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table order_netto_produk_th
#

DROP TABLE IF EXISTS `order_netto_produk_th`;
CREATE TABLE `order_netto_produk_th` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(250) DEFAULT '0',
  `jml_stock_be` int(11) NOT NULL DEFAULT '0',
  `jml_stock_in` int(11) NOT NULL DEFAULT '0',
  `jml_stock_ot` int(11) NOT NULL DEFAULT '0',
  `jml_stock_af` int(11) NOT NULL DEFAULT '0',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_transaksi_be` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_in` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_ot` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_af` int(11) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `th_x` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table order_netto_seller_bl
#

DROP TABLE IF EXISTS `order_netto_seller_bl`;
CREATE TABLE `order_netto_seller_bl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `seller_id` int(11) NOT NULL DEFAULT '0',
  `seller_nama` varchar(250) DEFAULT '0',
  `jml_stock_be` int(11) NOT NULL DEFAULT '0',
  `jml_stock_in` int(11) NOT NULL DEFAULT '0',
  `jml_stock_ot` int(11) NOT NULL DEFAULT '0',
  `jml_stock_af` int(11) NOT NULL DEFAULT '0',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_transaksi_be` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_in` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_ot` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_af` int(11) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `bl_x` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table order_netto_seller_co
#

DROP TABLE IF EXISTS `order_netto_seller_co`;
CREATE TABLE `order_netto_seller_co` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `seller_id` int(11) NOT NULL DEFAULT '0',
  `seller_nama` varchar(250) DEFAULT '0',
  `jml_stock_be` int(11) NOT NULL DEFAULT '0',
  `jml_stock_in` int(11) NOT NULL DEFAULT '0',
  `jml_stock_ot` int(11) NOT NULL DEFAULT '0',
  `jml_stock_af` int(11) NOT NULL DEFAULT '0',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_transaksi_be` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_in` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_ot` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_af` int(11) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `co_x` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table order_netto_seller_hr
#

DROP TABLE IF EXISTS `order_netto_seller_hr`;
CREATE TABLE `order_netto_seller_hr` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `seller_id` int(11) NOT NULL DEFAULT '0',
  `seller_nama` varchar(250) DEFAULT '0',
  `jml_stock_be` int(11) NOT NULL DEFAULT '0',
  `jml_stock_in` int(11) NOT NULL DEFAULT '0',
  `jml_stock_ot` int(11) NOT NULL DEFAULT '0',
  `jml_stock_af` int(11) NOT NULL DEFAULT '0',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_transaksi_be` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_in` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_ot` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_af` int(11) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `hr_x` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table order_netto_seller_th
#

DROP TABLE IF EXISTS `order_netto_seller_th`;
CREATE TABLE `order_netto_seller_th` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `seller_id` int(11) NOT NULL DEFAULT '0',
  `seller_nama` varchar(250) DEFAULT '0',
  `jml_stock_be` int(11) NOT NULL DEFAULT '0',
  `jml_stock_in` int(11) NOT NULL DEFAULT '0',
  `jml_stock_ot` int(11) NOT NULL DEFAULT '0',
  `jml_stock_af` int(11) NOT NULL DEFAULT '0',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_transaksi_be` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_in` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_ot` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_af` int(11) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `th_x` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table orders
#

DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_dtime` datetime DEFAULT NULL,
  `sellers_id` int(11) NOT NULL,
  `ipadd` varchar(50) NOT NULL,
  `sellers_nama` varchar(45) DEFAULT NULL,
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `supplier_nama` tinytext NOT NULL,
  `buyer_id` int(11) NOT NULL,
  `buyer_nama` varchar(45) DEFAULT NULL,
  `input_no` varchar(45) DEFAULT NULL,
  `nilai` int(11) NOT NULL,
  `pembayaran` varchar(6) DEFAULT NULL,
  `status` tinyint(2) NOT NULL DEFAULT '0',
  `bayar_dtime_0` datetime DEFAULT NULL,
  `bayar_dtime` datetime DEFAULT NULL,
  `bayar_keterangan` varchar(45) DEFAULT NULL,
  `pembayaran_nama` varchar(45) DEFAULT NULL,
  `rekber_id` int(11) DEFAULT NULL,
  `rekber_nama` varchar(45) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `bank_nama` varchar(45) DEFAULT NULL,
  `kurir_id` int(11) NOT NULL,
  `kurir_nama` varchar(45) DEFAULT NULL,
  `kirim_dtime` datetime DEFAULT NULL,
  `kurir_service_id` int(11) NOT NULL DEFAULT '0',
  `kurir_service` varchar(45) DEFAULT NULL,
  `kurir_biaya` decimal(10,2) DEFAULT NULL,
  `kurir_biaya_real` decimal(10,2) DEFAULT NULL,
  `kurir_biaya_selisih` decimal(10,2) DEFAULT NULL,
  `kurir_resi` varchar(255) DEFAULT NULL,
  `sampai_dtime` datetime DEFAULT NULL,
  `cancel_dtime` datetime DEFAULT NULL,
  `cancel_alasan` tinytext,
  `cancel_by` int(11) NOT NULL,
  `lama_kiriman` timestamp NULL DEFAULT NULL,
  `alamat_1` tinytext,
  `alamat_2` tinytext,
  `tlp_1` varchar(13) DEFAULT NULL,
  `rt` varchar(4) DEFAULT NULL,
  `rw` varchar(4) DEFAULT NULL,
  `kelurahan_id` int(11) NOT NULL,
  `kelurahan_nama` varchar(45) DEFAULT NULL,
  `kecamatan_id` int(11) NOT NULL,
  `kecamatan_nama` varchar(45) DEFAULT NULL,
  `kabupaten_id` int(11) NOT NULL,
  `kabupaten_nama` varchar(45) DEFAULT NULL,
  `propinsi_id` int(11) NOT NULL,
  `propinsi_nama` varchar(45) DEFAULT NULL,
  `kodepos` varchar(6) DEFAULT NULL,
  `kodepos_id` int(11) NOT NULL DEFAULT '0',
  `laporan` int(11) NOT NULL,
  `print_alamat` tinyint(1) NOT NULL DEFAULT '0',
  `selesai_dtime` datetime DEFAULT NULL,
  `n_email` tinyint(1) NOT NULL DEFAULT '0',
  `r_komisi` tinyint(1) NOT NULL DEFAULT '0',
  `trash` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table orders_bayar
#

DROP TABLE IF EXISTS `orders_bayar`;
CREATE TABLE `orders_bayar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_dtime` datetime DEFAULT NULL,
  `sellers_id` int(11) NOT NULL,
  `sellers_nama` varchar(45) DEFAULT NULL,
  `buyer_id` int(11) NOT NULL,
  `buyer_nama` varchar(45) DEFAULT NULL,
  `input_no` varchar(45) DEFAULT NULL,
  `nilai` int(11) NOT NULL,
  `pembayaran` varchar(6) DEFAULT NULL,
  `status` int(11) NOT NULL,
  `trash` int(11) NOT NULL,
  `kurir_id` int(11) NOT NULL,
  `kurir_nama` varchar(45) DEFAULT NULL,
  `kirim_dtime` datetime DEFAULT NULL,
  `bayar_dtime` datetime DEFAULT NULL,
  `bayar_keterangan` varchar(45) DEFAULT NULL,
  `rekber_id` int(11) DEFAULT NULL,
  `rekber_nama` varchar(45) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `bank_nama` varchar(45) DEFAULT NULL,
  `kurir_service` varchar(45) DEFAULT NULL,
  `kurir_biaya` int(11) DEFAULT NULL,
  `sampai_dtime` datetime DEFAULT NULL,
  `cancel_dtime` datetime DEFAULT NULL,
  `cancel_alasan` tinytext,
  `cancel_by` int(11) NOT NULL,
  `lama_kiriman` timestamp NULL DEFAULT NULL,
  `kelurahan_id` int(11) NOT NULL,
  `kelurahan_nama` varchar(45) DEFAULT NULL,
  `kecamatan_id` int(11) NOT NULL,
  `kecamatan_nama` varchar(45) DEFAULT NULL,
  `kabupaten_id` int(11) NOT NULL,
  `kabupaten_nama` varchar(45) DEFAULT NULL,
  `propinsi_id` int(11) NOT NULL,
  `propinsi_nama` varchar(45) DEFAULT NULL,
  `laporan` int(11) NOT NULL,
  `orders_id` int(11) NOT NULL,
  `orders_kirim_id` int(11) NOT NULL,
  `orders_sampai_id` int(11) NOT NULL,
  `transaksi_id` int(11) NOT NULL,
  `transaksi_no` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`,`orders_id`,`orders_kirim_id`,`orders_sampai_id`,`transaksi_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table orders_ceking
#

DROP TABLE IF EXISTS `orders_ceking`;
CREATE TABLE `orders_ceking` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_dtime` datetime DEFAULT NULL,
  `sellers_id` int(11) NOT NULL,
  `sellers_nama` varchar(45) DEFAULT NULL,
  `buyer_id` int(11) NOT NULL,
  `buyer_nama` varchar(45) DEFAULT NULL,
  `input_no` varchar(45) DEFAULT NULL,
  `nilai` int(11) NOT NULL,
  `pembayaran` varchar(6) DEFAULT NULL,
  `status` int(11) NOT NULL,
  `trash` int(11) NOT NULL,
  `kurir_id` int(11) NOT NULL,
  `kurir_nama` varchar(45) DEFAULT NULL,
  `kirim_dtime` datetime DEFAULT NULL,
  `bayar_dtime` datetime DEFAULT NULL,
  `bayar_keterangan` varchar(45) DEFAULT NULL,
  `rekber_id` int(11) DEFAULT NULL,
  `rekber_nama` varchar(45) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `bank_nama` varchar(45) DEFAULT NULL,
  `kurir_service` varchar(45) DEFAULT NULL,
  `kurir_biaya` int(11) DEFAULT NULL,
  `sampai_dtime` datetime DEFAULT NULL,
  `cancel_dtime` datetime DEFAULT NULL,
  `cancel_alasan` tinytext,
  `cancel_by` int(11) NOT NULL,
  `lama_kiriman` timestamp NULL DEFAULT NULL,
  `kelurahan_id` int(11) NOT NULL,
  `kelurahan_nama` varchar(45) DEFAULT NULL,
  `kecamatan_id` int(11) NOT NULL,
  `kecamatan_nama` varchar(45) DEFAULT NULL,
  `kabupaten_id` int(11) NOT NULL,
  `kabupaten_nama` varchar(45) DEFAULT NULL,
  `propinsi_id` int(11) NOT NULL,
  `propinsi_nama` varchar(45) DEFAULT NULL,
  `laporan` int(11) NOT NULL,
  `orders_id` int(11) NOT NULL,
  `orders_kirim_id` int(11) NOT NULL,
  `orders_bayar_id` int(11) NOT NULL,
  `orders_sampai_id` int(11) NOT NULL,
  `transaksi_id` int(11) NOT NULL,
  `transaksi_no` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`,`orders_id`,`orders_kirim_id`,`orders_bayar_id`,`orders_sampai_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table orders_data
#

DROP TABLE IF EXISTS `orders_data`;
CREATE TABLE `orders_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL DEFAULT '0',
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(255) DEFAULT NULL,
  `produk_ord_jml` int(11) NOT NULL DEFAULT '0',
  `produk_ord_hrg` int(11) NOT NULL DEFAULT '0',
  `produk_kir_jml` int(11) NOT NULL DEFAULT '0',
  `komisi` int(11) NOT NULL DEFAULT '0',
  `komisi_temp` int(11) NOT NULL DEFAULT '0',
  `hpp` int(11) NOT NULL DEFAULT '0',
  `laba` int(11) NOT NULL DEFAULT '0',
  `transaksi_id` int(11) NOT NULL DEFAULT '0',
  `trash` int(11) NOT NULL DEFAULT '0',
  `mlm_komisi` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=latin1;

#
# Source for table orders_kirim
#

DROP TABLE IF EXISTS `orders_kirim`;
CREATE TABLE `orders_kirim` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_dtime` datetime DEFAULT NULL,
  `sellers_id` int(11) NOT NULL,
  `sellers_nama` varchar(45) DEFAULT NULL,
  `buyer_id` int(11) NOT NULL,
  `buyer_nama` varchar(45) DEFAULT NULL,
  `input_no` varchar(45) DEFAULT NULL,
  `nilai` int(11) NOT NULL,
  `pembayaran` varchar(6) DEFAULT NULL,
  `status` int(11) NOT NULL,
  `trash` int(11) NOT NULL,
  `kurir_id` int(11) NOT NULL,
  `kurir_nama` varchar(45) DEFAULT NULL,
  `kurir_resi` varchar(45) DEFAULT NULL,
  `kirim_dtime` datetime DEFAULT NULL,
  `bayar_dtime` datetime DEFAULT NULL,
  `bayar_keterangan` varchar(45) DEFAULT NULL,
  `rekber_id` int(11) DEFAULT NULL,
  `rekber_nama` varchar(45) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `bank_nama` varchar(45) DEFAULT NULL,
  `kurir_service` varchar(45) DEFAULT NULL,
  `kurir_biaya` int(11) DEFAULT NULL,
  `sampai_dtime` datetime DEFAULT NULL,
  `cancel_dtime` datetime DEFAULT NULL,
  `cancel_alasan` tinytext,
  `cancel_by` int(11) NOT NULL,
  `lama_kiriman` timestamp NULL DEFAULT NULL,
  `kelurahan_id` int(11) NOT NULL,
  `kelurahan_nama` varchar(45) DEFAULT NULL,
  `kecamatan_id` int(11) NOT NULL,
  `kecamatan_nama` varchar(45) DEFAULT NULL,
  `kabupaten_id` int(11) NOT NULL,
  `kabupaten_nama` varchar(45) DEFAULT NULL,
  `propinsi_id` int(11) NOT NULL,
  `propinsi_nama` varchar(45) DEFAULT NULL,
  `laporan` int(11) NOT NULL,
  `orders_id` int(11) NOT NULL,
  `orders_bayar_id` int(11) NOT NULL,
  PRIMARY KEY (`id`,`orders_bayar_id`,`orders_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table orders_online
#

DROP TABLE IF EXISTS `orders_online`;
CREATE TABLE `orders_online` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_dtime` datetime DEFAULT NULL,
  `sellers_id` int(11) NOT NULL,
  `sellers_nama` varchar(45) DEFAULT NULL,
  `buyer_id` int(11) NOT NULL,
  `buyer_nama` varchar(45) DEFAULT NULL,
  `input_no` varchar(45) DEFAULT NULL,
  `nilai` int(11) NOT NULL,
  `pembayaran` varchar(6) DEFAULT NULL,
  `status` int(11) NOT NULL,
  `trash` int(11) NOT NULL,
  `kurir_id` int(11) NOT NULL,
  `kurir_nama` varchar(45) DEFAULT NULL,
  `kirim_dtime` datetime DEFAULT NULL,
  `bayar_dtime` datetime DEFAULT NULL,
  `bayar_keterangan` varchar(45) DEFAULT NULL,
  `rekber_id` int(11) DEFAULT NULL,
  `rekber_nama` varchar(45) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `bank_nama` varchar(45) DEFAULT NULL,
  `kurir_service` varchar(45) DEFAULT NULL,
  `kurir_biaya` int(11) DEFAULT NULL,
  `sampai_dtime` datetime DEFAULT NULL,
  `cancel_dtime` datetime DEFAULT NULL,
  `cancel_alasan` tinytext,
  `cancel_by` int(11) NOT NULL,
  `lama_kiriman` timestamp NULL DEFAULT NULL,
  `kelurahan_id` int(11) NOT NULL,
  `kelurahan_nama` varchar(45) DEFAULT NULL,
  `kecamatan_id` int(11) NOT NULL,
  `kecamatan_nama` varchar(45) DEFAULT NULL,
  `kabupaten_id` int(11) NOT NULL,
  `kabupaten_nama` varchar(45) DEFAULT NULL,
  `propinsi_id` int(11) NOT NULL,
  `propinsi_nama` varchar(45) DEFAULT NULL,
  `laporan` int(11) NOT NULL,
  `orders_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table orders_sampai
#

DROP TABLE IF EXISTS `orders_sampai`;
CREATE TABLE `orders_sampai` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_dtime` datetime DEFAULT NULL,
  `sellers_id` int(11) NOT NULL,
  `sellers_nama` varchar(45) DEFAULT NULL,
  `buyer_id` int(11) NOT NULL,
  `buyer_nama` varchar(45) DEFAULT NULL,
  `input_no` varchar(45) DEFAULT NULL,
  `nilai` int(11) NOT NULL,
  `pembayaran` varchar(6) DEFAULT NULL,
  `status` int(11) NOT NULL,
  `trash` int(11) NOT NULL,
  `kurir_id` int(11) NOT NULL,
  `kurir_nama` varchar(45) DEFAULT NULL,
  `kirim_dtime` datetime DEFAULT NULL,
  `bayar_dtime` datetime DEFAULT NULL,
  `bayar_keterangan` varchar(45) DEFAULT NULL,
  `rekber_id` int(11) DEFAULT NULL,
  `rekber_nama` varchar(45) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `bank_nama` varchar(45) DEFAULT NULL,
  `kurir_service` varchar(45) DEFAULT NULL,
  `kurir_biaya` int(11) DEFAULT NULL,
  `sampai_dtime` datetime DEFAULT NULL,
  `cancel_dtime` datetime DEFAULT NULL,
  `cancel_alasan` tinytext,
  `cancel_by` int(11) NOT NULL,
  `lama_kiriman` timestamp NULL DEFAULT NULL,
  `kelurahan_id` int(11) NOT NULL,
  `kelurahan_nama` varchar(45) DEFAULT NULL,
  `kecamatan_id` int(11) NOT NULL,
  `kecamatan_nama` varchar(45) DEFAULT NULL,
  `kabupaten_id` int(11) NOT NULL,
  `kabupaten_nama` varchar(45) DEFAULT NULL,
  `propinsi_id` int(11) NOT NULL,
  `propinsi_nama` varchar(45) DEFAULT NULL,
  `laporan` int(11) NOT NULL,
  `orders_id` int(11) NOT NULL,
  `orders_kirim_id` int(11) NOT NULL,
  `orders_bayar_id` int(11) NOT NULL,
  PRIMARY KEY (`id`,`orders_id`,`orders_kirim_id`,`orders_bayar_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table orders_selesai
#

DROP TABLE IF EXISTS `orders_selesai`;
CREATE TABLE `orders_selesai` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_dtime` datetime DEFAULT NULL,
  `sellers_id` int(11) NOT NULL,
  `sellers_nama` varchar(45) DEFAULT NULL,
  `buyer_id` int(11) NOT NULL,
  `buyer_nama` varchar(45) DEFAULT NULL,
  `input_no` varchar(45) DEFAULT NULL,
  `nilai` int(11) NOT NULL,
  `pembayaran` varchar(6) DEFAULT NULL,
  `status` int(11) NOT NULL,
  `trash` int(11) NOT NULL,
  `kurir_id` int(11) NOT NULL,
  `kurir_nama` varchar(45) DEFAULT NULL,
  `kirim_dtime` datetime DEFAULT NULL,
  `bayar_dtime` datetime DEFAULT NULL,
  `bayar_keterangan` varchar(45) DEFAULT NULL,
  `rekber_id` int(11) DEFAULT NULL,
  `rekber_nama` varchar(45) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `bank_nama` varchar(45) DEFAULT NULL,
  `kurir_service` varchar(45) DEFAULT NULL,
  `kurir_biaya` int(11) DEFAULT NULL,
  `sampai_dtime` datetime DEFAULT NULL,
  `cancel_dtime` datetime DEFAULT NULL,
  `cancel_alasan` tinytext,
  `cancel_by` int(11) NOT NULL,
  `lama_kiriman` timestamp NULL DEFAULT NULL,
  `kelurahan_id` int(11) NOT NULL,
  `kelurahan_nama` varchar(45) DEFAULT NULL,
  `kecamatan_id` int(11) NOT NULL,
  `kecamatan_nama` varchar(45) DEFAULT NULL,
  `kabupaten_id` int(11) NOT NULL,
  `kabupaten_nama` varchar(45) DEFAULT NULL,
  `propinsi_id` int(11) NOT NULL,
  `propinsi_nama` varchar(45) DEFAULT NULL,
  `laporan` int(11) NOT NULL,
  `orders_id` int(11) NOT NULL,
  `orders_kirim_id` int(11) NOT NULL,
  `orders_bayar_id` int(11) NOT NULL,
  `orders_sampai_id` int(11) NOT NULL,
  `transaksi_id` int(11) NOT NULL,
  `transaksi_no` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`,`orders_id`,`orders_kirim_id`,`orders_bayar_id`,`orders_sampai_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table orders_status
#

DROP TABLE IF EXISTS `orders_status`;
CREATE TABLE `orders_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL DEFAULT '0',
  `dtime` datetime DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '0',
  `anggota_id` int(11) NOT NULL DEFAULT '0',
  `alasan` tinytext,
  `umur` int(11) NOT NULL DEFAULT '0',
  `transaksi_id` int(11) NOT NULL DEFAULT '0',
  `author` int(11) NOT NULL DEFAULT '0',
  `r_komisi` tinyint(1) NOT NULL DEFAULT '0',
  `r_test` tinyint(1) NOT NULL DEFAULT '0',
  `r_ord` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=112 DEFAULT CHARSET=latin1;

#
# Source for table packing
#

DROP TABLE IF EXISTS `packing`;
CREATE TABLE `packing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `anggota_id` int(11) NOT NULL DEFAULT '0',
  `dtime_request` datetime DEFAULT NULL,
  `jumlah` int(1) NOT NULL DEFAULT '0',
  `status` int(2) NOT NULL DEFAULT '0',
  `dtime_approve` datetime DEFAULT NULL,
  `author` int(11) NOT NULL DEFAULT '0',
  `counter` varchar(255) DEFAULT NULL,
  `n_email` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table packing_data
#

DROP TABLE IF EXISTS `packing_data`;
CREATE TABLE `packing_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `packing_mutasi_id` int(11) NOT NULL DEFAULT '0',
  `packing_id` int(11) NOT NULL DEFAULT '0',
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `jumlah` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table packing_mutasi
#

DROP TABLE IF EXISTS `packing_mutasi`;
CREATE TABLE `packing_mutasi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `anggota_id` int(11) NOT NULL DEFAULT '0',
  `st_before` int(11) NOT NULL DEFAULT '0',
  `st_in` int(11) NOT NULL DEFAULT '0',
  `st_ot` int(11) NOT NULL DEFAULT '0',
  `st_after` int(11) NOT NULL DEFAULT '0',
  `dtime` datetime DEFAULT NULL,
  `packing_id` varchar(11) DEFAULT '0',
  `packing_no` varchar(255) NOT NULL DEFAULT '',
  `transaksi_id` int(11) NOT NULL DEFAULT '0',
  `transaksi_no` varchar(255) DEFAULT NULL,
  `keterangan` tinytext,
  `author` int(11) NOT NULL DEFAULT '0',
  `orders_id` int(11) NOT NULL DEFAULT '0',
  `orders_no` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=282 DEFAULT CHARSET=latin1;

#
# Source for table pages
#

DROP TABLE IF EXISTS `pages`;
CREATE TABLE `pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status` int(11) NOT NULL,
  `jenis` varchar(32) DEFAULT NULL,
  `nama` varchar(255) DEFAULT NULL,
  `isi` text,
  `oleh` int(11) NOT NULL DEFAULT '0',
  `isiS` text,
  `title` varchar(255) DEFAULT NULL,
  `dtime` datetime DEFAULT NULL,
  `kategori` varchar(32) DEFAULT NULL,
  `trash` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

#
# Source for table penjualan_cache
#

DROP TABLE IF EXISTS `penjualan_cache`;
CREATE TABLE `penjualan_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `anggota_id` int(11) NOT NULL DEFAULT '0',
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `jml_stock_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_stock_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_stock_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_transaksi_in` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_ot` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_af` int(11) NOT NULL DEFAULT '0',
  `dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `labels` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table penjualan_netto_bl
#

DROP TABLE IF EXISTS `penjualan_netto_bl`;
CREATE TABLE `penjualan_netto_bl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `jml_stock_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_stock_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_stock_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_stock_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_transaksi_be` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_in` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_ot` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_af` int(11) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table penjualan_netto_co
#

DROP TABLE IF EXISTS `penjualan_netto_co`;
CREATE TABLE `penjualan_netto_co` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(250) NOT NULL DEFAULT '0',
  `seller_id` int(11) NOT NULL DEFAULT '0',
  `seller_nama` varchar(250) NOT NULL DEFAULT '0',
  `jml_stock_be` int(14) NOT NULL DEFAULT '0',
  `jml_stock_in` int(11) NOT NULL DEFAULT '0',
  `jml_stock_ot` int(11) NOT NULL DEFAULT '0',
  `jml_stock_af` int(10) NOT NULL DEFAULT '0',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_transaksi_be` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_in` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_ot` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_af` int(11) NOT NULL DEFAULT '0',
  `orders_id` int(11) NOT NULL DEFAULT '0',
  `transaksi_id` int(11) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table penjualan_netto_hr
#

DROP TABLE IF EXISTS `penjualan_netto_hr`;
CREATE TABLE `penjualan_netto_hr` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `jml_stock_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_stock_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_stock_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_stock_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `last_dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table penjualan_netto_produk_bl
#

DROP TABLE IF EXISTS `penjualan_netto_produk_bl`;
CREATE TABLE `penjualan_netto_produk_bl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(250) DEFAULT '0',
  `jml_stock_be` int(11) NOT NULL DEFAULT '0',
  `jml_stock_in` int(11) NOT NULL DEFAULT '0',
  `jml_stock_ot` int(11) NOT NULL DEFAULT '0',
  `jml_stock_af` int(11) NOT NULL DEFAULT '0',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_transaksi_be` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_in` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_ot` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_af` int(11) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `bl_x` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table penjualan_netto_produk_seller_bl
#

DROP TABLE IF EXISTS `penjualan_netto_produk_seller_bl`;
CREATE TABLE `penjualan_netto_produk_seller_bl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(250) DEFAULT '0',
  `seller_id` int(11) NOT NULL DEFAULT '0',
  `seller_nama` varchar(250) DEFAULT '0',
  `jml_stock_be` int(11) NOT NULL DEFAULT '0',
  `jml_stock_in` int(11) NOT NULL DEFAULT '0',
  `jml_stock_ot` int(11) NOT NULL DEFAULT '0',
  `jml_stock_af` int(11) NOT NULL DEFAULT '0',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_transaksi_be` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_in` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_ot` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_af` int(11) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table penjualan_netto_seller_bl
#

DROP TABLE IF EXISTS `penjualan_netto_seller_bl`;
CREATE TABLE `penjualan_netto_seller_bl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `seller_id` int(11) NOT NULL DEFAULT '0',
  `seller_nama` varchar(250) DEFAULT '0',
  `jml_stock_be` int(11) NOT NULL DEFAULT '0',
  `jml_stock_in` int(11) NOT NULL DEFAULT '0',
  `jml_stock_ot` int(11) NOT NULL DEFAULT '0',
  `jml_stock_af` int(11) NOT NULL DEFAULT '0',
  `jml_komisi_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_komisi_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_transaksi_be` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_in` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_ot` int(11) NOT NULL DEFAULT '0',
  `jml_transaksi_af` int(11) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `bulan` tinyint(2) NOT NULL DEFAULT '0',
  `tahun` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `bl_x` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table per_customers
#

DROP TABLE IF EXISTS `per_customers`;
CREATE TABLE `per_customers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama_login` varchar(45) DEFAULT NULL,
  `nama` varchar(45) DEFAULT NULL,
  `nama_depan` varchar(45) DEFAULT NULL,
  `nama_belakang` varchar(45) DEFAULT NULL,
  `email` varchar(45) DEFAULT NULL,
  `tlp_1` varchar(45) DEFAULT NULL,
  `tlp_2` varchar(45) DEFAULT NULL,
  `pin_bb` varchar(10) DEFAULT NULL,
  `alamat_1` varchar(50) DEFAULT NULL,
  `alamat_2` varchar(50) DEFAULT NULL,
  `rt` varchar(45) DEFAULT NULL,
  `rw` varchar(45) DEFAULT NULL,
  `kelurahan` varchar(45) DEFAULT NULL,
  `kecamatan` varchar(45) DEFAULT NULL,
  `kabupaten` varchar(45) DEFAULT NULL,
  `propinsi` varchar(45) DEFAULT NULL,
  `kodepos` varchar(45) DEFAULT NULL,
  `password` varchar(32) DEFAULT NULL,
  `pwd_default` int(1) NOT NULL DEFAULT '1',
  `dtime_in` datetime DEFAULT NULL,
  `last_dtime` datetime DEFAULT NULL,
  `php_session` varchar(45) DEFAULT NULL,
  `access_jml` int(11) NOT NULL,
  `access_groups` varchar(45) DEFAULT NULL,
  `access_level` varchar(45) DEFAULT NULL,
  `kelamin` varchar(45) DEFAULT NULL,
  `dtime` datetime DEFAULT NULL,
  `mid` varchar(45) DEFAULT NULL,
  `transfer_kode` varchar(45) DEFAULT NULL,
  `packing_limit` int(11) NOT NULL,
  `packing_temp` int(11) NOT NULL,
  `packing` int(11) NOT NULL,
  `avatars` int(11) NOT NULL,
  `parent` int(11) NOT NULL,
  `childs` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `trash` int(11) NOT NULL,
  `seller_id` int(11) NOT NULL,
  `login_fail` int(11) NOT NULL,
  `phpsessid` varchar(45) DEFAULT NULL,
  `no_rekening` varchar(45) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `jenis` varchar(10) DEFAULT NULL,
  `id_jenis` int(11) DEFAULT NULL,
  `no_ktp` varchar(50) DEFAULT NULL,
  `foto_ktp` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

#
# Source for table per_employee
#

DROP TABLE IF EXISTS `per_employee`;
CREATE TABLE `per_employee` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama_login` varchar(45) DEFAULT NULL,
  `nama` varchar(45) DEFAULT NULL,
  `nama_depan` varchar(45) DEFAULT NULL,
  `nama_belakang` varchar(45) DEFAULT NULL,
  `email` varchar(45) DEFAULT NULL,
  `tlp_1` varchar(45) DEFAULT NULL,
  `tlp_2` varchar(45) DEFAULT NULL,
  `pin_bb` varchar(10) DEFAULT NULL,
  `rt` varchar(45) DEFAULT NULL,
  `rw` varchar(45) DEFAULT NULL,
  `kelurahan` varchar(45) DEFAULT NULL,
  `kecamatan` varchar(45) DEFAULT NULL,
  `kabupaten` varchar(45) DEFAULT NULL,
  `propinsi` varchar(45) DEFAULT NULL,
  `kode_pos` varchar(45) DEFAULT NULL,
  `password` varchar(32) DEFAULT NULL,
  `pwd_default` varchar(32) DEFAULT NULL,
  `dtime_in` datetime DEFAULT NULL,
  `last_dtime` datetime DEFAULT NULL,
  `php_session` varchar(45) DEFAULT NULL,
  `access_jml` int(11) NOT NULL,
  `access_groups` varchar(45) DEFAULT NULL,
  `access_level` varchar(45) DEFAULT NULL,
  `kelamin` varchar(45) DEFAULT NULL,
  `dtime` datetime DEFAULT NULL,
  `mid` varchar(45) DEFAULT NULL,
  `transfer_kode` varchar(45) DEFAULT NULL,
  `packing_limit` int(11) NOT NULL,
  `packing_temp` int(11) NOT NULL,
  `packing` int(11) NOT NULL,
  `avatars` varchar(50) NOT NULL,
  `parent` int(11) NOT NULL,
  `parent_2` varchar(255) DEFAULT NULL,
  `childs` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `trash` int(11) NOT NULL,
  `login_fail` int(11) NOT NULL,
  `phpsessid` varchar(45) DEFAULT NULL,
  `no_rekening` varchar(45) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `jenis` varchar(32) DEFAULT NULL,
  `id_jenis` int(11) DEFAULT NULL,
  `no_ktp` varchar(50) DEFAULT NULL,
  `foto_ktp` varchar(50) DEFAULT NULL,
  `gender` varchar(50) DEFAULT NULL,
  `jatuh_tempo` int(11) NOT NULL DEFAULT '0' COMMENT 'dalam detik',
  `def_pembayaran` tinytext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=latin1;

#
# Source for table per_employee_detail
#

DROP TABLE IF EXISTS `per_employee_detail`;
CREATE TABLE `per_employee_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `per_employee_id` int(11) NOT NULL,
  `fields` varchar(45) DEFAULT NULL,
  `values` varchar(45) DEFAULT NULL,
  `nilai` varchar(45) DEFAULT NULL,
  `dtime` datetime DEFAULT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table per_links
#

DROP TABLE IF EXISTS `per_links`;
CREATE TABLE `per_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `per_employee_id` int(11) NOT NULL DEFAULT '0',
  `web` varchar(255) DEFAULT NULL,
  `web_link` varchar(255) DEFAULT NULL,
  `dtime_last` datetime DEFAULT NULL,
  `umur` smallint(6) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table per_registrasi
#

DROP TABLE IF EXISTS `per_registrasi`;
CREATE TABLE `per_registrasi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `tlp` varchar(255) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `reg_code` varchar(255) DEFAULT NULL,
  `link_verifikasi` mediumtext NOT NULL,
  `dtime` datetime DEFAULT NULL,
  `ipadd` varchar(255) DEFAULT NULL,
  `access_groups` varchar(255) NOT NULL DEFAULT '',
  `jenis` varchar(255) NOT NULL DEFAULT '',
  `upline_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

#
# Source for table produk
#

DROP TABLE IF EXISTS `produk`;
CREATE TABLE `produk` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kode` varchar(255) DEFAULT NULL,
  `nama` varchar(255) DEFAULT NULL,
  `nic` varchar(255) DEFAULT NULL,
  `deskripsi` text,
  `deskripsi_pendek` tinytext,
  `author_id` int(11) NOT NULL DEFAULT '0',
  `author_nama` varchar(32) DEFAULT NULL,
  `seo_title` varchar(255) DEFAULT NULL,
  `seo_deskripsi` tinytext,
  `promo` tinyint(3) DEFAULT '0',
  `promo_harga` int(11) NOT NULL DEFAULT '0',
  `promo_start_tgl` date DEFAULT NULL,
  `promo_stop_tgl` date DEFAULT NULL,
  `kategori_1` tinyint(3) NOT NULL DEFAULT '0',
  `kategori_2` tinyint(3) NOT NULL DEFAULT '0',
  `kategori_3` tinyint(3) NOT NULL DEFAULT '0',
  `jml_stok` int(11) NOT NULL DEFAULT '0',
  `jml_stok_limit` int(11) NOT NULL DEFAULT '0',
  `jml_stok_packing` int(11) NOT NULL DEFAULT '0',
  `jml_stok_req_packing` int(11) NOT NULL DEFAULT '0',
  `jml_stok_stb` int(11) NOT NULL DEFAULT '0',
  `jml_stok_out` int(11) NOT NULL DEFAULT '0',
  `merk_id` int(11) NOT NULL DEFAULT '0',
  `merk_nama` varchar(32) DEFAULT NULL,
  `distributor_id` int(11) NOT NULL DEFAULT '0',
  `distributor_nama` int(11) NOT NULL DEFAULT '0',
  `hit_order` int(11) NOT NULL DEFAULT '0',
  `hit_views` int(11) NOT NULL DEFAULT '0',
  `berat` int(11) NOT NULL DEFAULT '0',
  `berat_real` smallint(4) NOT NULL DEFAULT '0',
  `status` tinyint(3) DEFAULT '0',
  `trash` tinyint(3) NOT NULL DEFAULT '0',
  `dtime_masuk` datetime DEFAULT NULL,
  `dtime_aktif` datetime DEFAULT NULL,
  `dtime_non_aktif` datetime DEFAULT NULL,
  `dtime_update` datetime DEFAULT NULL,
  `dtime_stok_kosong` datetime DEFAULT NULL,
  `dtime_stok_limit` datetime DEFAULT NULL,
  `harga` decimal(10,2) NOT NULL DEFAULT '0.00',
  `hpp` decimal(10,2) NOT NULL DEFAULT '0.00',
  `komisi` decimal(10,2) NOT NULL DEFAULT '0.00',
  `laba` decimal(10,2) NOT NULL DEFAULT '0.00',
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `n_email` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=300 DEFAULT CHARSET=latin1;

#
# Source for table rek_hpp
#

DROP TABLE IF EXISTS `rek_hpp`;
CREATE TABLE `rek_hpp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ks_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_after` decimal(14,2) NOT NULL DEFAULT '0.00',
  `dtime` datetime DEFAULT NULL,
  `transaksi_id` int(11) NOT NULL DEFAULT '0',
  `transaksi_no` varchar(255) DEFAULT NULL,
  `keterangan` tinytext,
  `author` int(11) NOT NULL DEFAULT '0',
  `jenis` varchar(255) NOT NULL DEFAULT '',
  `pembayaran` varchar(255) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table rek_hpp_cache
#

DROP TABLE IF EXISTS `rek_hpp_cache`;
CREATE TABLE `rek_hpp_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `jmlPembPiutang` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jmlPembHutang` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jmlRusak` int(11) NOT NULL DEFAULT '0',
  `jmlPerbaikan` int(11) NOT NULL DEFAULT '0',
  `jmlPenjualan` int(11) NOT NULL DEFAULT '0',
  `jmlReturnPenjualan` int(11) NOT NULL DEFAULT '0',
  `jmlTambah` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jmlKurang` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml` decimal(14,2) DEFAULT NULL,
  `tgl` varchar(2) DEFAULT NULL,
  `bln` varchar(2) DEFAULT NULL,
  `thn` varchar(2) DEFAULT NULL,
  `dtime` datetime DEFAULT NULL,
  `pembayaran` tinytext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table rek_penjualan
#

DROP TABLE IF EXISTS `rek_penjualan`;
CREATE TABLE `rek_penjualan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ks_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_after` decimal(14,2) NOT NULL DEFAULT '0.00',
  `dtime` datetime DEFAULT NULL,
  `transaksi_id` int(11) NOT NULL DEFAULT '0',
  `transaksi_no` varchar(255) DEFAULT NULL,
  `keterangan` tinytext,
  `author` int(11) NOT NULL DEFAULT '0',
  `jenis` varchar(255) NOT NULL DEFAULT '',
  `pembayaran` varchar(255) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table rek_penjualan_cache
#

DROP TABLE IF EXISTS `rek_penjualan_cache`;
CREATE TABLE `rek_penjualan_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `jmlPembPiutang` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jmlPembHutang` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jmlRusak` int(11) NOT NULL DEFAULT '0',
  `jmlPerbaikan` int(11) NOT NULL DEFAULT '0',
  `jmlPenjualan` int(11) NOT NULL DEFAULT '0',
  `jmlReturnPenjualan` int(11) NOT NULL DEFAULT '0',
  `jmlTambah` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jmlKurang` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml` decimal(14,2) DEFAULT NULL,
  `tgl` varchar(2) DEFAULT NULL,
  `bln` varchar(2) DEFAULT NULL,
  `thn` varchar(2) DEFAULT NULL,
  `dtime` datetime DEFAULT NULL,
  `pembayaran` tinytext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table rek_return_pembelian
#

DROP TABLE IF EXISTS `rek_return_pembelian`;
CREATE TABLE `rek_return_pembelian` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ks_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_after` decimal(14,2) NOT NULL DEFAULT '0.00',
  `dtime` datetime DEFAULT NULL,
  `transaksi_id` int(11) NOT NULL DEFAULT '0',
  `transaksi_no` varchar(255) DEFAULT NULL,
  `keterangan` tinytext,
  `author` int(11) NOT NULL DEFAULT '0',
  `jenis` varchar(255) NOT NULL DEFAULT '',
  `pembayaran` varchar(255) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table rek_return_pembelian_cache
#

DROP TABLE IF EXISTS `rek_return_pembelian_cache`;
CREATE TABLE `rek_return_pembelian_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `jmlPembPiutang` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jmlPembHutang` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jmlRusak` int(11) NOT NULL DEFAULT '0',
  `jmlPerbaikan` int(11) NOT NULL DEFAULT '0',
  `jmlPenjualan` int(11) NOT NULL DEFAULT '0',
  `jmlReturnPenjualan` int(11) NOT NULL DEFAULT '0',
  `jmlTambah` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jmlKurang` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml` decimal(14,2) DEFAULT NULL,
  `tgl` varchar(2) DEFAULT NULL,
  `bln` varchar(2) DEFAULT NULL,
  `thn` varchar(2) DEFAULT NULL,
  `dtime` datetime DEFAULT NULL,
  `pembayaran` tinytext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table rek_return_penjualan
#

DROP TABLE IF EXISTS `rek_return_penjualan`;
CREATE TABLE `rek_return_penjualan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ks_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `ks_after` decimal(14,2) NOT NULL DEFAULT '0.00',
  `dtime` datetime DEFAULT NULL,
  `transaksi_id` int(11) NOT NULL DEFAULT '0',
  `transaksi_no` varchar(255) DEFAULT NULL,
  `keterangan` tinytext,
  `author` int(11) NOT NULL DEFAULT '0',
  `jenis` varchar(255) NOT NULL DEFAULT '',
  `pembayaran` varchar(255) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table rek_return_penjualan_cache
#

DROP TABLE IF EXISTS `rek_return_penjualan_cache`;
CREATE TABLE `rek_return_penjualan_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `jmlPembPiutang` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jmlPembHutang` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jmlRusak` int(11) NOT NULL DEFAULT '0',
  `jmlPerbaikan` int(11) NOT NULL DEFAULT '0',
  `jmlPenjualan` int(11) NOT NULL DEFAULT '0',
  `jmlReturnPenjualan` int(11) NOT NULL DEFAULT '0',
  `jmlTambah` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jmlKurang` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml` decimal(14,2) DEFAULT NULL,
  `tgl` varchar(2) DEFAULT NULL,
  `bln` varchar(2) DEFAULT NULL,
  `thn` varchar(2) DEFAULT NULL,
  `dtime` datetime DEFAULT NULL,
  `pembayaran` tinytext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table scheduler
#

DROP TABLE IF EXISTS `scheduler`;
CREATE TABLE `scheduler` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `dtime_Y` smallint(4) DEFAULT NULL,
  `dtime_n` tinyint(2) DEFAULT NULL,
  `dtime_d` smallint(2) DEFAULT NULL,
  `dtime_H` tinyint(2) DEFAULT NULL,
  `dtime_i` tinyint(2) DEFAULT NULL,
  `dtime_s` tinyint(2) DEFAULT NULL,
  `fungsi` varchar(255) DEFAULT NULL,
  `jenis` varchar(255) DEFAULT NULL,
  `nilai_1` varchar(255) DEFAULT NULL,
  `nilai_2` varchar(255) DEFAULT '',
  `target` varchar(255) DEFAULT NULL,
  `nama` varchar(255) DEFAULT NULL,
  `keterangan` tinytext,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `author` int(11) NOT NULL DEFAULT '0',
  `trash` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

#
# Source for table settings
#

DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `jenis` varchar(255) DEFAULT NULL,
  `untuk` varchar(255) DEFAULT NULL,
  `nilai` varchar(255) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `trash` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=latin1;

#
# Source for table slider
#

DROP TABLE IF EXISTS `slider`;
CREATE TABLE `slider` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama_file` varchar(255) DEFAULT NULL,
  `alt_text` varchar(255) DEFAULT NULL,
  `dimensi` varchar(255) DEFAULT NULL,
  `author` int(11) NOT NULL DEFAULT '0',
  `dtime` datetime DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `trash` int(11) NOT NULL DEFAULT '0',
  `produk_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

#
# Source for table stock
#

DROP TABLE IF EXISTS `stock`;
CREATE TABLE `stock` (
  `st_id` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date DEFAULT NULL,
  `st_type` varchar(12) DEFAULT NULL,
  `st_item` int(11) NOT NULL,
  `st_supplier` int(11) DEFAULT NULL,
  `st_alias` varchar(255) NOT NULL,
  `st_client` int(11) NOT NULL,
  `st_clientgroup` int(11) NOT NULL,
  `st_tgl` varchar(2) NOT NULL,
  `st_bln` varchar(2) NOT NULL,
  `st_thn` varchar(4) NOT NULL,
  `st_jam` varchar(8) NOT NULL,
  `st_by` varchar(64) NOT NULL,
  `st_before` int(11) NOT NULL,
  `st_io` int(11) NOT NULL,
  `st_oi` int(11) NOT NULL DEFAULT '0',
  `st_after` int(11) NOT NULL,
  `st_harga` decimal(10,2) NOT NULL DEFAULT '0.00',
  `st_hpp` decimal(10,2) NOT NULL DEFAULT '0.00',
  `st_komisi` decimal(10,2) NOT NULL DEFAULT '0.00',
  `st_laba` decimal(10,2) NOT NULL DEFAULT '0.00',
  `st_commonafter` int(11) NOT NULL,
  `st_desc` text NOT NULL,
  `nota` varchar(255) NOT NULL,
  `localID` varchar(128) NOT NULL,
  `trID` int(11) DEFAULT NULL,
  `eventID` int(11) DEFAULT NULL,
  `session` varchar(255) NOT NULL,
  `r_stock` tinyint(1) NOT NULL DEFAULT '0',
  `c_stock` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`st_id`),
  KEY `primary_key` (`st_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table stock_bl
#

DROP TABLE IF EXISTS `stock_bl`;
CREATE TABLE `stock_bl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date DEFAULT NULL,
  `bulan` int(11) NOT NULL DEFAULT '0',
  `tahun` int(11) NOT NULL DEFAULT '0',
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(255) DEFAULT NULL,
  `stock_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `stock_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `stock_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `stock_after` decimal(14,2) NOT NULL DEFAULT '0.00',
  `komisi_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `komisi_after` decimal(14,2) NOT NULL DEFAULT '0.00',
  `omset_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `omset_in` decimal(14,2) DEFAULT '0.00',
  `omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `omset_after` decimal(12,2) NOT NULL DEFAULT '0.00',
  `omset_hpp_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `omset_hpp_in` decimal(14,2) DEFAULT '0.00',
  `omset_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `omset_hpp_after` decimal(12,2) NOT NULL DEFAULT '0.00',
  `status` int(11) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `r_stock` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table stock_cache
#

DROP TABLE IF EXISTS `stock_cache`;
CREATE TABLE `stock_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `companyID` int(11) DEFAULT NULL,
  `outletID` int(11) DEFAULT NULL,
  `suppID` int(11) DEFAULT NULL,
  `itemID` int(11) DEFAULT NULL,
  `jmlInput` int(11) NOT NULL DEFAULT '0',
  `jmlReturnPembelian` int(11) NOT NULL DEFAULT '0',
  `jmlRusak` int(11) NOT NULL DEFAULT '0',
  `jmlPerbaikan` int(11) NOT NULL DEFAULT '0',
  `jmlPenjualan` int(11) NOT NULL DEFAULT '0',
  `jmlReturnPenjualan` int(11) NOT NULL DEFAULT '0',
  `jmlTambah` int(11) NOT NULL DEFAULT '0',
  `jmlKurang` int(11) NOT NULL DEFAULT '0',
  `jml` int(11) DEFAULT NULL,
  `jmlAll` int(11) DEFAULT NULL,
  `tgl` varchar(2) DEFAULT NULL,
  `bln` varchar(2) DEFAULT NULL,
  `thn` varchar(4) DEFAULT NULL,
  `description` text,
  `dtime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table stock_cache_hr_bl
#

DROP TABLE IF EXISTS `stock_cache_hr_bl`;
CREATE TABLE `stock_cache_hr_bl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `jml_stock` decimal(14,2) DEFAULT NULL,
  `jml_komisi` decimal(14,2) DEFAULT NULL,
  `jml_omset` decimal(14,2) DEFAULT NULL,
  `jml_hpp_omset` decimal(14,2) DEFAULT NULL,
  `dtime` datetime DEFAULT NULL,
  `last_dtime` datetime DEFAULT NULL,
  `pembayaran` tinytext NOT NULL,
  `labels` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table stock_common
#

DROP TABLE IF EXISTS `stock_common`;
CREATE TABLE `stock_common` (
  `stc_id` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date DEFAULT NULL,
  `stc_item` int(11) NOT NULL,
  `stc_supplier` int(11) DEFAULT NULL,
  `stc_alias` varchar(255) NOT NULL,
  `stc_client` int(11) NOT NULL,
  `stc_clientgroup` int(11) NOT NULL,
  `stc_tgl` varchar(2) NOT NULL,
  `stc_bln` varchar(2) NOT NULL,
  `stc_thn` varchar(4) NOT NULL,
  `stc_jam` varchar(8) NOT NULL,
  `stc_by` varchar(64) NOT NULL,
  `stc_before` int(11) NOT NULL,
  `stc_io` int(11) NOT NULL,
  `stc_after` int(11) NOT NULL,
  `stc_desc` text NOT NULL,
  `nota` varchar(255) NOT NULL,
  `localID` varchar(128) NOT NULL,
  `trID` int(11) DEFAULT NULL,
  `eventID` int(11) DEFAULT NULL,
  `session` varchar(255) NOT NULL,
  PRIMARY KEY (`stc_id`),
  KEY `primary_key` (`stc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table stock_hr
#

DROP TABLE IF EXISTS `stock_hr`;
CREATE TABLE `stock_hr` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date DEFAULT NULL,
  `bulan` int(11) NOT NULL DEFAULT '0',
  `tahun` int(11) NOT NULL DEFAULT '0',
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(255) DEFAULT NULL,
  `stock_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `stock_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `stock_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `stock_after` decimal(14,2) NOT NULL DEFAULT '0.00',
  `komisi_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `komisi_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `komisi_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `komisi_after` decimal(14,2) NOT NULL DEFAULT '0.00',
  `omset_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `omset_in` decimal(14,2) DEFAULT '0.00',
  `omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `omset_after` decimal(12,2) NOT NULL DEFAULT '0.00',
  `omset_hpp_before` decimal(14,2) NOT NULL DEFAULT '0.00',
  `omset_hpp_in` decimal(14,2) DEFAULT '0.00',
  `omset_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `omset_hpp_after` decimal(12,2) NOT NULL DEFAULT '0.00',
  `status` int(11) NOT NULL DEFAULT '0',
  `last_dtime` datetime DEFAULT NULL,
  `r_stock` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table stock_nilai
#

DROP TABLE IF EXISTS `stock_nilai`;
CREATE TABLE `stock_nilai` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dtime` datetime DEFAULT NULL,
  `produk_id` int(11) NOT NULL DEFAULT '0',
  `produk_nama` varchar(250) DEFAULT '0',
  `jml_stock_be` int(11) NOT NULL DEFAULT '0',
  `jml_stock_in` int(11) NOT NULL DEFAULT '0',
  `jml_stock_ot` int(11) NOT NULL DEFAULT '0',
  `jml_stock_af` int(11) NOT NULL DEFAULT '0',
  `on_komisi` decimal(14,2) NOT NULL DEFAULT '0.00',
  `on_harga` decimal(14,2) NOT NULL DEFAULT '0.00',
  `on_hpp` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_omset_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_be` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_in` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_ot` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml_hpp_af` decimal(14,2) NOT NULL DEFAULT '0.00',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `transaksi_id` int(11) NOT NULL DEFAULT '0',
  `transaksi_no` varchar(250) DEFAULT '0',
  `transaksi_jenis` int(11) NOT NULL DEFAULT '0',
  `stock_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table stock_nilai_cache
#

DROP TABLE IF EXISTS `stock_nilai_cache`;
CREATE TABLE `stock_nilai_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `jmlPembPiutang` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jmlPembHutang` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jmlRusak` int(11) NOT NULL DEFAULT '0',
  `jmlPerbaikan` int(11) NOT NULL DEFAULT '0',
  `jmlPenjualan` int(11) NOT NULL DEFAULT '0',
  `jmlReturnPenjualan` int(11) NOT NULL DEFAULT '0',
  `jmlTambah` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jmlKurang` decimal(14,2) NOT NULL DEFAULT '0.00',
  `jml` decimal(14,2) DEFAULT NULL,
  `tgl` varchar(2) DEFAULT NULL,
  `bln` varchar(2) DEFAULT NULL,
  `thn` varchar(2) DEFAULT NULL,
  `dtime` datetime DEFAULT NULL,
  `pembayaran` tinytext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# Source for table transaksi
#

DROP TABLE IF EXISTS `transaksi`;
CREATE TABLE `transaksi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `jenis` varchar(255) DEFAULT NULL,
  `nomer` varchar(32) DEFAULT NULL,
  `dtime` datetime DEFAULT NULL,
  `oleh_id` int(11) DEFAULT NULL COMMENT 'pelaku transaksi',
  `oleh_nama` varchar(255) DEFAULT NULL,
  `customers_id` int(11) NOT NULL DEFAULT '0',
  `suppliers_id` int(11) NOT NULL DEFAULT '0',
  `approvals_id` int(11) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '0',
  `transaksi_nilai` decimal(14,2) NOT NULL DEFAULT '0.00',
  `sys_pembayaran` varchar(5) DEFAULT NULL,
  `keterangan` tinytext,
  `trash` int(1) NOT NULL DEFAULT '0',
  `orders_id` int(11) NOT NULL DEFAULT '0',
  `bank_id` int(11) NOT NULL DEFAULT '0',
  `jurnal_id` int(11) NOT NULL DEFAULT '0',
  `kas_id` int(11) NOT NULL DEFAULT '0',
  `pembayaran` tinytext NOT NULL,
  `jatuh_tempo` int(11) NOT NULL DEFAULT '0' COMMENT 'dalam satuan detik (second)',
  `dtime_jatuh_tempo` datetime DEFAULT NULL,
  `g_kas` tinyint(1) NOT NULL DEFAULT '0',
  `r_penjualan` tinyint(1) NOT NULL DEFAULT '0',
  `r_test` tinyint(1) NOT NULL DEFAULT '0',
  `r_laba` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=latin1;

/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
