<?php

/**
 * Created by PhpStorm.
 * User: thomas
 * Date: 18/04/18
 * Time: 18:19
 */
class Produk
{

    protected $key_words;
    protected $tipe_produk;
    protected $order;

    public function getOrder()
    {
        return $this->order;
    }

    public function setOrder($order)
    {
        $this->order = $order;
    }


    public function setTipeProduk($tipe_produk)
    {
        $this->tipe_produk = $tipe_produk;
    }

    public function setKeyWords($key_words)
    {
        $this->key_words = $key_words;
    }


    function __construct()
    {
        $this->db = New _00_DBclass();
        !$this->db->connect() ? die($this->db->display_errors()) : "";

        $this->tbl = "produk";
        $this->tbl_harga = "harga";
        $this->tbl_komposisi = "produk_komposisi";
        $this->tbl_supply = "produk_supplies";
        $this->tbl_cache_supply = "produk_stok_cache_supplies";

        $this->fieldProduk = array(
            'id',
            'jenis',
            'kode',
            'nama',
            'folders',
            'keterangan',
            'status',
            'trash',
            'tanda',
            'satuan',
            'paket',
            'folders_nama',
            'pic',
            'dtime',
            'ppn',
            'dijual',
            'barcode',
            'no_part',
            'deskripsi',
            'berat',
            'lebar',
            'panjang',
            'tinggi',
            'volume',
            'berat_gross',
            'lebar_gross',
            'panjang_gross',
            'tinggi_gross',
            'volume_gross',
            'diskon_kategori',
            'diskon_kategori_id',
        );
        $this->fieldHarga = array(
            'id',
            'produk_id',
            'cabang_id',
            // 'harga_lama',
            'harga_baru',
            'harga_cabang',
            // 'jenis',
            'hpp_lama',
            'hpp_baru',
            // 'komisi_lama',
            // 'komisi_baru',
            // 'laba_lama',
            // 'laba_baru',
            // 'alasan',
            // 'dtime',
            'status',
            // 'status_harga',
            // 'trash',
            // 'author',
            // 'author_nama',
            // 'parent_id',
            // 'approvals_id',
            // 'approvals_nama',
            'hppo_baru',
            'harga_bruto',
        );
    }

    public function callIsiFolder($folder_id = "")
    {
        if ($folder_id > 0) {
            $condite = "folders='$folder_id'";
        }
        else {
            $condite = "folders<>'0'";
        }
        $conditional_2 = "where $condite AND trash='0'";

        $q_2 = "select id, folders from $this->tbl $conditional_2";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrFolders = array();
        while ($l_2 = $this->db->get_row($x_2)) {
            $folders = $l_2->folders;
            $produk_id = $l_2->id;

            $arrFolders[$folders][] = $produk_id;
        }

        return $arrFolders;
    }

    public function callProdukCacheSupplier($supplier_id = "")
    {
        $tbl_4 = "produk_cache_supplier";
        $arrKolom = array(
            "id",
            "data_id",
            "produk_nama",
            "suppliers_id",
            "suppliers_nama",
            "harga",
            "hpp",
            "persediaan_st",
            "persediaan_limit",
            "folder_id",
            "folder_nama",
            "cabang_id",
        );
        $kolom_list = implode(',', $arrKolom);

        $conditional = "where status='1' and trash='0'";
        /*
         * untuk searcing gunakan set_key_words saat mengunakan*/
        if ((isset($this->key_words) && (strlen($this->key_words) > 3))) {
            $conditional .= " and produk_nama like '%" . $this->key_words . "%'";
        }
        else {
            $conditional .= "";
        }

        if (!empty($supplier_id)) {
            $conditional .= " and suppliers_id='$supplier_id'";
        }
        else {
            $conditional .= "";
        }
        $q_4 = "select $kolom_list from $tbl_4 $conditional";
        //    echo "$q_4";
        $x_4 = $this->db->select($q_4);
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $j_4 = $this->db->select($q_4, true);

        // endregion cek log_notif

        $arrData = array();
        while ($l_4 = $this->db->get_row($x_4)) {
            $arrDataKolom = array();
            $id = $l_4->id;
            foreach ($arrKolom as $kolom) {
                //                $$kolom = $l_4->$kolom;
                $arrDataKolom[$kolom] = $l_4->$kolom;
            }

            $arrData[$id] = $arrDataKolom;
        }

        return $arrData;
    }

    public function callProdukAktif($produk_id = "")
    {
        $tbl_4 = $this->tbl;
        $arrKolom = $this->fieldProduk;
        $kolom_list = implode(',', $arrKolom);

        $conditional = "where jenis='item' and status='1' and trash='0'";
        /*
         * untuk searcing gunakan set_key_words saat mengunakan*/
        if ((isset($this->key_words) && (strlen($this->key_words) > 3))) {
            $conditional .= " and produk_nama like '%" . $this->key_words . "%'";
        }
        else {
            $conditional .= "";
        }

        if (!empty($supplier_id)) {
            $conditional .= " and suppliers_id='$supplier_id'";
        }
        else {
            $conditional .= "";
        }

        if ((!isset($this->order)) || ($this->order === false)) {
            $conditional .= "";
        }
        else {
            is_array($this->order) ? "" : mati_disini("setOrder harus arau kolom desc/asc");
            foreach ($this->order as $itemKy => $itemVal) {
                $conditional .= "order by $itemKy $itemVal";
            }
        }
        $conditional .= (!isset($this->limit)) || ($this->limit === false) ? "" : " limit $this->limit";

        $q_4 = "select $kolom_list from $tbl_4 $conditional";
        //    echo "$q_4";
        $x_4 = $this->db->select($q_4);
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $j_4 = $this->db->select($q_4, true);

        // endregion cek log_notif

        $arrData = array();
        while ($l_4 = $this->db->get_row($x_4)) {
            $arrDataKolom = array();
            $id = $l_4->id;
            foreach ($arrKolom as $kolom) {
                //                $$kolom = $l_4->$kolom;
                $arrDataKolom[$kolom] = $l_4->$kolom;
            }

            $arrData[$id] = $arrDataKolom;
        }

        return $arrData;
    }

    public function callProdukFolder()
    {
        $tbl_4 = $this->tbl;
        $arrKolom = array(
            "id", //            "data_id",
            "nama", //            "suppliers_id",
        );
        $kolom_list = implode(',', $arrKolom);

        $conditional = "where 1 and trash='0' and jenis='folder'";

        $q_4 = "select $kolom_list from $tbl_4 $conditional";
        //    echo "$q_4";
        $x_4 = $this->db->select($q_4);
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $j_4 = $this->db->select($q_4, true);

        // endregion cek log_notif

        $arrData = array();
        while ($l_4 = $this->db->get_row($x_4)) {
            $arrDataKolom = array();
            $id = $l_4->id;
            foreach ($arrKolom as $kolom) {
                //                $$kolom = $l_4->$kolom;
                $arrDataKolom[$kolom] = $l_4->$kolom;
            }

            $arrData[$id] = $arrDataKolom;
        }

        return $arrData;
    }

    public function callProdukHarga()
    {
        $tbl_4 = $this->tbl_harga;
        $arrKolom = $this->fieldHarga;
        $kolom_list = implode(',', $arrKolom);

        $conditional = "where status='1' and trash='0'";
        /*
         * untuk searcing gunakan set_key_words saat mengunakan*/
        if ((isset($this->key_words) && (strlen($this->key_words) > 3))) {
            $conditional .= " and produk_nama like '%" . $this->key_words . "%'";
        }
        else {
            $conditional .= "";
        }

        if (!empty($supplier_id)) {
            $conditional .= " and suppliers_id='$supplier_id'";
        }
        else {
            $conditional .= "";
        }
        $q_4 = "select $kolom_list from $tbl_4 $conditional";
        cekHijau("$q_4");
        $x_4 = $this->db->select($q_4);
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $j_4 = $this->db->select($q_4, true);

        // endregion cek log_notif

        $arrData = array();
        while ($l_4 = $this->db->get_row($x_4)) {
            $arrDataKolom = array();
            $id = $l_4->id;
            $cabang_id = $l_4->cabang_id;
            $produk_id = $l_4->produk_id;
            foreach ($arrKolom as $kolom) {
                //                $$kolom = $l_4->$kolom;
                $arrDataKolom[$kolom] = $l_4->$kolom;
            }

            $arrData['row'][$id] = $arrDataKolom;
            $arrData['cabang'][$cabang_id][$produk_id] = $arrDataKolom;
        }

        return $arrData;
    }

    public function callProdukImages($produk_id)
    {
        // $tbl = "produk";
        $tbl_2 = "images";
        // region get data image
        $conditional_4 = "where parent_id='$produk_id' and trash='0' and jenis='produk'";
        $q_4 = "SELECT id,files, parent_id FROM $tbl_2 $conditional_4";
        $x_4 = $this->db->select($q_4);
        // cekHere("$j_4<hr>$q_4");
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        $j_4 = $this->db->select($q_4, true);
        $arrFiles = array();
        while ($l_4 = $this->db->get_row($x_4)) {
            $aktif_id = $l_4->parent_id;
            $fid = $l_4->id;
            $files_mentah = $l_4->files;
            // $deskripsi = $l_4->deskripsi;

            $files = unserialize(base64_decode($files_mentah));

            // $emp_id = $arrTimeline_empl[$aktif_id];
            $arrFiles[$fid] = $files;
            // $arrCaption[$aktif_id][] = $deskripsi;
        }

        return $arrFiles;
    }

    public function callProdukImagesSupplies($produk_id)
    {
        // $tbl = "produk";
        $tbl_2 = "images";
        // region get data image
        $conditional_4 = "where parent_id='$produk_id' and trash='0' and jenis='produk_supplies'";
        $q_4 = "SELECT id,files, parent_id FROM $tbl_2 $conditional_4";
        $x_4 = $this->db->select($q_4);
        // cekHere("$j_4<hr>$q_4");
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        $j_4 = $this->db->select($q_4, true);
        $arrFiles = array();
        while ($l_4 = $this->db->get_row($x_4)) {
            $aktif_id = $l_4->parent_id;
            $fid = $l_4->id;
            $files_mentah = $l_4->files;
            // $deskripsi = $l_4->deskripsi;

            $files = unserialize(base64_decode($files_mentah));

            // $emp_id = $arrTimeline_empl[$aktif_id];
            $arrFiles[$fid] = $files;
            // $arrCaption[$aktif_id][] = $deskripsi;
        }

        return $arrFiles;
    }

    public function callProdukData($produk_id)
    {
        // $tbl = "produk";
        $tbl_2 = $this->tbl;


        $arrKolom = array(
            "id", //            "data_id",
            "nama", //            "suppliers_id",
            "deskripsi",
            //            "harga",
            //            "hpp",
            //            "persediaan_st",
            //            "persediaan_limit",
            //            "folder_id",
            //            "folder_nama",
        );
        $kolom_list = implode(',', $arrKolom);

        $conditional_4 = "where id='$produk_id'";
        $q_4 = "SELECT $kolom_list FROM $tbl_2 $conditional_4";
        $x_4 = $this->db->select($q_4);
        // cekHere("$j_4<hr>$q_4");
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        $j_4 = $this->db->select($q_4, true);
        $arrFiles = array();
        while ($l_4 = $this->db->get_row($x_4)) {

            $fid = $l_4->id;
            $files_mentah = $l_4->files;
            $deskripsi = $l_4->deskripsi;
            $arrData = array();
            foreach ($arrKolom as $itemKolom => $valueKolom) {
                $arrData[$valueKolom] = $l_4->$valueKolom;
            }

            $files = unserialize(base64_decode($files_mentah));

            // $emp_id = $arrTimeline_empl[$aktif_id];
            $arrFiles[$fid] = $arrData;
            // $arrCaption[$aktif_id][] = $deskripsi;
        }

        return $arrFiles;
    }

    public function callProdukDiskonKategori($diskon_kategori_id = "")
    {
        $tbl_4 = $this->tbl;
        $arrKolom = array(
            "id", //            "data_id",
            "nama",
            "kode",
            "keterangan",
            "folders_nama",
            //            "suppliers_nama",
            // "harga",
            // "hpp",
            // "persediaan_st",
            // "persediaan_limit",
            // "folder_id",
            // "folder_nama",
        );
        $kolom_list = implode(',', $arrKolom);

        $conditional = "where status='1' and trash='0'";
        /*
         * untuk searcing gunakan set_key_words saat mengunakan*/
        if ((isset($this->key_words) && (strlen($this->key_words) > 3))) {
            $conditional .= " and produk_nama like '%" . $this->key_words . "%'";
        }
        else {
            $conditional .= "";
        }

        if (!empty($diskon_kategori_id)) {
            $conditional .= " and diskon_kategori_id='$diskon_kategori_id'";
        }
        else {
            $conditional .= "";
        }
        $q_4 = "select $kolom_list from $tbl_4 $conditional";
        // echo "$q_4";
        $x_4 = $this->db->select($q_4);
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $j_4 = $this->db->select($q_4, true);

        // endregion cek log_notif

        $arrData = array();
        while ($l_4 = $this->db->get_row($x_4)) {
            $arrDataKolom = array();
            $id = $l_4->id;
            foreach ($arrKolom as $kolom) {
                //                $$kolom = $l_4->$kolom;
                $arrDataKolom[$kolom] = $l_4->$kolom;
            }

            $arrData[$id] = $arrDataKolom;
        }

        return $arrData;
    }


    public function callProdukSupplies($produk_id = "")
    {
        $tbl_4 = $this->tbl_supply;
        $arrKolom = array(
            "id", //            "data_id",
            "nama", //            "suppliers_id",
            //            "suppliers_nama",
            //"harga", "hpp",
            //"persediaan_st", "persediaan_limit",
            "folders",
            "folders_nama",
        );
        $kolom_list = implode(',', $arrKolom);

        if (isset($this->tipe_produk)) {
            $tipe_produk = $this->tipe_produk;
            $tipe_produk_f = "and item_jenis='$tipe_produk'";
        }
        else {
            $tipe_produk_f = "and item_jenis='0'";
        }


        $conditional = "where status='1' and trash='0' and jenis='item' $tipe_produk_f";

        /*
         * untuk searcing gunakan set_key_words saat mengunakan*/
        if ((isset($this->key_words) && (strlen($this->key_words) >= 3))) {
            $conditional .= " and nama like '%" . $this->key_words . "%'";
        }
        else {
            $conditional .= "";
        }

        if (!empty($supplier_id)) {
            $conditional .= " and suppliers_id='$supplier_id'";
        }
        else {
            $conditional .= "";
        }

        $q_4 = "select $kolom_list from $tbl_4 $conditional";
        $x_4 = $this->db->select($q_4);
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        $j_4 = $this->db->select($q_4, true);
        //        cekHere($q_4);
        // endregion cek log_notif

        $arrData = array();
        while ($l_4 = $this->db->get_row($x_4)) {
            $arrDataKolom = array();
            $id = $l_4->id;
            foreach ($arrKolom as $kolom) {
                //                $$kolom = $l_4->$kolom;
                $arrDataKolom[$kolom] = $l_4->$kolom;
            }

            $arrData[$id] = $arrDataKolom;
        }

        return $arrData;
    }

    public function callProdukSuppliesById($produk_id)
    {
        $tbl_4 = $this->tbl_supply;
        $arrKolom = array(
            "id", //            "data_id",
            "nama", //            "suppliers_id",
            //            "suppliers_nama",
            //"harga", "hpp",
            //"persediaan_st", "persediaan_limit",
            "folders",
            "folders_nama",
        );
        $kolom_list = implode(',', $arrKolom);

        $conditional = "where id='$produk_id'";
        /*
         * untuk searcing gunakan set_key_words saat mengunakan*/
        //        if ((isset($this->key_words) && (strlen($this->key_words) >= 3))) {
        //            $conditional .= " and nama like '%" . $this->key_words . "%'";
        //        }
        //        else {
        //            $conditional .= "";
        //        }
        //
        //        if (!empty($supplier_id)) {
        //            $conditional .= " and suppliers_id='$supplier_id'";
        //        }
        //        else {
        //            $conditional .= "";
        //        }

        $q_4 = "select $kolom_list from $tbl_4 $conditional";
        $x_4 = $this->db->select($q_4);
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        $j_4 = $this->db->select($q_4, true);
        //        cekHere("$q_4 ; $j_4");
        // endregion cek log_notif

        $arrData = array();
        //        while ($l_4 = $this->db->get_row($x_4)) {
        $l_4 = $this->db->get_row($x_4);
        $arrDataKolom = array();
        $id = $l_4->id;
        foreach ($arrKolom as $kolom) {
            //                $$kolom = $l_4->$kolom;
            $arrDataKolom[$kolom] = $l_4->$kolom;
        }

        $arrData = $arrDataKolom;

        //        }

        return $arrData;
    }

    public function callProdukCacheSupplies($conditional)
    {
        $tbl = $this->tbl_cache_supply;

        $arrKolom = array(
            "id",
            "produk_id",
            "produk_nama",
            "persediaan",
            "cabang_id",
        );
        $kolom_list = implode(',', $arrKolom);
        $conditional_f = strlen($conditional) > 2 ? "where $conditional" : "";

        $q_4 = "select $kolom_list from $tbl $conditional_f";
        $x_4 = $this->db->select($q_4);
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        //        $j_4 = $this->db->select($q_4, true);
        $arrProdukCacheSupplies = array();

        while ($l_4 = $this->db->get_row($x_4)) {
            $arrProdukCacheSupplies[$l_4->produk_id][$l_4->cabang_id] = $l_4->persediaan;
        }


        return $arrProdukCacheSupplies;
    }

    public function callProdukKomposisi($produk_id = "")
    {
        $tbl_4 = $this->tbl_komposisi;
        $arrKolom = array(
            "id", //            "data_id",
            "produk_dasar_nama", //            "suppliers_id",
            "produk_dasar_id",
            "satuan_nama",
            "jml",
            //"persediaan_st", "persediaan_limit",

        );
        $kolom_list = implode(',', $arrKolom);

        $conditional = "where status='1'";

        /*
         * untuk searcing gunakan set_key_words saat mengunakan*/
        if ((isset($this->key_words) && (strlen($this->key_words) >= 3))) {
            $conditional .= " and nama like '%" . $this->key_words . "%'";
        }
        else {
            $conditional .= "";
        }

        if (!empty($produk_id)) {
            $conditional .= " and produk_id='$produk_id'";
        }
        else {
            $conditional .= "";
        }

        $q_4 = "select $kolom_list from $tbl_4 $conditional";
        $x_4 = $this->db->select($q_4);
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        $j_4 = $this->db->select($q_4, true);
        //        cekHere($q_4);
        // endregion cek log_notif

        $arrData = array();
        while ($l_4 = $this->db->get_row($x_4)) {
            $arrDataKolom = array();
            $id = $l_4->id;
            foreach ($arrKolom as $kolom) {
                //                $$kolom = $l_4->$kolom;
                $arrDataKolom[$kolom] = $l_4->$kolom;
            }

            $arrData[$id] = $arrDataKolom;
        }

        return $arrData;
    }

    public function callProdukFifo($produk_id)
    {
        // $tbl = "produk";
        $tbl_2 = rek_cache_persediaan_produk_fifo;


        $arrKolom = array(
            "id", //            "data_id",
            "produk_id",
            "produk_nama",
            "unit",
            "hpp",
            "jml_nilai",
            "transaksi_id",
            "transaksi_jenis",
            "dtime",
            "dtime_last",
        );
        $kolom_list = implode(',', $arrKolom);

        $conditional_4 = "where produk_id='$produk_id' and trash='0'";
        $q_4 = "SELECT $kolom_list FROM $tbl_2 $conditional_4";
        $x_4 = $this->db->select($q_4);
        // cekHere("$j_4<hr>$q_4");
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        $j_4 = $this->db->select($q_4, true);
        $arrFiles = array();
        while ($l_4 = $this->db->get_row($x_4)) {

            $fid = $l_4->id;
            $arrData = array();
            foreach ($arrKolom as $itemKolom => $valueKolom) {
                $arrData[$valueKolom] = $l_4->$valueKolom;
            }

            // $files = unserialize(base64_decode($files_mentah));

            // $emp_id = $arrTimeline_empl[$aktif_id];
            $arrFiles[$fid] = $arrData;
            // $arrCaption[$aktif_id][] = $deskripsi;
        }

        $arrVar['data'] = $arrFiles;
        $arrVar['kolom'] = $arrKolom;

        return $arrVar;
    }
}