<?php

/**
 * Created by PhpStorm.
 * User: thomas
 * Date: 19/04/18
 * Time: 18:09
 */
class PenjualanExport
{
    protected $cabang_id;
    protected $transaksi_id;
    protected $employee_id;
    protected $customer_id;
    protected $tanggal;
    protected $tanggal_range;
    protected $limit;
    protected $order;
    protected $condite;
    protected $fieldColomChild = array();
    protected $fieldColomParent = array();
    protected $defKolom = array();

    // region seter
    public function getTransaksiId()
    {
        return $this->transaksi_id;
    }

    public function setTransaksiId($transaksi_id)
    {
        $this->transaksi_id = $transaksi_id;
    }

    public function getTanggalRange()
    {
        return $this->tanggal_range;
    }

    public function setTanggalRange($tanggal_range)
    {
        $this->tanggal_range = $tanggal_range;
    }

    public function getFieldColomParent()
    {
        return $this->fieldColomParent;
    }

    public function getDefKolom()
    {
        return $this->defKolom;
    }

    public function setDefKolom($defKolom)
    {
        $this->defKolom = $defKolom;
    }

    public function getCondite()
    {
        return $this->condite;
    }

    public function setCondite($condite)
    {
        $this->condite = $condite;
    }

    public function setFieldColomParent($fieldColomParent)
    {
        $this->fieldColomParent = $fieldColomParent;
    }

    public function getFieldColomChild()
    {
        return $this->fieldColomChild;
    }

    public function setFieldColomChild($fieldColomChild)
    {
        $this->fieldColomChild = $fieldColomChild;
    }

    public function setLimit($limit)
    {
        $this->limit = $limit;
    }

    public function getCustomerId()
    {
        return $this->customer_id;
    }

    public function setCustomerId($customer_id)
    {
        $this->customer_id = $customer_id;
    }

    public function getOrder()
    {
        return $this->order;
    }

    public function setOrder($order)
    {
        $this->order = $order;
    }

    public function setCabangId($cabang_id)
    {
        $this->cabang_id = $cabang_id;
    }

    public function setEmployeeId($employee_id)
    {
        $this->employee_id = $employee_id;
    }

    public function setTanggal($tanggal)
    {
        $this->tanggal = $tanggal;
    }


    // endregion seter

    function __construct()
    {
        $this->db = New _00_DBclass();
        !$this->db->connect() ? die($this->db->display_errors()) : "";

        $this->tblparent = "transaksi";
        $this->tblchild = "transaksi_data";
        $this->fieldColomParent = $this->defkolom = array(
            "id",
            "nomer",
            "inv",
            "jenis",
            "dtime",
            "transaksi_nilai",
            "diskon_nilai",
            "diskon_jenis",
            "ppn_nilai",
            "ppn_persen",
            "transaksi_net",
            "status",
            "status_edit",
            "deposit_persen_in",
            "deposit_nilai_in",
            "deposit_nilai",
            "oleh_id",
            "oleh_nama",
            "customers_id",
            "customers_nama",
            "approvals_id",
            "approvals_nama",
            "approvals_dtime",
            "approvals_batal_id",
            "approvals_batal_nama",
            "approvals_batal_alasan",
            "approvals_batal_dtime",
            "approvals_batal_kirim_id",
            "batal_kirim",
            "approvals_batal_kirim_id",
            "approvals_batal_kirim_nama",
            "approvals_batal_kirim_dtime",
            "gudang_id",
            "gudang_nama",
            "gudang_dtime",
            "referensi_id",
            "cabang_id",
            "cabang_nama",
            "cabang_id_tujuan",
            "cabang_nama_tujuan",
            "seller_id",
            "seller_nama",
            "last_info",
            "jatuh_tempo",
            "dtime_jatuh_tempo",
            "transaksi_jenis",
            "tpl_alamat_id",
            "pembayaran",
            "bank_id",
            "bank_nama",
            "bank_rekening_id",
            "bank_rekening_nama",
            "pembayaran_tunai",
            "deposit_nilai_in",
            "kontainer_harga",
            "kontainer_ppn",
            "ekspedisi_id",
            "ekspedisi_nama",
            "tipe",
            "trash",
            "setor_status",
            "dtime_kirim",
            "valas_nama",
            "valas_nilai",
            "kontainer_valas_nilai"
        );
        $this->jasaKolom = array(
            "id",
            "nomer",
            "inv",
            "jenis",
            "dtime",
            "transaksi_nilai",
            "diskon_nilai",
            "diskon_jenis",
            "ppn_nilai",
            "ppn_persen",
            "transaksi_net",
            "status",
            "status_edit",
            "deposit_nilai_in",
            "deposit_nilai",
            "oleh_id",
            "oleh_nama",
            "suppliers_id",
            "suppliers_nama",
            "approvals_id",
            "approvals_nama",
            "approvals_dtime",
            "approvals_batal_id",
            "referensi_id",
            "cabang_id",
            "cabang_nama",
            "cabang_id_tujuan",
            "cabang_nama_tujuan",
            "last_info",
            "jatuh_tempo",
            "dtime_jatuh_tempo",
            "transaksi_jenis",
            "tpl_alamat_id",
            "pembayaran",
            "bank_id",
            "bank_nama",
            "bank_rekening_id",
            "bank_rekening_nama",
            "pembayaran_tunai",
            "deposit_nilai_in",
            "tipe",
            "trash",
        );
        $this->fieldColomChild = array(
            "produk_jenis",
            "produk_id",
            "produk_ord_jml",
            "produk_ord_hrg",
            "keterangan",
            "kirim",
            "status",
            "produk_kode",
            "transaksi_id",
            "produk_nama",
            "produk_nama_2",
            "no_part",
            // "keterangan",
            "satuan",
            "produk_keterangan",
            "produk_folders",
            "produk_ord_jml",
            "produk_ord_stok",
            "produk_ord_diskon",
            "produk_ord_diskon_persen",
            "produk_ord_diskon_khusus",
            "produk_ord_diterima",
            "produk_ord_kurang",
            "produk_ord_batal",
            "produk_ord_hrg",
            "produk_hrg_ori",
            "produk_berat",
            "produk_berat_gross",
            "produk_volume",
            "produk_volume_gross",
            "hpp",
            "ppn",
            "ppn_persen",
            "kirim",
            "oleh_id",
            "oleh_nama",
            "batal_dtime",
            "batal_oleh_id",
            "batal_oleh_nama",
            "id",
            "valas_ord_nama",
            "valas_ord_hrg",
        );
    }

    public function call_sales_so()
    {

        $arrKolom = $this->defkolom;

        $list_kolom = implode(',', $arrKolom);

        $condite = "and jenis='382r' and trash='0'";
        // $condite .= !isset($this->cabang_id) ? mati_disini("please cabang_id" . __FUNCTION__ . " harap di set") : " and cabang_id='" . $this->cabang_id . "'";
        $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";

        if (isset($this->condite)) {
            if (is_array($this->condite)) {

                $hasil = "";
                foreach ($this->condite as $itemKolom => $itemValue) {
                    $var = " and $itemKolom='$itemValue'";
                    if ($hasil == "") {
                        $hasil .= "$var";
                    }
                    else {
                        $hasil = "$hasil" . "$var";
                    }

                }
                $condite .= $hasil;
            }
            else {
                mati_disini("setCondite harus array");
            }
            // $condite .=
        }
        else {
            $condite .= "";
        }

        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        // cekHijau("$q_2");
        $arrData = array();
        $arrRow = array();
        $arrOleh = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrRow[$id] = $arrKolom_nilai;
            $arrOleh[$oleh_id][$id] = $arrKolom_nilai;
        }
        $arrData['row'] = $arrRow;
        $arrData['sales'] = $arrOleh;

        return $arrData;
    }

    public function call_sales_so_done()
    {

        $arrKolom = $this->defkolom;

        $list_kolom = implode(',', $arrKolom);

        $condite = "and jenis='382r' and trash='0' and status='1'";
        // $condite .= !isset($this->cabang_id) ? mati_disini("please cabang_id" . __FUNCTION__ . " harap di set") : " and cabang_id='" . $this->cabang_id . "'";
        $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";

        if (isset($this->condite)) {
            if (is_array($this->condite)) {

                $hasil = "";
                foreach ($this->condite as $itemKolom => $itemValue) {
                    $var = " and $itemKolom='$itemValue'";
                    if ($hasil == "") {
                        $hasil .= "$var";
                    }
                    else {
                        $hasil = "$hasil" . "$var";
                    }

                }
                $condite .= $hasil;
            }
            else {
                mati_disini("setCondite harus array");
            }
            // $condite .=
        }
        else {
            $condite .= "";
        }

        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        // cekHijau("$q_2");
        $arrData = array();
        $arrRow = array();
        $arrOleh = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrRow[$id] = $arrKolom_nilai;
            $arrOleh[$oleh_id][$id] = $arrKolom_nilai;
        }
        $arrData['row'] = $arrRow;
        $arrData['sales'] = $arrOleh;

        return $arrData;
    }

    public function call_sales_so_hold()
    {

        $arrKolom = $this->defkolom;

        $list_kolom = implode(',', $arrKolom);

        $condite = "and jenis='382r' and trash='0' and status='0'";
        // $condite .= !isset($this->cabang_id) ? mati_disini("please cabang_id" . __FUNCTION__ . " harap di set") : " and cabang_id='" . $this->cabang_id . "'";
        $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";

        if (isset($this->condite)) {
            if (is_array($this->condite)) {

                $hasil = "";
                foreach ($this->condite as $itemKolom => $itemValue) {
                    $var = " and $itemKolom='$itemValue'";
                    if ($hasil == "") {
                        $hasil .= "$var";
                    }
                    else {
                        $hasil = "$hasil" . "$var";
                    }

                }
                $condite .= $hasil;
            }
            else {
                mati_disini("setCondite harus array");
            }
            // $condite .=
        }
        else {
            $condite .= "";
        }

        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        // cekMerah("$q_2");
        $arrData = array();
        $arrRow = array();
        $arrOleh = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrRow[$id] = $arrKolom_nilai;
            $arrOleh[$oleh_id][$id] = $arrKolom_nilai;
        }
        $arrData['row'] = $arrRow;
        $arrData['sales'] = $arrOleh;

        return $arrData;
    }

    public function call_pre_so_all()
    {

        $arrKolom = $this->defkolom;

        $list_kolom = implode(',', $arrKolom);

        $condite = "and jenis='382r'";
        $condite .= !isset($this->cabang_id) ? mati_disini("please cabang_id" . __FUNCTION__ . " harap di set") : " and cabang_id='" . $this->cabang_id . "'";
        $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";

        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrData[$id] = $arrKolom_nilai;
        }

        return $arrData;
    }

    public function call_pre_so()
    {

        $arrKolom = $this->defkolom;

        $list_kolom = implode(',', $arrKolom);

        $condite = "and jenis='382r' and status='0' and trash='0'";
        $condite .= !isset($this->cabang_id) ? mati_disini("please cabang_id" . __FUNCTION__ . " harap di set") : " and cabang_id='" . $this->cabang_id . "'";
        $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";
        // if ((!isset($this->order)) || ($this->order === false)) {
        //     $condite .= "";
        // }
        // else {
        //     is_array($this->order) ? "" : mati_disini("setOrder harus arau kolom desc/asc");
        //     foreach ($this->order as $itemKy => $itemVal) {
        //         $condite .= "order by $itemKy $itemVal";
        //     }
        // }
        // $condite .= (!isset($this->limit)) || ($this->limit === false) ? "" : " limit $this->limit";
        //
        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite";
        // cekHijau("$q_2");
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrData[$id] = $arrKolom_nilai;
        }

        return $arrData;
    }

    public function call_pre_so_active()
    {

        $arrKolom = $this->defkolom;

        $list_kolom = implode(',', $arrKolom);

        $condite = "and jenis='382r' and trash='0'";
        $condite .= !isset($this->cabang_id) ? mati_disini("please cabang_id" . __FUNCTION__ . " harap di set") : " and cabang_id='" . $this->cabang_id . "'";
        $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";

        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrData[$id] = $arrKolom_nilai;
        }

        return $arrData;
    }

    public function call_pre_so_done()
    {

        $arrKolom = $this->defkolom;

        $list_kolom = implode(',', $arrKolom);

        $condite = "and jenis='382r' and status='1' and trash='0'";
        $condite .= !isset($this->cabang_id) ? mati_disini("please " . __FUNCTION__ . " harap di set") : " and cabang_id='" . $this->cabang_id . "'";
        $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";

        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrData[$id] = $arrKolom_nilai;
        }

        return $arrData;
    }

    public function call_pre_so_del()
    {

        $arrKolom = $this->defkolom;

        $list_kolom = implode(',', $arrKolom);

        $condite = "and jenis='382r' and status='0' and trash='1'";
        $condite .= !isset($this->cabang_id) ? mati_disini("please " . __FUNCTION__ . " harap di set") : " and cabang_id='" . $this->cabang_id . "'";
        $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";

        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrData[$id] = $arrKolom_nilai;
        }

        return $arrData;
    }

    public function call_pre_so_siap_stok()
    {
        $arrKolom = $this->defkolom;

        $list_kolom = implode(',', $arrKolom);

        $condite = "and jenis='382r' and status='0' and trash='0' and tipe is NULL";
        $condite .= !isset($this->cabang_id) ? mati_disini("please " . __FUNCTION__ . " harap di set") : " and cabang_id='" . $this->cabang_id . "'";
        $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";

        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite";
        // cekHere($q_2);
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        $arrDataLastApproved = array();
        $arrDataRaw = array();
        $arrDataNeedApproval = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrDataRaw[$id] = $arrKolom_nilai;

            if ($approvals_id > 0) {
                $arrDataLastApproved[$id] = $arrKolom_nilai;
                if ($setor_status == 1) {
                    $arrDataReadyPl[$id] = $arrKolom_nilai;
                }
            }
            else {
                $arrDataNeedApproval[$id] = $arrKolom_nilai;
            }
        }
        $arrData = $arrDataRaw;
        $arrData['ready_pl'] = $arrDataReadyPl;
        $arrData['last_approved'] = $arrDataLastApproved;
        $arrData['need_approval'] = $arrDataNeedApproval;

        return $arrData;
    }

    public function call_otorisasi_cancel_so()
    {
        $arrKolom = $this->defkolom;

        $list_kolom = implode(',', $arrKolom);

        $condite = "and jenis='382r' and status='0' and trash='0' and tipe is NULL and approvals_batal_id>'0'";
        $condite .= !isset($this->cabang_id) ? mati_disini("please " . __FUNCTION__ . " harap di set") : " and cabang_id='" . $this->cabang_id . "'";
        $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";

        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite";
        // cekHere($q_2);
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        $arrDataLastApproved = array();
        $arrDataRaw = array();
        $arrDataNeedApproval = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrData[$id] = $arrKolom_nilai;
        }

        return $arrData;
    }

    public function call_pre_so_menunggu_stok()
    {
        $arrKolom = $this->defkolom;

        $list_kolom = implode(',', $arrKolom);

        $condite = "and jenis='382r' and status='0' and trash='0' and tipe='2'";
        $condite .= !isset($this->cabang_id) ? mati_disini("please " . __FUNCTION__ . " harap di set") : " and cabang_id='" . $this->cabang_id . "'";
        $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";

        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        // cekBiru("$q_2");
        $arrData = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrData[$id] = $arrKolom_nilai;
        }

        return $arrData;
    }

    public function call_history_approval_so()
    {
        $arrKolom = $this->defkolom;
        // $condite =
        $list_kolom = implode(',', $arrKolom);

        $condite = "and jenis='382r' and trash='0' and tipe is null and approvals_id>'0'";
        $condite .= !isset($this->cabang_id) ? mati_disini("please " . __FUNCTION__ . " harap di set") : " and cabang_id='" . $this->cabang_id . "'";
        $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";

        if ((!isset($this->order)) || ($this->order === false)) {
            $condite .= "";
        }
        else {
            is_array($this->order) ? "" : mati_disini("setOrder harus arau kolom desc/asc");
            foreach ($this->order as $itemKy => $itemVal) {
                $condite .= "order by $itemKy $itemVal";
            }
        }
        $condite .= (!isset($this->limit)) || ($this->limit === false) ? "" : " limit $this->limit";

        // $condite .= " order by approvals_dtime asc";
        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite";
        // cekHere($q_2);
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        $arrDataLastApproved = array();
        $arrDataRaw = array();
        $arrDataNeedApproval = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrDataRaw[$id] = $arrKolom_nilai;

            if ($approvals_id > 0) {
                $arrDataLastApproved[$id] = $arrKolom_nilai;
            }
            else {
                $arrDataNeedApproval[$id] = $arrKolom_nilai;
            }
        }
        $arrData = $arrDataRaw;
        // $arrData['last_approved'] = $arrDataLastApproved;
        // $arrData['need_approval'] = $arrDataNeedApproval;

        return $arrData;
    }

    public function call_so_nunggu_pl()
    {
        $arrKolom = $this->defkolom;
        // $condite =
        $list_kolom = implode(',', $arrKolom);

        $condite = "and jenis='382r' and trash='0' and tipe is null and approvals_id>'0' and status='0'";
        $condite .= !isset($this->cabang_id) ? mati_disini("please " . __FUNCTION__ . " harap di set") : " and cabang_id='" . $this->cabang_id . "'";
        $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";

        if ((!isset($this->order)) || ($this->order === false)) {
            $condite .= "";
        }
        else {
            is_array($this->order) ? "" : mati_disini("setOrder harus arau kolom desc/asc");
            foreach ($this->order as $itemKy => $itemVal) {
                $condite .= "order by $itemKy $itemVal";
            }
        }
        // $condite .= (!isset($this->limit)) || ($this->limit === false) ? "" : " limit $this->limit";

        // $condite .= " order by approvals_dtime asc";
        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite";
        // cekHere($q_2);
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        $arrDataLastApproved = array();
        $arrDataRaw = array();
        $arrDataNeedApproval = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrDataRaw[$id] = $arrKolom_nilai;

            if ($approvals_id > 0) {
                $arrDataLastApproved[$id] = $arrKolom_nilai;
            }
            else {
                $arrDataNeedApproval[$id] = $arrKolom_nilai;
            }
        }
        $arrData = $arrDataRaw;
        // $arrData['last_approved'] = $arrDataLastApproved;
        // $arrData['need_approval'] = $arrDataNeedApproval;

        return $arrData;
    }

    public function call_child($transaksi_id)
    {

        $transaksi_id < 1 ? mati_disini("transaksi_id harus berisi bilangan asli") : "";
        $arrKolom = $this->fieldColomChild;

        $list_kolom = implode(',', $arrKolom);

        $condite = "and transaksi_id='$transaksi_id' and trash='0'";

        $q_2 = "select $list_kolom from $this->tblchild where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrData[$id] = $arrKolom_nilai;
        }

        return $arrData;
    }

    public function call_child_382r($transaksi_id)
    {

        $transaksi_id < 1 ? mati_disini("transaksi_id harus berisi bilangan asli") : "";
        $arrKolom = array(
            "id",
            "transaksi_id",
            "inv",
        );

        $list_kolom = implode(',', $arrKolom);

        $condite = "and transaksi_id='$transaksi_id' and trash='0' and produk_jenis='produk'";

        $q_2 = "select $list_kolom from $this->tblchild where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrData[$id] = $arrKolom_nilai;
        }

        return $arrData;
    }

    public function call_child_produk_jenis($produk_jenis)
    {
        $transaksi_id = isset($this->transaksi_id) && ($this->transaksi_id >= 1) ? $this->transaksi_id : mati_disini("transaksi_id harus berisi bilangan asli " . $this->transaksi_id);
        $arrKolom = $this->fieldColomChild;

        $list_kolom = implode(',', $arrKolom);

        $condite = "and transaksi_id='$transaksi_id' and trash='0' and produk_jenis='$produk_jenis'";

        $q_2 = "select $list_kolom from $this->tblchild where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrData[$id] = $arrKolom_nilai;
        }

        return $arrData;
    }

    public function call_child_byid($transaksi_data_id)
    {
        $transaksi_data_id < 1 ? mati_disini("transaksi_data_id harus berisi bilangan asli " . __FUNCTION__ . __LINE__) : "";

        $arrKolom = $this->fieldColomChild;

        $list_kolom = implode(',', $arrKolom);

        $condite = "and id='$transaksi_data_id'";

        $q_2 = "select $list_kolom from $this->tblchild where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrData[$transaksi_data_id] = $arrKolom_nilai;
        }

        return $arrData;
    }

    public function call_child_produk($transaksi_id)
    {
        $transaksi_id < 1 ? mati_disini("transaksi_id harus berisi bilangan asli " . __FUNCTION__) : "";

        $arrKolom = $this->fieldColomChild;

        $list_kolom = implode(',', $arrKolom);

        $condite = "and transaksi_id='$transaksi_id' and trash='0' and produk_jenis='produk'";

        $q_2 = "select $list_kolom from $this->tblchild where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrData[$id] = $arrKolom_nilai;
        }

        return $arrData;
    }

    public function call_child_diskon($transaksi_id)
    {

        $transaksi_id < 1 ? mati_disini("transaksi_id harus berisi bilangan asli") : "";
        $arrKolom = array(
            "id",
            "produk_nama",
            "produk_jenis",
            "produk_ord_hrg",
            "produk_ord_diskon",
            "produk_ord_diskon_khusus",
        );

        $list_kolom = implode(',', $arrKolom);

        $condite = "and transaksi_id='$transaksi_id' and trash='0' and produk_jenis='diskon'";

        $q_2 = "select $list_kolom from $this->tblchild where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrData[$id] = $arrKolom_nilai;
        }

        return $arrData;
    }

    public function call_child_produk_dikirim($arrTransaksi_id)
    {

        $transaksi_list = implode(",", $arrTransaksi_id);
        // $transaksi_id < 1 ? mati_disini("transaksi_id harus berisi bilangan asli") : "";
        $arrKolom = array(
            "id",
            "produk_jenis",
            "produk_id",
            "produk_nama",
            "produk_keterangan",
            "produk_folders",
            "produk_ord_jml",
            "produk_ord_stok",
            "produk_ord_diskon",
            "produk_ord_diskon_khusus",
            "produk_ord_diterima",
            "produk_ord_kurang",
            "produk_ord_hrg",
            "produk_hrg_ori",
            "produk_berat",
            "produk_volume",
            "produk_volume_gross",
            "ppn",
            "kirim",
            "oleh_id",
            "oleh_nama",
        );

        $list_kolom = implode(',', $arrKolom);

        $condite = "and transaksi_id in ($transaksi_list) and trash='0' and produk_jenis='produk'";

        $q_2 = "select $list_kolom from $this->tblchild where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        // cekHere("$q_2");
        $arrData = array();
        $arrKolom_nilai = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_asli = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_asli[$kolom] = $l_2->$kolom;
            }


            $arrKolom_asli_loh[$id] = $arrKolom_asli;
            $arrKolom_nilai['produk_nama'] = $produk_nama;
            $arrKolom_nilai['produk_ord_jml'] = $produk_ord_jml;

            $arrData[$produk_id][] = $arrKolom_nilai;

            // $arrData[$produk_id] += $produk_ord_jml;
        }

        // arrPrint($arrKolom_asli_loh);
        // arrPrint($arrData);

        return $arrData;
    }

    public function call_child_produk_multi($arrTransaksi_id)
    {

        // $transaksi_id < 1 ? mati_disini("transaksi_id harus berisi bilangan asli") : "";
        !is_array($arrTransaksi_id) ? mati_disini("transaksi_id harus berupa array " . __LINE__) : "";
        $arrKolom = $this->fieldColomChild;
        $list_transaksi_id = implode(',', $arrTransaksi_id);

        $list_kolom = implode(',', $arrKolom);

        $condite = "and transaksi_id in ($list_transaksi_id) and trash='0' and produk_jenis='produk' order by produk_nama asc";

        $q_2 = "select $list_kolom from $this->tblchild where 1 $condite";
        $x_2 = $this->db->select($q_2);
        // cekHere("$q_2");
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrData[$transaksi_id][] = $arrKolom_nilai;
        }

        return $arrData;
    }

    public function call_child_produk_belum_dikirim_multi($arrTransaksi_id)
    {

        // $transaksi_id < 1 ? mati_disini("transaksi_id harus berisi bilangan asli") : "";
        !is_array($arrTransaksi_id) ? mati_disini("transaksi_id harus berupa array " . __LINE__ ." ". __FILE__) : "";
        $arrKolom = $this->fieldColomChild;
        $list_transaksi_id = implode(',', $arrTransaksi_id);

        $list_kolom = implode(',', $arrKolom);

        $condite = "and transaksi_id in ($list_transaksi_id) and trash='0' and status='0' and produk_jenis='produk' order by produk_nama asc";

        $q_2 = "select $list_kolom from $this->tblchild where 1 $condite";
        $x_2 = $this->db->select($q_2);
        // cekHere("$q_2");
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrData[$transaksi_id][] = $arrKolom_nilai;
        }

        return $arrData;
    }

    public function call_parent($transaksi_id)
    {
        $transaksi_id < 1 ? mati_disini("transaksi_id harus berisi bilangan asli") : "";
        $arrKolom = $this->defkolom;

        $list_kolom = implode(',', $arrKolom);

        $condite = "and id='$transaksi_id'";

        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrData[$id] = $arrKolom_nilai;
        }

        return $arrData;
    }

    public function call_produk_dipakai()
    {
        // $transaksi_id < 1 ? mati_disini("transaksi_id harus berisi bilangan asli") : "";
        $arrKolom = array(
            "id",
            "produk_jenis",
            "produk_id",
            // "produk_nama",
            // "produk_keterangan",
            // "produk_folders",
            "produk_ord_jml",
            // "produk_ord_stok",
            // "produk_ord_diskon",
            // "produk_ord_diskon_khusus",
            // "produk_ord_diterima",
            // "produk_ord_kurang",
            // "produk_ord_hrg",
            // "produk_hrg_ori",
            // "produk_berat",
            // "produk_volume",
            // "produk_volume_gross",
            // "ppn",
            // "kirim",
            // "oleh_id",
            // "oleh_nama",
        );

        $list_kolom = implode(',', $arrKolom);

        $condite = "and trash='0' and produk_jenis='produk'";

        $q_2 = "select $list_kolom from $this->tblchild where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        $no = 0;
        while ($l_2 = $this->db->get_row($x_2)) {
            $no++;
            // $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                // $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrData[$produk_id] = $no;
        }

        return $arrData;
    }

    public function call_pengiriman()
    {

        $arrKolom = $this->defkolom;

        $list_kolom = implode(',', $arrKolom);

        $condite = "and jenis='382k' and status='0' and trash='0'";
        $condite .= !isset($this->cabang_id) ? mati_disini("please " . __FUNCTION__ . " cabang_id harap di set") : " and cabang_id='" . $this->cabang_id . "'";
        $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        $condite .= (!isset($this->customer_id)) || ($this->customer_id === false) ? "" : " and customers_id='" . $this->customer_id . "'";
        $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";

        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        // cekHere("$q_2");
        $arrData = array();
        $arrData['customer_kirim'] = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }
            if ($pembayaran_tunai == 1) {
                $arrData['tunai'][$customers_id] = $customers_nama;
            }
            else {
                $arrData['non_tunai'][$customers_id] = $customers_nama;
            }

            $arrData['dtime'][$customers_id]['kirim'][] = $dtime_kirim;
            $arrData['dtime'][$customers_id]['pl'][] = $dtime;
            $arrData['customer'][$customers_id] = $customers_nama;
            $arrData['customer_bill'][$customers_id] += $transaksi_net;
            $arrData['customer_bill_valas'][$customers_id] += $transaksi_net /$valas_nilai;
            $arrData['customer_valas_label'][$customers_id] = $valas_nama;
            $arrData['customer_jml_pengiriman'][$customers_id] += 1;
            $arrData['raw'][$id] = $arrKolom_nilai;
        }

        return $arrData;
    }

    public function call_histori_pengeluaran()
    {
        $arrKolom_tambahan = array(
            "ekspedisi_id",
            "ekspedisi_nama",
        );
        $arrKolom = array_merge($this->defkolom, $arrKolom_tambahan);

        $list_kolom = implode(',', $arrKolom);

        // $condite = "and jenis='382k' and status='0' and trash='0'";
        $condite = "and jenis='382k' and trash='0'";
        $condite .= !isset($this->cabang_id) ? mati_disini("please cabang_id " . __FUNCTION__ . " harap di set") : " and cabang_id='" . $this->cabang_id . "'";
        $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";
        $condite .= (!isset($this->tanggal_range)) || ($this->tanggal_range === false) ? "" : $this->tanggal_range;
        if ((!isset($this->order)) || ($this->order === false)) {
            $condite .= "";
        }
        else {
            is_array($this->order) ? "" : mati_disini("setOrder harus arau kolom desc/asc");
            foreach ($this->order as $itemKy => $itemVal) {
                $condite .= "order by $itemKy $itemVal";
            }
        }
        $condite .= (!isset($this->limit)) || ($this->limit === false) ? "" : " limit $this->limit";


        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        // cekBiru("$q_2");
        $arrData = array();
        while ($l_2 = $this->db->get_row($x_2)) {
            $id = $l_2->id;
            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrData[$id] = $arrKolom_nilai;
        }

        return $arrData;
    }

    public function call_history_invoicing()
    {
        $arrKolom = $this->defkolom;
        // $condite =
        $list_kolom = implode(',', $arrKolom);

        $condite = "and jenis='382' and trash='0'";
        $condite .= !isset($this->cabang_id) ? mati_disini("please cabang_id " . __FUNCTION__ . " harap di set") : " and cabang_id='" . $this->cabang_id . "'";
        $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";

        if ((!isset($this->order)) || ($this->order === false)) {
            $condite .= "";
        }
        else {
            is_array($this->order) ? "" : mati_disini("setOrder harus arau kolom desc/asc");
            foreach ($this->order as $itemKy => $itemVal) {
                $condite .= "order by $itemKy $itemVal";
            }
        }
        $condite .= (!isset($this->limit)) || ($this->limit === false) ? "" : " limit $this->limit";

        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite";
        // cekHere($q_2);
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        $arrDataLastApproved = array();
        $arrDataRaw = array();
        $arrDataNeedApproval = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrDataRaw[$id] = $arrKolom_nilai;

            if ($approvals_id > 0) {
                $arrDataLastApproved[$id] = $arrKolom_nilai;
            }
            else {
                $arrDataNeedApproval[$id] = $arrKolom_nilai;
            }
        }
        $arrData = $arrDataRaw;
        // $arrData['last_approved'] = $arrDataLastApproved;
        // $arrData['need_approval'] = $arrDataNeedApproval;

        return $arrData;
    }

    public function call_referensi($referensi_id, $transaksi_jenis = "")
    {
        $referensi_id < 1 ? mati_disini("reftransaksi_id harus berisi bilangan asli") : "";
        $arrKolom = $this->defkolom;
        // $condite =
        $list_kolom = implode(',', $arrKolom);

        $condite = "and referensi_id='$referensi_id'";
        if (strlen($transaksi_jenis) > 3) {
            $condite .= " and jenis='$transaksi_jenis'";
        }
        // $condite .= !isset($this->cabang_id) ? mati_disini("please cabang_id " . __FUNCTION__ . " harap di set") : " and cabang_id='" . $this->cabang_id . "'";
        // $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        // $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";

        // if((!isset($this->order)) || ($this->order === false)){
        //     $condite .= "";
        // }
        // else{
        //     is_array($this->order) ? "" : mati_disini("setOrder harus arau kolom desc/asc");
        //     foreach ($this->order as $itemKy => $itemVal) {
        //         $condite .= "order by $itemKy $itemVal";
        //     }
        // }
        // $condite .= (!isset($this->limit)) || ($this->limit === false) ? "" : " limit $this->limit";

        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite order by id desc";
        // cekHere($q_2 . "<hr>$transaksi_id");
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        $arrDataLastApproved = array();
        $arrDataRaw = array();
        $arrDataNeedApproval = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrDataRaw[$id] = $arrKolom_nilai;

            if ($approvals_id > 0) {
                $arrDataLastApproved[$id] = $arrKolom_nilai;
            }
            else {
                $arrDataNeedApproval[$id] = $arrKolom_nilai;
            }
        }

        $arrData = $arrDataRaw;


        return $arrData;
    }

    public function call_histori_return_penjualan()
    {
        $arrKolom_tambahan = array(
            "ekspedisi_id",
            "ekspedisi_nama",
        );
        $arrKolom = array_merge($this->defkolom, $arrKolom_tambahan);

        $list_kolom = implode(',', $arrKolom);

        // $condite = "and jenis='382k' and status='0' and trash='0'";
        $condite = "and jenis='982' and trash='0'";
        $condite .= !isset($this->cabang_id) ? mati_disini("please " . __FUNCTION__ . " harap di set :" . $this->cabang_id) : " and cabang_id='" . $this->cabang_id . "'";
        $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";
        if ((!isset($this->order)) || ($this->order === false)) {
            $condite .= "";
        }
        else {
            is_array($this->order) ? "" : mati_disini("setOrder harus arau kolom desc/asc");
            foreach ($this->order as $itemKy => $itemVal) {
                $condite .= "order by $itemKy $itemVal";
            }
        }
        $condite .= (!isset($this->limit)) || ($this->limit === false) ? "" : " limit $this->limit";


        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        // cekBiru("$q_2");
        $arrData = array();
        while ($l_2 = $this->db->get_row($x_2)) {
            $id = $l_2->id;
            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrData[$id] = $arrKolom_nilai;
        }

        return $arrData;
    }

    public function call_histori_req_return_penjualan()
    {
        $arrKolom_tambahan = array(
            "ekspedisi_id",
            "ekspedisi_nama",
        );
        $arrKolom = array_merge($this->defkolom, $arrKolom_tambahan);

        $list_kolom = implode(',', $arrKolom);

        // $condite = "and jenis='382k' and status='0' and trash='0'";
        $condite = "and jenis='982r' and trash='0'";
        $condite .= !isset($this->cabang_id) ? mati_disini("please " . __FUNCTION__ . " harap di set :" . $this->cabang_id) : " and cabang_id='" . $this->cabang_id . "'";
        $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";
        if ((!isset($this->order)) || ($this->order === false)) {
            $condite .= "";
        }
        else {
            is_array($this->order) ? "" : mati_disini("setOrder harus arau kolom desc/asc");
            foreach ($this->order as $itemKy => $itemVal) {
                $condite .= "order by $itemKy $itemVal";
            }
        }
        $condite .= (!isset($this->limit)) || ($this->limit === false) ? "" : " limit $this->limit";


        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        // cekBiru("$q_2");
        $arrData = array();
        while ($l_2 = $this->db->get_row($x_2)) {
            $id = $l_2->id;
            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrData[$id] = $arrKolom_nilai;
        }

        return $arrData;
    }

    public function call_histori_penerimaan_piutang()
    {
        $arrKolom_tambahan = array(
            "ekspedisi_id",
            "ekspedisi_nama",
        );
        $arrKolom = array_merge($this->defkolom, $arrKolom_tambahan);

        $list_kolom = implode(',', $arrKolom);

        // $condite = "and jenis='382k' and status='0' and trash='0'";
        $condite = "and jenis='349' and trash='0' and penerimaan='valas'";
        $condite .= !isset($this->cabang_id) ? mati_disini("please " . __FUNCTION__ . " harap di set :" . $this->cabang_id) : " and cabang_id='" . $this->cabang_id . "'";
        $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";
        if ((!isset($this->order)) || ($this->order === false)) {
            $condite .= "";
        }
        else {
            is_array($this->order) ? "" : mati_disini("setOrder harus arau kolom desc/asc");
            foreach ($this->order as $itemKy => $itemVal) {
                $condite .= "order by $itemKy $itemVal";
            }
        }
        $condite .= (!isset($this->limit)) || ($this->limit === false) ? "" : " limit $this->limit";


        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
//         cekBiru("$q_2");
        $arrData = array();
        while ($l_2 = $this->db->get_row($x_2)) {
            $id = $l_2->id;
            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrData[$id] = $arrKolom_nilai;
        }

        return $arrData;
    }

    public function call_supplies_jasa()
    {
        $arrKolom = $this->jasaKolom;

        $list_kolom = implode(',', $arrKolom);
        // "condite" => "and jenis='461' and status='0' and trash='0' and approvals_id='0' and cabang_id='$cabang_id'",
        $condite = "and jenis='461' and status='0' and tipe='1' and trash='0'";
        $condite .= !isset($this->cabang_id) ? mati_disini("please " . __FUNCTION__ . " harap di set") : " and cabang_id='" . $this->cabang_id . "'";
        $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";

        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite";
        // cekHere($q_2);
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        $arrDataLastApproved = array();
        $arrDataRaw = array();
        $arrDataNeedApproval = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrDataRaw[$id] = $arrKolom_nilai;

            if ($approvals_id > 0) {
                $arrDataLastApproved[$id] = $arrKolom_nilai;
            }
            else {
                $arrDataNeedApproval[$id] = $arrKolom_nilai;
            }
        }
        $arrData = $arrDataRaw;
        $arrData['last_approved'] = $arrDataLastApproved;
        $arrData['need_approval'] = $arrDataNeedApproval;

        return $arrData;
    }

    public function call_history_supplies_jasa()
    {
        $arrKolom = $this->jasaKolom;
        // $condite =
        $list_kolom = implode(',', $arrKolom);

        $condite = "and jenis='461' and trash='0' and tipe='1'";
        $condite .= !isset($this->cabang_id) ? mati_disini("please " . __FUNCTION__ . " harap di set") : " and cabang_id='" . $this->cabang_id . "'";
        $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";

        if ((!isset($this->order)) || ($this->order === false)) {
            $condite .= "";
        }
        else {
            is_array($this->order) ? "" : mati_disini("setOrder harus arau kolom desc/asc");
            foreach ($this->order as $itemKy => $itemVal) {
                $condite .= "order by $itemKy $itemVal";
            }
        }
        $condite .= (!isset($this->limit)) || ($this->limit === false) ? "" : " limit $this->limit";

        // $condite .= " order by approvals_dtime asc";
        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite";
        // cekHere($q_2);
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        $arrDataLastApproved = array();
        $arrDataRaw = array();
        $arrDataNeedApproval = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrDataRaw[$id] = $arrKolom_nilai;

            if ($approvals_id > 0) {
                $arrDataLastApproved[$id] = $arrKolom_nilai;
            }
            else {
                $arrDataNeedApproval[$id] = $arrKolom_nilai;
            }
        }
        $arrData['row'] = $arrDataRaw;
        $arrData['approved'] = $arrDataLastApproved;
        $arrData['need_approval'] = $arrDataNeedApproval;

        return $arrData;
    }

    public function call_referensi_all($transaksi_jenis)
    {
        // $referensi_id < 1 ? mati_disini("reftransaksi_id harus berisi bilangan asli") : "";
        // $arrKolom = $this->defkolom;
        $arrKolom = array("id", "referensi_id", "jenis");
        // $condite =
        $list_kolom = implode(',', $arrKolom);

        // $condite = "and referensi_id='$referensi_id'";
        if (strlen($transaksi_jenis) > 3) {
            // $condite .= " and jenis='$transaksi_jenis'";
        }
        else {
            mati_disini("transaksi_jenis harap diisi " . __FUNCTION__);
        }
        // $condite .= !isset($this->cabang_id) ? mati_disini("please cabang_id " . __FUNCTION__ . " harap di set") : " and cabang_id='" . $this->cabang_id . "'";
        // $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        // $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";

        // if((!isset($this->order)) || ($this->order === false)){
        //     $condite .= "";
        // }
        // else{
        //     is_array($this->order) ? "" : mati_disini("setOrder harus arau kolom desc/asc");
        //     foreach ($this->order as $itemKy => $itemVal) {
        //         $condite .= "order by $itemKy $itemVal";
        //     }
        // }
        // $condite .= (!isset($this->limit)) || ($this->limit === false) ? "" : " limit $this->limit";

        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite order by id desc";
        // cekHere($q_2 . "<hr>$transaksi_id");
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        $arrDataLastApproved = array();
        $arrDataRaw = array();
        $arrDataNeedApproval = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            // $arrDataRaw[$id] = $arrKolom_nilai;
            if ($referensi_id > 0) {

                // $arrDataRaw[$referensi_id][$jenis][] = $arrKolom_nilai;
                $arrDataRaw[$referensi_id][$id] = $jenis;
            }

            if ($referensi_id == $id) {
                $arrDataLastApproved[$id][] = $arrKolom_nilai;
            }
            else {
                $arrDataNeedApproval[$id] = $arrKolom_nilai;
            }
        }

        $arrData = $arrDataRaw;


        // return $arrDataLastApproved;
        return $arrData;
    }

    public function call_so_582()
    {
        // $referensi_id < 1 ? mati_disini("reftransaksi_id harus berisi bilangan asli") : "";
        $arrKolom = $this->defkolom;
        $transaksi_jenis = "382";
        // $arrKolom = array("id","referensi_id","jenis");
        // $condite =
        $list_kolom = implode(',', $arrKolom);

        // $condite = "and referensi_id='$referensi_id'";
        // if (strlen($transaksi_jenis) > 3) {
        $condite = " and jenis='$transaksi_jenis'";
        // }
        // else {
        //     mati_disini("transaksi_jenis harap diisi " . __FUNCTION__);
        // }
        // $condite .= !isset($this->cabang_id) ? mati_disini("please cabang_id " . __FUNCTION__ . " harap di set") : " and cabang_id='" . $this->cabang_id . "'";
        // $condite .= (!isset($this->employee_id)) || ($this->employee_id === false) ? "" : " and oleh_id='" . $this->employee_id . "'";
        // $condite .= (!isset($this->tanggal)) || ($this->tanggal === false) ? "" : " and date(dtime)='" . $this->tanggal . "'";

        // if((!isset($this->order)) || ($this->order === false)){
        //     $condite .= "";
        // }
        // else{
        //     is_array($this->order) ? "" : mati_disini("setOrder harus arau kolom desc/asc");
        //     foreach ($this->order as $itemKy => $itemVal) {
        //         $condite .= "order by $itemKy $itemVal";
        //     }
        // }
        // $condite .= (!isset($this->limit)) || ($this->limit === false) ? "" : " limit $this->limit";

        $q_2 = "select $list_kolom from $this->tblparent where 1 $condite order by id desc";
        // cekHere($q_2 . "<hr>$transaksi_id");
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        $arrDataRaw = array();
        $arrData582_0 = array();
        $arrData582_1 = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrDataRaw[$id] = $arrKolom_nilai;

            if ($status == 0) {

                $arrData582_0[$id] = $referensi_id;
            }
            else {
                $arrData582_1[$id] = $referensi_id;
            }

        }

        $arrData['raw'] = $arrDataRaw;
        $arrData['582_0'] = $arrData582_0;
        $arrData['582_1'] = $arrData582_1;


        // return $arrDataLastApproved;
        return $arrData;
    }
}