<?php

/**
 * Created by PhpStorm.
 * User: thomas
 * Date: 16/06/18
 * Time: 17:00
 */
class Diskon
{
    protected $cabang_id;
    protected $produk_id;
    protected $customer_id;
    protected $jenis;
    protected $jenis_diskon_kategori;
    protected $nilai;
    protected $urutan;
    protected $data_id;
    protected $parent_id;

    public function setProdukId($produk_id)
    {
        $this->produk_id = $produk_id;
    }

    public function setCustomerId($customer_id)
    {
        $this->customer_id = $customer_id;
    }

    public function setDataId($data_id)
    {
        $this->data_id = $data_id;
    }

    public function setParentId($parent_id)
    {
        $this->parent_id = $parent_id;
    }

    public function setUrutan($urutan)
    {
        $this->urutan = $urutan;
    }

    public function setJenisDiskonKategori($jenis_diskon_kategori)
    {
        $this->jenis_diskon_kategori = $jenis_diskon_kategori;
    }

    //region gerter setter
    public function setJenis($jenis)
    {
        $this->jenis = $jenis;
    }

    public function setNilai($nilai)
    {
        $this->nilai = $nilai;
    }

    public function setCabangId($cabang_id)
    {
        $this->cabang_id = $cabang_id;
    }

    //endregion

    function __construct()
    {
        $this->db = New _00_DBclass();
        !$this->db->connect() ? die($this->db->display_errors()) : "";

        $this->tbl = "diskon";
        $this->tbl_dcustomer = "diskon_customer";
        $this->tbl_dkategori = "diskon_kategori";

        $this->crud = New Crud();
        $this->produk_qty = "produk_qty";
        $this->kategori = "diskon_kategori";
        $this->field_list = (object)array(
            "produk_qty" => array(
                "id",
                "cabang_id",
                "harga",
                "nilai",
                "persen",
                "produk_id",
                "minim",
                "maxim",
                "urutan",
            ),
            "diskon_kategori" => array(
                "id",
                "persen",
                "produk_id",
                "minim",
                "maxim",
                "urutan",
                "cabang_id",
            ),

        );
    }

    /*
 id
 jenis
 produk_id
 cabang_id
 nilai
 persen
 dtime
 status
 author
 alasan
 */
    public function setDiskonProduk($arrParam)
    {
        $cabang_id = isset($this->cabang_id) ? $this->cabang_id : mati_disini("cabang_id harap diset dulu " . __LINE__ . " " . __FUNCTION__);
        $produk_id = isset($this->produk_id) ? $this->produk_id : mati_disini("produk_id harap diset dulu " . __LINE__ . " " . __FUNCTION__);
        $jenis = isset($this->jenis) ? $this->jenis : mati_disini("jenis harap diset dulu " . __LINE__ . " " . __FUNCTION__);
        $sesId = sesId();
        $tbl = $tbl_4 = $this->tbl;
        $c = $this->crud;
        !is_array($arrParam) ? mati_disini("harus array array(produk_harga, diskon_nilai)") : "";

        $q = "select id,status,persen from $tbl where produk_id='$produk_id' and cabang_id='$cabang_id' order by id desc limit 1";
        $x = $this->db->select($q);
        $l = $this->db->get_row($x);
        !$x ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        $j = $this->db->select($q, true);

        //                $parent_id = $l->id;
        //arrPrint($arrParam);
        $produk_harga = $arrParam['produk_harga'];
        $live_val = $arrParam['diskon_nilai'];
        //        cekHere(__LINE__ . " $q<hr>$prouduk_harga $live_val");
        if ($j == 1) {
            $id = $l->id;
            $status = $l->status;
            $nilai_db = $l->nilai;
            $persen_db = $l->persen;

            switch ($jenis) {
                case "nilai":
                    $persen_0 = ($live_val / $produk_harga) * 100;
                    $persen = round($persen_0, 2);
                    $nilai = $live_val;
                    break;
                case "persen":
                    $persen_0 = $live_val / $produk_harga;
                    $persen = round($live_val, 2);
                    $nilai = $produk_harga * ($live_val / 100);
                    break;
            }

            if (($persen_db != $persen) || ($nilai_db != $nilai)) {
                // region update status 1
                $arrUpdate = array(
                    "status" => 0,
                );
                $c->setTbl($tbl);
                $c->setConditional("where id='$id'");
                $c->setCreate($arrUpdate, false);
                // endregion update status 1

                //region insert diskon yg baru
                $arrInsert = array(
                    "jenis" => "produk",
                    "produk_id" => $produk_id,
                    "cabang_id" => $cabang_id,
                    "harga" => $produk_harga,
                    "persen" => $persen,
                    "nilai" => $nilai,
                    "status" => 1,
                    "author" => $sesId,
                );
                //                                        arrPrint($arrInsert);
                //                    mati_disini();
                //                    $c->setTbl($tbl);
                $c->setConditional("");
                $c->setCreate($arrInsert);
                //endregion
            }
            else {
                mati_disini("tidak ada update diskon == $persen_db != $persen");
            }
        }
        else {

            switch ($jenis) {
                case "nilai":
                    $persen_0 = $live_val / $produk_harga;
                    $persen = round($persen_0, 2);
                    $nilai = $live_val;
                    break;
                case "persen":
                    $persen_0 = $live_val / $produk_harga;
                    $persen = round($live_val, 2);
                    $nilai = $produk_harga * ($live_val / 100);
                    break;
            }

            // mati_disini("$persen = $live_val / $produk_harga");
            $arrInsert = array(
                "jenis" => "produk",
                "produk_id" => $produk_id,
                "cabang_id" => $cabang_id,
                "harga" => $produk_harga,
                "persen" => $persen,
                "nilai" => $nilai,
                "status" => 1,
                "author" => $sesId,
            );
            // arrPrint($arrInsert);
            //mati_disini();
            $c->setTbl($tbl);
            $c->setCreate($arrInsert);
        }
    }

    public function callDiskonProduk($produk_id = "")
    {

        $tbl_4 = $this->tbl;
        $arrKolom = array(
            "id",
            "cabang_id",
            "nilai",
            "persen",
        );
        $kolom_list = implode(',', $arrKolom);
        $conditional = "where jenis='produk' and status='1'";
        if ($produk_id == "") {
            $conditional .= "";
        }
        else {
            $conditional .= " and produk_id='$produk_id'";
        }

        $q_4 = "select $kolom_list from $tbl_4 $conditional";
        //        echo "$q_4";
        $x_4 = $this->db->select($q_4);
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $j_4 = $this->db->select($q_4, true);

        // endregion cek log_notif

        $arrData = array();
        //        if($produk_id == ""){
        //
        //        }
        while ($l_4 = $this->db->get_row($x_4)) {
            $arrDataKolom = array();
            $id = $l_4->id;
            foreach ($arrKolom as $kolom) {
                //                $$kolom = $l_4->$kolom;
                $arrDataKolom[$kolom] = $l_4->$kolom;
            }

            $arrData[$id] = $arrDataKolom;
        }

        return $arrData;
    }

    public function callDiskonProdukCabang($produk_id = "")
    {
        $cabang_id = isset($this->cabang_id) ? $this->cabang_id : mati_disini("cabang_id harap diset dulu " . __LINE__ . " " . __FUNCTION__);
        $tbl_4 = $this->tbl;
        $arrKolom = array(
            "id",
            "nilai",
            "persen",

        );
        $kolom_list = implode(',', $arrKolom);
        $conditional = "where jenis='produk' and status='1'";
        if ($produk_id == "") {
            $conditional .= " and cabang_id='$cabang_id'";
        }
        else {
            $conditional .= " and cabang_id='$cabang_id' and produk_id='$produk_id'";
        }

        $q_4 = "select $kolom_list from $tbl_4 $conditional";
        echo "$q_4";
        $x_4 = $this->db->select($q_4);
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $j_4 = $this->db->select($q_4, true);

        // endregion cek log_notif

        $arrData = array();
        //        if($produk_id == ""){
        //
        //        }
        while ($l_4 = $this->db->get_row($x_4)) {
            $arrDataKolom = array();
            $id = $l_4->id;
            foreach ($arrKolom as $kolom) {
                //                $$kolom = $l_4->$kolom;
                $arrDataKolom[$kolom] = $l_4->$kolom;
            }
            if ($produk_id > 0) {
                return $arrDataKolom;
            }

            $arrData[$id] = $arrDataKolom;
        }
        if ($produk_id == 0) {
            return $arrData;
        }
    }


    public function setDiskonPenjualan($arrParam)
    {

        $cabang_id = isset($this->cabang_id) ? $this->cabang_id : mati_disini("cabang_id harap diset dulu " . __LINE__ . " " . __FUNCTION__);
        $produk_id = isset($this->produk_id) ? $this->produk_id : mati_disini("produk_id untuk penjualan #? " . __LINE__ . " " . __FUNCTION__);
        // $jenis = isset($this->jenis) ? $this->jenis : mati_disini("jenis harap diset dulu " . __LINE__ . " " . __FUNCTION__);

        $tbl = $tbl_4 = $this->tbl;
        $c = $this->crud;
        !is_array($arrParam) ? mati_disini("harus array array(produk_harga, diskon_nilai)") : "";

        $q = "select id,status,persen,harga from $tbl where jenis='penjualan' and cabang_id='$cabang_id' and produk_id='$produk_id' and status='1' order by id desc limit 1";
        $x = $this->db->select($q);
        $l = $this->db->get_row($x);
        !$x ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        $j = $this->db->select($q, true);

        if ($j == 1) {
            $id = $l->id;
            $status = $l->status;
            $nilai_db = $l->nilai;
            $harga_db = $l->harga;
            $persen_db = $l->persen;
            if (($harga_db != $arrParam['harga']) || ($persen_db != $arrParam['persen'])) {
                $arrUpdate = array(
                    "status" => 0,
                );
                $c->setTbl($tbl);
                $c->setConditional("where id='$id'");
                $c->setCreate($arrUpdate, false);

                $arrStatic = array(
                    "jenis" => "penjualan",
                    "produk_id" => $produk_id,
                    "cabang_id" => $cabang_id,
                    // "harga" => $produk_harga,
                    // "persen" => $persen,
                    // "nilai" => $nilai,
                    "status" => 1,
                    "author" => sesId(),
                );

                $arrInsert = array_merge($arrStatic, $arrParam);

                $c->setConditional("");
                $c->setCreate($arrInsert);
            }
            else {
                cekHere("masuk sini " . __FILE__ . __LINE__);
            }

        }
        else {
            $arrStatic = array(
                "jenis" => "penjualan",
                "produk_id" => $produk_id,
                "cabang_id" => $cabang_id,
                // "harga" => $penjualan_nilai,
                // "persen" => $diskon_persen,
                // "nilai" => $diskon_nilai,
                "status" => 1,
                "author" => sesId(),
            );

            $arrInsert = array_merge($arrStatic, $arrParam);
            // arrPrint($arrInsert);
            //mati_disini();
            $c->setTbl($tbl);
            $c->setCreate($arrInsert);

        }
    }

    public function callDiskonPenjualan($kondisi_ke = "")
    {
        $tbl_4 = $this->tbl;
        $arrKolom = array(
            "id",
            "cabang_id",
            "harga",
            "nilai",
            "persen",
            "produk_id",
        );
        $kolom_list = implode(',', $arrKolom);
        $conditional = "where jenis='penjualan' and status='1' order by harga asc";
        if ($kondisi_ke == "") {
            $conditional .= "";
        }
        else {
            $conditional .= " and produk_id='$kondisi_ke'";
        }

        $q_4 = "select $kolom_list from $tbl_4 $conditional";
        //        echo "$q_4";
        $x_4 = $this->db->select($q_4);
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $j_4 = $this->db->select($q_4, true);

        // endregion cek log_notif


        //        if($produk_id == ""){
        //
        //        }
        $arrData = array();
        if ($j_4 > 0) {
            while ($l_4 = $this->db->get_row($x_4)) {
                $arrDataKolom = array();
                $id = $l_4->id;
                foreach ($arrKolom as $kolom) {
                    //                $$kolom = $l_4->$kolom;
                    $arrDataKolom[$kolom] = $l_4->$kolom;
                }

                $arrData[$id] = $arrDataKolom;
            }
        }
        else {
            $arrData = array();
        }

        return $arrData;
    }

    public function callDiskonPenjualanF()
    {
        $arrData = array();
        foreach ($this->callDiskonPenjualan() as $ky => $arrItem) {
            $cb_id = $arrItem['cabang_id'];
            $pr_id = $arrItem['produk_id'];
            // $db_harga = $arrItem['harga'];
            // $db_persen = $arrItem['persen'];

            $arrData[$cb_id][$pr_id]["harga"] = $arrItem['harga'];
            $arrData[$cb_id][$pr_id]["persen"] = $arrItem['persen'];
        }

        return $arrData;
    }

    public function callDiskonPenjualanCabang($cabang_id)
    {
        $cabang_id = CB_ID_PUSAT;
        $arrDiskon_tambahan = array();
        if (sizeof($this->callDiskonPenjualanF()[$cabang_id]) > 0) {

            foreach ($this->callDiskonPenjualanF()[$cabang_id] as $kondisi => $arrDisc_penjualan) {
                $sett_penjualan_nilai = formatAngkaClean($arrDisc_penjualan['harga']);
                $sett_penjualan_diskon = formatAngkaClean($arrDisc_penjualan['persen']);

                $arrDiskon_tambahan[$sett_penjualan_nilai] = $sett_penjualan_diskon;

            }
        }

        return $arrDiskon_tambahan;
    }

    public function callDiskonRangePenjualanCabang($cabang_id)
    {
        $cabang_id = CB_ID_PUSAT;
        $diskon_penjualan = $this->callDiskonPenjualanCabang($cabang_id);

        $jml_kondisi = count($diskon_penjualan);

        $arrMax_penjualan = array_keys($diskon_penjualan);
        // arrPrint($arrMax_penjualan);
        $start = 0;
        $end = $jml_kondisi;
        $arrRangePenjualan = array();
        for ($i = $start; $i < $end; $i++) {
            $ii = $i + 1;

            $arrRangePenjualan[$i]['min'] = $arrMax_penjualan[$i];
            $arrRangePenjualan[$i]['max'] = $arrMax_penjualan[$ii];
            $arrRangePenjualan[$i]['disc'] = $diskon_penjualan[$arrMax_penjualan[$i]];
            //do something with array
        }

        return $arrRangePenjualan;
    }


    public function setDiskonPenjualanQty($arrParam)
    {

        $cabang_id = isset($this->cabang_id) ? $this->cabang_id : mati_disini("cabang_id harap diset dulu " . __LINE__ . " " . __FUNCTION__);
        $produk_id = isset($this->produk_id) ? $this->produk_id : mati_disini("produk_id untuk penjualan #? " . __LINE__ . " " . __FUNCTION__);
        $urutan = isset($this->urutan) ? $this->urutan : mati_disini("urutan untuk diskonQty #? " . __LINE__ . " " . __FUNCTION__);
        // $jenis = isset($this->jenis) ? $this->jenis : mati_disini("jenis harap diset dulu " . __LINE__ . " " . __FUNCTION__);

        $tbl = $tbl_4 = $this->tbl;
        $jenis = $this->produk_qty;
        $arrKolom = $this->field_list->$jenis;
        $kolom_list = implode(',', $arrKolom);
        $c = $this->crud;
        !is_array($arrParam) ? mati_disini("harus array array(produk_harga, diskon_nilai)") : "";

        $q = "select $kolom_list from $tbl where jenis='$jenis' and cabang_id='$cabang_id' and produk_id='$produk_id' and urutan='$urutan' and status='1'";
        $x = $this->db->select($q);
        $l = $this->db->get_row($x);
        !$x ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        $j = $this->db->select($q, true);

        // region insert_data
        $arrStatic = array(
            "jenis" => $jenis,
            "produk_id" => $produk_id,
            "cabang_id" => $cabang_id,
            "urutan" => $urutan,
            // "harga" => $produk_harga,
            // "persen" => $persen,
            // "nilai" => $nilai,
            "status" => 1,
            "author" => sesId(),
        );

        $arrInsert = array_merge($arrStatic, $arrParam);
        // endregion insert_data

        if ($j >= 1) {
            $id = $l->id;
            $status = $l->status;
            $nilai_db = $l->nilai;
            $harga_db = $l->harga;
            $urutan_db = $l->urutan;

            if ($harga_db != $arrParam['harga']) {
                $arrUpdate = array(
                    "status" => 0,
                );
                $c->setTbl($tbl);
                $c->setConditional("where cabang_id='$cabang_id' and produk_id='$produk_id' and status='1'");
                // $c->setConditional("where cabang_id='$cabang_id' and id='$id'");
                $c->setCreate($arrUpdate, false);


                $c->setConditional("");
                $c->setCreate($arrInsert);
            }
            else {
            }

        }
        else {
            //                                arrPrint($arrInsert);
            //mati_disini();
            $c->setTbl($tbl);
            $c->setCreate($arrInsert);

        }
    }

    public function callDiskonPenjualanQty($cabang_id = "")
    {
        $tbl_4 = $this->tbl;
        $jenis = $this->produk_qty;
        $arrKolom = $this->field_list->$jenis;

        $kolom_list = implode(',', $arrKolom);

        $conditional = "where jenis='$jenis' and status='1'";
        if ($cabang_id == 0) {
            $conditional .= "";
        }
        else {
            $conditional .= " and cabang_id='$cabang_id'";
        }
        $conditional .= " order by urutan asc";

        $q_4 = "select $kolom_list from $tbl_4 $conditional";
        // cekHere("$q_4");
        $x_4 = $this->db->select($q_4);
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $j_4 = $this->db->select($q_4, true);

        $arrData = array();
        if ($j_4 > 0) {
            while ($l_4 = $this->db->get_row($x_4)) {
                $arrDataKolom = array();
                $id = $l_4->id;
                foreach ($arrKolom as $kolom) {
                    //                $$kolom = $l_4->$kolom;
                    $arrDataKolom[$kolom] = $l_4->$kolom;
                }

                $arrData[$id] = $arrDataKolom;
            }
        }
        else {
            $arrData = array();
        }

        return $arrData;
    }

    public function callDiskonPenjualanQtyProduk()
    {
        $cabang_id = isset($this->cabang_id) ? $this->cabang_id : "";
        $arrData = array();
        if (sizeof($arrDataSource = $this->callDiskonPenjualanQty($cabang_id)) > 0) {

            foreach ($arrDataSource as $itemData) {

                $cabang_id = $itemData['cabang_id'];
                $produk_id = $itemData['produk_id'];

                $arrSpec = array(
                    "min" => $itemData['minim'],
                    "max" => $itemData['maxim'],
                    "disc" => $itemData['persen'],
                    "harga" => $itemData['harga'],
                    "nilai" => $itemData['nilai'],
                    "db_id" => $itemData['id'],
                    // "urutan" => $itemData['urutan'],
                );

                $arrData[$cabang_id][$produk_id][] = $arrSpec;
            }
        }

        return $arrData;
    }

    public function DelDiskonPenjualanQty()
    {
        $cabang_id = isset($this->cabang_id) ? $this->cabang_id : mati_disini("cabang_id harap diset dulu " . __LINE__ . " " . __FUNCTION__);
        $produk_id = isset($this->produk_id) ? $this->produk_id : mati_disini("produk_id untuk penjualan #? " . __LINE__ . " " . __FUNCTION__);
        $urutan = isset($this->urutan) ? $this->urutan : mati_disini("urutan untuk diskonQty #? " . __LINE__ . " " . __FUNCTION__);

        $tbl = $tbl_4 = $this->tbl;
        $jenis = $this->produk_qty;
        $arrKolom = $this->field_list->$jenis;
        // $kolom_list = implode(',', $arrKolom);
        $c = $this->crud;

        if ($cabang_id == 0) {
            matiHere("cabang id tidak terdeteksi ");
        }

        $arrUpdate = array(
            "status" => 0,
        );
        $c->setTbl($tbl);
        $c->setConditional("where cabang_id='$cabang_id' and produk_id='$produk_id' and status='1' and urutan='$urutan'");
        // $c->setConditional("where cabang_id='$cabang_id' and id='$id'");
        $c->setCreate($arrUpdate, false);

    }


    public function setDiskonKategori()
    {

    }

    public function addDiskonKategori($arrData)
    {
        $jenis = isset($this->jenis_diskon_kategori) ? $this->jenis_diskon_kategori : matiHere("jenis_diskon_kategori harap di set (parent/child)");

        // $jenis = "child";
        $tbl_2 = "diskon_kategori";
        $c = $this->crud;
        // region edit diskon kategori
        switch ($jenis) {
            case "parent":
                $c->setTbl($tbl_2);
                $c->setConditional("where id='$data_id'");
                $c->setCreate($arrData, false);
                break;
            case "child":
                $parent_id = isset($this->parent_id) ? $this->parent_id : matiHere("parent_id harap di set dulu");
                $arrFix = array(
                    "parent_id" => $parent_id,
                    "jenis" => $jenis,
                );

                $arrData = array_merge($arrData, $arrFix);
                $c->setTbl($tbl_2);
                $c->setCreate($arrData);
                break;
            default:
                matiHere(__LINE__ . " " . __FILE__);
                break;
        }
        // endregion edit diskon kategori


    }

    public function editDiskonKategori($arrData)
    {

        $data_id = isset($this->data_id) ? $this->data_id : matiHere("data_kategori harap di set ");
        $jenis = isset($this->jenis_diskon_kategori) ? $this->jenis_diskon_kategori : matiHere("jenis_diskon_kategori harap di set (parent/child)");
        $tbl_2 = "diskon_kategori";
        $tbl = $this->tbl;
        $diskon_jenis = $this->kategori;
        $c = $this->crud;
        // $arrParam =
        if (sizeof($arrData) > 0) {
            // region edit diskon kategori
            switch ($jenis) {
                case "parent":
                    $c->setTbl($tbl_2);
                    $c->setConditional("where id='$data_id'");
                    $c->setCreate($arrData, false);
                    break;
                case "child":
                    $c->setTbl($tbl_2);
                    $c->setConditional("where id='$data_id'");
                    $c->setCreate($arrData, false);
                    break;
                default:
                    matiHere(__LINE__ . " " . __FILE__);
                    break;
            }
            // endregion edit diskon kategori


            $arrData['produk_id'] = $data_id;
            // $arrData['nama'] = $data_id;
            // $arrParam = $arrData;


            // region history diskon kategori
            $q = "select id,status,persen,harga,nama from $tbl where jenis='$diskon_jenis' and produk_id='$data_id' and status='1' order by id desc limit 1";
            cekHijau($q);
            $x = $this->db->select($q);
            $l = $this->db->get_row($x);
            !$x ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
            $j = $this->db->select($q, true);

            if ($j == 1) {
                $id = $l->id;
                $status = $l->status;
                $nilai_db = $l->nilai;
                $harga_db = $l->harga;
                $persen_db = $l->persen;
                $nama_db = $l->nama;
                $minim_db = $l->minim;
                $maxim_db = $l->maxim;

                // $arrLama = array("persen" => $persen_db, "nama" =>$nama_db);
                $arrLama = array(
                    "persen" => $persen_db,
                    "nama" => $nama_db,
                    "minim" => $minim_db,
                    "maxim" => $maxim_db,
                );
                $arrParam = array_merge($arrLama, $arrData);
                arrPrint($arrLama);
                arrPrint($arrParam);
                // matiHere();
                cekHere($id);
                if (($harga_db != $arrParam['harga']) || ($persen_db != $arrParam['persen'])) {
                    $arrUpdate = array(
                        "status" => 0,
                    );
                    $c->setTbl($tbl);
                    $c->setConditional("where id='$id'");
                    $c->setCreate($arrUpdate, false);

                    $arrStatic = array(
                        "jenis" => $diskon_jenis,
                        "produk_id" => $data_id,
                        "status" => 1,
                        "author" => sesId(),
                    );

                    $arrInsert = array_merge($arrStatic, $arrParam);

                    $c->setConditional("");
                    $c->setCreate($arrInsert);
                }
                else {
                    cekHere("masuk sini " . __FILE__ . __LINE__);
                }
            }
            else {
                cekHere("kosong");
                $arrParam = $arrData;
                $arrStatic = array(
                    "jenis" => $diskon_jenis,
                    "produk_id" => $data_id,
                    "status" => 1,
                    "author" => sesId(),
                );

                $arrInsert = array_merge($arrStatic, $arrParam);
                arrPrint($arrInsert);
                //mati_disini();
                $c->setTbl($tbl);
                $c->setCreate($arrInsert);

            }

            // endregion history diskon kategori

            return true;
        }
        else {
            return false;
        }

    }

    public function callDiskonKategoriTrash()
    {
        $tbl_4 = "diskon_kategori";
        // $jenis = $this->produk_qty;
        $arrKolom = array(
            "id",
            "minim",
            "maxim",
            "jenis",
            "parent_id",
            "persen",
            "nama",
            "trash ",
        );

        $kolom_list = implode(',', $arrKolom);

        $conditional = "where trash='1'";
        // if ($cabang_id == 0) {
        //     $conditional .= "";
        // }
        // else {
        //     $conditional .= " and cabang_id='$cabang_id'";
        // }
        // $conditional .= " order by urutan asc";

        $q_4 = "select $kolom_list from $tbl_4 $conditional";
        // cekHere("$q_4");
        $x_4 = $this->db->select($q_4);
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $j_4 = $this->db->select($q_4, true);

        $arrData = array();
        if ($j_4 > 0) {
            $arrParent = array();
            $arrChild = array();
            while ($l_4 = $this->db->get_row($x_4)) {
                $arrDataKolom = array();
                $id = $l_4->id;
                foreach ($arrKolom as $kolom) {
                    $$kolom = $l_4->$kolom;
                    $arrDataKolom[$kolom] = $l_4->$kolom;
                }
                // cekHere("$parent_id");
                if ($parent_id == 0) {
                    $arrParent[] = $arrDataKolom;
                }
                if ($parent_id > 0) {
                    $arrChild[$parent_id][] = $arrDataKolom;
                }
            }
            $arrData['parent'] = $arrParent;
            $arrData['child'] = $arrChild;
            // cekHijau("kkk");
            // arrPrint($arrParent);
            // arrPrint($arrChild);


        }
        else {
            $arrData = array();
        }

        return $arrData;
    }

    public function callDiskonKategoriRaw()
    {
        $tbl_4 = "diskon_kategori";
        // $jenis = $this->produk_qty;
        $arrKolom = array(
            "id",
            "minim",
            "maxim",
            "jenis",
            "parent_id",
            "persen",
            "nama",
            "trash",
        );

        $kolom_list = implode(',', $arrKolom);

        $conditional = "where trash='0'";
        // if ($cabang_id == 0) {
        //     $conditional .= "";
        // }
        // else {
        //     $conditional .= " and cabang_id='$cabang_id'";
        // }
        // $conditional .= " order by urutan asc";

        $q_4 = "select $kolom_list from $tbl_4 $conditional";
        // cekHere("$q_4");
        $x_4 = $this->db->select($q_4);
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $j_4 = $this->db->select($q_4, true);

        $arrData = array();
        if ($j_4 > 0) {
            $arrParent = array();
            $arrChild = array();
            while ($l_4 = $this->db->get_row($x_4)) {
                $arrDataKolom = array();
                $id = $l_4->id;
                foreach ($arrKolom as $kolom) {
                    $$kolom = $l_4->$kolom;
                    $arrDataKolom[$kolom] = $l_4->$kolom;
                }
                // cekHere("$parent_id");
                if ($parent_id == 0) {
                    $arrParent[] = $arrDataKolom;
                }
                if ($parent_id > 0) {
                    $arrChild[$parent_id][] = $arrDataKolom;
                }
            }
            $arrData['parent'] = $arrParent;
            $arrData['child'] = $arrChild;
            // cekHijau("kkk");
            // arrPrint($arrParent);
            // arrPrint($arrChild);


        }
        else {
            $arrData = array();
        }

        return $arrData;
    }

    public function callDiskonKategori()
    {

        $arr = $this->callDiskonKategoriRaw();
        $arrParent = $arr['parent'];
        $arrChild = $arr['child'];

        $arrData = array();
        if (sizeof($arrParent) > 0) {
            foreach ($arrParent as $arrDParent) {
                $p_id = $arrDParent['id'];

                $arrData[$p_id]['nama'] = $arrDParent['nama'];
                $arrData[$p_id]['diskon'] = $arrDParent['persen'];
                $arrChildSpec = array();
                if (sizeof($arrChild[$p_id]) > 0) {

                    foreach ($arrChild[$p_id] as $arrDChild) {

                        $spec['minim'] = $arrDChild['minim'];
                        $spec['maxim'] = $arrDChild['maxim'];
                        $spec['diskon'] = $arrDChild['persen'];

                        $arrChildSpec[] = $spec;
                    }
                }
                else {
                    $arrChildSpec = array();
                }
                $arrData[$p_id]['child'] = $arrChildSpec;
            }

        }
        else {
            $arrData = array();
        }

        return $arrData;
    }


    public function setDiskonCustomerLast($arrData)
    {
        $customer_id = isset($this->customer_id) ? $this->customer_id : matiHere("customer Id belum di set");
        $produk_id = isset($this->produk_id) ? $this->produk_id : matiHere("tentukan [roduk id dolu ya");

        $q = "select $kolom_list from $tbl where jenis='$jenis' and cabang_id='$cabang_id' and produk_id='$produk_id' and urutan='$urutan' and status='1'";
        $x = $this->db->select($q);
        $l = $this->db->get_row($x);
        !$x ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";
        $j = $this->db->select($q, true);

        $this->crud->setTbl($this->tbl_dcustomer);
        $this->crud->setCreate($arrData);
    }

    public function callLastDiskoncustomer($customer_id)
    {
        $tbl_4 = $this->tbl_dcustomer;
        // $jenis = $this->produk_qty;
        $arrKolom = array(
            "id",
            "produk_id",
            "produk_jml",
            "diskon",
            "transaksi_id",
        );

        $kolom_list = implode(',', $arrKolom);

        $conditional = "where status='1'";
        if ($customer_id > 0) {
            $conditional .= " and customer_id='$customer_id'";
        }
        else {
            $conditional .= "";
        }
        // $conditional .= " order by urutan asc";

        $q_4 = "select $kolom_list from $tbl_4 $conditional";
        // cekHere("$q_4");
        $x_4 = $this->db->select($q_4);
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $j_4 = $this->db->select($q_4, true);

        $arrData = array();
        if ($j_4 > 0) {
            $arrParent = array();
            $arrChild = array();
            while ($l_4 = $this->db->get_row($x_4)) {
                $arrDataKolom = array();
                // $id = $l_4->id;
                foreach ($arrKolom as $kolom) {
                    $$kolom = $l_4->$kolom;
                    $arrDataKolom[$kolom] = $l_4->$kolom;
                }
                // cekHere("$produk_id");

                $arrChild[$produk_id] = $arrDataKolom;

            }
            if ($customer_id > 0) {

                $arrData = $arrChild;
            }
            else {
                $arrData[$customer_id] = $arrChild;
            }

        }
        else {
            $arrData = array();
        }

        return $arrData;
    }
} 