<?php

/**
 * Created by PhpStorm.
 * User: widi
 * Date: 6/8/2019
 * Time: 10:10 PM
 */
class DetilMutasi
{

    private $jenis;
    private $cabang_id;
    private $selected_date;
    private $kolom_alias;
    private $formatCollom=array(
        "unit_be" => "class='text-right'",
        "unit_in" => "class='text-right'",
        "unit_ot" => "class='text-right'",
        "unit_af" => "class='text-right'",
        "nilai_be" => "class='text-right'",
        "nilai_in" => "class='text-right'",
        "nilai_ot" => "class='text-right'",
        "nilai_af" => "class='text-right'"
    );


    public function getFormatCollom()
    {
        return $this->formatCollom;
    }

    public function setFormatCollom($formatCollom)
    {
        $this->formatCollom = $formatCollom;
    }


    public function callCollom($jenis){
//        cekHere("$jenis");
        switch ($jenis){
            default:
                $cool = array(
                    "dtime" => "Tanggal",
                    "transaksi_no" => "Invoice",
//                    "unit_be" => "PREV",
//                    "unit_in" => "IN",
//                    "unit_ot" => "OUT",
//                    "unit_af" => "LAST",
                    "nilai_be" => "PREV(IDR)",
                    "nilai_in" => "IN(IDR)",
                    "nilai_ot" => "OUT(IDR)",
                    "nilai_af" => "BALANCE(IDR)"
                );
                break;
//            case "piutang valas":
            case "persediaan supplies":
            case "persediaan produk":
                $cool = array(
                    "dtime" => "Tanggal",
                    "transaksi_no" => "Invoice",
                    "unit_be" => "PREV",
                    "unit_in" => "IN",
                    "unit_ot" => "OUT",
                    "unit_af" => "LAST",
                    "nilai_be" => "PREV(IDR)",
                    "nilai_in" => "IN(IDR)",
                    "nilai_ot" => "OUT(IDR)",
                    "nilai_af" => "BALANCE(IDR)"
                );
                break;
        }
        return $this->kolom_alias= $cool;
    }




    public function getKolomAlias()
    {
        return $this->kolom_alias;
    }

    public function setKolomAlias($kolom_alias)
    {
        $this->kolom_alias = $kolom_alias;
    }

    //region GS
    public function getJenis()
    {
        return $this->jenis;
    }

    public function setJenis($jenis)
    {
        $this->jenis = $jenis;
    }

    public function getCabangId()
    {
        return $this->cabang_id;
    }


    public function setCabangId($cabang_id)
    {
        $this->cabang_id = $cabang_id;
    }


    public function getSelectedDate()
    {
        return $this->selected_date;
    }


    public function setSelectedDate($selected_date)
    {
        $this->selected_date = $selected_date;
    }
    //endregion
    function __construct()
    {
        $this->db = New _00_DBclass();
        $this->db->connect();

        $this->selected_table = array(
            "kas"=> "rek_kas_pembantu",
            "piutang dagang" => "rek_piutang_customer",
            "piutang cabang" => "rek_piutang_cabang",
            "hutang dagang" => "rek_hutang_supplier",
            "hutang ke konsumen" => "rek_hutang_ke_konsumen_pembantu",
            "persediaan produk" => "rek_persediaan_produk",
            "persediaan supplies" => "rek_persediaan_produk_supplies",
            "piutang valas" => "rek_piutang_valas_customer",
            "hutang biaya" => "rek_hutang_biaya_pembantu",
        );

//        $this->kolom_alias= array(
//            "dtime" => "Tanggal",
////            "transaksi_jenis" => "Jenis",
//
//            "transaksi_no" => "Invoice",
//            "unit_be" => "PREV",
//            "unit_in" => "IN",
//            "unit_ot" => "OUT",
//            "unit_af" => "LAST",
//            "nilai_be" => "PREV(IDR)",
//            "nilai_in" => "IN(IDR)",
//            "nilai_ot" => "OUT(IDR)",
//            "nilai_af" => "BALANCE(IDR)"
//        );
        $this->tranformValue = array(
            "dtime" => "formatTanggal",
            "transaksi_jenis" => "",
            "transaksi_no" => "formatTransNomer",
            "nilai_be" => "formatAngka",
            "nilai_in" => "formatAngka",
            "nilai_ot" => "formatAngka",
            "nilai_af" => "formatAngka"
        );
    }

    public function callData($condite){
        $db1 = New _01_DBclass();
        !$db1->connect() ? $db1->display_errors(__FILE__ . " no " . __LINE__) : "";
        $selectedTable = $this->selected_table;

        $jenis = !isset($this->jenis) ? matiHere("jenis belum diset! Line: ".__LINE__) : $this->jenis;
        $cabang_id = !isset($this->cabang_id) ? matiHere("cabang id belum diset") : $this->cabang_id;

        $selected_date = isset($this->selected_date)? "and ".$this->selected_date : " LIMIT 100,10";



        $tbl = isset($selectedTable[$jenis]) ? $selectedTable[$jenis] : matiHere("jenis($jenis) belum ditambahkan ke selected_table ! ON LINE: ".__LINE__." FILE: ".__FILE__);
//cekHere($condite);
        $sql = "SHOW COLUMNS FROM $tbl";
        $arrColumns = $db1->get_columns($sql);
        $colSelected = $this->callCollom($jenis);
        if(isset($this->selected_date)){
            $q = "select * from $tbl where 1 $condite and cabang_id='$cabang_id' $selected_date";
        }else{
            $q="SELECT * FROM (SELECT * FROM $tbl where 1 $condite ORDER BY id DESC LIMIT 30) sub ORDER BY id ASC";
        }

//        $q = "select * from $tbl where 1 $condite and cabang_id='$cabang_id' $selected_date";
        cekHere($q);
        $x = $db1->select($q);
        !$x ? die($db1->display_errors(__FILE__ . " on: " . __LINE__)) : "";
        $j = $db1->select($q,true);
        $arrTranformValue = $this->tranformValue;
        $data = array();
        $i = 0;
        if($j > 0){
         while($l = $db1->get_row($x)){
             $temp = array();
             foreach ($colSelected as $kolom => $aliasFormat){
                 $i++;
                 switch($arrTranformValue[$kolom]){
                     case "formatTanggal":
                         $temp[$kolom] = formatTanggal($l->$kolom);
                         break;
                     case "formatAngka":
                         $formatedValue = (1*$l->$kolom);
                         $temp[$kolom] = formatAngka($formatedValue);
                         break;
                     case "formatTransNomer":
                         switch($l->transaksi_jenis){

                             case "583":
                             case "983":
                             case "582k":
                             case "582":
                             case "467":
                                 $jenis = $l->transaksi_jenis == "582" ? "582k" : $l->transaksi_jenis;
                                 $prefix = $jenis=="persediaan produk" ? "p" : "j";
                                 $temp[$kolom] = "<a href='javascript:void(0);' onclick=\"popup('../../public/pembelian/printnable.php?Mode=".$prefix."_".$jenis."&id=".$l->transaksi_id."','wnext')\">".formatTransNomer($l->$kolom, $jenis ,$l->cabang_id)."</a>";
                                 break;
                             case "663":
                             case "331":
                                 $temp[$kolom] = formatTransNomer($l->$kolom, $l->transaksi_jenis, $l->cabang_id);
                                 break;
                             default:
                                 $temp[$kolom] = "<a href='javascript:void(0);' onclick=\"popup('../../public/pembelian/printnable.php?Mode=".$l->transaksi_jenis."&id=".$l->transaksi_id."','wnext')\">".formatTransNomer($l->$kolom, $l->transaksi_jenis ,$l->cabang_id)."</a>";
                                 break;
                         }
                        break;
                     default:
                         $temp[$kolom] = $l->$kolom;
                         break;
                 }
             }
             $data[]=$temp;
         }
        }

        return $data;
    }

}