<?php

/**
 * Created by PhpStorm.
 * User: thomas
 * Date: 08/06/18
 * Time: 23:12
 */
class Customer
{
    protected $smart_search;
    protected $customer_id;
    protected $cabang_id;
    protected $data;
    protected $f_kali;
    protected $def_fields;

    public function getDefFields()
    {
        return $this->def_fields;
    }

    public function setDefFields($def_fields)
    {
        $this->def_fields = $def_fields;
    }

    public function getFKali()
    {
        return $this->f_kali;
    }

    public function setFKali($f_kali)
    {
        $this->f_kali = $f_kali;
    }

    public function getData()
    {
        return $this->data;
    }

    public function setData($data)
    {
        $this->data = $data;
    }

    public function getCabangId()
    {
        return $this->cabang_id;
    }

    public function setCabangId($cabang_id)
    {
        $this->cabang_id = $cabang_id;
    }

    public function setCustomerId($customer_id)
    {
        $this->customer_id = $customer_id;
    }

    public function setSmartSearch($smart_search)
    {
        $this->smart_search = $smart_search;
    }

    function __construct()
    {
        $this->db = New _00_DBclass();
        !$this->db->connect() ? die($this->db->display_errors()) : "";

        $this->crud = New Crud();

        $this->tbl = "per_customers";
        $this->tbl_stok_cache_penjualan = "produk_stok_cache_penjualan_customers";
        $this->kol_stok_cache_penjualan = array(
            "id",
            "produk_id",
            "produk_nama",
            "persediaan",
            "hpp",
            "harga",
            "harga_ori",
        );

        $this->crud = New Crud();
        $this->def_fields = $this->defFields = array(
            "id",
            "nama",
            "nama_login",
            "nama_depan",
            "nama_belakang",
            "email",
            "tlp_1",
            "tlp_2",
            "npwp",
            "no_ktp",
            "diskon",
            "kredit_limit",
            "jatuh_tempo",
            "alamat_1",
            "kelurahan",
            "kecamatan",
            "kabupaten",
            "propinsi",
            "negara",
            "kode_pos",
        );
    }

    public function call_customer_aktif()
    {
        $tbl_4 = $this->tbl;
        $arrKolom = $this->defFields;
        $kolom_list = implode(',', $arrKolom);

        $conditional = "where status='1' and trash='0' order by nama asc";
        /*
         * untuk searcing gunakan set_key_words saat mengunakan*/
        if ((isset($this->smart_search) && (is_array($this->smart_search)))) {
            //            $conditional .= " and produk_nama like '%" . $this->key_words . "%'";
        } else {
            $conditional .= "";
        }


        $q_4 = "select $kolom_list from $tbl_4 $conditional";
        //        cekHere("$q_4 ****" . __FILE__ . __LINE__);
        $x_4 = $this->db->select($q_4);
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $j_4 = $this->db->select($q_4, true);

        $arrData = array();
        if ($j_4 > 0) {
            while ($l_4 = $this->db->get_row($x_4)) {
                $arrDataKolom = array();
                $id = $l_4->id;
                foreach ($arrKolom as $kolom) {
                    //                $$kolom = $l_4->$kolom;
                    $arrDataKolom[$kolom] = $l_4->$kolom;
                }

                $arrData[$id] = $arrDataKolom;
            }
        }

        return $arrData;

    }

    public function call_customer_non_aktif()
    {
        $tbl_4 = $this->tbl;
        $arrKolom = array(
            "id",
            "nama",
            "nama_login",
            "nama_depan",
            "nama_belakang",
            "email",
            "tlp_1",

        );
        $kolom_list = implode(',', $arrKolom);

        $conditional = "where jenis='seller' and status='0' and trash='0'";
        /*
         * untuk searcing gunakan set_key_words saat mengunakan*/
        if ((isset($this->smart_search) && (is_array($this->smart_search)))) {
            //            $conditional .= " and produk_nama like '%" . $this->key_words . "%'";
        } else {
            $conditional .= "";
        }

        //        if (!empty($supplier_id)) {
        //            $conditional .= " and suppliers_id='$supplier_id'";
        //        }
        //        else {
        //            $conditional .= "";
        //        }
        $q_4 = "select $kolom_list from $tbl_4 $conditional";
        //        cekHere("$q_4 ****" . __FILE__ . __LINE__);
        $x_4 = $this->db->select($q_4);
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $j_4 = $this->db->select($q_4, true);

        // endregion cek log_notif

        $arrData = array();
        while ($l_4 = $this->db->get_row($x_4)) {
            $arrDataKolom = array();
            $id = $l_4->id;
            foreach ($arrKolom as $kolom) {
                //                $$kolom = $l_4->$kolom;
                $arrDataKolom[$kolom] = $l_4->$kolom;
            }

            $arrData[$id] = $arrDataKolom;
        }

        //echo toAlert("ddd");
        return $arrData;

    }

    public function call_customer_hit()
    {

    }

    public function call_customer($id)
    {
        $tbl_4 = $this->tbl;
        $arrKolom = array(
            "id",
            "nama",
            "nama_login",
            "nama_depan",
            "nama_belakang",
            "email",
            "tlp_1",
            "tlp_2",
            "status",
            "trash",
            "negara",
            "propinsi",
            "kabupaten",
            "kecamatan",
            "kelurahan",
            "kode_pos",
            "no_ktp",
            "npwp",
            "alamat_1",
            "foto_ktp",
            "foto_npwp",

        );
        $kolom_list = implode(',', $arrKolom);

        $conditional = "where id='$id'";
        /*
         * untuk searcing gunakan set_key_words saat mengunakan*/
        if ((isset($this->smart_search) && (is_array($this->smart_search)))) {
            //            $conditional .= " and produk_nama like '%" . $this->key_words . "%'";
        } else {
            $conditional .= "";
        }


        $q_4 = "select $kolom_list from $tbl_4 $conditional";
        //        cekHere("$q_4 ****" . __FILE__ . __LINE__);
        $x_4 = $this->db->select($q_4);
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $j_4 = $this->db->select($q_4, true);

        $arrData = array();
        if ($j_4 > 0) {
            while ($l_4 = $this->db->get_row($x_4)) {
                $arrDataKolom = array();
                $id = $l_4->id;
                foreach ($arrKolom as $kolom) {
                    //                $$kolom = $l_4->$kolom;
                    $arrDataKolom[$kolom] = $l_4->$kolom;
                }

                $arrData[$id] = $arrDataKolom;
            }
        }

        return $arrData;

    }

    public function edit_customer($arrData)
    {
        $id = !isset($this->customer_id) ? matiHere("customer_id harap di set") : $this->customer_id;

        $this->crud->setTbl($this->tbl);
        $this->crud->setConditional("where id='$id'");
        $this->crud->setCreate($arrData, false);


    }

    public function call_customer_stok_cache_penjualan($customer_id)
    {
        $tbl_4 = $this->tbl_stok_cache_penjualan;
        $cabang_id = ((isset($this->cabang_id)) && ($this->cabang_id != 0)) ? $this->cabang_id : mati_disini("cabang_id harap diisi om " . __LINE__ . " " . __FUNCTION__);
        $arrKolom = $this->kol_stok_cache_penjualan;

        $kolom_list = implode(',', $arrKolom);

        $conditional = "where jenis='produk' and trash='0' and cabang_id='$cabang_id' and customers_id='$customer_id'";
        /*
         * untuk searcing gunakan set_key_words saat mengunakan*/
        if ((isset($this->smart_search) && (is_array($this->smart_search)))) {
            //            $conditional .= " and produk_nama like '%" . $this->key_words . "%'";
        } else {
            $conditional .= "";
        }

        //        if (!empty($supplier_id)) {
        //            $conditional .= " and suppliers_id='$supplier_id'";
        //        }
        //        else {
        //            $conditional .= "";
        //        }
        $q_4 = "select $kolom_list from $tbl_4 $conditional";
               // cekHere("$q_4 ****" . __FILE__ . __LINE__);
        $x_4 = $this->db->select($q_4);
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $j_4 = $this->db->select($q_4, true);

        // endregion cek log_notif

        $arrData = array();
        while ($l_4 = $this->db->get_row($x_4)) {
            $arrDataKolom = array();
            $produk_id = $l_4->produk_id;
            foreach ($arrKolom as $kolom) {
                //                $$kolom = $l_4->$kolom;
                $arrDataKolom[$kolom] = $l_4->$kolom;
            }

            $arrData[$produk_id] = $arrDataKolom;
        }

        //echo toAlert("ddd");
        return $arrData;
    }

    public function set_customer_stok_cache_penjualan($customer_id)
    {
        $cabang_id = isset($this->cabang_id) ? $this->cabang_id : mati_disini("cabang_id harap di set untuk " . __FUNCTION__);
        $f_kali = isset($this->f_kali) ? $this->f_kali : mati_disini("f_kali harap di set untuk " . __FUNCTION__);
        $tbl = $this->tbl_stok_cache_penjualan;
        $kolom = $this->kol_stok_cache_penjualan;
        $tr_data = (isset($this->data) && is_array($this->data)) ? $this->data : mati_disini("transaksi_data harap di set berupa array produk");

        $arrData = $this->call_customer_stok_cache_penjualan($customer_id);

        $produk_id_new = $tr_data['produk_id'];
        $arrData_lama = $arrData[$produk_id_new];
        $produk_nama_new = $tr_data['produk_nama'];
        $persediaan = $tr_data['produk_ord_jml'];
        $hpp = $tr_data['hpp'];
        $harga = $tr_data['produk_ord_hrg'];
        $harga_ori = $tr_data['produk_hrg_ori'];

        $persediaan_db = $arrData_lama['persediaan'];
        $hpp_db = $arrData_lama['hpp'];
        $harga_db = $arrData_lama['harga'];
        $harga_ori_db = $arrData_lama['harga_ori'];


        // arrPrint($tr_data);
        // arrPrint($arrData_lama);
        // cekHijau("fkali $f_kali");
        // $sum_persediaan =
        switch ($f_kali) {
            case "1":
                $sum_persediaan = $persediaan_db + $persediaan;
                break;
            case "-1":
                $sum_persediaan = $persediaan_db - $persediaan;
                break;
            default:
                mati_disini(__LINE__ . " " . __FILE__ . " f_kali belum di setting");
                break;
        }


        if (array_key_exists($produk_id_new, $arrData)) {
            $hpp_ = $hpp == 0 ? $hpp_db : $hpp;
            $harga_ = $harga == 0 ? $harga_db : $harga;
            $harga_ori_ = $harga_ori == 0 ? $harga_ori_db : $harga_ori;

            // update data
            $arrUpd = array(
                "persediaan" => $sum_persediaan,
                "hpp" => $hpp_,
                "harga" => $harga_,
                "harga_ori" => $harga_ori_,
            );
            $arrUpd_f = array_filter($arrUpd);
            $this->crud->setConditional("where customers_id='$customer_id' and produk_id='$produk_id_new' and cabang_id='$cabang_id'");
            $this->crud->setTbl($tbl);
            $this->crud->setCreate($arrUpd, false);

        } else {
            // insert data
            if ($sum_persediaan < 0) {
                $sum_persediaan = 0;
                createLog("produk stok cahe customer $customer_id minus", "dev");
            }
            // cekMerah("$sum_persediaan");
            $arrUpd = array(
                "jenis" => "produk",
                "persediaan" => $sum_persediaan,
                "hpp" => $hpp,
                "harga" => $harga,
                "harga_ori" => $harga_ori,
                "produk_id" => $produk_id_new,
                "produk_nama" => $produk_nama_new,
                "cabang_id" => $cabang_id,
                "customers_id" => $customer_id,
            );

            // $this->crud->setConditional("where customers_id='$customer_id' and produk_id='$produk_id_new' and cabang_id='$cabang_id'");
            $this->crud->setTbl($tbl);
            $this->crud->setCreate($arrUpd);
        }

    }

    public function add_alamat_kirim($arrData)
    {

        $this->crud->setTbl("tpl_alamat");

        return $this->crud->setCreate($arrData);

    }

    public function call_alamat_kirim($customer_id = "")
    {
        $tbl_4 = "tpl_alamat";
        $arrKolom = array(
            "id",
            "per_customers_id",
            "alias",
            "alamat",
            "email",
            "tlp",
            "kelurahan",
            "kodepos",
            "kabupaten",
            "kecamatan",
            "kelurahan",
            "propinsi",
            "negara",
            "status",
            "per_customers_nama",

        );
        $kolom_list = implode(',', $arrKolom);

        $conditional = "where trash='0'";
        /*
         * untuk searcing gunakan set_key_words saat mengunakan*/
        if ((isset($this->smart_search) && (is_array($this->smart_search)))) {
            //            $conditional .= " and produk_nama like '%" . $this->key_words . "%'";
        } else {
            $conditional .= "";
        }

        if ($customer_id > 0) {
            $conditional .= "and per_customers_id='$customer_id'";
        } else {
            $conditional .= "";
        }


        $q_4 = "select $kolom_list from $tbl_4 $conditional";
        $x_4 = $this->db->select($q_4);
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $j_4 = $this->db->select($q_4, true);

        $arrData = array();
        if ($j_4 > 0) {
            while ($l_4 = $this->db->get_row($x_4)) {
                $arrDataKolom = array();
                $id = $l_4->id;
                foreach ($arrKolom as $kolom) {
                    //                $$kolom = $l_4->$kolom;
                    $arrDataKolom[$kolom] = $l_4->$kolom;
                }

                $arrData[$id] = $arrDataKolom;
            }
        }

        return $arrData;
    }

    public function del_alamat_kirim($id_data)
    {
        $arrData = array("trash" => 1);
        $this->crud->setConditional("where id='$id_data'");
        $this->crud->setTbl("tpl_alamat");
        $this->crud->setCreate($arrData, false);

        return 1;
    }

    public function call_alamat_kirim_data($id)
    {
        $tbl_4 = "tpl_alamat";
        $id < 1 ? mati_disini("id harus berisi bilangan asli " . __FUNCTION__) : "";
        $arrKolom = array(
            "id",
            "jenis",
            "per_customers_id",
            "per_customers_nama",
            "alias",
            "email",
            "tlp",
            "tlp_2",
            "tlp_3",
            "alamat",
            "kelurahan",
            "kabupaten",
            "kecamatan",
            "propinsi",
            "negara",
            "kodepos",
            "status",
            "dtime",
            "trash",
            "per_employee_id",
            "warehouse",
            "npwp",
            "no_ktp",
        );

        $list_kolom = implode(',', $arrKolom);

        $condite = "and id='$id'";

        $q_2 = "select $list_kolom from $tbl_4 where 1 $condite";
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        while ($l_2 = $this->db->get_row($x_2)) {

            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;

                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }

            $arrData[$id] = $arrKolom_nilai;
        }

        return $arrData;
    }


    public function call_alamat_terima($customer_id = "")
    {
        $tbl_4 = "tpl_alamat";
        $arrKolom = array(
            "id",
            "per_customers_id",
            "alias",
            "alamat",
            "email",
            "tlp",
            "kelurahan",
            "kodepos",
            "kabupaten",
            "kecamatan",
            "kelurahan",
            "propinsi",
            "status",
            "warehouse",

        );
        $kolom_list = implode(',', $arrKolom);

        $conditional = "where jenis='terima' and trash='0'";
        /*
         * untuk searcing gunakan set_key_words saat mengunakan*/
        if ((isset($this->smart_search) && (is_array($this->smart_search)))) {
            //            $conditional .= " and produk_nama like '%" . $this->key_words . "%'";
        } else {
            $conditional .= "";
        }

        if ($customer_id > 0) {
            $conditional .= "and per_customers_id='$customer_id'";
        } else {
            $conditional .= "";
        }


        $q_4 = "select $kolom_list from $tbl_4 $conditional";
        $x_4 = $this->db->select($q_4);
        !$x_4 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $j_4 = $this->db->select($q_4, true);

        $arrData = array();
        if ($j_4 > 0) {
            while ($l_4 = $this->db->get_row($x_4)) {
                $arrDataKolom = array();
                $id = $l_4->id;
                foreach ($arrKolom as $kolom) {
                    //                $$kolom = $l_4->$kolom;
                    $arrDataKolom[$kolom] = $l_4->$kolom;
                }

                $arrData[$id] = $arrDataKolom;
            }
        }

        return $arrData;
    }

    public function call_alamat_terima_data($id)
    {
        $tbl_4 = "tpl_alamat";
        $id < 1 ? mati_disini("id harus berisi bilangan asli") : "";
        $arrKolom = array(
            "id",
            "per_customers_id",
            "alias",
            "alamat",
            "email",
            "tlp",
            "kelurahan",
            "kodepos",
            "kabupaten",
            "kecamatan",
            "kelurahan",
            "propinsi",
            "status",
            "warehouse",
        );

        $list_kolom = implode(',', $arrKolom);

        $condite = "and jenis='terima' and id='$id'";

        $q_2 = "select $list_kolom from $tbl_4 where 1 $condite";
        //        cekHere("$q_2");
        $x_2 = $this->db->select($q_2);
        !$x_2 ? die($this->db->display_errors(__FILE__ . " on line " . __LINE__)) : "";

        $arrData = array();
        while ($l_2 = $this->db->get_row($x_2)) {
            $arrKolom_nilai = array();
            foreach ($arrKolom as $kolom) {
                $$kolom = $l_2->$kolom;
                $arrKolom_nilai[$kolom] = $l_2->$kolom;
            }
            $arrData[$id] = $arrKolom_nilai;
        }

        return $arrData;
    }

    public function del_alamat_terima($id_data)
    {
        $arrData = array("trash" => 1);
        $this->crud->setConditional("where id='$id_data'");
        $this->crud->setTbl("tpl_alamat");
        $this->crud->setCreate($arrData, false);

        return 1;
    }


}