<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


$connectionParams = array(
    "host"     => dbHost(), "user" => dbUser(), "password" => dbPass(), //"database" => "dx_mcm_02",    
    "database" => db_0(), "table" => "transaksi", "label" => "ILM", "homepage" => "http://ilm.mayagrahakencana.com",
);

$appConfig = array(
    "label"         => "ILM", "homepage" => "http://www.malioboro.co.id/login", "rpSatuan" => 1000000,
    "defaultFilter" => "cabang_id",
);

$reportConfig = array(
    "general" => array(
        "maxItemView" => 700,//===jumlah yang dianggap sudah memberatkan tampilan
        "maxRowCount" => 3000,//===jumlah yang dianggap sudah fetching hasil query
    ), "466"  => array(
        "filters"          => array(
            "produk_id" => "Produk", "suppliers_id" => "Supplier", //"sellers_id" => "Seller",
            //"customers_id" => "Customer",
            "oleh_id"   => "Petugas", "cabang_id" => "Cabang",
        ), "defaultFilter" => "suppliers_id",
    ), "467"  => array(
        "filters"          => array(
            "produk_id" => "Produk", "suppliers_id" => "Supplier", //"sellers_id" => "Seller",
            //"customers_id" => "Customer",
            "oleh_id"   => "Petugas", "cabang_id" => "Cabang",
        ), "defaultFilter" => "suppliers_id",
    ), "967r" => array(
        "filters"          => array(
            "produk_id" => "Produk", "suppliers_id" => "Supplier", //"sellers_id" => "Seller",
            //"customers_id" => "Customer",
            "oleh_id"   => "Petugas", "cabang_id" => "Cabang",
        ), "defaultFilter" => "suppliers_id",
    ), "967"  => array(
        "filters"          => array(
            "produk_id" => "Produk", "suppliers_id" => "Supplier", //"sellers_id" => "Seller",
            //"customers_id" => "Customer",
            "oleh_id"   => "Petugas", "cabang_id" => "Cabang",
        ), "defaultFilter" => "suppliers_id",
    ), "776r" => array(
        "filters"          => array(
            "produk_id" => "Produk", "suppliers_id" => "Supplier", //"sellers_id" => "Seller",
            //"customers_id" => "Customer",
            "oleh_id"   => "Petugas", "cabang_id" => "Cabang",
        ), "defaultFilter" => "oleh_id",
    ), "776"  => array(
        "filters"          => array(
            "produk_id" => "Produk", "suppliers_id" => "Supplier", //"sellers_id" => "Seller",
            //"customers_id" => "Customer",
            "oleh_id"   => "Petugas", "cabang_id" => "Cabang",
        ), "defaultFilter" => "oleh_id",
    ), "583"  => array(
        "filters"          => array(
            "produk_id" => "Produk", //"suppliers_id" => "Supplier",
            //"sellers_id" => "Seller",
            //"customers_id" => "Customer",
            "oleh_id"   => "Petugas", "cabang_id" => "Cabang",
        ), "defaultFilter" => "cabang_id",
    ), "582r" => array(
        "filters"          => array(
            "produk_id"    => "Produk", //"suppliers_id" => "Supplier",
            //"sellers_id" => "Seller",
            "customers_id" => "Customer", "oleh_id" => "Petugas", "cabang_id" => "Cabang",
        ), "defaultFilter" => "cabang_id",
    ), "582"  => array(
        "filters"          => array(
            "produk_id"    => "Produk", //"suppliers_id" => "Supplier",
            //"sellers_id" => "Seller",
            "customers_id" => "Customer", "oleh_id" => "Petugas", "cabang_id" => "Cabang",
        ), "defaultFilter" => "cabang_id",
    ), "982r" => array(
        "filters"          => array(
            "produk_id"    => "Produk", //"suppliers_id" => "Supplier",
            //"sellers_id" => "Seller",
            "customers_id" => "Customer", "oleh_id" => "Petugas", "cabang_id" => "Cabang",
        ), "defaultFilter" => "cabang_id",
    ), "982"  => array(
        "filters"          => array(
            "produk_id"    => "Produk", //"suppliers_id" => "Supplier",
            //"sellers_id" => "Seller",
            "customers_id" => "Customer", "oleh_id" => "Petugas", "cabang_id" => "Cabang",
        ), "defaultFilter" => "cabang_id",
    ),
);

$reportTypes = array(
    334    => "konversi", "334r" => "req. konversi", 465 => "PO. bahan jadi", 466 => "PO. bahan baku",
    467    => "pembelian", 488 => "hutang kontainer", "489r" => "req. pembayaran_hutang", 489 => "pembayaran_hutang",
    581    => "order", "582r" => "req. penjualan", "582sj" => "surat jalan", 582 => "penjualan",
    "583r" => "order distribusi", 583 => "distribusi", "663r" => "req. modal", 663 => "modal",
    "664r" => "req. modal out", 664 => "modal out", "670" => "penambahan plafon pettycash", "671r" => "req. kas kecil",
    671    => "kas kecil", //        722 => "packing",
    "722r" => "pemindahan produk dari gudang produksi ke gudang distribusi",
    722    => "penerimaan produk dari gudang produksi di gudang distribusi", 748 => "piutang",
    "749r" => "req. pembayaran_piutang", 749 => "pembayaran_piutang", "757r" => "req. pemindahan  kas",
    757    => "pemindahan kas", "759r" => "req. penyetoran kas ke pusat", 759 => "penyetoran kas ke pusat",
    769    => "rugi laba", "776r" => "req. proses", 776 => "proses", "779r" => "req. penerimaan setoran",
    779    => "penerimaan setoran", 787 => "rusak", 788 => "pembayaran hutang kontainer",
    "945r" => "req. pengiriman kas ke cabang", "945" => "pengiriman kas ke cabang",
    "949"  => "pengembalian deposit ke konsumen", "967r" => "req. return pembelian", 967 => "return pembelian",
    "982r" => "req. return penjualan", 982 => "return penjualan", "983r" => "req. return distribusi",
    983    => "return distribusi", 947 => "penyesuaian piutang", 970 => "pengurangan plafon pettycash",
    988    => "return hutang kontainer",
);

/*
  $reportTypes = array(
  //=============
  235 => "adjustment",
  465 => "po bahan jadi",
  "466" => "Purchasing",  //== punya ILM
  //"467r" => "po bahan baku", // penganti 466
  467 => "pembelian",
  581 => "order",
  "582r" => "req. penjualan",
  "582o" => "penjualan",
  "582p" => "pembayaran",
  "582d" => "pembayaran deposit",
  "582k" => "kirim",
  "582s" => "selesai",
  "782r" => "req. pembayarankomisi",
  782 => "pembayaran komisi",
  582 => "penjualan",
  //        582 => "penjualan",
  "583r" => "order distribusi",
  583 => "distribusi",
  488 => "hutang",
  "489r" => "req. pembayaran_hutang",
  489 => "pembayaran_hutang",
  748 => "piutang",
  "749r" => "req. pembayaran_piutang",
  749 => "pembayaran_piutang",
  "759r" => "req. penyetoran kas ke pusat",
  759 => "penyetoran kas ke pusat",
  769 => "rugi laba",
  "776r" => "req. proses",
  776 => "konversi",
  "779r" => "req. penerimaan setoran",
  779 => "penerimaan setoran",
  787 => "rusak",
  "671r" => "hutang ongkir",
  671 => "Pembayaran hutang ongkir",
  "671p" => "ongkir pending",
  676 => "kas kecil",
  "663r" => "req. modal",
  663 => "modal",
  788 => "perbaikan",
  "967r" => "req. retur pembelian",
  967 => "retur pembelian",
  976 => "retur konversi",
  "982r" => "req. retur penjualan",
  "982o" => "retur barang piutang out",
  "982k" => "retur barang piutang kirim",
  "982s" => "retur barang piutang sampai",
  982 => "retur penjualan",
  "982p" => "retur pembayaran",
  "982d" => "return deposit",
  "983r" => "req. return distribusi",
  983 => "retur distribusi",
  722 => "packing",
  "c0" => "cod",
  "b1" => "bank",
  "r2" => "rekber",
  "d3" => "dropship",
  "972r" => "req. pembatalan komisi",
  "972" => "pembatalan komisi",
  "969" => "pembatalan rugi laba"
  ); */


$historyFields = array(
    //"467r" => array("dtime", "nomer", "suppliers_nama", "produk_nama", "produk_ord_jml", "produk_ord_hrg", "oleh_nama"),
    "466"      => array(
        "dtime", "nomer", "suppliers_nama", "produk_nama", "produk_ord_jml", "produk_ord_hrg", "oleh_nama"
    ), "467"   => array(
        "dtime", "nomer", "nomer_parent", "suppliers_nama", "produk_nama", "produk_ord_jml", "produk_ord_hrg",
        "oleh_nama", "diskon_nilai", "transaksi_net", "ppn_nilai",
    ), "967r"  => array(
        "dtime", "nomer", "nomer_parent", "suppliers_nama", "produk_nama", "produk_ord_jml", "produk_ord_hrg",
        "oleh_nama"
    ), "967"   => array(
        "dtime", "nomer", "nomer_parent", "suppliers_nama", "produk_nama", "produk_ord_jml", "produk_ord_hrg",
        "oleh_nama"
    ), "582r"  => array("dtime", "nomer", "customers_nama", "produk_nama", "produk_ord_jml", "produk_ord_hrg"),
    "582"      => array(
        "dtime", "nomer", "referensi_id", "customers_nama", "produk_nama", "produk_ord_jml", "produk_ord_hrg",
        "oleh_nama"
    ), "982r"  => array(
        "dtime", "nomer", "referensi_id", "customers_nama", "produk_nama", "produk_ord_jml", "produk_ord_hrg",
        "oleh_nama"
    ), "982"   => array(
        "dtime", "nomer", "referensi_id", "customers_nama", "produk_nama", "produk_ord_jml", "produk_ord_hrg",
        "oleh_nama"
    ), "582d"  => array("dtime", "nomer", "referensi_id", "oleh_nama", "transaksi_nilai"),
    "671r"     => array("dtime", "nomer", "referensi_id", "oleh_nama", "transaksi_nilai"),
    "activity" => array("dtime", "nomer", "referensi_id", "transaksi_nilai"),
);

$productExecptions = array(
    "582", "582r", "982", "982r", "582k", "671r", "582d", "583"
);
$fieldLabels = array(
    "nomer"          => "Nota", "nomer_parent" => "Ref", "referensi_id" => "RefID", "dtime" => "Tanggal",
    "suppliers_nama" => "Supplier", "customers_nama" => "Customer", "sellers_nama" => "Sales person",
    "oleh_nama"      => "PIC", "produk_nama" => "Nama barang", "produk_ord_jml" => "JML",
    "produk_ord_hrg" => "Harga Satuan", "transaksi_nilai" => "Nilai", "komisi" => "komisi", "komisi_ori" => "komisi",
);

function formatHistoryField($fieldValue, $fieldName)
{
    //echo "formatting $fieldName $fieldValue ";
    $fieldValue = trim($fieldValue);
    switch ($fieldName) {
        case "dtime":
            return "<a title='$fieldValue'><span style='color:#cc7755;font-family:Arial;font-size:12px;'><span class='glyphicon glyphicon-time'></span>&nbsp;" . str_replace(" ", "&nbsp;", convertDatetimeToShort($fieldValue)) . "</span></a>&nbsp;";
            break;
        case "produk_ord_jml":
            return "<span class='btn-block text-right' style='background:transparent;color:#0056cd;border:0px #abcdef solid;'>" . $fieldValue . "</span>";
            break;
        case "transaksi_nilai":
        case "produk_ord_hrg":
            return "<span class='btn-block btn-block text-right' style='color:#dd3300;background:transparent;border:0px #efcdab solid;'>" . number_format($fieldValue * 1) . "</span>";
            break;
        case "komisi":
        case "komisi_ori":
            //return "<span class='btn-block btn-block text-right' style='color:#009900;background:transparent;border:0px #efcdab solid;'>" . number_format($fieldValue) . "</span>";
            return "<span class='btn-block btn-block text-right' style='color:#009900;background:transparent;border:0px #efcdab solid;'>" . number_format($fieldValue * 1) . "</span>&nbsp;";
            break;
        case "produk_nama":
            return "<span style='font-family:Georgia;font-style:italic;text-transform:Uppercase;'>" . str_replace(" ", "&nbsp;", $fieldValue) . "</span>&nbsp;";
            break;

        case "nomer":
        case "nomer_parent":
            $pecahan = explode("-", $fieldValue);
            $maxIdx = count($pecahan);
            $link = "https://malioboro.co.id/public/penjualan/modal_582r.php?Mode=Setor&id=343488&a=582k";

            //return "<a title='$fieldValue'><span style='font-size:11px;'>.." . $pecahan[$maxIdx - 3] . "-" . $pecahan[$maxIdx - 2] . "-" . $pecahan[$maxIdx - 1] . "</span></a>";
            return "<a title='$fieldValue'><span style='font-size:11px;'>" . $fieldValue . "</span></a>&nbsp;";
            break;
        default:
            if (preg_match("/_nama/i", $fieldName)) {
                $pecahan = explode(" ", $fieldValue);
                $fieldStr = sizeof($pecahan) > 1 ? $pecahan[0] . ".." : $fieldValue;

                return "<a title='$fieldValue'>" . "<span style='color:#676767;font-family:Arial;font-size:12px;'><span class='glyphicon glyphicon-user'></span>&nbsp;" . str_replace(" ", "&nbsp;", $fieldStr) . "</span></a>&nbsp;";
            }
            else {
                return $fieldValue . "&nbsp;";
            }

            break;
    }
}

$filterLabels = array(
    "produk_id"    => "Produk", "suppliers_id" => "Supplier",
    //"sellers_id2" => "Seller", //===ini kolom imajiner, aslinya di tabelnya kan kosong
    "sellers_id"   => "Seller", //===ini kolom imajiner, aslinya di tabelnya kan kosong
    "customers_id" => "Customer", "oleh_id" => "Petugas", "cabang_id" => "Cabang"
);

function getWeekNumber($ddate)
{
    //$ddate = "2012-10-18";
    $date = new DateTime($ddate);
    $week = $date->format("W");

    return $week;
}

$rpSatuans = array(
    1000 => "ribuan", 1000000 => "jutaan"
);
$defaultSatuan = 1000;

$periodTypes = array(
    "monthly" => "bulanan", "weekly" => "mingguan", "daily" => "harian",
);

$defaultPeriodPoints = array(
    "monthly" => date("Y"), "weekly" => date("Y"), "daily" => date("Y-m"),
);

function convertDatetimeToShort($dt)
{
    $arrMonthShortNames = array(
        "01" => "Jan", "02" => "Feb", "03" => "Mar", "04" => "Apr", "05" => "Mei", "06" => "Jun", "07" => "Jul",
        "08" => "Agu", "09" => "Sep", "10" => "Okt", "11" => "Nov", "12" => "Des",
    );
    if (strlen($dt) > 9) {//===YYYY-mm-dd HH:ii
        $thn = substr($dt, 0, 4);
        $thnShort = substr($dt, 2, 2);
        $bln = substr($dt, 5, 2);
        $tgl = substr($dt, 8, 2);
        $jam = substr($dt, 11, 5);
        $strJam = ("$thn/$bln/$tgl" == date("Y/m/d")) ? $jam : "";

        if ("$thn/$bln/$tgl" == date("Y/m/d")) {
            //return "<strong>Hari ini</strong> <small>$strJam</small>";
            //return "<small>$strJam</small>";
            //return "<strong>$thn " . date("F", strtotime("2001-" . $bln . "-01")) . " $tgl</strong> (hari ini) <small>$strJam</small>";
            return "<strong>$tgl " . $arrMonthShortNames[$bln] . " $thn</strong> <small>$strJam</small>";
        }
        else {
            if ($thn == date("Y")) {
                //return "<strong>$tgl " . $arrMonthShortNames[$bln] . "'$thnShort</strong> <small>$strJam</small>";
                return "<strong>$tgl " . $arrMonthShortNames[$bln] . " $thn</strong> <small>$strJam</small>";
            }
            else {
                //return "<strong>$tgl " . $arrMonthShortNames[$bln] . "'$thnShort</strong> <small>$strJam</small>";
                return "<strong>$tgl " . $arrMonthShortNames[$bln] . " $thn</strong> <small>$strJam</small>";
            }
        }
    }
    else {
        if (strlen($dt) > 6) {//===YYYY-mm
            $thn = substr($dt, 0, 4);
            $thnShort = substr($dt, 2, 2);
            $bln = substr($dt, 5, 2);


            if ("$thn/$bln" == date("Y/m")) {
                //return "<strong>Hari ini</strong> <small>$strJam</small>";
                return "bulan ini";
            }
            else {
                if ($thn == date("Y")) {
                    //return "<strong>" . date("F", strtotime("2001-" . $bln . "-01")) . "'$thnShort</strong> ";
                    return "<strong>$tgl " . date("F", strtotime("2001-" . $bln . "-01")) . " $thn</strong> ";
                }
                else {
                    //return "<strong>" . date("F", strtotime("2001-" . $bln . "-01")) . "'$thnShort</strong>";
                    return "<strong>$tgl " . date("F", strtotime("2001-" . $bln . "-01")) . " $thn</strong> ";
                }
            }
        }
        else {
            return $dt;
        }
    }
}

function day_diff($dt1, $dt2)
{
    $y1 = substr($dt1, 0, 4);
    $m1 = substr($dt1, 5, 2);
    $d1 = substr($dt1, 8, 2);
    $h1 = substr($dt1, 11, 2);
    $i1 = substr($dt1, 14, 2);
    $s1 = substr($dt1, 17, 2);

    $y2 = substr($dt2, 0, 4);
    $m2 = substr($dt2, 5, 2);
    $d2 = substr($dt2, 8, 2);
    $h2 = substr($dt2, 11, 2);
    $i2 = substr($dt2, 14, 2);
    $s2 = substr($dt2, 17, 2);

    $r1 = date('U', mktime($h1, $i1, $s1, $m1, $d1, $y1));
    $r2 = date('U', mktime($h2, $i2, $s2, $m2, $d2, $y2));

    return abs(($r1 - $r2) / (3600 * 24));
}

function fetchUser()
{
    global $connectionParams;
    $connID = mysqli_connect($connectionParams['host'], $connectionParams['user'], $connectionParams['password'], $connectionParams['database']); //, $port, $socket);    
    $q = "select * from per_employee where trash='0' order by nama";
    $does = mysqli_query($connID, $q) or die(mysqli_error());
    $tmp = array();
    while ($row = mysqli_fetch_assoc($does)) {
        $tmp[$row[id]] = $row[nama] . " (" . $row[jenis] . ")";
    }

    return $tmp;
}

function replaceQueryString($url, $params)
{
    $newURL = $url;
    if (is_array($params) and sizeof($params) > 0) {
        foreach ($params as $var => $value) {
            if (preg_match("/$var/i", $newURL)) {
                $newURL = str_replace("$var=", "$var=$value&*", "$newURL");
            }
            else {
                $newURL = $newURL . "&" . $var . "=" . $value;
            }
        }

        return $newURL;
    }
    else {
        return $url;
    }
}
