<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * @author aziz
 */
if (!isset($_SESSION['employee_jenis'])) {
    include_once 'template.php';
    $contentStr .= "<div class='alert alert-danger'>";
    $contentStr .= "Anda tidak diperkenankan mengakses halaman ini<br>";
    $contentStr .= "Silahkan perbarui status wewenang anda dengan cara masuk pada <strong>web " . $connectionParams['label'] . "</strong><br>";
    $contentStr .= "<a href='" . $connectionParams['homepage'] . "'>Ke " . $connectionParams['label'] . "</a><br>";
    $contentStr .= "</div class='alert alert-danger'>";
    $p = new clTemplate();
    $p->defineTheme("../viewer.html");
    $p->defineTag("{title}", "Anda Tak Punya Wewenang");
    $p->defineTag("{backURL}", "JavaScript:void(0);");
    $p->defineTag("{backTitle}", "Ini sudah paling depan");
    $p->defineTag("{content}", $contentStr);
    $p->parse();
    $p->printTheme();
    die();
}

class RPeriodicReportParser
{

    //put your code here  
    private $r; //===connector ke objek RBasic
    private $content;
    private $title;
    private $backURL;
    private $backTitle;
    private $viewType; //==is it screen or print

    // <editor-fold defaultstate="collapsed" desc="getter-setter, kampungan">

    function getViewType()
    {
        return $this->viewType;
    }

    function setViewType($viewType)
    {
        $this->viewType = $viewType;
    }

    function getBackURL()
    {
        return $this->backURL;
    }

    function getBackTitle()
    {
        return $this->backTitle;
    }

    function setBackURL($backURL)
    {
        $this->backURL = $backURL;
    }

    function setBackTitle($backTitle)
    {
        $this->backTitle = $backTitle;
    }

    function getTitle()
    {
        return $this->title;
    }

    function setTitle($title)
    {
        $this->title = $title;
    }

    function getContent()
    {
        return $this->content;
    }

    function setContent($content)
    {
        $this->content = $content;
    }

    function getR()
    {
        return $this->r;
    }

    function setR($r)
    {
        $this->r = $r;
    }

    // </editor-fold>

    public function __construct($r)
    {
        global $reportTypes, $appConfig;
        $this->viewType = "screen";
        $this->r = $r;


        $this->title = $reportTypes[$r->getJenis()] . " " . $r->getLabels()['periodTitle'] . " " . convertDatetimeToShort($r->getPeriodPoint());
        switch ($appConfig['rpSatuan']) {
            case 1000:
                $this->title .= " (dalam ribuan)";
                break;
            case 1000000:
                $this->title .= " (dalam jutaan)";
                break;
        }
        $this->backURL = "../index/";
        $this->backTitle = "Ke Indeks Laporan";
    }

    public function parse()
    {
        global $reportTypes, $appConfig, $rpSatuans, $reportConfig, $filterLabels;
        $this->r->arrange();
        $this->r->normalize();
        $resultCount = count($this->r->getResults());
        if ($resultCount > 0) {
            $results = $this->r->getResults();
            $resultsPertime = $this->r->getResultsPertime();
            $varNames = $this->r->getVarNames();
            $periodNames = $this->r->getPeriodPoints();

            switch ($this->r->getPeriodType()) {
                case "weekly":
                case "monthly":
                    if ($this->r->getPeriodPoint() == date("Y")) {
                        $jmlPeriode = (date("m") - min($periodNames));
                    }
                    else {
                        $jmlPeriode = (max($periodNames) - min($periodNames));
                    }
                    break;
                case "daily":
                    if ($this->r->getPeriodPoint() == date("Y-m")) {
                        $jmlPeriode = (date("d") - min($periodNames));
                    }
                    else {
                        $jmlPeriode = (max($periodNames) - min($periodNames));
                    }
                    break;
            }


            //            $this->content .= "<script>";
            //            $this->content .= "$(document).ready( function () {
            //    $('#dTable').DataTable();
            //} );";
            //            $this->content .= "</script>";
            $this->content .= "<div class='panel-body'>";
            $this->content .= "<span class='badge judulRincian'>";
            $this->content .= "TOTAL " . $reportTypes[$this->r->getJenis()] . " selama " . $this->r->getAvgFactor() . " " . $this->r->getLabels()['periodName'] . " dalam jumlah unit dan nilai " . $rpSatuans[$appConfig['rpSatuan']] . "";
            $this->content .= "</span>";
            $this->content .= "<div class='row alert filterDialog'>";

            $this->content .= "<div class='col-sm-6'>";


            // <editor-fold defaultstate="collapsed" desc="angka total besar">
            $this->content .= "<table cellspacing=0 cellpadding=2>";
            $this->content .= "<tr>";
            $this->content .= "<td class='resTotalQtyLabel'>dalam unit";
            $this->content .= "</td class='col-sm-4'>";
            $this->content .= "<td class='resTotalQtyLabel'>:";
            $this->content .= "</td class='col-sm-1'>";
            $this->content .= "<td class='text-right resTotalQtyValue'>" . number_format($results['QTY']);
            $this->content .= "</td class='col-sm-4'>";
            $this->content .= "</tr>";


            $this->content .= "<tr>";
            $this->content .= "<td class='resTotalRpLabel'>dalam " . $rpSatuans[$appConfig['rpSatuan']];
            $this->content .= "</div class='col-sm-4'>";
            $this->content .= "<td class='resTotalRpLabel'>:";
            $this->content .= "</td class='col-sm-1'>";
            $this->content .= "<td class='text-right resTotalRpValue'>" . number_format($results['VALUE'] / $appConfig['rpSatuan']);
            $this->content .= "</td class='col-sm-4'>";
            $this->content .= "</tr class='row'>";
            $this->content .= "</table>";
            // </editor-fold>


            $this->content .= "</div class='col'>";

            $this->content .= "<div class='col-sm-6'>";
            if ($this->viewType == "screen") {
                // <editor-fold defaultstate="collapsed" desc="filter periode">
                $periodFilters = $this->r->getPeriodFilters();
                if (sizeof($periodFilters) > 0) {
                    $this->content .= "<div class='input-group'>";
                    $this->content .= "<span class='input-group-addon'><i class='glyphicon glyphicon-calendar'></i></span>";
                    $this->content .= "<select class='form-control' onChange=\"location.href='" . $_SERVER['PHP_SELF'] . "?f=$_GET[f]&ps='+this.value;\">";
                    foreach ($periodFilters as $pID) {
                        $periodSelected = $pID == $this->r->getPeriodPoint() ? "selected" : "";
                        $this->content .= "<option value='$pID' $periodSelected>" . $this->r->getLabels()['periodParentName'] . " " . convertDatetimeToShort($pID) . "</option>";
                    }
                    $this->content .= "</select>";


                    $this->content .= "<span class='input-group-addon'>";
                    $this->content .= "<a title='Tampilkan versi siap cetak' href=# onclick=\"window.open('" . $_SERVER['PHP_SELF'] . "?f=$_GET[f]&ps=" . $this->r->getPeriodPoint() . "&vt=print');\">";
                    $this->content .= "<i class='glyphicon glyphicon-print'></i>";
                    $this->content .= "</a>";
                    $this->content .= "</span>";


                    $this->content .= "</div class='input-group'>";
                }// </editor-fold>
            }
            $this->content .= "</div class='col'>";

            $this->content .= "</div class='row'>";

            $this->content .= "</div>";


            // <editor-fold defaultstate="collapsed" desc="rincian angka by tgl/bln/mingguan">
            //if (sizeof($periodNames) > 0) {


            $this->content .= "<div class='panel-body'>";
            $this->content .= "<span class='badge judulRincian'>";
            $this->content .= "Rincian " . $this->r->getLabels()['periodCaption'] . " dalam jumlah unit dan nilai " . $rpSatuans[$appConfig['rpSatuan']] . "";
            $this->content .= "</span class='alert'>";
            $this->content .= "<table cellspacing=0 cellpadding=2 border=0 class='alert dialog'>";
            $this->content .= "<tr>";
            $this->content .= "<td class='colHeader'>";
            $this->content .= "<span class='badge judulPeriode' >";
            $this->content .= $this->r->getLabels()['periodName'];
            $this->content .= "</span>";
            $this->content .= "</td>";

            if ($this->r->getPeriodType() == "weekly") {
                $periodArray = array_slice($this->r->getPeriodPoints(), -10, 10, true);
            }
            else {
                $periodArray = $this->r->getRawPeriods();
            }

            foreach ($periodArray as $pID => $pName) {

                $this->content .= "<td align=center class='colHeader' colspan=2>";
                $this->content .= "<span class='badge judulPeriode btn-block'>";
                switch ($this->r->getPeriodType()) {
                    case "monthly":
                        $this->content .= "<a href='" . str_replace("monthly", "daily", $_SERVER['PHP_SELF']) . "?f=$appConfig[defaultFilter]&ps=" . $this->r->getPeriodPoint() . "-$pID' title='Klik untuk menampilkan " . $this->r->getLabels()['periodName'] . " $pID'>";
                        $this->content .= "$pName";
                        $this->content .= "</a>";
                        break;
                    default:
                        $tmpDate = $this->r->getPeriodPoint() . "-" . $pID;
                        $thn = substr($tmpDate, 0, 4);
                        $bln = substr($tmpDate, 5, 4);
                        $tgl = $pID;
                        $dayName = date("l", mktime(0, 0, 0, $bln, $tgl, $thn));
                        $dayColor = $dayName == "Sunday" ? "#ffffff" : "inherit";
                        $dayBgColor = $dayName == "Sunday" ? "#ff0000" : "inherit";
                        $this->content .= "<span style='background:$dayBgColor;color:$dayColor;'>";
                        $this->content .= "$pName";
                        $this->content .= "</span style=''>";
                        break;
                }

                $this->content .= "</span>";
                $this->content .= "</td>";
            }
            $this->content .= "<td align=center  class='colTotalQty' colspan=2><span class='badge judulTotal btn-block'>TOTAL</span>";
            $this->content .= "</td>";

            $this->content .= "<td align=center  class='colAvgQty' colspan=2><span class='badge judulAvg btn-block'>" . $this->r->getPeriodType() . "<brot>&nbsp;AVG</span>";
            $this->content .= "</td>";
            $this->content .= "</tr>";

            $this->content .= "<tr>";
            $this->content .= "<td class='colVarName'>";
            $this->content .= "Total";
            $this->content .= "</td>";
            $vTOTAL = array();
            foreach ($periodArray as $pID => $pName) {
                $strQty = $results['qty']['period'][$pID] > 0 ? number_format($results['qty']['period'][$pID]) : "";
                $strValue = $results['value']['period'][$pID] > 0 ? number_format($results['value']['period'][$pID] / $appConfig['rpSatuan']) : "";


                if ($results['qty']['period'][$pID] > 0) {

                    $vTOTAL['qty'] += $results['qty']['period'][$pID];
                    $vTOTAL['value'] += $results['value']['period'][$pID];
                    $this->content .= "<td align=right class='colRegLeft'>";
                    $this->content .= "<span class='angkaRegQty'>";
                    $this->content .= $strQty;
                    $this->content .= "</span>";
                    $this->content .= "</td align=right>";

                    $this->content .= "<td align=right class='colRegRight'>";
                    $this->content .= "<span class='angkaRegValue'>";
                    $this->content .= $strValue;
                    $this->content .= "</span>";
                    $this->content .= "</td>";
                }
                else {
                    $this->content .= "<td align=center colspan=2 class='colRegSpan'>";
                    $this->content .= "<span class='angkaKosong'>";
                    $this->content .= $pName;
                    $this->content .= "</span>";
                    $this->content .= "</td>";
                }
            }
            // <editor-fold defaultstate="collapsed" desc="total">
            $this->content .= "<td align=right  class='colTotalQty'>";
            $strQty = $vTOTAL['qty'] > 0 ? number_format($vTOTAL['qty']) : "";
            $strValue = $vTOTAL['value'] > 0 ? number_format($vTOTAL['value'] / $appConfig['rpSatuan']) : "";
            $this->content .= $strQty;
            $this->content .= "</td align=right  class='colTotalQty'>";

            $this->content .= "<td align=right  class='colTotalRp'>";
            $this->content .= $strValue;
            $this->content .= "</td>"; // </editor-fold>
            // <editor-fold defaultstate="collapsed" desc="rata2">
            $this->content .= "<td align=right  class='colAvgQty'>";
            $strQty = $vTOTAL['qty'] > 0 ? number_format($vTOTAL['qty'] / $this->r->getAvgFactor(), 2) : "";
            $strValue = $vTOTAL['value'] > 0 ? number_format(($vTOTAL['value'] / $this->r->getAvgFactor()) / $appConfig['rpSatuan']) : "";
            $this->content .= $strQty;
            $this->content .= "</td align=right  class='colAvgQty'>";
            $this->content .= "<td align=right  class='colAvgRp'>";
            $this->content .= $strValue;

            $this->content .= "</td>"; // </editor-fold>


            $this->content .= "</tr>";


            $this->content .= "</table>";
            $this->content .= "</div class='panel-body'>";
            //}// </editor-fold>

            $this->content .= "</div>";

            if (sizeof($varNames) > 0) {//===ada isinya
                if ($this->viewType == "screen") {
                    $this->content .= "<div class='panel-body text-left'>";
                    // <editor-fold defaultstate="collapsed" desc="pilih rincian, berupa produk,seller, etc">
                    $this->content .= "<div class='panel panel-body filterDialog text-center'>";
                    $this->content .= "<a class='btn btn-normal'>Lihat rincian <br>berdasarkan:</a>";
                    foreach ($varNames as $vID => $vSpec) {
                        $jmlEntry = count($vSpec);
                        if ($jmlEntry > 0) {
                            if ($vID == $_GET['f']) {
                                $disabledBtn = "disabledddd";
                                //$btnClass = 'btn-warning';
                                $btnStyle = 'background:#ccddff;border:1px #99aacc solid;color:#0056cd;';
                            }
                            else {
                                $disabledBtn = "";
                                //$btnClass = 'btn-primary';
                                $btnStyle = 'background:#dddddd;border:1px #aaaaaa solid;color:#454545;';
                            }
                            $this->content .= "<a href='" . $_SERVER['PHP_SELF'] . "?ps=$_GET[ps]&f=$vID' class='btn $btnClass' style='$btnStyle' $disabledBtn title='Tampilkan rincian berdasarkan " . $filterLabels[$this->r->getSelectedVar()] . "'>";
                            $this->content .= $filterLabels[$vID] . " ";
                            $this->content .= "<br><i class='badge btnFilter' style='color:#898989;background:transparent;font-size:12px;border:0px;'>$jmlEntry entri</i>";
                            $this->content .= "</a>";
                        }
                    }// </editor-fold>


                    $this->content .= "<br>";
                    // <editor-fold defaultstate="collapsed" desc="pilih perbandingan, versus">
                    $this->content .= "<span class='glyphicon glyphicon-th-list'></span> ";
                    $this->content .= "Bandingkan " . $reportConfig[$this->r->getJenis()]['filters'][$_GET['f']] . " dengan: ";
                    foreach ($varNames as $vID => $vSpec) {
                        $jmlEntry = count($vSpec);
                        if ($jmlEntry > 0) {
                            if ($vID != $_GET['f']) {
                                $this->content .= "<a href='../index/compare.php?j=" . $this->r->getJenis() . "&f1=$_GET[f]&f2=$vID' class='btn btn-link'>";
                                $this->content .= "<span class='glyphicon glyphicon-hand-right'></span>&nbsp;";
                                $this->content .= $reportConfig[$this->r->getJenis()]['filters'][$vID] . " ";
                                $this->content .= "</a>";
                            }
                        }
                    }// </editor-fold>

                    $this->content .= "</div class='alert alert-info'>";
                }


                //==pilih array berdasarkan sortMode
                //echo "".$this->r->getSortMode()."=".$this->r->getSortPoint();
                switch ($this->r->getSortMode()) {
                    case "qty":
                        $leadNames = $this->r->getYQtys()[$this->r->getSortPoint()];
                        arsort($leadNames);
                        break;
                    case "value":
                        $leadNames = $this->r->getYValues()[$this->r->getSortPoint()];
                        arsort($leadNames);
                        break;
                    case "totalQty":
                        $leadNames = $this->r->getYTotalQtys();
                        arsort($leadNames);
                        break;
                    case "totalValue":
                        $leadNames = $this->r->getYTotalValues();
                        arsort($leadNames);
                        break;
                    case "avgQty":
                        $leadNames = $this->r->getYAvgQtys();
                        arsort($leadNames);
                        break;
                    case "avgValue":
                        $leadNames = $this->r->getYAvgValues();
                        arsort($leadNames);
                        break;
                    case "name":
                        $leadNames = $this->r->getYNames();
                        asort($leadNames);
                        break;
                    default:
                        $leadNames = $this->r->getYNames();
                        asort($leadNames);
                        break;
                }

                //print_r($leadNames);
                //foreach ($varNames as $vID => $vSpec) {


                $jmlEntry = count($leadNames);

                if ($jmlEntry > 0) {

                    $this->content .= "<div id='exp$vID' class='panel-body'>";
                    $this->content .= "<span class='badge judulRincian'>";
                    $this->content .= "Rincian " . $filterLabels[$this->r->getSelectedVar()] . " dalam jumlah unit dan nilai " . $rpSatuans[$appConfig['rpSatuan']] . "</span> ";
                    $this->content .= "<table cellspacing=0 cellpadding=2 border=0 id='dTable' class='alert dialog display'>";
                    $this->content .= "<thead>";
                    $this->content .= "<tr>";
                    $this->content .= "<th  align=right class='colHeader'>";
                    $this->content .= "<span class='badge judulPeriode btn-block'>";
                    $this->content .= "No.";
                    $this->content .= "</span class='badge judulPeriode btn-block'>";
                    $this->content .= "<th class='colHeader'>";
                    $sortURL = $_SERVER['PHP_SELF'] . "?f=$_GET[f]&ps=$_GET[ps]&sortMode=name&sortPoint=e76kjhahsj4547445wsjdhsgdsdhg";
                    $this->content .= "<a href='$sortURL' title='Urutkan berdasarkan " . $filterLabels[$this->r->getSelectedVar()] . "'>";
                    $this->content .= "<span class='badge judulPeriode btn-block'>";
                    $this->content .= "Nama " . $filterLabels[$this->r->getSelectedVar()];
                    $this->content .= "</span class='badge judulPeriode btn-block'>";
                    $this->content .= "</a>";
                    $this->content .= "</th>";
                    foreach ($periodArray as $pID => $pName) {
                        $sortQtyURL = $this->r->getYQtys()[$pID] > 0 ? $_SERVER['PHP_SELF'] . "?f=$_GET[f]&ps=$_GET[ps]&sortMode=qty&sortPoint=$pID" : "#";
                        $sortValueURL = $this->r->getYValues()[$pID] > 0 ? $_SERVER['PHP_SELF'] . "?f=$_GET[f]&ps=$_GET[ps]&sortMode=value&sortPoint=$pID" : "#";
                        $pointBgColor = $pID == $this->r->getSortPoint() ? "#ffffc0" : "transparent";
                        $this->content .= "<th colspan=2 align=center class='colHeader'>";


                        $this->content .= $pName;


                        $this->content .= "</th>";
                    }


                    // <editor-fold defaultstate="collapsed" desc="total kanan">
                    $this->content .= "<th colspan=2 align=center class='colTotalHeader'>";


                    $this->content .= "total";


                    $this->content .= "</th>"; // </editor-fold>
                    // <editor-fold defaultstate="collapsed" desc="rata2 kanan">
                    $this->content .= "<th colspan=2 align=center class='colAvgHeader'>";


                    $this->content .= "" . $this->r->getPeriodType() . "<brot>&nbsp;AVG";


                    $this->content .= "</th>"; // </editor-fold>


                    $this->content .= "</tr>";
                    $this->content .= "</thead>";

                    $this->content .= "<tbody>";

                    $itemCounter = 0;

                    $verticalQty = array();
                    $verticalValue = array();

                    foreach ($leadNames as $k => $vhfgdghdhg) {
                        $itemCounter++;
                        //echo "selVar".$this->r->getSelectedVar()."<br>";
                        $vID = $this->r->getSelectedVar();
                        $v = $this->r->getYNames()[$k];
                        $lineRowBorderColor = ($itemCounter % 3) == 0 ? "#777799" : "#ccccee";
                        $varLabel = strlen($v) > 0 ? $v : "(anonim)";
                        $this->content .= "<tr>";
                        //$this->content .= "<strong class='label' style='background:#009900;color:#ffffff;'>" . number_format($results['qty'][$vID][$k]) . "</strong> $varLabel " . "<span class='badge' style='color:#dd3300;background:#fff0f0;border:1px #dd3300 solid;'><sup>Rp.</sup>" . number_format($results['value'][$vID][$k] / $appConfig['rpSatuan']) . "</span><br>";
                        $this->content .= "<td  align=right style='border-bottom:1px $lineRowBorderColor solid;border-right:1px #cccccc solid;' class='colHeader'>";
                        $this->content .= "<span class='badge judulPeriode btn-block'>";
                        $this->content .= "$itemCounter.";
                        $this->content .= "</span class='badge judulPeriode btn-block'>";
                        $this->content .= "</td>";

                        $this->content .= "<td class='colVarName' style='border-bottom:1px $lineRowBorderColor solid;' >" . str_replace(" ", "&nbsp;", $varLabel);
                        $this->content .= "</td>";

                        $tmpTotal = array();
                        foreach ($periodArray as $pID => $pName) {
                            $strQty = $resultsPertime['qty'][$vID][$k][$pID] > 0 ? "<span class='badge angkaRegQty'>" . number_format($resultsPertime['qty'][$vID][$k][$pID]) . "</span>" : "";
                            $strValue = $resultsPertime['value'][$vID][$k][$pID] > 0 ? "<span class='badge angkaRegValue'>" . number_format($resultsPertime['value'][$vID][$k][$pID] / $appConfig['rpSatuan']) : "";

                            $tmpTotal['qty'] += $resultsPertime['qty'][$vID][$k][$pID];
                            $tmpTotal['value'] += $resultsPertime['value'][$vID][$k][$pID];

                            $strEmpty = "$pName";
                            $colBG = $resultsPertime['qty'][$vID][$k][$pID] > 0 ? "#ddeeff" : "transparent";


                            $verticalQty[$pID] += $resultsPertime['qty'][$vID][$k][$pID];
                            $verticalValue[$pID] += $resultsPertime['value'][$vID][$k][$pID];

                            if ($this->r->getPeriodType() != 'weekly') {
                                $histLink = "../history/?j=" . $this->r->getJenis() . "&ft=" . $_GET['f'] . "&fv=" . $k . "&pt=" . $this->r->getPeriodType() . "&pp=" . $this->r->getPeriodPoint() . "&psp=" . $pID;
                                $histTitle = "$varLabel, $pName, klik untuk menampilkan riwayat";
                            }
                            else {
                                $histLink = "JavaScript:void(0)";
                                $histTitle = "$varLabel, $pName, riwayat tidak tersedia untuk periode mingguan";
                            }

                            if ($resultsPertime['qty'][$vID][$k][$pID] > 0) {
                                $pointBgColor = ($this->r->getSortMode() == "qty" && $pID == $this->r->getSortPoint()) ? "#ffffc0" : "transparent";
                                $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;' align=right class='colRegLeft' bgcolor=$pointBgColor>";
                                $this->content .= "<a href='$histLink' title='$histTitle'>";
                                $this->content .= $strQty;
                                $this->content .= "</a>";
                                $this->content .= "</td>";
                                $pointBgColor = ($this->r->getSortMode() == "value" && $pID == $this->r->getSortPoint()) ? "#ffffc0" : "transparent";
                                $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;'  align=right class='colRegRight' bgcolor=$pointBgColor>";
                                $this->content .= "<a href='$histLink' title='$histTitle'>";
                                $this->content .= $strValue;
                                $this->content .= "</a>";
                                $this->content .= "</td>";
                            }
                            else {

                                $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;'  align=center colspan=2 class='colRegSpan'>";
                                $this->content .= "<span class='angkaKosong'>";
                                $this->content .= $strEmpty;
                                $this->content .= "</span class='angkaKosong'>";
                                $this->content .= "</td>";
                            }
                        }
                        // <editor-fold defaultstate="collapsed" desc="total">

                        if ($this->r->getPeriodType() != 'weekly') {
                            $histLink = "../history/?j=" . $this->r->getJenis() . "&ft=" . $_GET['f'] . "&fv=" . $k . "&pt=" . $this->r->getPeriodType() . "&pp=" . $this->r->getPeriodPoint();
                            $histTitle = "$varLabel, klik untuk menampilkan riwayat";
                        }
                        else {
                            $histLink = "JavaScript:void(0)";
                            $histTitle = "$varLabel, riwayat tidak tersedia untuk periode mingguan";
                        }

                        $strQty = $tmpTotal['qty'] > 0 ? "" . number_format($tmpTotal['qty']) . "" : "";
                        $strValue = $tmpTotal['value'] > 0 ? "" . number_format($tmpTotal['value'] / $appConfig['rpSatuan']) . "" : "";
                        $pointBgColor = ($this->r->getSortMode() == "totalQty") ? "#ffffc0" : "transparent";
                        $this->content .= "<td align=right class='colTotalQty' style='background:$pointBgColor;'>";
                        $this->content .= "<span class='judulHeader btn-block'>";
                        $this->content .= "<a href='$histLink' title='$histTitle'>";
                        $this->content .= $strQty;
                        $this->content .= "</a>";
                        $this->content .= "</span>";
                        $this->content .= "</td>";
                        $pointBgColor = ($this->r->getSortMode() == "totalValue") ? "#ffffc0" : "transparent";
                        $this->content .= "<td align=right class='colTotalRp' style='background:$pointBgColor;'>";
                        $this->content .= "<a href='$histLink' title='$histTitle'>";
                        $this->content .= $strValue;
                        $this->content .= "</a>";
                        $this->content .= "</td>"; // </editor-fold>
                        // <editor-fold defaultstate="collapsed" desc="avg">
                        $strQty = $tmpTotal['qty'] > 0 ? "" . number_format($tmpTotal['qty'] / $this->r->getAvgFactor(), 2) . "" : "";
                        $strValue = $tmpTotal['value'] > 0 ? "" . number_format($tmpTotal['value'] / $this->r->getAvgFactor() / $appConfig['rpSatuan']) . "" : "";
                        $pointBgColor = ($this->r->getSortMode() == "avgQty") ? "#ffffc0" : "transparent";
                        $this->content .= "<td align=right  class='colAvgQty' style='background:$pointBgColor;'>" . $strQty;
                        $this->content .= "</td>";
                        $pointBgColor = ($this->r->getSortMode() == "avgValue") ? "#ffffc0" : "transparent";
                        $this->content .= "<td align=right class='colAvgRp' style='background:$pointBgColor;'>" . $strValue;
                        $this->content .= "</td>"; // </editor-fold>

                        $this->content .= "</tr>";
                    }

                    // <editor-fold defaultstate="collapsed" desc="total bawah">
                    $this->content .= "<tr >";
                    $this->content .= "<td class='colFooter'  colspan=2>";
                    $this->content .= "<span class='badge judulPeriode btn-block'>";
                    $this->content .= "TOTAL PER-" . strtoupper($this->r->getLabels()['periodName']) . "";
                    $this->content .= "</span class='badge judulPeriode btn-block'>";
                    $this->content .= "</td>";
                    foreach ($periodArray as $pID => $pName) {
                        $strQty = $verticalQty[$pID] > 0 ? "<span class='badge' style='background:transparent;color:#0077ff;'>" . number_format($verticalQty[$pID]) . "</span>" : "";
                        $strValue = $verticalValue[$pID] > 0 ? "<span class='badge' style='background:transparent;color:#dd3300;border:0px #dd3300 solid;'>" . number_format($verticalValue[$pID] / $appConfig['rpSatuan']) : "";
                        $strEmpty = "$pName";

                        if ($verticalQty[$pID] > 0) {
                            $this->content .= "<td class='colFooter' align=right>" . $strQty;
                            $this->content .= "</td>";
                            $this->content .= "<td class='colFooter' align=right>" . $strValue;
                            $this->content .= "</td>";
                        }
                        else {

                            $this->content .= "<td class='colFooter' align=center colspan=2>";
                            $this->content .= "<span class='badge judulPeriode btn-block'>";
                            $this->content .= $strEmpty;
                            $this->content .= "</td>";
                        }
                    }

                    $strQty = $vTOTAL["qty"] > 0 ? "" . number_format($vTOTAL["qty"]) : "";
                    $strValue = $vTOTAL["value"] > 0 ? "" . number_format($vTOTAL["value"] / $appConfig['rpSatuan']) : "";
                    $strEmpty = "$pName";

                    $this->content .= "<td class='colTotalQty'   align=right class='colTotalQty'>";
                    $this->content .= "<span class='badge judulTotal btn-block'>";
                    $this->content .= $strQty;
                    $this->content .= "</span>";
                    $this->content .= "</td>";
                    $this->content .= "<td class='colTotalRp'  align=right class='colTotalRp'>";
                    $this->content .= "<span class='badge judulTotal btn-block'>";
                    $this->content .= $strValue;
                    $this->content .= "</span>";
                    $this->content .= "</td>";

                    $strQty = $vTOTAL["qty"] > 0 ? "" . number_format($vTOTAL["qty"] / $this->r->getAvgFactor(), 2) : "";
                    $strValue = $vTOTAL["value"] > 0 ? "" . number_format($vTOTAL["value"] / $this->r->getAvgFactor() / $appConfig['rpSatuan']) : "";
                    $strEmpty = "$pName";

                    $this->content .= "<td class='colAvgQty'  align=right class='colAvgQty'>";
                    $this->content .= "<span class='badge judulAvg btn-block'>";
                    $this->content .= $strQty;
                    $this->content .= "</span>";
                    $this->content .= "</td>";
                    $this->content .= "<td class='colAvgRp'  align=right class='colAvgRp'>";
                    $this->content .= "<span class='badge judulAvg btn-block'>";
                    $this->content .= $strValue;
                    $this->content .= "</span>";
                    $this->content .= "</td>";

                    $this->content .= "</tr>"; // </editor-fold>

                    $this->content .= "</tbody>";

                    $this->content .= "</table>";
                    $this->content .= "</div>";
                    //}
                }
                //$this->content .= "<tr>";
                //$this->content .= "</table class='pager'>";
                $this->content .= "</div class='panel-body'>";
            }
        }
        else {//===kosong
            // <editor-fold defaultstate="collapsed" desc="hasil kosong">
            $this->content .= "<div class='row'>";

            $this->content .= "<div class='col-sm-12'>";
            $this->content .= "<div class='alert filterDialog'>";
            if ($this->viewType == "screen") {
                // <editor-fold defaultstate="collapsed" desc="filter periode">
                $periodFilters = $this->r->getPeriodFilters();
                if (sizeof($periodFilters) > 0) {
                    $this->content .= "<div class='input-group'>";
                    $this->content .= "<span class='input-group-addon'><i class='glyphicon glyphicon-calendar'></i></span>";
                    $this->content .= "<select class='form-control' onChange=\"location.href='" . $_SERVER['PHP_SELF'] . "?f=$_GET[f]&ps='+this.value;\">";
                    foreach ($periodFilters as $pID) {
                        $periodSelected = $pID == $this->r->getPeriodPoint() ? "selected" : "";
                        $this->content .= "<option value='$pID' $periodSelected>" . $this->r->getLabels()['periodParentName'] . " " . convertDatetimeToShort($pID) . "</option>";
                    }
                    $this->content .= "</select>";

                    $this->content .= "</div class='input-group'>";
                }// </editor-fold>
            }
            $this->content .= "</div class='alert filterDialog'>";

            $this->content .= "<div class='alert alert-danger'>";
            $this->content .= "Laporan pada periode ini kosong.<br>Silahkan pilih periode yang lain melalui selektor di bagian atas halaman.";
            $this->content .= "</div class='alert alert-danger'>";

            $this->content .= "</div class='col'>";
            $this->content .= "<div class='row'>";
            // </editor-fold>
        }
        if ($this->viewType == "print") {//===matikan link2 jika mode print
            $this->content = str_replace("<a ", "<asu ", $this->content);
            $this->content = str_replace("</a ", "</asu ", $this->content);
        }
    }

}
