<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of RBasic
 * @author aziz
 */
//echo date("l", mktime(0, 0, 0, 12, 11, 2017));
class RPeriodicReport
{

    //put your code here
    private $jenis;
    private $periodType; // eq:monthly, weekly, daily, range
    private $periodPoint; // eq:2017, atau 2017-12
    private $periodPoints = array(); //runtutan nama2 bulan/nomor2 tanggal
    private $periodFilters = array(); //filter periode buat dipilih, contoh isinya {2014,2015,2016,2017}
    private $rawPeriods = array();
    private $rawDataCount; //jumlah baris tabel yang terlibat
    private $results;
    private $resultsPertime;
    private $varNames;
    private $selectedVar;
    private $labels = array();
    private $avgFactor;
    //====for sorting purpose
    // <editor-fold defaultstate="collapsed" desc="sorting properties">
    private $sortMode;
    private $sortPoint;
    private $sortedEntries;
    private $yNames = array();
    private $yQtys = array();
    private $yValues = array();
    private $yTotalQtys = array();
    private $yTotalValues = array();
    private $yAvgQtys = array();
    private $yAvgValues = array();
    // </editor-fold>
    //==terpaksa dijadikan properti
    private $clause; //==klausa query, diset di konstruktor biar bisa dievaluasi

    // <editor-fold defaultstate="collapsed" desc="getter setter, kampungan">

    function getClause()
    {
        return $this->clause;
    }

    function setClause($clause)
    {
        $this->clause = $clause;
    }

    function getRawDataCount()
    {
        return $this->rawDataCount;
    }

    function setRawDataCount($rawDataCount)
    {
        $this->rawDataCount = $rawDataCount;
    }

    function getYAvgQtys()
    {
        return $this->yAvgQtys;
    }

    function getYAvgValues()
    {
        return $this->yAvgValues;
    }

    function setYAvgQtys($yAvgQtys)
    {
        $this->yAvgQtys = $yAvgQtys;
    }

    function setYAvgValues($yAvgValues)
    {
        $this->yAvgValues = $yAvgValues;
    }

    function getYTotalQtys()
    {
        return $this->yTotalQtys;
    }

    function getYTotalValues()
    {
        return $this->yTotalValues;
    }

    function setYTotalQtys($yTotalQtys)
    {
        $this->yTotalQtys = $yTotalQtys;
    }

    function setYTotalValues($yTotalValues)
    {
        $this->yTotalValues = $yTotalValues;
    }

    function getSortMode()
    {
        return $this->sortMode;
    }

    function getSortPoint()
    {
        return $this->sortPoint;
    }

    function getSortedEntries()
    {
        return $this->sortedEntries;
    }

    function getYNames()
    {
        return $this->yNames;
    }

    function getYQtys()
    {
        return $this->yQtys;
    }

    function getYValues()
    {
        return $this->yValues;
    }

    function getYTotals()
    {
        return $this->yTotals;
    }

    function getYAvgs()
    {
        return $this->yAvgs;
    }

    function setSortMode($sortMode)
    {
        $this->sortMode = $sortMode;
    }

    function setSortPoint($sortPoint)
    {
        $this->sortPoint = $sortPoint;
    }

    function setSortedEntries($sortedEntries)
    {
        $this->sortedEntries = $sortedEntries;
    }

    function setYNames($yNames)
    {
        $this->yNames = $yNames;
    }

    function setYQtys($yQtys)
    {
        $this->yQtys = $yQtys;
    }

    function setYValues($yValues)
    {
        $this->yValues = $yValues;
    }

    function setYTotals($yTotals)
    {
        $this->yTotals = $yTotals;
    }

    function setYAvgs($yAvgs)
    {
        $this->yAvgs = $yAvgs;
    }

    function getSelectedVar()
    {
        return $this->selectedVar;
    }

    function setSelectedVar($selectedVar)
    {
        $this->selectedVar = $selectedVar;
    }

    function getAvgFactor()
    {
        return $this->avgFactor;
    }

    function setAvgFactor($avgFactor)
    {
        $this->avgFactor = $avgFactor;
    }

    function getRawPeriods()
    {
        return $this->rawPeriods;
    }

    function setRawPeriods($rawPeriods)
    {
        $this->rawPeriods = $rawPeriods;
    }

    function getResultsPertime()
    {
        return $this->resultsPertime;
    }

    function setResultsPertime($resultsPertime)
    {
        $this->resultsPertime = $resultsPertime;
    }

    function getPeriodFilters()
    {
        return $this->periodFilters;
    }

    function setPeriodFilters($periodFilters)
    {
        $this->periodFilters = $periodFilters;
    }

    function getSatuan()
    {
        return $this->satuan;
    }

    function setSatuan($satuan)
    {
        $this->satuan = $satuan;
    }

    function getLabels()
    {
        return $this->labels;
    }

    function setLabels($labels)
    {
        $this->labels = $labels;
    }

    function getPeriodPoints()
    {
        return $this->periodPoints;
    }

    function setPeriodPoints($periodPoints)
    {
        $this->periodPoints = $periodPoints;
    }

    function getResults()
    {
        return $this->results;
    }

    function getVarNames()
    {
        return $this->varNames;
    }

    function setResults($results)
    {
        $this->results = $results;
    }

    function setVarNames($varNames)
    {
        $this->varNames = $varNames;
    }

    function getJenis()
    {
        return $this->jenis;
    }

    function getAvailFilters()
    {
        return $reportConfig[$this->jenis]['filters'];
    }

    function getPeriodType()
    {
        return $this->periodType;
    }

    function getPeriodPoint()
    {
        return $this->periodPoint;
    }

    function setJenis($jenis)
    {
        $this->jenis = $jenis;
    }

    function setAvailFilters($availFilters)
    {
        $reportConfig[$this->jenis]['filters'] = $availFilters;
    }

    function setPeriodType($periodType)
    {
        $this->periodType = $periodType;
    }

    function setPeriodPoint($periodPoint)
    {
        $this->periodPoint = $periodPoint;
    }

    // </editor-fold>


    public function __construct($jenis, $periodType, $periodPoint)
    {
        global $connectionParams, $reportConfig, $productExecptions;
        $this->jenis = $jenis;
        $this->periodType = $periodType;
        $this->periodPoint = $periodPoint;
        $this->selectedVar = $reportConfig[$this->jenis]['defaultFilter'];
        $this->sortMode = "name";
        $this->sortPoint = "";

        $this->clause = "transaksi_id=transaksi.id and jenis = '" . $this->jenis . "' and transaksi.trash<>'1' and transaksi_data.trash<>'1' and jenis<>'663' ";

        switch ($this->periodType) {
            case "monthly":
                $this->clause .= " and year(dtime)='" . $this->periodPoint . "'";
                if ($this->periodPoint == date("Y")) {
                    $this->labels = array(
                        "periodName"    => "bulan", "periodParentName" => "tahun", "periodTitle" => "year2date",
                        "periodCaption" => "bulanan",
                    );
                }
                else {
                    $this->labels = array(
                        "periodName"    => "bulan", "periodParentName" => "tahun", "periodTitle" => "tahun",
                        "periodCaption" => "bulanan",
                    );
                }

                for ($i = 1; $i <= 12; $i++) {
                    $strI = strlen($i) < 2 ? "0" . $i : $i;
                    $this->rawPeriods[$strI] = date("M", strtotime("2001-" . $strI . "-01"));
                }
                break;
            case "weekly":
                $this->clause .= " and year(dtime)='" . $this->periodPoint . "'";
                $this->labels = array(
                    "periodName"    => "minggu", "periodParentName" => "tahun", "periodTitle" => "year2week",
                    "periodCaption" => "mingguan",
                );
                for ($i = 1; $i <= 55; $i++) {
                    $strI = strlen($i) < 2 ? "0" . $i : $i;
                    $this->rawPeriods[$strI] = "wk#" . $strI;
                }
                break;
            case "daily":
                //==kalau daily, berarti format periodPoint-nya semacam ini: 2017-12
                $thn = substr($this->periodPoint, 0, 4);
                $bln = substr($this->periodPoint, 5, 2);
                $this->clause .= " and year(dtime)='" . $thn . "' and month(dtime)='" . $bln . "'";
                $this->labels = array(
                    "periodName"    => "hari", "periodParentName" => "bulan", "periodTitle" => "month2date",
                    "periodCaption" => "harian",
                );
                for ($i = 1; $i <= 31; $i++) {
                    $strI = strlen($i) < 2 ? "0" . $i : $i;
                    $this->rawPeriods[$strI] = $strI;
                }
                break;
            default:
                break;
        }


        if (in_array($this->jenis, $productExecptions)) {
            $this->clause .= " and produk_jenis='produk' ";
        }
        else {
            $this->clause .= " and produk_jenis='bahan' ";
        }

        //$q .= " order by id desc limit 0, 1";
        //die($q);

        $connID = mysqli_connect($connectionParams['host'], $connectionParams['user'], $connectionParams['password'], $connectionParams['database']); //, $port, $socket);    
        $q = "SELECT count(transaksi_data.id) FROM transaksi,transaksi_data where " . $this->clause;

        $does = mysqli_query($connID, $q) or die(mysqli_error($connID) . " " . __FILE__ . " " . __LINE__);
        if (mysqli_num_rows($does) > 0) {
            while ($row = mysqli_fetch_row($does)) {
                $this->rawDataCount = $row[0];
            }
        }
    }

    public function arrange()
    {
        global $connectionParams, $reportConfig, $productExecptions;

        $connID = mysqli_connect($connectionParams['host'], $connectionParams['user'], $connectionParams['password'], $connectionParams['database']); //, $port, $socket);    
        $q = "SELECT * FROM transaksi,transaksi_data where " . $this->clause;

        $does = mysqli_query($connID, $q) or die(mysqli_error($connID) . " " . __FILE__ . " " . __LINE__);
        //$this->rawDataCount = mysqli_num_rows($does);
        if ($this->rawDataCount > 0) {
            //return mysqli_fetch_assoc($does);           

            $results = array();
            $resultsPertime = array();
            $varNames = array();
            $periodPoints = array();

            $startPoint = 0;
            $endPoint = 0;

            while ($row = mysqli_fetch_assoc($does)) {
                // <editor-fold defaultstate="collapsed" desc="akumulator by period">
                $thn = substr($row[dtime], 0, 4);
                $bln = substr($row[dtime], 5, 2);
                $tgl = substr($row[dtime], 8, 2);
                $week = getWeekNumber($row[dtime]);


                switch ($this->periodType) {
                    case "monthly":
                        if (sizeof($periodPoints) < 1) {
                            $startPoint = $bln;
                        }
                        $endPoint = $bln;
                        if (!array_key_exists($bln, $periodPoints)) {
                            $periodPoints[$bln] = date('F', mktime(0, 0, 0, $bln, 10));
                        }
                        $results['qty']["period"][$bln] += $row[produk_ord_jml];
                        $results['value']["period"][$bln] += ($row[produk_ord_jml] * $row[produk_ord_hrg]);
                        break;
                    case "weekly":
                        if (sizeof($periodPoints) < 1) {
                            $startPoint = $week;
                        }
                        $endPoint = $week;
                        if (!array_key_exists($week, $periodPoints)) {
                            $periodPoints[$week] = $week;
                        }
                        $results['qty']["period"][$week] += $row[produk_ord_jml];
                        $results['value']["period"][$week] += ($row[produk_ord_jml] * $row[produk_ord_hrg]);
                        break;
                    case "daily":
                        if (sizeof($periodPoints) < 1) {
                            $startPoint = $tgl;
                        }
                        $endPoint = $tgl;
                        if (!in_array($tgl, $periodPoints)) {
                            $periodPoints[$tgl] = $tgl;
                        }
                        $results['qty']["period"][$tgl] += $row[produk_ord_jml];
                        $results['value']["period"][$tgl] += ($row[produk_ord_jml] * $row[produk_ord_hrg]);
                        break;
                }// </editor-fold>


                foreach ($reportConfig[$this->jenis]['filters'] as $fID => $fName) {

                    //akumulator
                    $results['qty'][$fID][$row[$fID]] += $row[produk_ord_jml];
                    $results['value'][$fID][$row[$fID]] += ($row[produk_ord_jml] * $row[produk_ord_hrg]);

                    //==akumulator per-satuan waktu
                    switch ($this->periodType) {
                        case "monthly":
                            $resultsPertime['qty'][$fID][$row[$fID]][$bln] += $row[produk_ord_jml];
                            $resultsPertime['value'][$fID][$row[$fID]][$bln] += ($row[produk_ord_jml] * $row[produk_ord_hrg]);
                            break;
                        case "weekly":
                            $resultsPertime['qty'][$fID][$row[$fID]][$week] += $row[produk_ord_jml];
                            $resultsPertime['value'][$fID][$row[$fID]][$week] += ($row[produk_ord_jml] * $row[produk_ord_hrg]);
                            break;
                        case "daily":
                            $resultsPertime['qty'][$fID][$row[$fID]][$tgl] += $row[produk_ord_jml];
                            $resultsPertime['value'][$fID][$row[$fID]][$tgl] += ($row[produk_ord_jml] * $row[produk_ord_hrg]);
                            break;
                    }

                    //translator
                    $nameField = str_replace('id2', 'id', $fID);
                    $nameField = str_replace('id', 'nama', $nameField);
                    $varNames[$fID][$row[$fID]] = $row[$nameField];
                }
                $results['QTY'] += $row[produk_ord_jml];
                $results['VALUE'] += ($row[produk_ord_jml] * $row[produk_ord_hrg]);

                //==resort varNames
            }

            //print_r($results);
            //print_r($varNames);
            //print_r($resultsPertime);

            $this->results = $results;
            $this->resultsPertime = $resultsPertime;
            $this->varNames = $varNames;
            $this->periodPoints = $periodPoints;
            if ($this->periodType == "weekly") {
                $this->avgFactor = 10;
            }
            else {
                $this->avgFactor = ((int)$endPoint - (int)$startPoint) + 1;
            }

            //die("AVG Factor ".$this->avgFactor);
            // <editor-fold defaultstate="collapsed" desc="filter waktu">
            //===bikin filter waktu
            switch ($this->periodType) {
                case "weekly":
                case "monthly":
                    $qf = "SELECT year(dtime) as thn from transaksi group by thn ";

                    break;
                case "daily":
                    $qf = "SELECT date_format(dtime,'%Y-%m') as thnbln from transaksi group by thnbln";

                    break;
            }
            $doesf = mysqli_query($connID, $qf) or die(mysqli_error($connID) . " " . __FILE__ . " " . __LINE__);
            if (mysqli_num_rows($doesf) > 0) {
                while ($rowf = mysqli_fetch_row($doesf)) {
                    $this->periodFilters[$rowf[0]] = $rowf[0];
                }
            }// </editor-fold>
        }
        else {

            // <editor-fold defaultstate="collapsed" desc="filter waktu">
            //===bikin filter waktu
            switch ($this->periodType) {
                case "weekly":
                case "monthly":
                    $qf = "SELECT year(dtime) as thn from transaksi group by thn ";

                    break;
                case "daily":
                    $qf = "SELECT date_format(dtime,'%Y-%m') as thnbln from transaksi group by thnbln";

                    break;
            }
            $doesf = mysqli_query($connID, $qf) or die(mysqli_error($connID) . " " . __FILE__ . " " . __LINE__);
            if (mysqli_num_rows($doesf) > 0) {
                while ($rowf = mysqli_fetch_row($doesf)) {
                    $this->periodFilters[$rowf[0]] = $rowf[0];
                }
            }// </editor-fold>
            return null;
        }
    }

    //==fungsi normalize ini dibuat untuk keperluan sorting
    public function normalize()
    {
        if (sizeof($this->varNames[$this->selectedVar]) > 0) {
            foreach ($this->varNames[$this->selectedVar] as $fID => $fName) {
                $fLabel = $this->selectedVar;
                //echo "fLabel:$fLabel<br>";
                foreach ($this->periodPoints as $pID => $pName) {
                    if (!isset($this->resultsPertime['qty'][$fLabel][$fID][$pID])) {
                        $this->resultsPertime['qty'][$fLabel][$fID][$pID] = 0;
                    }
                    if (!isset($this->resultsPertime['value'][$fLabel][$fID][$pID])) {
                        $this->resultsPertime['value'][$fLabel][$fID][$pID] = 0;
                    }
                    $this->yQtys[$pID][$fID] = $this->resultsPertime['qty'][$fLabel][$fID][$pID];
                    $this->yValues[$pID][$fID] = $this->resultsPertime['value'][$fLabel][$fID][$pID];

                    $this->yTotalQtys[$fID] += $this->resultsPertime['qty'][$fLabel][$fID][$pID];
                    $this->yTotalValues[$fID] += $this->resultsPertime['value'][$fLabel][$fID][$pID];

                    $this->yAvgQtys[$fID] = ($this->yTotalQtys[$fID] / $this->avgFactor);
                    $this->yAvgValues[$fID] = ($this->yTotalValues[$fID] / $this->avgFactor);
                }
                //print_r($this->resultsPertime['qty'][$this->selectedVar][$fID]);
                asort($this->resultsPertime['qty'][$this->selectedVar][$fID]);
            }
            $this->yNames = $this->varNames[$this->selectedVar];
        }
    }

}
