<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of RParser
 * @author aziz
 */
class RParser
{

    //put your code here    
    private $r; //===connector ke objek RBasic
    private $content;

    function getContent()
    {
        return $this->content;
    }

    function setContent($content)
    {
        $this->content = $content;
    }

    function getR()
    {
        return $this->r;
    }

    function setR($r)
    {
        $this->r = $r;
    }

    public function __construct($r)
    {
        $this->r = $r;
    }

    public function parse()
    {
        global $reportTypes;
        $resultCount = count($this->r->getResults());
        if ($resultCount > 0) {
            $results = $this->r->getResults();
            $resultsPertime = $this->r->getResultsPertime();
            $varNames = $this->r->getVarNames();
            $periodNames = $this->r->getPeriodPoints();

            switch ($this->r->getPeriodType()) {
                case "weekly":
                case "monthly":
                    if ($this->r->getPeriodPoint() == date("Y")) {
                        $jmlPeriode = (date("m") - min($periodNames));
                    }
                    else {
                        $jmlPeriode = (max($periodNames) - min($periodNames));
                    }
                    break;
                case "daily":
                    if ($this->r->getPeriodPoint() == date("Y-m")) {
                        $jmlPeriode = (date("d") - min($periodNames));
                    }
                    else {
                        $jmlPeriode = (max($periodNames) - min($periodNames));
                    }
                    break;
            }


            $this->content .= "<div class='panel-body'>";

            $this->content .= "<div class='row'>";
            $this->content .= "<div class='col-sm-6 alert alert-success'>";
            $this->content .= "TOTAL " . $reportTypes[$this->r->getJenis()] . " selama " . $jmlPeriode . " " . $this->r->getLabels()['periodName'] . " di <strong>" . $this->r->getLabels()['periodParentName'] . " " . $this->r->getPeriodPoint() . "</strong><br>";

            $this->content .= "<span class='badge' style='font-size:22px;background:#0077ff;'>" . number_format($results['QTY']) . "</span>";
            $this->content .= "<span class='badge' style='font-size:20px;color:#dd3300;background:#fff0f0;border:1px #dd3300 solid;'>Rp." . number_format($results['VALUE'] / $this->r->getSatuan()) . "</span>";
            $this->content .= "<br>";
            $this->content .= "<span class='badge' style='font-size:14px;background:#f0fff0;color:#0077ff;'>" . "UNIT" . "</span>";
            //$this->content .= "<span class='badge' style='font-size:14px;color:#f0f0f0;background:#dd3300;'>" . "RP" . "</span>";

            $this->content .= "</div class='col'>";

            $this->content .= "<div class='col-sm-6 alert alert-info'>";
            $periodFilters = $this->r->getPeriodFilters();
            if (sizeof($periodFilters) > 0) {
                $this->content .= "Pilih " . $this->r->getLabels()['periodParentName'];
                $this->content .= "<div class='input-group'>";
                $this->content .= "<span class='input-group-addon'><i class='glyphicon glyphicon-calendar'></i></span>";
                $this->content .= "<select class='form-control' onChange=\"location.href='" . $_SERVER['PHP_SELF'] . "?ps='+this.value;\">";
                foreach ($periodFilters as $pID) {
                    $periodSelected = $pID == $this->r->getPeriodPoint() ? "selected" : "";
                    $this->content .= "<option value='$pID' $periodSelected>$pID</option>";
                }
                $this->content .= "</select>";
                $this->content .= "</div class='input-group'>";
            }
            $this->content .= "</div class='col'>";

            $this->content .= "</div class='row'>";

            $this->content .= "</div>";

            if (sizeof($periodNames) > 0) {

                $this->content .= "<div class='panel-body text-center'>";
                $this->content .= "<div class='row'>";
                $this->content .= "<div class='col-sm-1 text-center alert alert-info'>";
                $this->content .= "<span class='label text-left' style='background:#777777;'>";
                $this->content .= $this->r->getLabels()['periodName'];
                $this->content .= "</span><br>";

                $this->content .= "<span class='badge' style='background:#0077ff;'>";

                $this->content .= "<strong>";
                $this->content .= "Jml";
                $this->content .= "</strong> ";
                $this->content .= "</span><br>";

                //$this->content .= "<sup>Rp.</sup>";
                $this->content .= "Nilai";

                $this->content .= "</div>";
                $this->content .= "<div class='row'>";
                foreach ($periodNames as $pID => $pName) {

                    $this->content .= "<div class='col-sm-1 text-left alert alert-warning'>";
                    $this->content .= "<span class='label text-center' style='background:#f0f0f0;color:#454545;'>";
                    $this->content .= $pName;
                    $this->content .= "</span><br>";

                    $this->content .= "<span class='badge text-center' style='background:#009900;'>";
                    $this->content .= "<strong>";
                    $this->content .= number_format($results['qty']['period'][$pID]);
                    $this->content .= "</strong>";
                    $this->content .= "</span><br>";


                    $this->content .= "<span class='badge text-right' style='color:#dd3300;background:#fff0f0;border:1px #dd3300 solid;'>";
                    //$this->content .= "<sup>Rp.</sup>";
                    $this->content .= number_format($results['value']['period'][$pID] / $this->r->getSatuan());
                    $this->content .= "</span>";
                    $this->content .= "</div>";
                }


                $this->content .= "<div class='col-sm-1 text-left alert alert-success'>";
                $this->content .= "<span class='label text-left' style='background:#999999;'>";
                $this->content .= "TOTAL";
                $this->content .= "</span><br>";

                $this->content .= "<span class='badge text-center' style='background:#009900;'>";
                $this->content .= "<strong>";
                $this->content .= number_format($results['QTY']);
                $this->content .= "</strong>&nbsp;<small>unit</small>";
                $this->content .= "</span><br>";


                $this->content .= "<span class='badge text-right' style='color:#dd3300;background:#fff0f0;border:1px #dd3300 solid;'>";
                //$this->content .= "<sup>Rp.</sup>";
                $this->content .= number_format($results['VALUE'] / $this->r->getSatuan());
                $this->content .= "</span>";
                $this->content .= "</div>";

                $this->content .= "</div class='row'>";
                $this->content .= "</div class='panel-body'>";
            }

            if (sizeof($varNames) > 0) {
                $this->content .= "<div class='panel-body text-left'>";
                //$this->content .= "Rincian per-filter: <br>";
                //$this->content .= "<table align=center border=1 bordercolor=red>";
                //$this->content .= "<tr>";
                foreach ($varNames as $vID => $vSpec) {
                    $jmlEntry = count($vSpec);
                    //$this->content .= "<td valign=top>";


                    /* $this->content .= "<a href=# class='btn btn-default btn-block' onclick=\"
                      if(document.getElementById('exp$vID').style.display=='none'){document.getElementById('exp$vID').style.display='block';this.className='btn btn-success btn-block';}else{document.getElementById('exp$vID').style.display='none';this.className='btn btn-default btn-block';}
                      \">"; */

                    $this->content .= "<a href='" . $_SERVER['PHP_SELF'] . "?ps=$_GET[ps]&f=$vID' class='btn btn-default btn-block'>";

                    $this->content .= " <span class='badge' style='color:#eeeeee;background:#0056cd;'>$jmlEntry</span> ";
                    $this->content .= "<span style='color:#454545;'>";
                    $this->content .= $this->r->getAvailFilters()[$vID] . " ";
                    $this->content .= "</span>";
                    $this->content .= "</a>";

                    if ($jmlEntry > 0) {
                        $defaultDisplay = $vID == $_GET['f'] ? "block" : "none";
                        $this->content .= "<div id='exp$vID' class='text-left' style='display:$defaultDisplay;'>";
                        $this->content .= "<table cellspacing=0 cellpadding=2 border=0>";
                        $this->content .= "<tr>";
                        $this->content .= "<td><span class='badge' style='background:#909090;'>" . $this->r->getAvailfilters()[$vID] . "</span> ";
                        $this->content .= "</td>";
                        foreach ($periodNames as $pID => $pName) {
                            $this->content .= "<td colspan=2 align=center><span class='badge' style='background:#9999cc;'>$pName</span>";
                            $this->content .= "</td>";
                        }
                        $this->content .= "<td colspan=2 align=center><span class='badge' style='background:#8888bb;'>TOTAL</span>";
                        $this->content .= "</td>";
                        $this->content .= "</tr>";

                        $itemCounter = 0;
                        foreach ($vSpec as $k => $v) {
                            $itemCounter++;
                            $lineRowBorderColor = ($itemCounter % 3) == 0 ? "#777799" : "#ccccee";
                            $varLabel = strlen($v) > 0 ? $v : "(anonim)";
                            $this->content .= "<tr>";
                            //$this->content .= "<strong class='label' style='background:#009900;color:#ffffff;'>" . number_format($results['qty'][$vID][$k]) . "</strong> $varLabel " . "<span class='badge' style='color:#dd3300;background:#fff0f0;border:1px #dd3300 solid;'><sup>Rp.</sup>" . number_format($results['value'][$vID][$k] / $this->r->getSatuan()) . "</span><br>";
                            $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;' ><span class='glyphicon glyphicon-ok-circle'></span> $varLabel";
                            $this->content .= "</td>";


                            foreach ($periodNames as $pID => $pName) {
                                $strQty = $resultsPertime['qty'][$vID][$k][$pID] > 0 ? "<span class='badge' style='background:#009900;'>" . number_format($resultsPertime['qty'][$vID][$k][$pID]) . "</span>" : "";
                                $strValue = $resultsPertime['value'][$vID][$k][$pID] > 0 ? "<span class='badge' style='background:transparent;color:#dd3300;border:1px #dd3300 solid;'>" . number_format($resultsPertime['value'][$vID][$k][$pID] / $this->r->getSatuan()) : "";
                                $strEmpty = "<span class='badge' style='background:transparent;color:#d5d5d5;'>$pName</span>";
                                if ($resultsPertime['qty'][$vID][$k][$pID] > 0) {
                                    $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;'  align=right>" . $strQty;
                                    $this->content .= "</td>";
                                    $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;'  align=right>" . $strValue;
                                    $this->content .= "</td>";
                                }
                                else {

                                    $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;'  align=center colspan=2>" . $strEmpty;
                                    $this->content .= "</td>";
                                }
                            }
                            $strQty = $results['qty'][$vID][$k] > 0 ? "<span class='badge' style='background:#009900;'>" . number_format($results['qty'][$vID][$k]) . "</span>" : "";
                            $strValue = $results['value'][$vID][$k] > 0 ? "<span class='badge' style='background:transparent;color:#dd3300;border:1px #dd3300 solid;'>" . number_format($results['value'][$vID][$k] / $this->r->getSatuan()) . "</span>" : "";
                            $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;'  align=right>" . $strQty;
                            $this->content .= "</td>";
                            $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;'  align=right>" . $strValue;
                            $this->content .= "</td>";

                            $this->content .= "</tr>";
                        }
                        $this->content .= "</table>";
                        $this->content .= "</div>";
                    }
                    //$this->content .= "</td>";
                }
                //$this->content .= "<tr>";
                //$this->content .= "</table class='pager'>";
                $this->content .= "</div class='panel-body'>";
            }
        }
        else {
            $this->content .= "kosong.";
        }
    }

}
