<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of RComparatorParser
 * @author aziz
 */
if (!isset($_SESSION['employee_jenis'])) {
    include_once 'template.php';
    $contentStr .= "<div class='alert alert-danger'>";
    $contentStr .= "Anda tidak diperkenankan mengakses halaman ini<br>";
    $contentStr .= "Silahkan perbarui status wewenang anda dengan cara masuk pada <strong>web " . $connectionParams['label'] . "</strong><br>";
    $contentStr .= "<a href='" . $connectionParams['homepage'] . "'>Ke " . $connectionParams['label'] . "</a><br>";
    $contentStr .= "</div class='alert alert-danger'>";
    $p = new clTemplate();
    $p->defineTheme("../viewer.html");
    $p->defineTag("{title}", "Anda Tak Punya Wewenang");
    $p->defineTag("{backURL}", "JavaScript:void(0);");
    $p->defineTag("{backTitle}", "Ini sudah paling depan");
    $p->defineTag("{content}", $contentStr);
    $p->parse();
    $p->printTheme();
    die();
}

class RComparatorParser
{

    //put your code here
    private $r; //===connector ke objek RBasic
    private $content;
    private $title;
    private $backURL;
    private $backTitle;
    private $viewType; //==is it screen or print

    // <editor-fold defaultstate="collapsed" desc="getter-setter">

    function getViewType()
    {
        return $this->viewType;
    }

    function setViewType($viewType)
    {
        $this->viewType = $viewType;
    }

    function getBackURL()
    {
        return $this->backURL;
    }

    function getBackTitle()
    {
        return $this->backTitle;
    }

    function setBackURL($backURL)
    {
        $this->backURL = $backURL;
    }

    function setBackTitle($backTitle)
    {
        $this->backTitle = $backTitle;
    }

    function getR()
    {
        return $this->r;
    }

    function getContent()
    {
        return $this->content;
    }

    function getTitle()
    {
        return $this->title;
    }

    function setR($r)
    {
        $this->r = $r;
    }

    function setContent($content)
    {
        $this->content = $content;
    }

    function setTitle($title)
    {
        $this->title = $title;
    }

    // </editor-fold>

    function __construct($r)
    {
        global $reportTypes, $appConfig, $filterLabels;
        $this->viewType = "screen";
        $this->r = $r;
        $this->title .= $reportTypes[$this->r->getJenis()] . " ";
        $this->title .= $filterLabels[$this->r->getFilter1()] . " vs. " . $filterLabels[$this->r->getFilter2()];
        $this->title .= " ";
        $this->title .= convertDatetimeToShort($this->r->getDate1());
        $this->title .= " s/d. ";
        $this->title .= convertDatetimeToShort($this->r->getDate2());
        switch ($appConfig['rpSatuan']) {
            case 1000:
                $this->title .= " (dalam ribuan)";
                break;
            case 1000000:
                $this->title .= " (dalam jutaan)";
                break;
        }
        $this->backURL = "../index/";
        $this->backTitle = "Ke Indeks Laporan";
    }

    public function parse()
    {
        global $reportTypes, $rpSatuans, $filterLabels, $appConfig;

        $this->content .= "<div class='panel-body'>";
        $this->content .= "<span class='badge judulRincian'>";
        $this->content .= "TOTAL " . $reportTypes[$this->r->getJenis()] . " ";
        $this->content .= convertDatetimeToShort($this->r->getDate1());
        $this->content .= " s/d. ";
        $this->content .= convertDatetimeToShort($this->r->getDate2());
        $this->content .= "</span>";
        $this->content .= "<div class='row alert dialog'>";

        $this->content .= "<div class='col-sm-6'>";

        // <editor-fold defaultstate="collapsed" desc="angka total besar">
        $this->content .= "<table cellspacing=0 cellpadding=2>";
        $this->content .= "<tr>";
        $this->content .= "<td class='resTotalQtyLabel'>dalam unit";
        $this->content .= "</td class='col-sm-4'>";
        $this->content .= "<td class='resTotalQtyLabel'>:";
        $this->content .= "</td class='col-sm-1'>";
        $this->content .= "<td class='text-right resTotalQtyValue'>" . number_format($this->r->getResultTotal()['qty']);
        $this->content .= "</td class='col-sm-4'>";
        $this->content .= "</tr>";


        $this->content .= "<tr>";
        $this->content .= "<td class='resTotalRpLabel'>dalam " . $rpSatuans[$appConfig['rpSatuan']];
        $this->content .= "</div class='col-sm-4'>";
        $this->content .= "<td class='resTotalRpLabel'>:";
        $this->content .= "</td class='col-sm-1'>";
        $this->content .= "<td class='text-right resTotalRpValue'>" . number_format($this->r->getResultTotal()['value'] / $appConfig['rpSatuan']);
        $this->content .= "</td class='col-sm-4'>";
        $this->content .= "</tr class='row'>";
        $this->content .= "</table>";
        // </editor-fold>


        $this->content .= "</div class='col'>";

        if ($this->viewType == "screen") {
            // <editor-fold defaultstate="collapsed" desc="filter range tanggal">
            $periodFilters = $this->r->getPeriodFilters();
            if (sizeof($periodFilters) > 0) {
                $this->content .= "<div class='col-sm-3'>";
                //$this->content .= "Pilih " . $this->r->getLabels()['periodParentName'];
                $this->content .= "<div class='input-group'>";
                $this->content .= "<span class='input-group-addon'><i class='glyphicon glyphicon-calendar'></i></span>";
                $this->content .= "<select class='form-control' id=dt1>";
                foreach ($periodFilters as $pID) {
                    $periodSelected = $pID == $this->r->getDate1() ? "selected" : "";
                    $this->content .= "<option value='$pID' $periodSelected>" . " " . convertDatetimeToShort($pID) . "</option>";
                }
                $this->content .= "</select>";
                $this->content .= "</div class='input-group'>";


                $this->content .= "</div class='col'>";

                $this->content .= "<div class='col-sm-3'>";

                $this->content .= "<div class='input-group'>";
                $this->content .= "<span class='input-group-addon'><i class='glyphicon glyphicon-calendar'></i></span>";
                $this->content .= "<select class='form-control' id=dt2>";
                foreach ($periodFilters as $pID) {
                    $periodSelected = $pID == $this->r->getDate2() ? "selected" : "";
                    $this->content .= "<option value='$pID' $periodSelected>" . " " . convertDatetimeToShort($pID) . "</option>";
                }
                $this->content .= "</select>";
                $this->content .= "<span class='input-group-addon'>";
                $this->content .= "<button onclick=\"location.href='" . $_SERVER['PHP_SELF'] . "?j=" . $this->r->getJenis() . "&f1=" . $this->r->getFilter1() . "&f2=" . $this->r->getFilter2() . "&dt1='+document.getElementById('dt1').value+'&dt2='+document.getElementById('dt2').value;\">";
                $this->content .= "<span class='glyphicon glyphicon-refresh'></span>";
                $this->content .= "</button></span>";

                $this->content .= "<span class='input-group-addon'>";
                $this->content .= "<a title='Tampilkan versi siap cetak' href=# onclick=\"window.open('" . $_SERVER['PHP_SELF'] . "?j=$_GET[j]&f1=$_GET[f1]&f2=$_GET[f2]&dt1='+document.getElementById('dt1').value+'&dt2='+document.getElementById('dt2').value+'&vt=print');\">";
                $this->content .= "<i class='glyphicon glyphicon-print'></i>";
                $this->content .= "</a>";
                $this->content .= "</span>";

                $this->content .= "</div class='input-group'>";
            }
            $this->content .= "</div class='col'>"; // </editor-fold>
        }
        $this->content .= "</div class='row'>";

        $this->content .= "</div>";


        $this->content .= "<div class='panel-body'>";
        $this->content .= "<span class='badge judulRincian'>";
        $this->content .= "Perbandingan " . $reportTypes[$this->r->getJenis()] . " <strong style='color:#009900;'>" . $filterLabels[$this->r->getFilter1()] . " vs. " . $filterLabels[$this->r->getFilter2()] . "</strong> dalam jumlah unit dan nilai " . $rpSatuans[$appConfig['rpSatuan']] . "";
        $this->content .= "</span class='badge judulRincian'>";
        $this->content .= "<br>";
        $this->content .= "<span class='badge judulRincian'>";
        $this->content .= convertDatetimeToShort($this->r->getDate1());
        $this->content .= " s/d. ";
        $this->content .= convertDatetimeToShort($this->r->getDate2());
        $this->content .= "</span class='alert'>";

        $this->content .= "<table cellspacing=0 cellpadding=2 border=0 class='alert dialog'>";
        $this->content .= "<tr>";
        $this->content .= "<td class='colHeader'>No.</td>";
        $this->content .= "<td class='colHeader'>";
        $this->content .= "<span class='badge judulPeriode'>";
        $this->content .= $filterLabels[$this->r->getFilter1()] . " vs " . $filterLabels[$this->r->getFilter2()];
        $this->content .= "</span>";
        $this->content .= "<a title='Balikkan sumbu (" . $filterLabels[$this->r->getFilter2()] . " vs " . $filterLabels[$this->r->getFilter1()] . ")' href='" . $_SERVER['PHP_SELF'] . "?j=" . $this->r->getJenis() . "&f1=" . $this->r->getFilter2() . "&f2=" . $this->r->getFilter1() . "&dt1=" . $this->r->getDate1() . "&dt2=" . $this->r->getDate2() . "'>";
        $this->content .= "<span class='glyphicon glyphicon-random btn btn-link'>";
        $this->content .= "</span>";
        $this->content .= "</a>";
        $this->content .= "</td>";
        foreach ($this->r->getVarsX() as $id => $name) {
            $pecahanNama = explode(" ", $name);
            //$strName = sizeof($pecahanNama) > 0 ? $pecahanNama[0] . ".." : $name;
            $strName = sizeof($pecahanNama) > 0 ? str_replace(" ", "<br>", $name) : $name;
            $this->content .= "<td class='colHeader' colspan=2 align=right>";
            $this->content .= "<a title='$name'><span class='badge judulPeriode'  style='writing-mode: vertical-rl;
  text-orientation: mixed;letter-spacing:0.5px;font-size:16px;font-weight:normal;text-align:right;'>";
            $this->content .= $strName;
            $this->content .= "</span></a></td>";
        }
        $this->content .= "<td colspan=2 class='colTotalHeader' align=center><a title='TOTAL'><span class='badge judulPeriode'>Total</span></a></td>";
        $this->content .= "<td colspan=2 class='colAvgHeader' align=center><a title='rata-rata per-" . $filterLabels[$this->r->getFilter2()] . "'><span class='badge judulPeriode'>" . $filterLabels[$this->r->getFilter2()] . "<br>AVG</span></a></td>";
        $this->content .= "<td colspan=2 class='colAvgHeader' align=center><a title='rata-rata harian'><span class='badge judulPeriode'>Daily<br>AVG</span></a></td>";
        $this->content .= "</tr>";

        $itemCounter = 0;
        foreach ($this->r->getVarsY() as $yID => $yName) {
            $itemCounter++;
            $lineRowBorderColor = ($itemCounter % 3) == 0 ? "#777799" : "#ccccee";
            $this->content .= "<tr>";
            $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;border-right:1px #cccccc solid;' align=right valign=top class='colHeader'>";
            $this->content .= "<span class='judulPeriode btn-block'>" . $itemCounter . ".</span>";
            $this->content .= "</td>";
            $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;' class='colVarName'>";
            $this->content .= "<span>" . str_replace(" ", "&nbsp;", $yName) . "</span>";
            $this->content .= "</td>";
            foreach ($this->r->getVarsX() as $xID => $xName) {
                $strQty = $this->r->getResults()['qty'][$yID][$xID] > 0 ? "<span class='badge angkaRegQty'>" . number_format($this->r->getResults()['qty'][$yID][$xID]) . "</span>" : "";
                $strValue = $this->r->getResults()['value'][$yID][$xID] > 0 ? "<span class='badge angkaRegValue'>" . number_format($this->r->getResults()['value'][$yID][$xID] / $appConfig['rpSatuan']) . "</span>" : "";
                $strEmpty = "<span class='badge' style='background:transparent;color:#d5d5d5;'>$xName</span>";

                //if ($this->r->getResults()['qty'][$yID][$xID] > 0) {

                $histLink = "../history/?j=" . $this->r->getJenis() . "&f1=" . $this->r->getFilter1() . "&f2=" . $this->r->getFilter2() . "&f1v=$yID&f2v=$xID&dt1=" . $this->r->getDate1() . "&dt2=" . $this->r->getDate2() . "";
                $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;' align=right class='colRegLeft'>";
                $this->content .= "<a title='$yName, $xName' href='$histLink'>";
                $this->content .= $strQty;
                $this->content .= "</a>";
                $this->content .= "</td>";
                $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;' align=right class='colRegRight'>";
                $this->content .= "<a title='$yName, $xName' href='$histLink'>";
                $this->content .= $strValue;
                $this->content .= "</a>";
                $this->content .= "</td>";
                //} else {
                //$this->content .= "<td colspan=2 style='border-bottom:1px $lineRowBorderColor solid;border-right:1px #a0c0f0 solid;' align=center>";                    
                //$this->content .= $strEmpty;                    
                //$this->content .= "</td>";
                //}
            }

            // <editor-fold defaultstate="collapsed" desc="total kanan">
            $strQty = $this->r->getResultsY()['qty'][$yID] > 0 ? "<span class='badge angkaRegQty'>" . number_format($this->r->getResultsY()['qty'][$yID]) . "</span>" : "";
            $strValue = $this->r->getResultsY()['value'][$yID] > 0 ? "<span class='badge angkaRegValue'>" . number_format($this->r->getResultsY()['value'][$yID] / $appConfig['rpSatuan']) . "</span>" : "";
            $histLink = "../history/?j=" . $this->r->getJenis() . "&f1=" . $this->r->getFilter1() . "&f2=" . $this->r->getFilter2() . "&f1v=$yID&dt1=" . $this->r->getDate1() . "&dt2=" . $this->r->getDate2() . "";

            $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;' align=right class='colTotalQty'>";
            $this->content .= "<a title='$yName' href='$histLink'>";
            $this->content .= $strQty;
            $this->content .= "</a>";
            $this->content .= "</td>";
            $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;' align=right class='colTotalRp'>";
            $this->content .= "<a title='$yName' href='$histLink'>";
            $this->content .= $strValue;
            $this->content .= "</a>";
            $this->content .= "</td>";
            // </editor-fold>
            // <editor-fold defaultstate="collapsed" desc="rata2 #1, kanan">
            $strQty = $this->r->getResultsY()['qty'][$yID] > 0 ? "<span class='badge angkaRegQty'>" . number_format($this->r->getResultsY()['qty'][$yID] / sizeof($this->r->getVarsX()), 2) . "</span>" : "";
            $strValue = $this->r->getResultsY()['value'][$yID] > 0 ? "<span class='badge angkaRegValue'>" . number_format($this->r->getResultsY()['value'][$yID] / sizeof($this->r->getVarsX()) / $appConfig['rpSatuan'], 2) . "</span>" : "";
            $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;' align=right class='colAvgQty'>";
            $this->content .= "<a title='$yName, $xName'>";
            $this->content .= $strQty;
            $this->content .= "</a>";
            $this->content .= "</td>";
            $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;' align=right class='colAvgRp'>";
            $this->content .= "<a title='$yName, $xName'>";
            $this->content .= $strValue;
            $this->content .= "</a>";
            $this->content .= "</td>"; // </editor-fold>
            // <editor-fold defaultstate="collapsed" desc="rata2 #2, kanan">
            $strQty = $this->r->getResultsY()['qty'][$yID] > 0 ? "<span class='badge angkaRegQty'>" . number_format($this->r->getResultsY()['qty'][$yID] / $this->r->getAvgFactor(), 2) . "</span>" : "";
            $strValue = $this->r->getResultsY()['value'][$yID] > 0 ? "<span class='badge angkaRegValue'>" . number_format($this->r->getResultsY()['value'][$yID] / $this->r->getAvgFactor() / $appConfig['rpSatuan'], 2) . "</span>" : "";
            $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;border-right:1px #ff7700 solid;' bgcolor=#efcdab align=right>";
            $this->content .= "<a title='$yName, $xName'>";
            $this->content .= $strQty;
            $this->content .= "</a>";
            $this->content .= "</td>";
            $this->content .= "<td bgcolor=#f0f0f0 style='border-bottom:1px $lineRowBorderColor solid;border-right:1px #ff7700 solid;' align=right>";
            $this->content .= "<a title='$yName, $xName'>";
            $this->content .= $strValue;
            $this->content .= "</a>";
            $this->content .= "</td>"; // </editor-fold>


            $this->content .= "</tr>";
        }


        //=============================
        // <editor-fold defaultstate="collapsed" desc="total bawah">
        $this->content .= "<tr>";
        $this->content .= "<td class='colHeader' colspan=2 align=center>";
        $this->content .= "<span class='judulPeriode'>TOTAL</span>";
        $this->content .= "</td>";
        foreach ($this->r->getVarsX() as $xID => $xName) {
            $strQty = $this->r->getResultsX()['qty'][$xID] > 0 ? "<span class='badge angkaRegQty'>" . number_format($this->r->getResultsX()['qty'][$xID]) . "</span>" : "";
            $strValue = $this->r->getResultsX()['value'][$xID] > 0 ? "<span class='badge angkaRegValue'>" . number_format($this->r->getResultsX()['value'][$xID] / $appConfig['rpSatuan']) . "</span>" : "";
            $strEmpty = "<span class='badge' style='background:transparent;color:#d5d5d5;'>$xName</span>";

            $this->content .= "<td align=right class='colHeader'>";
            $this->content .= "<a title='$yName, $xName'>";
            $this->content .= $strQty;
            $this->content .= "</a>";
            $this->content .= "</td>";
            $this->content .= "<td align=right class='colHeader'>";
            $this->content .= "<a title='$yName, $xName'>";
            $this->content .= $strValue;
            $this->content .= "</a>";
            $this->content .= "</td>";
        }

        // </editor-fold>
        // <editor-fold defaultstate="collapsed" desc="total total">
        $strQty = $this->r->getResultTotal()['qty'] > 0 ? "<span class='badge angkaRegQty' style='color;#ffffff;'>" . number_format($this->r->getResultTotal()['qty']) . "</span>" : "";
        $strValue = $this->r->getResultTotal()['value'] > 0 ? "<span class='badge angkaRegValue'>" . number_format($this->r->getResultTotal()['value'] / $appConfig['rpSatuan']) . "</span>" : "";
        $strEmpty = "<span class='badge' style='background:transparent;color:#d5d5d5;'>$xName</span>";

        $this->content .= "<td align=right class='colTotalHeader'>";
        $this->content .= "<a title='$yName, $xName'>";
        $this->content .= $strQty;
        $this->content .= "</a>";
        $this->content .= "</td>";
        $this->content .= "<td align=right class='colTotalHeader'>";
        $this->content .= "<a title='$yName, $xName'>";
        $this->content .= $strValue;
        $this->content .= "</a>";
        $this->content .= "</td>"; // </editor-fold>


        $this->content .= "</tr bgcolor=#e5e5e5>";


        $this->content .= "</table>";


        $this->content .= "</div class='panel-body'>";
        if ($this->viewType == "print") {//===matikan link2 jika mode print
            $this->content = str_replace("<a ", "<asu ", $this->content);
            $this->content = str_replace("</a ", "</asu ", $this->content);
        }
    }

}
