<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of RActivityParser
 * @author aziz
 */
if (!isset($_SESSION['employee_jenis'])) {
    include_once 'template.php';
    $contentStr .= "<div class='alert alert-danger'>";
    $contentStr .= "Anda tidak diperkenankan mengakses halaman ini<br>";
    $contentStr .= "Silahkan perbarui status wewenang anda dengan cara masuk pada <strong>web " . $connectionParams['label'] . "</strong><br>";
    $contentStr .= "<a href='" . $connectionParams['homepage'] . "'>Ke " . $connectionParams['label'] . "</a><br>";
    $contentStr .= "</div class='alert alert-danger'>";
    $p = new clTemplate();
    $p->defineTheme("../viewer.html");
    $p->defineTag("{title}", "Anda Tak Punya Wewenang");
    $p->defineTag("{backURL}", "JavaScript:void(0);");
    $p->defineTag("{backTitle}", "Ini sudah paling depan");
    $p->defineTag("{content}", $contentStr);
    $p->parse();
    $p->printTheme();
    die();
}

class RActivityParser
{

    //put your code here
    private $r; //===connector ke objek RBasic
    private $content;
    private $title;
    private $timeDescription;
    private $backURL;
    private $backTitle;

    // <editor-fold defaultstate="collapsed" desc="getter-setter, kampungan">
    function getTimeDescription()
    {
        return $this->timeDescription;
    }

    function setTimeDescription($timeDescription)
    {
        $this->timeDescription = $timeDescription;
    }

    function getR()
    {
        return $this->r;
    }

    function getContent()
    {
        return $this->content;
    }

    function getTitle()
    {
        return $this->title;
    }

    function getBackURL()
    {
        return $this->backURL;
    }

    function getBackTitle()
    {
        return $this->backTitle;
    }

    function setR($r)
    {
        $this->r = $r;
    }

    function setContent($content)
    {
        $this->content = $content;
    }

    function setTitle($title)
    {
        $this->title = $title;
    }

    function setBackURL($backURL)
    {
        $this->backURL = $backURL;
    }

    function setBackTitle($backTitle)
    {
        $this->backTitle = $backTitle;
    }

    // </editor-fold>


    function __construct($r)
    {
        global $reportTypes;
        $this->r = $r;
        $this->title .= "Laporan Aktivitas " . $this->r->getUserName() . ", ";
        if ($this->r->getDate1() == $this->r->getDate2()) {
            $this->timeDescription = "Tanggal " . convertDatetimeToShort($this->r->getDate1());
        }
        else {
            $this->timeDescription = "Periode " . convertDatetimeToShort($this->r->getDate1());
            $this->timeDescription .= " s/d. ";
            $this->timeDescription .= convertDatetimeToShort($this->r->getDate2());
        }
        $this->title .= $this->timeDescription;

        $this->backURL = "../index/";
        $this->backTitle = "Ke Indeks Laporan";
    }

    public function parse()
    {
        global $reportTypes, $rpSatuans, $filterLabels, $fieldLabels, $historyFields;

        $this->content .= "<div class='badge judulRincian'>";
        $this->content .= "Laporan Aktivitas " . $this->r->getUserName();
        $this->content .= "</div class='badge judulRincian'>";
        $this->content .= "<br>";
        $this->content .= "<div class='badge judulRincian'>";
        $this->content .= "<small>" . $this->timeDescription . "</small>";
        $this->content .= "</div class='badge judulRincian'>";

        /*
          $this->content .= "<br>";
          $this->content .= "<div class='badge judulRincian' style='font-size:12px;font-style:italic;'>";
          $this->content .= "<small>Laporan ditampilkan pada " . convertDatetimeToShort(date("Y-m-d H:i:s")) . "</small>";
          $this->content .= "</div class='badge judulRincian'>";
          $this->content .= "<br>";

         */

        // <editor-fold defaultstate="collapsed" desc="filter range tanggal">
        $this->content .= "<div class='alert alert-info' style='border:1px #abcdef solid;'>";
        $this->content .= "<div class='row'>";

        if (in_array("admin", $_SESSION['employee_jenis'])) {
            $this->content .= "<div class='col-sm-3'>";
            $this->content .= "<div class='input-group'>";
            $this->content .= "<span class='input-group-addon'><i class='glyphicon glyphicon-user'></i></span>";
            $this->content .= "<select class='form-control' id=u>";
            foreach (fetchUser() as $pID => $pName) {
                $periodSelected = $pID == $this->r->getUserID() ? "selected" : "";
                $this->content .= "<option value='$pID' $periodSelected>" . " " . $pName . "</option>";
            }
            $this->content .= "</select>";
            $this->content .= "</div class='input-group'>";
            $this->content .= "</div class='col-sm-3'>";
        }

        $periodFilters = $this->r->getPeriodFilters();
        if (sizeof($periodFilters) > 0) {

            $this->content .= "<div class='col-sm-3'>";
            //$this->content .= "Pilih " . $this->r->getLabels()['periodParentName'];
            $this->content .= "<div class='input-group'>";
            $this->content .= "<span class='input-group-addon'><i class='glyphicon glyphicon-calendar'></i></span>";
            $this->content .= "<select class='form-control' id=dt1>";
            foreach ($periodFilters as $pID) {
                $periodSelected = $pID == $this->r->getDate1() ? "selected" : "";
                $this->content .= "<option value='$pID' $periodSelected>" . " " . convertDatetimeToShort($pID) . "</option>";
            }
            $this->content .= "</select>";
            $this->content .= "</div class='input-group'>";
            $this->content .= "</div class='col'>";

            $this->content .= "<div class='col-sm-3'>";
            $this->content .= "<div class='input-group'>";
            $this->content .= "<span class='input-group-addon'><i class='glyphicon glyphicon-calendar'></i></span>";
            $this->content .= "<select class='form-control' id=dt2>";
            foreach ($periodFilters as $pID) {
                $periodSelected = $pID == $this->r->getDate2() ? "selected" : "";
                $this->content .= "<option value='$pID' $periodSelected>" . " " . convertDatetimeToShort($pID) . "</option>";
            }
            $this->content .= "</select>";
            $this->content .= "<span class='input-group-addon'>";
            $this->content .= "<button onclick=\"location.href='" . $_SERVER['PHP_SELF'] . "?u='+document.getElementById('u').value+'&dt1='+document.getElementById('dt1').value+'&dt2='+document.getElementById('dt2').value;\">";
            $this->content .= "<span class='glyphicon glyphicon-refresh'></span>";
            $this->content .= "</button></span>";
            $this->content .= "</div class='input-group'>";
            $this->content .= "</div class='col'>";
        }
        $this->content .= "</div class='row'>";
        $this->content .= "</div class='alert alert-info' style='background:#f0f0f0;border:1px #cccccc solid;'>";
        // </editor-fold>

        $this->content .= "<div class='badge judulRincian'>";
        $this->content .= "Ringkasan Aktivitas " . $this->r->getUserName();
        $this->content .= "</div class='badge judulRincian'>";


        $resumes = $this->r->getResumedEntries();
        if (sizeof($resumes) > 0) {
            $this->content .= "<div class='alert alert-info' style='background:transparent;border:1px #cccccc solid;'>";
            $this->content .= "<table cellspacing=0 cellpadding=4 border=0 bordercolor=#999999>";
            $this->content .= "<tr bgcolor=#e5e5e5>";

            $this->content .= "<td align=right>";
            $this->content .= "<span class='badge judulNonPeriode'>";
            $this->content .= "No";
            $this->content .= "</span class='badge judulNonPeriode'>";
            $this->content .= "</td>";

            $this->content .= "<td>";
            $this->content .= "<span class='badge judulNonPeriode'>";
            $this->content .= "Kode";
            $this->content .= "</span class='badge judulNonPeriode'>";
            $this->content .= "</td>";

            $this->content .= "<td>";
            $this->content .= "<span class='badge judulNonPeriode'>";
            $this->content .= "Nama aktivitas";
            $this->content .= "</span class='badge judulNonPeriode'>";
            $this->content .= "</td>";

            $this->content .= "<td>";
            $this->content .= "<span class='badge judulNonPeriode'>";
            $this->content .= "Jumlah nota";
            $this->content .= "</span class='badge judulNonPeriode'>";
            $this->content .= "</td>";

            $this->content .= "<td>";
            $this->content .= "<span class='badge judulNonPeriode'>";
            $this->content .= "Total Nilai transaksi";
            $this->content .= "</span class='badge judulNonPeriode'>";
            $this->content .= "</td>";

            $this->content .= "</tr>";

            $itemCounter = 0;
            foreach ($resumes as $j => $spec) {
                $itemCounter++;

                $this->content .= "<tr>";
                $this->content .= "<td align=right>";
                $this->content .= "<span class='badge' style='font-weight:bold;background:#cccccc;color:#454545;'>";
                $this->content .= $itemCounter;
                $this->content .= "</span>";
                $this->content .= "</td>";

                $jName = isset($reportTypes[$j]) ? $reportTypes[$j] : "Transaksi " . $j;
                $histLink = "../history/?j=" . $j . "&f1=" . "oleh_id" . "&f1v=" . $this->r->getUserID() . "&dt1=" . $this->r->getDate1() . "&dt2=" . $this->r->getDate2() . "";
                $histDesc = "Riwayat $jName oleh " . $this->r->getUserName() . "";
                //$this->content .= "&nbsp;&nbsp;<span class='glyphicon glyphicon-ok'></span>&nbsp;" . $jName;
                $this->content .= "<td align=center>";
                $this->content .= "<a href='$histLink' title='$histDesc'>";
                $this->content .= $j;
                $this->content .= "</a>";
                $this->content .= "</td>";
                $this->content .= "<td>";
                $this->content .= "<a href='$histLink' title='$histDesc'>";
                $this->content .= $jName;
                $this->content .= "</a>";
                $this->content .= "</td>";

                $this->content .= "<td align=right>";
                $this->content .= "<a href='$histLink' title='$histDesc'>";
                $this->content .= "<span style='font-weight:bold;color:#0056cd'>";
                $this->content .= $spec['count'];
                $this->content .= "</span>";
                $this->content .= "</a>";
                $this->content .= "</td>";

                $this->content .= "<td align=right>";
                $this->content .= "<a href='$histLink' title='$histDesc'>";
                $this->content .= "<span style='color:#dd3300'>";
                $this->content .= "Rp. " . number_format($spec['value']);
                $this->content .= "</span>";
                $this->content .= "</a>";
                $this->content .= "</td>";


                $this->content .= "<td align=right>";
                $this->content .= "&nbsp;<a href='$histLink' title='$histDesc'>";
                $this->content .= "<span class='glyphicon glyphicon-time'></span>";
                $this->content .= "</a>&nbsp;";
                $this->content .= "</td>";


                $this->content .= "</tr>";
            }

            $this->content .= "</table cellspacing=0 cellpadding=4 border=0 bordercolor=#999999>";
            $this->content .= "</div class='alert alert-info'>";
        }
        else {
            $this->content .= "<div class='alert alert-danger'>";
            $this->content .= "Ringkasan aktivitas <strong>" . $this->r->getUserName() . "</strong> <strong style='color:#dd3300;'>kosong</strong>.<br>";
            $this->content .= "<small>Cobalah untuk memilih <strong>person</strong> atau <strong><i>range</i> waktu</strong> yang lain</small>.";
            $this->content .= "</div class='alert alert-danger'>";
        }


        $this->content .= "<div class='badge judulRincian'>";
        $this->content .= "Rincian Aktivitas " . $this->r->getUserName();
        $this->content .= "</div class='badge judulRincian'>";

        $details = $this->r->getDetailedEntries();
        if (sizeof($details) > 0) {
            //$this->content .= "<div class='alert alert-info' style='background:#f0f0f0;border:1px #cccccc solid;'>";
            $qty = 0;
            $value = 0;
            $total = 0;
            $komisiTotal = 0;
            $notas = array();
            foreach ($details as $j => $jSpec) {
                //$columns = isset($historyFields[$j]) ? $historyFields[$j] : array("nomer", "dtime", "oleh_nama","produk_nama","produk_ord_jml","produk_ord_hrg");
                $total = 0;
                $columns = $historyFields["activity"];
                //$columns = isset($historyFields[$j]) ? $historyFields[$j] : $historyFields["activity"];
                $jName = isset($reportTypes[$j]) ? $reportTypes[$j] : "Transaksi " . $j;
                $this->content .= "<div class='panel-body'>";
                $this->content .= "<table cellspacing=0 cellpadding=2 border=0 bordercolor=#999999 class='tbl-bordered'>";
                $this->content .= "<tr>";
                $this->content .= "<td colspan=" . sizeof($columns) . ">";
                $this->content .= "<span class='glyphicon glyphicon-th-list'></span>&nbsp;";
                $histLink = "../history/?j=" . $j . "&f1=" . "oleh_id" . "&f1v=" . $this->r->getUserID() . "&dt1=" . $this->r->getDate1() . "&dt2=" . $this->r->getDate2() . "";
                $histDesc = "Riwayat $jName " . $this->r->getUserName() . "";
                $this->content .= "Rincian " . $jName . "($j) ";
                $this->content .= "&nbsp;<a href='$histLink' title='$histDesc'>";
                $this->content .= "<span class='glyphicon glyphicon-time'></span>";
                $this->content .= "</a>&nbsp;";
                $this->content .= "</td colspan=5>";
                $this->content .= "</tr>";


                $this->content .= "<tr bgcolor=#f0f0f0>";
                //$this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;'>&nbsp;</td>";
                $this->content .= "<td align=right style='border-bottom:1px $lineRowBorderColor solid;font-weight:bold;color:#999999;'>No</td>";

                foreach ($columns as $k => $v) {
                    $fLabel = isset($fieldLabels[$v]) ? $fieldLabels[$v] : $v;
                    $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;font-weight:bold;color:#999999;'>" . $fLabel . "</td>";
                }
                $this->content .= "</tr>";

                $itemCounter = 0;

                foreach ($jSpec as $c => $cSpec) {

                    $qty += $cSpec['produk_ord_jml'];
                    $value += ($cSpec['produk_ord_jml'] * $cSpec['produk_ord_hrg']);
                    $komisiTotal += ($cSpec['produk_ord_jml'] * $cSpec['komisi_ori']);


                    if (!in_array($cSpec['nomer'], $notas)) {
                        $itemCounter++;
                        $lineRowBorderColor = ($itemCounter % 3) == 0 ? "#777799" : "#ccccee";
                        $notas[] = $cSpec['nomer'];
                        $total += $cSpec['transaksi_nilai'];
                        $this->content .= "<tr>";
                        //$this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;'>&nbsp;</td>";
                        $this->content .= "<td align=right bgcolor=#e5e5e5 style='border-bottom:1px $lineRowBorderColor solid;'>$itemCounter.</td>";
                        //foreach ($cSpec as $k => $v) {
                        foreach ($cSpec as $k => $v) {
                            $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;'>" . formatHistoryField($v, $k) . "</td>";
                        }

                        $this->content .= "</tr>";
                    }
                }

                // <editor-fold defaultstate="collapsed" desc="total bawah">
                $this->content .= "<tr bgcolor=#e5e5e5>";
                //$this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;'><span class='badge' style='background:#dddddd;color:#121212;'>&nbsp;</span></td>";
                $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;'><span class='badge' style='background:#dddddd;color:#121212;'>TOTAL</span></td>";
                $columns = $historyFields["activity"];
                //$columns = isset($historyFields[$j]) ? $historyFields[$j] : $historyFields["activity"];
                foreach ($columns as $col) {
                    switch ($col) {
                        case "produk_ord_jml":
                            $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;font-weight:bold;font-size:19px;'><span>" . formatHistoryField($qty, $col) . "</span></td>";
                            break;
                        case "produk_ord_hrg":
                            $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;font-weight:bold;font-size:19px;'><span>" . formatHistoryField($value, $col) . "</span></td>";
                            break;
                        case "transaksi_nilai":
                            $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;font-weight:bold;font-size:19px;'><span>" . formatHistoryField($total, $col) . "</span></td>";
                            break;
                        case "komisi":
                        case "komisi_ori":
                            $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;font-weight:bold;font-size:19px;'><span>" . formatHistoryField($komisiTotal, $col) . "</span></td>";
                            break;
                        default:
                            $this->content .= "<td style='border-bottom:1px $lineRowBorderColor solid;'>&nbsp;</td>";
                            break;
                    }
                }
                $this->content .= "</tr>"; // </editor-fold>
                $this->content .= "</table>";
                $this->content .= "</div class='panel-body'>";
            }
            //$this->content .= "</div class='alert alert-info' style='background:#f0f0f0;border:1px #cccccc solid;'>";
        }
        else {

            $this->content .= "<div class='alert alert-danger'>";
            $this->content .= "Rincian aktivitas <strong>" . $this->r->getUserName() . "</strong> <strong style='color:#dd3300;'>kosong</strong>.<br>";
            $this->content .= "<small>Cobalah untuk memilih <strong>person</strong> atau <strong><i>range</i> waktu</strong> yang lain</small>.";
            $this->content .= "</div class='alert alert-danger'>";
        }
    }

}
