(function(){var properties=['direction','boxSizing','width','height','overflowX','overflowY','borderTopWidth','borderRightWidth','borderBottomWidth','borderLeftWidth','borderStyle','paddingTop','paddingRight','paddingBottom','paddingLeft','fontStyle','fontVariant','fontWeight','fontStretch','fontSize','fontSizeAdjust','lineHeight','fontFamily','textAlign','textTransform','textIndent','textDecoration','letterSpacing','wordSpacing','tabSize','MozTabSize'];var isBrowser=(typeof window!=='undefined');var isFirefox=(isBrowser&&window.mozInnerScreenX!=null);function getCaretCoordinates(element,position,options){if(!isBrowser){throw new Error('textarea-caret-position#getCaretCoordinates should only be called in a browser')}
var debug=options&&options.debug||!1;if(debug){var el=document.querySelector('#input-textarea-caret-position-mirror-div');if(el)el.parentNode.removeChild(el)}
var div=document.createElement('div');div.id='input-textarea-caret-position-mirror-div';document.body.appendChild(div);var style=div.style;var computed=window.getComputedStyle?window.getComputedStyle(element):element.currentStyle;var isInput=element.nodeName==='INPUT';style.whiteSpace='pre-wrap';if(!isInput)
style.wordWrap='break-word';style.position='absolute';if(!debug)
style.visibility='hidden';properties.forEach(function(prop){if(isInput&&prop==='lineHeight'){style.lineHeight=computed.height}else{style[prop]=computed[prop]}});if(isFirefox){if(element.scrollHeight>parseInt(computed.height))
style.overflowY='scroll'}else{style.overflow='hidden'}
div.textContent=element.value.substring(0,position);if(isInput)
div.textContent=div.textContent.replace(/\s/g,'\u00a0');var span=document.createElement('span');span.textContent=element.value.substring(position)||'.';div.appendChild(span);var coordinates={top:span.offsetTop+parseInt(computed.borderTopWidth),left:span.offsetLeft+parseInt(computed.borderLeftWidth),height:parseInt(computed.lineHeight)};if(debug){span.style.backgroundColor='#aaa'}else{document.body.removeChild(div)}
return coordinates}
if(typeof module!='undefined'&&typeof module.exports!='undefined'){module.exports=getCaretCoordinates}else if(isBrowser){window.getCaretCoordinates=getCaretCoordinates}}());(function(){var keyboardeventKeyPolyfill={polyfill:polyfill,keys:{3:'Cancel',6:'Help',8:'Backspace',9:'Tab',12:'Clear',13:'Enter',16:'Shift',17:'Control',18:'Alt',19:'Pause',20:'CapsLock',27:'Escape',28:'Convert',29:'NonConvert',30:'Accept',31:'ModeChange',32:' ',33:'PageUp',34:'PageDown',35:'End',36:'Home',37:'ArrowLeft',38:'ArrowUp',39:'ArrowRight',40:'ArrowDown',41:'Select',42:'Print',43:'Execute',44:'PrintScreen',45:'Insert',46:'Delete',48:['0',')'],49:['1','!'],50:['2','@'],51:['3','#'],52:['4','$'],53:['5','%'],54:['6','^'],55:['7','&'],56:['8','*'],57:['9','('],91:'OS',93:'ContextMenu',144:'NumLock',145:'ScrollLock',181:'VolumeMute',182:'VolumeDown',183:'VolumeUp',186:[';',':'],187:['=','+'],188:[',','<'],189:['-','_'],190:['.','>'],191:['/','?'],192:['`','~'],219:['[','{'],220:['\\','|'],221:[']','}'],222:["'",'"'],224:'Meta',225:'AltGraph',246:'Attn',247:'CrSel',248:'ExSel',249:'EraseEof',250:'Play',251:'ZoomOut'}};var i;for(i=1;i<25;i++){keyboardeventKeyPolyfill.keys[111+i]='F'+i}
var letter='';for(i=65;i<91;i++){letter=String.fromCharCode(i);keyboardeventKeyPolyfill.keys[i]=[letter.toLowerCase(),letter.toUpperCase()]}
function polyfill(){if(!('KeyboardEvent' in window)||'key' in KeyboardEvent.prototype){return!1}
var proto={get:function(x){var key=keyboardeventKeyPolyfill.keys[this.which||this.keyCode];if(Array.isArray(key)){key=key[+this.shiftKey]}
return key}};Object.defineProperty(KeyboardEvent.prototype,'key',proto);return proto}
keyboardeventKeyPolyfill.polyfill()})();if(!Element.prototype.matches){Element.prototype.matches=Element.prototype.matchesSelector||Element.prototype.mozMatchesSelector||Element.prototype.msMatchesSelector||Element.prototype.oMatchesSelector||Element.prototype.webkitMatchesSelector||function(s){var matches=(this.document||this.ownerDocument).querySelectorAll(s),i=matches.length;while(--i>=0&&matches.item(i)!==this){}
return i>-1}}
var KB={components:{},utils:{},html:{},http:{},listeners:{clicks:{},changes:{},keys:[],internals:{}}};KB.on=function(eventType,callback){if(!this.listeners.internals.hasOwnProperty(eventType)){this.listeners.internals[eventType]=[]}
this.listeners.internals[eventType].push(callback)};KB.trigger=function(eventType,eventData){if(this.listeners.internals.hasOwnProperty(eventType)){for(var i=0;i<this.listeners.internals[eventType].length;i++){this.listeners.internals[eventType][i](eventData)}}};KB.removeListener=function(eventType,callback){if(this.listeners.internals.hasOwnProperty(eventType)){for(var i=0;i<this.listeners.internals[eventType].length;i++){if(this.listeners.internals[eventType][i]===callback){this.listeners.internals[eventType].splice(i,1)}}}};KB.onClick=function(selector,callback,noPreventDefault){this.listeners.clicks[selector]={callback:callback,noPreventDefault:noPreventDefault===!0}};KB.onChange=function(selector,callback){this.listeners.changes[selector]=callback};KB.onKey=function(combination,callback,ignoreInputField,ctrlKey,metaKey){this.listeners.keys.push({'combination':combination,'callback':callback,'ignoreInputField':ignoreInputField||!1,'ctrlKey':ctrlKey||!1,'metaKey':metaKey||!1})};KB.listen=function(){var self=this;var keysQueue=[];function onClick(e){for(var selector in self.listeners.clicks){if(self.listeners.clicks.hasOwnProperty(selector)&&e.target.matches(selector)){if(!self.listeners.clicks[selector].noPreventDefault){e.preventDefault()}
self.listeners.clicks[selector].callback(e)}}}
function onChange(e){for(var selector in self.listeners.changes){if(self.listeners.changes.hasOwnProperty(selector)&&e.target.matches(selector)){self.listeners.changes[selector](e.target)}}}
function onKeyPressed(e){var key=KB.utils.getKey(e);var isInputField=KB.utils.isInputField(e);if(!isInputField||['Escape','Enter'].indexOf(key)!==-1){keysQueue.push(key)}
if(keysQueue.length>0){var reset=!0;for(var i=0;i<self.listeners.keys.length;i++){var params=self.listeners.keys[i];var combination=params.combination;var sequence=combination.split('+');if(KB.utils.arraysIdentical(keysQueue,sequence)&&e.ctrlKey===params.ctrlKey&&e.metaKey===params.metaKey){if(isInputField&&!params.ignoreInputField){keysQueue=[];return}
e.preventDefault();e.stopPropagation();keysQueue=[];params.callback(e);break}else if(KB.utils.arraysStartsWith(keysQueue,sequence)&&keysQueue.length<sequence.length){reset=!1}}
if(reset){keysQueue=[]}}}
document.addEventListener('click',onClick,!1);document.addEventListener('change',onChange,!1);window.addEventListener('keydown',onKeyPressed,!1)};KB.component=function(name,object){this.components[name]=object};KB.getComponent=function(name,containerElement,options){var object=this.components[name];return new object(containerElement,options)};KB.render=function(){for(var name in this.components){var elementList=document.querySelectorAll('.js-'+name);for(var i=0;i<elementList.length;i++){if(this.components.hasOwnProperty(name)){var options;if(elementList[i].dataset.params){options=JSON.parse(elementList[i].dataset.params)}
var component=KB.getComponent(name,elementList[i],options);component.render();elementList[i].className=elementList[i].className+'-rendered'}}}};KB.interval=function(seconds,callback){setInterval(callback,seconds*1000)};KB.dom=function(tag){function DomManipulation(tag){var element=typeof tag==='string'?document.createElement(tag):tag;this.attr=function(attribute,value){if(value!==null&&typeof value!=='undefined'){element.setAttribute(attribute,value);return this}else{return element.getAttribute(attribute)}};this.data=function(attribute,value){if(arguments.length===1){return element.dataset[attribute]}
element.dataset[attribute]=value;return this};this.hide=function(){element.style.display='none';return this};this.show=function(){element.style.display='block';return this};this.toggle=function(){if(element.style.display==='none'){this.show()}else{this.hide()}
return this};this.style=function(attribute,value){element.style[attribute]=value;return this};this.on=function(eventName,callback,ignorePrevent){element.addEventListener(eventName,function(e){if(!ignorePrevent){e.preventDefault()}
callback(e.target)});return this};this.click=function(callback){return this.on('click',callback)};this.mouseover=function(callback){return this.on('mouseover',callback)};this.change=function(callback){return this.on('change',callback)};this.add=function(node){element.appendChild(node);return this};this.replace=function(node){element.parentNode.replaceChild(node,element);return this};this.html=function(html){element.innerHTML=html;return this};this.text=function(text){element.appendChild(document.createTextNode(text));return this};this.replaceText=function(text){element.textContent=text;return this};this.addClass=function(className){element.classList.add(className);return this};this.removeClass=function(className){element.classList.remove(className);return this};this.toggleClass=function(className){element.classList.toggle(className);return this};this.hasClass=function(className){return element.classList.contains(className)};this.disable=function(){element.disabled=!0;return this};this.enable=function(){element.disabled=!1;return this};this.remove=function(){element.parentNode.removeChild(element);return this};this.empty=function(){while(element.firstChild){element.removeChild(element.firstChild)}
return this};this.parent=function(selector){for(;element&&element!==document;element=element.parentNode){if(element.matches(selector)){return element}}
return null};this.find=function(selector){return element.querySelector(selector)};this.for=function(tag,list){for(var i=0;i<list.length;i++){var dict=list[i];if(typeof dict!=='object'){element.appendChild(KB.dom(tag).text(dict).build())}else{var node=KB.dom(tag);for(var attribute in dict){if(dict.hasOwnProperty(attribute)&&attribute in this&&typeof this[attribute]==='function'){node[attribute](dict[attribute])}else{node.attr(attribute,dict[attribute])}}
element.appendChild(node.build())}}
return this};this.build=function(){return element}}
return new DomManipulation(tag)};KB.find=function(selector){var element=document.querySelector(selector);if(element){return KB.dom(element)}
return null};KB.exists=function(selector){return!!document.querySelector(selector)};KB.focus=function(selector){var element=document.querySelector(selector);if(element){return element.focus()}};KB.html.label=function(label,id){return KB.dom('label').attr('for',id).text(label).build()};KB.html.radio=function(label,name,value){return KB.dom('label').add(KB.dom('input').attr('type','radio').attr('name',name).attr('value',value).build()).text(label).build()};KB.html.radios=function(items){var html=KB.dom('div');for(var item in items){if(items.hasOwnProperty(item)){html.add(KB.html.radio(item.label,item.name,item.value))}}};KB.http.request=function(method,url,headers,body){var successCallback=function(){};var authErrorCallback=function(){};var netErrorCallback=function(){};var errorCallback=function(){};function parseResponse(request){var redirect=request.getResponseHeader('X-Ajax-Redirect');var location=request.getResponseHeader('Location');if(redirect==='self'){window.location.reload()}else if(redirect&&redirect.indexOf('#')>-1){window.location=redirect.split('#')[0]}else if(redirect){window.location=redirect}else if(location){window.location=location}else if(request.getResponseHeader('Content-Type')==='application/json'){try{return JSON.parse(request.responseText)}catch(e){}}
return request.responseText}
this.execute=function(){var request=new XMLHttpRequest();request.open(method,url,!0);request.setRequestHeader('X-Requested-With','XMLHttpRequest');for(var header in headers){if(headers.hasOwnProperty(header)){request.setRequestHeader(header,headers[header])}}
request.onerror=function(){errorCallback()};request.onreadystatechange=function(){if(request.readyState===XMLHttpRequest.DONE){var response=parseResponse(request);switch(request.status){case 200:successCallback(response);return;case 401:authErrorCallback(response);errorCallback(response);break;case 0:netErrorCallback(response);errorCallback(response);break;default:errorCallback(response);break}}};request.send(body);return this};this.success=function(callback){successCallback=callback;return this};this.authError=function(callback){authErrorCallback=callback;return this};this.netError=function(callback){netErrorCallback=callback;return this};this.error=function(callback){errorCallback=callback;return this}};KB.http.get=function(url){return(new KB.http.request('GET',url)).execute()};KB.http.postJson=function(url,body){var headers={'Content-Type':'application/json','Accept':'application/json'};return(new KB.http.request('POST',url,headers,JSON.stringify(body))).execute()};KB.http.postForm=function(url,formElement){var formData=new FormData(formElement);return(new KB.http.request('POST',url,{},formData)).execute()};KB.http.uploadFile=function(url,file,csrf,onProgress,onComplete,onError,onServerError,onRequestTooLarge){var fd=new FormData();fd.append('files[]',file);fd.append('csrf_token',csrf);var xhr=new XMLHttpRequest();xhr.upload.addEventListener('progress',onProgress);xhr.upload.addEventListener('error',onError);xhr.open('POST',url,!0);xhr.setRequestHeader('X-Requested-With','XMLHttpRequest');xhr.onreadystatechange=function(){if(xhr.readyState===XMLHttpRequest.DONE){if(xhr.status===200){onComplete()}else if(xhr.status===413){if(typeof onRequestTooLarge!=='undefined'){onRequestTooLarge()}else{onError(xhr.responseText)}}else if(typeof onServerError!=='undefined'){onServerError(JSON.parse(xhr.responseText))}}};xhr.send(fd)};(function(){var isOpen=!1;var isFormDirty=!1;function onOverlayClick(e){if(e.target.matches('#modal-overlay')&&isFormDirty===!1){e.stopPropagation();e.preventDefault();destroy()}}
function onCloseButtonClick(){KB.trigger('modal.close')}
function onFormChange(){isFormDirty=!0}
function onFormSubmit(){KB.trigger('modal.loading');submitForm()}
function getForm(){return document.querySelector('#modal-content form:not(.js-modal-ignore-form)')}
function submitForm(){var form=getForm();if(form){var url=form.getAttribute('action');if(url){KB.http.postForm(url,form).success(function(response){KB.trigger('modal.stop');if(response){replace(response)}else{destroy()}}).error(function(response){KB.trigger('modal.stop');if(response.hasOwnProperty('message')){window.alert(response.message)}})}}}
function afterRendering(){var formElement=KB.find('#modal-content form');if(formElement){formElement.on('change',onFormChange,!1);formElement.on('submit',onFormSubmit,!1)}
var autoFocusElement=document.querySelector('#modal-content input[autofocus]');if(autoFocusElement){autoFocusElement.focus()}
KB.render();_KB.datePicker();_KB.autoComplete();_KB.tagAutoComplete();_KB.get('Task').onPopoverOpened();KB.trigger('modal.afterRender')}
function replace(html){var contentElement=KB.find('#modal-content');if(contentElement){contentElement.replace(KB.dom('div').attr('id','modal-content').html(html).build());afterRendering()}}
function create(html,width,overlayClickDestroy){var closeButtonElement=KB.dom('a').attr('href','#').attr('id','modal-close-button').html('<i class="fa fa-times"></i>').click(onCloseButtonClick).build();var headerElement=KB.dom('div').attr('id','modal-header').add(closeButtonElement).build();var contentElement=KB.dom('div').attr('id','modal-content').html(html).build();var boxElement=KB.dom('div').attr('id','modal-box').style('width',width).add(headerElement).add(contentElement).build();var overlayElement=KB.dom('div').attr('id','modal-overlay').add(boxElement).build();if(overlayClickDestroy){overlayElement.addEventListener('click',onOverlayClick,!1)}
document.body.appendChild(overlayElement);afterRendering()}
function destroy(){isOpen=!1;isFormDirty=!1;var overlayElement=KB.find('#modal-overlay');if(overlayElement){KB.trigger('modal.beforeDestroy');overlayElement.remove()}}
function getWidth(size){var viewport=KB.utils.getViewportSize();if(viewport.width<700){return'99%'}
switch(size){case 'large':return viewport.width<1350?'98%':'1350px';case 'medium':return viewport.width<1024?'70%':'1024px'}
return viewport.width<800?'75%':'800px'}
KB.on('modal.close',function(){destroy()});KB.on('modal.submit',function(){submitForm()});KB.modal={open:function(url,size,overlayClickDestroy){KB.trigger('modal.open');_KB.get('Dropdown').close();destroy();if(typeof overlayClickDestroy==='undefined'){overlayClickDestroy=!0}
KB.http.get(url).success(function(response){isOpen=!0;create(response,getWidth(size),overlayClickDestroy)})},close:function(){destroy()},isOpen:function(){return isOpen},replace:function(url){KB.http.get(url).success(function(response){replace(response)})},getForm:getForm,submitForm:submitForm}}());KB.on('dom.ready',function(){function onMouseOver(mytarget){if(!exists()){create(mytarget)}}
function onMouseLeaveContainer(){setTimeout(destroy,500)}
function mouseLeftParent(){setTimeout(destroyIfNotOnTooltip,500)}
function mouseOnTooltip(){document.getElementById("tooltip-container").mouseOnTooltip=!0}
function destroyIfNotOnTooltip(){var div=document.getElementById("tooltip-container");if(div!=null&&!div.mouseOnTooltip)destroy()}
function create(element){var contentElement=element.querySelector("script");if(contentElement){render(element,contentElement.innerHTML);return}
var link=element.dataset.href;if(link){fetch(link,function(html){if(html){render(element,html)}})}}
function fetch(url,callback){var request=new XMLHttpRequest();request.open("GET",url,!0);request.setRequestHeader("X-Requested-With","XMLHttpRequest");request.onreadystatechange=function(){if(request.readyState===XMLHttpRequest.DONE){if(request.status===200){callback(request.responseText)}}};request.send(null)}
function render(element,html){var containerElement=document.createElement("div");containerElement.id="tooltip-container";containerElement.innerHTML=html;containerElement.addEventListener("mouseleave",onMouseLeaveContainer,!1);containerElement.addEventListener("mouseenter",mouseOnTooltip,!1);containerElement.mouseOnTooltip=!1;var elementRect=element.getBoundingClientRect();var top=elementRect.top+window.scrollY+elementRect.height;containerElement.style.top=top-20+"px";if(elementRect.left>(window.innerWidth-600)){var right=window.innerWidth-elementRect.right-window.scrollX;containerElement.style.right=right-25+"px"}else{var left=elementRect.left+window.scrollX;containerElement.style.left=left-25+"px"}
document.body.appendChild(containerElement);document.body.onclick=function(event){if(!containerElement.contains(event.target)){destroy()}}}
function destroy(){var element=document.getElementById("tooltip-container");if(element){element.parentNode.removeChild(element)}}
function exists(){return!!document.getElementById("tooltip-container")}
document.body.addEventListener('mouseover',function(e){if(e.target.classList.contains('tooltip')){onMouseOver(e.target)}
if(e.target.classList.contains('fa')&&e.target.parentNode.classList.contains('tooltip')){onMouseOver(e.target.parentNode)}});document.body.addEventListener('mouseout',function(e){if(e.target.classList.contains('tooltip')){mouseLeftParent()}
if(e.target.classList.contains('fa')&&e.target.parentNode.classList.contains('tooltip')){mouseLeftParent()}})});KB.utils.formatDuration=function(d){if(d>=86400){return Math.round(d/86400)+"d"}else if(d>=3600){return Math.round(d/3600)+"h"}else if(d>=60){return Math.round(d/60)+"m"}
return d+"s"};KB.utils.getSelectionPosition=function(element){var selectionStart,selectionEnd;if(element.value.length<element.selectionStart){selectionStart=element.value.length}else{selectionStart=element.selectionStart}
if(element.selectionStart===element.selectionEnd){selectionEnd=selectionStart}else{selectionEnd=element.selectionEnd}
return{selectionStart:selectionStart,selectionEnd:selectionEnd}};KB.utils.arraysIdentical=function(a,b){var i=a.length;if(i!==b.length){return!1}
while(i--){if(a[i]!==b[i]){return!1}}
return!0};KB.utils.arraysStartsWith=function(array1,array2){var length=Math.min(array1.length,array2.length);for(var i=0;i<length;i++){if(array1[i]!==array2[i]){return!1}}
return!0};KB.utils.isInputField=function(event){var element=event.target;return!!(element.tagName==='INPUT'||element.tagName==='SELECT'||element.tagName==='TEXTAREA'||element.isContentEditable)};KB.utils.getKey=function(e){var mapping={'Esc':'Escape','Up':'ArrowUp','Down':'ArrowDown','Left':'ArrowLeft','Right':'ArrowRight'};for(var key in mapping){if(mapping.hasOwnProperty(key)&&key===e.key){return mapping[key]}}
return e.key};KB.utils.getViewportSize=function(){return{width:Math.max(document.documentElement.clientWidth,window.innerWidth||0),height:Math.max(document.documentElement.clientHeight,window.innerHeight||0)}};KB.utils.isVisible=function(){var property='';if(typeof document.hidden!=='undefined'){property='visibilityState'}else if(typeof document.mozHidden!=='undefined'){property='mozVisibilityState'}else if(typeof document.msHidden!=='undefined'){property='msVisibilityState'}else if(typeof document.webkitHidden!=='undefined'){property='webkitVisibilityState'}
if(property!==''){return document[property]==='visible'}
return!0};KB.onClick('.js-autocomplete-email',function(e){var email=e.target.dataset.email;var emailField=document.querySelector('.js-mail-form input[name="emails"]');if(!email||!emailField){return}
if(emailField.value!==''){emailField.value+=', '+email}else{emailField.value=email}
_KB.controllers.Dropdown.close()});KB.onClick('.js-autocomplete-subject',function(e){var subject=KB.dom(e.target).data('subject');var subjectField=KB.find('.js-mail-form input[name="subject"]');if(subject&&subjectField){subjectField.build().value=subject}
_KB.controllers.Dropdown.close()});(function(){function redirectToTaskView(e){var ignoreParentElement=KB.dom(e.target).parent('a, .task-board-change-assignee');if(ignoreParentElement){return}
var taskElement=KB.dom(e.target).parent('.task-board');if(taskElement){var taskUrl=KB.dom(taskElement).data('taskUrl');if(taskUrl){window.location=taskUrl}}}
function openEditTask(e){var baseElement=KB.dom(e.target).parent('.task-board-change-assignee');var url=KB.dom(baseElement).data('url');if(url){KB.modal.open(url,'medium',!0)}}
KB.onClick('.task-board *',redirectToTaskView,!0);KB.onClick('.task-board-change-assignee *',openEditTask,!0)}());KB.component('chart-project-avg-time-column',function(containerElement,options){this.render=function(){var metrics=options.metrics;var plots=[options.label];var categories=[];for(var column_id in metrics){plots.push(metrics[column_id].average);categories.push(metrics[column_id].title)}
KB.dom(containerElement).add(KB.dom('div').attr('id','chart').build());c3.generate({data:{columns:[plots],type:'bar'},bar:{width:{ratio:0.5}},axis:{x:{type:'category',categories:categories},y:{tick:{format:KB.utils.formatDuration}}},legend:{show:!1}})}});KB.component('chart-project-burndown',function(containerElement,options){this.render=function(){var metrics=options.metrics;var columns=[[options.labelTotal]];var categories=[];var inputFormat=d3.time.format("%Y-%m-%d");var outputFormat=d3.time.format(options.dateFormat);for(var i=0;i<metrics.length;i++){for(var j=0;j<metrics[i].length;j++){var currentValue=metrics[i][j];if(i===0){if(j>0){columns.push([currentValue])}}else{if(j>0){columns[j].push(currentValue);if(typeof columns[0][i]==='undefined'){columns[0].push(0)}
columns[0][i]+=currentValue}else{categories.push(outputFormat(inputFormat.parse(currentValue)))}}}}
KB.dom(containerElement).add(KB.dom('div').attr('id','chart').build());c3.generate({data:{columns:columns},axis:{x:{type:'category',categories:categories}}})}});KB.component('chart-project-cumulative-flow',function(containerElement,options){this.render=function(){var metrics=options.metrics;var columns=[];var groups=[];var categories=[];var inputFormat=d3.time.format("%Y-%m-%d");var outputFormat=d3.time.format(options.dateFormat);for(var i=0;i<metrics.length;i++){for(var j=0;j<metrics[i].length;j++){var currentValue=metrics[i][j];if(i===0){if(j>0){groups.push(currentValue);columns.push([currentValue])}}else{if(j>0){columns[j-1].push(currentValue)}else{categories.push(outputFormat(inputFormat.parse(currentValue)))}}}}
KB.dom(containerElement).add(KB.dom('div').attr('id','chart').build());c3.generate({data:{columns:columns.reverse(),type:'area-spline',groups:[groups],order:null},axis:{x:{type:'category',categories:categories}}})}});KB.component('chart-project-estimated-actual-column',function(containerElement,options){this.render=function(){var spent=[options.labelSpent];var estimated=[options.labelEstimated];var columns=[];for(var column in options.metrics){spent.push(options.metrics[column].hours_spent);estimated.push(options.metrics[column].hours_estimated);columns.push(options.metrics[column].title)}
KB.dom(containerElement).add(KB.dom('div').attr('id','chart').build());c3.generate({data:{columns:[spent,estimated],type:'bar'},bar:{width:{ratio:0.2}},axis:{x:{type:'category',categories:columns}},legend:{show:!0}})}});KB.component('chart-project-lead-cycle-time',function(containerElement,options){this.render=function(){var metrics=options.metrics;var cycle=[options.labelCycle];var lead=[options.labelLead];var categories=[];var types={};types[options.labelCycle]='area';types[options.labelLead]='area-spline';var colors={};colors[options.labelLead]='#afb42b';colors[options.labelCycle]='#4e342e';for(var i=0;i<metrics.length;i++){cycle.push(parseInt(metrics[i].avg_cycle_time));lead.push(parseInt(metrics[i].avg_lead_time));categories.push(metrics[i].day)}
KB.dom(containerElement).add(KB.dom('div').attr('id','chart').build());c3.generate({data:{columns:[lead,cycle],types:types,colors:colors},axis:{x:{type:'category',categories:categories},y:{tick:{format:KB.utils.formatDuration}}}})}});KB.component('chart-project-task-distribution',function(containerElement,options){this.render=function(){var columns=[];for(var i=0;i<options.metrics.length;i++){columns.push([options.metrics[i].column_title,options.metrics[i].nb_tasks])}
KB.dom(containerElement).add(KB.dom('div').attr('id','chart').build());c3.generate({data:{columns:columns,type:'donut'}})}});KB.component('chart-project-time-comparison',function(containerElement,options){this.render=function(){var spent=[options.labelSpent];var estimated=[options.labelEstimated];var categories=[];for(var status in options.metrics){spent.push(options.metrics[status].time_spent);estimated.push(options.metrics[status].time_estimated);categories.push(status==='open'?options.labelOpen:options.labelClosed)}
KB.dom(containerElement).add(KB.dom('div').attr('id','chart').build());c3.generate({data:{columns:[spent,estimated],type:'bar'},bar:{width:{ratio:0.2}},axis:{x:{type:'category',categories:categories}},legend:{show:!0}})}});KB.component('chart-project-user-distribution',function(containerElement,options){this.render=function(){var columns=[];for(var i=0;i<options.metrics.length;i++){columns.push([options.metrics[i].user,options.metrics[i].nb_tasks])}
KB.dom(containerElement).add(KB.dom('div').attr('id','chart').build());c3.generate({data:{columns:columns,type:'donut'}})}});KB.component('chart-task-time-column',function(containerElement,options){this.render=function(){var metrics=options.metrics;var plots=[options.label];var categories=[];for(var i=0;i<metrics.length;i++){plots.push(metrics[i].time_spent);categories.push(metrics[i].title)}
KB.dom(containerElement).add(KB.dom('div').attr('id','chart-task-time-column').build());c3.generate({bindto:'#chart-task-time-column',data:{columns:[plots],type:'bar'},bar:{width:{ratio:0.5}},axis:{x:{type:'category',categories:categories},y:{tick:{format:KB.utils.formatDuration}}},legend:{show:!1}})}});KB.on('dom.ready',function(){function highlightComment(){if(window.location.hash.indexOf('#comment-')===0){var commentElement=KB.find(window.location.hash);if(commentElement){var commentsElement=document.querySelectorAll('.comment');commentsElement.forEach(function(element){KB.dom(element).removeClass('comment-highlighted')});commentElement.addClass('comment-highlighted')}}}
window.addEventListener('hashchange',highlightComment);highlightComment()});KB.component('confirm-buttons',function(containerElement,options){var isLoading=!1;function onSubmit(){isLoading=!0;KB.find('#modal-confirm-button').replace(buildButton());KB.http.get(options.url)}
function onCancel(){KB.trigger('modal.close')}
function onStop(){isLoading=!1;KB.find('#modal-confirm-button').replace(buildButton())}
function buildButton(){var button=KB.dom('button').click(onSubmit).attr('id','modal-confirm-button').attr('type','button').attr('class','btn btn-red');if(isLoading){button.disable().add(KB.dom('i').attr('class','fa fa-spinner fa-pulse').build()).text(' ')}
if(options.tabindex){button.attr('tabindex',options.tabindex)}
return button.text(options.submitLabel).build()}
this.render=function(){KB.on('modal.stop',onStop);KB.on('modal.close',function(){KB.removeListener('modal.stop',onStop)});var element=KB.dom('div').attr('class','form-actions').add(buildButton()).text(' '+options.orLabel+' ').add(KB.dom('a').attr('href','#').click(onCancel).text(options.cancelLabel).build()).build();containerElement.appendChild(element)}});KB.component('external-task-view',function(containerElement,options){this.render=function(){KB.dom(containerElement).html('<div id="external-task-view"><i class="fa fa-spinner fa-2x fa-pulse"></div>');$.ajax({cache:!1,url:options.url,success:function(data){KB.dom(containerElement).html('<div id="external-task-view">'+data+'</div>')}})}});KB.component('file-upload',function(containerElement,options){var inputFileElement=null;var dropzoneElement=null;var files=[];var currentFileIndex=0;function onProgress(e){if(e.lengthComputable){var progress=e.loaded/e.total;var percentage=Math.floor(progress*100);KB.find('#file-progress-'+currentFileIndex).attr('value',progress);KB.find('#file-percentage-'+currentFileIndex).replaceText('('+percentage+'%)')}}
function onError(){var errorElement=KB.dom('div').addClass('file-error').text(options.labelUploadError).build();KB.find('#file-item-'+currentFileIndex).add(errorElement)}
function onServerError(response){var errorElement=KB.dom('div').addClass('file-error').text(response.message).build();KB.find('#file-item-'+currentFileIndex).add(errorElement);KB.trigger('modal.stop')}
function onRequestTooLarge(){var label=options.labelOversize?options.labelOversize:options.labelUploadError;var errorElement=KB.dom('div').addClass('file-error').text(label).build();KB.find('#file-item-'+currentFileIndex).add(errorElement)}
function onComplete(){currentFileIndex++;if(currentFileIndex<files.length){KB.http.uploadFile(options.url,files[currentFileIndex],options.csrf,onProgress,onComplete,onError,onServerError)}else{KB.trigger('modal.stop');KB.trigger('modal.hide');var alertElement=KB.dom('div').addClass('alert').addClass('alert-success').text(options.labelSuccess).build();var buttonElement=KB.dom('button').attr('type','button').addClass('btn').addClass('btn-blue').click(onCloseWindow).text(options.labelCloseSuccess).build();KB.dom(dropzoneElement).replace(KB.dom('div').add(alertElement).add(buttonElement).build())}}
function onCloseWindow(){window.location.reload()}
function onSubmit(){currentFileIndex=0;uploadFiles()}
function onFileChange(){for(var i=0;i<inputFileElement.files.length;i++){files.push(inputFileElement.files[i])}
showFiles()}
function onClickFileBrowser(){files=[];currentFileIndex=0;inputFileElement.click()}
function onDragOver(e){e.stopPropagation();e.preventDefault()}
function onDrop(e){e.stopPropagation();e.preventDefault();for(var i=0;i<e.dataTransfer.files.length;i++){files.push(e.dataTransfer.files[i])}
showFiles()}
function uploadFiles(){if(files.length>0){KB.http.uploadFile(options.url,files[currentFileIndex],options.csrf,onProgress,onComplete,onError,onServerError,onRequestTooLarge)}}
function showFiles(){if(files.length>0){KB.trigger('modal.enable');KB.dom(dropzoneElement).empty().add(buildFileListElement())}else{KB.trigger('modal.disable');KB.dom(dropzoneElement).empty().add(buildInnerDropzoneElement())}}
function buildFileInputElement(){return KB.dom('input').attr('id','file-input-element').attr('type','file').attr('name','files[]').attr('multiple',!0).on('change',onFileChange).hide().build()}
function buildInnerDropzoneElement(){var dropzoneLinkElement=KB.dom('a').attr('href','#').text(options.labelChooseFiles).click(onClickFileBrowser).build();return KB.dom('div').attr('id','file-dropzone-inner').text(options.labelDropzone+' '+options.labelOr+' ').add(dropzoneLinkElement).build()}
function buildDropzoneElement(){var dropzoneElement=KB.dom('div').attr('id','file-dropzone').add(buildInnerDropzoneElement()).build();dropzoneElement.ondragover=onDragOver;dropzoneElement.ondrop=onDrop;dropzoneElement.ondragover=onDragOver;return dropzoneElement}
function buildFileListItem(index){var isOversize=!1;var progressElement=KB.dom('progress').attr('id','file-progress-'+index).attr('value',0).build();var percentageElement=KB.dom('span').attr('id','file-percentage-'+index).text('(0%)').build();var deleteElement=KB.dom('span').attr('id','file-delete-'+index).html('<a href="#"><i class="fa fa-trash fa-fw"></i></a>').on('click',function(){files.splice(index,1);KB.find('#file-item-'+index).remove();showFiles()}).build();var itemElement=KB.dom('li').attr('id','file-item-'+index).add(deleteElement).add(progressElement).text(' '+files[index].name+' ').add(percentageElement);if(options.maxSize>0&&files[index].size>options.maxSize){itemElement.add(KB.dom('div').addClass('file-error').text(options.labelOversize).build());isOversize=!0}
if(isOversize){KB.trigger('modal.disable')}
return itemElement.build()}
function buildFileListElement(){var fileListElement=KB.dom('ul').attr('id','file-list').build();for(var i=0;i<files.length;i++){fileListElement.appendChild(buildFileListItem(i))}
return fileListElement}
this.render=function(){KB.on('modal.submit',onSubmit);KB.on('modal.close',function(){KB.removeListener('modal.submit',onSubmit)});inputFileElement=buildFileInputElement();dropzoneElement=buildDropzoneElement();containerElement.appendChild(inputFileElement);containerElement.appendChild(dropzoneElement)}});KB.onClick('.js-form-export',function(e){var formElement=document.querySelector('#modal-content form');var fromElement=formElement.querySelector('#form-from');var toElement=formElement.querySelector('#form-to');if(fromElement.value!==''&&toElement.value!==''){formElement.submit()}});KB.component('image-slideshow',function(containerElement,options){var currentImage;function onKeyDown(e){switch(KB.utils.getKey(e)){case 'Escape':destroySlide();break;case 'ArrowRight':renderNextSlide();break;case 'ArrowLeft':renderPreviousSlide();break}}
function onOverlayClick(element){if(element.matches('.slideshow-next-icon')){renderNextSlide()}else if(element.matches('.slideshow-previous-icon')){renderPreviousSlide()}else if(element.matches('.slideshow-download-icon')){window.location.href=element.href}else{destroySlide()}}
function onClick(element){var imageId=KB.dom(element).data('imageId');var image=getImage(imageId);renderSlide(image)}
function renderNextSlide(){destroySlide();for(var i=0;i<options.images.length;i++){if(options.images[i].id===currentImage.id){var index=i+1;if(index>=options.images.length){index=0}
currentImage=options.images[index];break}}
renderSlide()}
function renderPreviousSlide(){destroySlide();for(var i=0;i<options.images.length;i++){if(options.images[i].id===currentImage.id){var index=i-1;if(index<0){index=options.images.length-1}
currentImage=options.images[index];break}}
renderSlide()}
function renderSlide(){var closeElement=KB.dom('div').attr('class','fa fa-window-close slideshow-icon slideshow-close-icon').build();var downloadElement=KB.dom('a').attr('class','fa fa-download slideshow-icon slideshow-download-icon').attr('href',getUrl(currentImage,'download')).build();var previousElement=KB.dom('div').attr('class','fa fa-chevron-circle-left slideshow-icon slideshow-previous-icon').build();var nextElement=KB.dom('div').attr('class','fa fa-chevron-circle-right slideshow-icon slideshow-next-icon').build();var imageElement=KB.dom('img').attr('src',getUrl(currentImage,'image')).attr('alt',currentImage.name).attr('title',currentImage.name).style('maxHeight',(window.innerHeight-50)+'px').build();var captionElement=KB.dom('figcaption').text(currentImage.name).build();var figureElement=KB.dom('figure').add(imageElement).add(captionElement).build();var overlayElement=KB.dom('div').addClass('image-slideshow-overlay').add(closeElement).add(downloadElement).add(previousElement).add(nextElement).add(figureElement).click(onOverlayClick).build();document.body.appendChild(overlayElement);document.addEventListener('keydown',onKeyDown,!1)}
function destroySlide(){var overlayElement=KB.find('.image-slideshow-overlay');if(overlayElement!==null){document.removeEventListener('keydown',onKeyDown,!1);overlayElement.remove()}}
function getImage(imageId){for(var i=0;i<options.images.length;i++){if(options.images[i].id===imageId){return options.images[i]}}
return null}
function getUrl(image,type){var regex=new RegExp(options.regex,'g');return options.url[type].replace(regex,image.id)}
function buildThumbnailElement(image){return KB.dom('img').attr('src',getUrl(image,'thumbnail')).attr('alt',image.name).attr('title',image.name).data('imageId',image.id).click(onClick).build()}
this.render=function(){currentImage=options.image;containerElement.appendChild(buildThumbnailElement(currentImage))}});KB.keyboardShortcuts=function(){function goToLink(selector){if(!KB.modal.isOpen()){var element=KB.find(selector);if(element!==null){window.location=element.attr('href')}}}
function submitForm(){if(KB.modal.isOpen()){KB.modal.submitForm()}else{var forms=$("form");if(forms.length==1){forms.submit()}else if(forms.length>1){if(document.activeElement.tagName==='INPUT'||document.activeElement.tagName==='TEXTAREA'){$(document.activeElement).parents("form").submit()}}}}
KB.onKey('?',function(){if(!KB.modal.isOpen()){KB.modal.open(KB.find('body').data('keyboardShortcutUrl'),'',!0)}});KB.onKey('Escape',function(){if(!KB.exists('#suggest-menu')){KB.trigger('modal.close');_KB.get("Dropdown").close()}},!0);KB.onKey('Enter',submitForm,!0,!0);KB.onKey('Enter',submitForm,!0,!1,!0);KB.onKey('b',function(){if(!KB.modal.isOpen()){KB.trigger('board.selector.open')}});if(KB.exists('#board')){KB.onKey('c',function(){if(!KB.modal.isOpen()){_KB.get('BoardHorizontalScrolling').toggle()}});KB.onKey('s',function(){if(!KB.modal.isOpen()){_KB.get('BoardCollapsedMode').toggle()}});KB.onKey('n',function(){if(!KB.modal.isOpen()){KB.modal.open(KB.find('#board').data('taskCreationUrl'),'large',!0)}})}
if(KB.exists('#task-view')){KB.onKey('e',function(){if(!KB.modal.isOpen()){KB.modal.open(KB.find('#task-view').data('editUrl'),'large',!0)}});KB.onKey('c',function(){if(!KB.modal.isOpen()){KB.modal.open(KB.find('#task-view').data('commentUrl'),'medium',!0)}});KB.onKey('s',function(){if(!KB.modal.isOpen()){KB.modal.open(KB.find('#task-view').data('subtaskUrl'),'medium',!0)}});KB.onKey('l',function(){if(!KB.modal.isOpen()){KB.modal.open(KB.find('#task-view').data('internalLinkUrl'),'medium',!0)}})}
KB.onKey('f',function(){if(!KB.modal.isOpen()){KB.focus('#form-search')}});KB.onKey('r',function(){if(!KB.modal.isOpen()){var reset=$(".filter-reset").data("filter");var input=$("#form-search");input.val(reset);$("form.search").submit()}});KB.onKey('v+o',function(){goToLink('a.view-overview')});KB.onKey('v+b',function(){goToLink('a.view-board')});KB.onKey('v+l',function(){goToLink('a.view-listing')})};document.addEventListener("DOMContentLoaded",function(){function selectAllItems(event){event.preventDefault();var items=document.querySelectorAll("input[data-list-item=selectable]");for(var i=0;i<items.length;i++){items[i].checked=!0}
showActionMenu()}
function unselectAllItems(event){event.preventDefault();var items=document.querySelectorAll("input[data-list-item=selectable]");for(var i=0;i<items.length;i++){items[i].checked=!1}
hideActionMenu()}
function onItemChange(event){var selectedItems=document.querySelectorAll("input[data-list-item=selectable]:checked");if(selectedItems.length>0){showActionMenu()}else if(selectedItems.length==0){hideActionMenu()}}
function showActionMenu(){var element=document.querySelector(".list-item-actions");if(element){element.classList.remove("list-item-action-hidden")}}
function hideActionMenu(){var element=document.querySelector(".list-item-actions");if(element&&!element.classList.contains("list-item-action-hidden")){element.classList.add("list-item-action-hidden")}}
function onActionClick(event){event.preventDefault();var selectedItems=document.querySelectorAll("input[data-list-item=selectable]:checked");var taskIDs=[];for(var i=0;i<selectedItems.length;i++){taskIDs.push(selectedItems[i].value)}
var link=event.target.href+"&task_ids="+taskIDs.join(",");KB.modal.open(link,"medium",!0)}
var selectAllLink=document.querySelector("a[data-list-item-selection=all]");if(selectAllLink){selectAllLink.addEventListener("click",selectAllItems)}
var unselectLink=document.querySelector("a[data-list-item-selection=none]");if(unselectLink){unselectLink.addEventListener("click",unselectAllItems)}
var items=document.querySelectorAll("input[data-list-item=selectable]");for(var i=0;i<items.length;i++){items[i].addEventListener("change",onItemChange)}
KB.on('dropdown.afterRender',function(){var actionLinks=document.querySelectorAll("a[data-list-item-action=modal]");for(var i=0;i<actionLinks.length;i++){actionLinks[i].addEventListener("click",onActionClick,!1)}})});(function(){function getLink(e){if(e.target.tagName==='I'){return e.target.parentNode.getAttribute('href')}
return e.target.getAttribute('href')}
KB.onClick('.js-modal-large',function(e){KB.modal.open(getLink(e),'large',!0)});KB.onClick('.js-modal-medium',function(e){if(KB.modal.isOpen()){KB.modal.replace(getLink(e))}else{KB.modal.open(getLink(e),'medium',!0)}});KB.onClick('.js-modal-small',function(e){KB.modal.open(getLink(e),'small',!0)});KB.onClick('.js-modal-confirm',function(e){KB.modal.open(getLink(e),'small',!0)});KB.onClick('.js-modal-close',function(){KB.modal.close()});KB.onClick('.js-modal-replace',function(e){var link=getLink(e);if(KB.modal.isOpen()){KB.modal.replace(link)}else{window.location.href=link}})}());KB.onChange('.js-project-creation-select-options',function(element){var projectId=element.value;if(projectId==='0'){KB.find('.js-project-creation-options').hide()}else{KB.find('.js-project-creation-options').show()}});KB.component('project-select-role',function(containerElement,options){var isLoading=!1;var isSuccess=!1;var isError=!1;var componentElement;function onChange(element){isLoading=!0;options.role=element.value;replaceComponentElement();updateRole()}
function updateRole(){KB.http.postJson(options.url,{id:options.id,role:options.role}).success(function(){isLoading=!1;isSuccess=!0;replaceComponentElement()}).error(function(){isLoading=!1;isSuccess=!1;isError=!0;replaceComponentElement()})}
function replaceComponentElement(){KB.dom(componentElement).remove();componentElement=buildComponentElement();containerElement.appendChild(componentElement)}
function getAriaLabelValue(){if(options.ariaLabel){return options.ariaLabel}
return''}
function buildComponentElement(){var roles=[];var container=KB.dom('div');for(var role in options.roles){if(options.roles.hasOwnProperty(role)){var item={value:role,text:options.roles[role]};if(options.role===role){item.selected='selected'}
roles.push(item)}}
container.add(KB.dom('select').attr('aria-label',getAriaLabelValue()).change(onChange).for('option',roles).build());if(isLoading){container.text(' ');container.add(KB.dom('i').attr('class','fa fa-spinner fa-pulse fa-fw').build())}else if(isSuccess){container.text(' ');container.add(KB.dom('i').attr('class','fa fa-check fa-fw icon-fade-out icon-success').build())}else if(isError){container.text(' ');container.add(KB.dom('i').attr('class','fa fa-check fa-fw icon-fade-out icon-error').build())}
return container.build()}
this.render=function(){componentElement=buildComponentElement();containerElement.appendChild(componentElement)}});KB.component('screenshot',function(containerElement){var inputElement=null;function onFileLoaded(e){createImage(e.target.result)}
function onPaste(e){if(e.clipboardData&&e.clipboardData.items){var items=e.clipboardData.items;if(items){for(var i=0;i<items.length;i++){if(items[i].type.indexOf("image")!==-1){var blob=items[i].getAsFile();var reader=new FileReader();reader.onload=onFileLoaded;reader.readAsDataURL(blob)}}}}}
function initialize(){window.addEventListener('paste',onPaste,!1)}
function createImage(blob){var pastedImage=new Image();pastedImage.src=blob;pastedImage.onload=function(){var sourceSplit=blob.split('base64,');inputElement.value=sourceSplit[1]};var zone=document.getElementById('screenshot-zone');zone.innerHTML='';zone.className='screenshot-pasted';zone.appendChild(pastedImage);initialize()}
this.render=function(){inputElement=KB.dom('input').attr('type','hidden').attr('name','screenshot').build();containerElement.appendChild(inputElement);initialize()}});KB.component('select-dropdown-autocomplete',function(containerElement,options){var componentElement,inputElement,inputHiddenElement,chevronIconElement,loadingIconElement;function onLoadingStart(){KB.dom(loadingIconElement).show();KB.dom(chevronIconElement).hide()}
function onLoadingStop(){KB.dom(loadingIconElement).hide();KB.dom(chevronIconElement).show()}
function onScroll(){var menuElement=KB.find('#select-dropdown-menu');if(menuElement){var componentPosition=componentElement.getBoundingClientRect();menuElement.style('top',(document.body.scrollTop+componentPosition.bottom)+'px')}}
function onKeyDown(e){switch(KB.utils.getKey(e)){case 'Escape':inputElement.value='';destroyDropdownMenu();break;case 'ArrowUp':e.preventDefault();e.stopImmediatePropagation();moveUp();break;case 'ArrowDown':e.preventDefault();e.stopImmediatePropagation();moveDown();break;case 'Enter':e.preventDefault();e.stopImmediatePropagation();insertSelectedItem();break}}
function onInputChanged(){destroyDropdownMenu();renderDropdownMenu()}
function onItemMouseOver(element){if(KB.dom(element).hasClass('select-dropdown-menu-item')){KB.find('.select-dropdown-menu-item.active').removeClass('active');KB.dom(element).addClass('active')}}
function onItemClick(){insertSelectedItem()}
function onDocumentClick(e){if(!containerElement.contains(e.target)){inputElement.value='';destroyDropdownMenu()}}
function toggleDropdownMenu(){var menuElement=KB.find('#select-dropdown-menu');if(menuElement===null){renderDropdownMenu()}else{destroyDropdownMenu()}}
function insertSelectedItem(){var element=KB.find('.select-dropdown-menu-item.active');var value=element.data('value');inputHiddenElement.value=value;inputElement.value=options.items[value];destroyDropdownMenu();if(options.redirect){window.location=options.redirect.url.replace(new RegExp(options.redirect.regex,'g'),value)}else if(options.replace){onLoadingStart();KB.modal.replace(options.replace.url.replace(new RegExp(options.replace.regex,'g'),value))}}
function resetSelection(){var elements=document.querySelectorAll('.select-dropdown-menu-item');for(var i=0;i<elements.length;i++){if(KB.dom(elements[i]).hasClass('active')){KB.dom(elements[i]).removeClass('active');break}}
return{items:elements,index:i}}
function moveUp(){var result=resetSelection();if(result.index>0){result.index=result.index-1}
KB.dom(result.items[result.index]).addClass('active')}
function moveDown(){var result=resetSelection();if(result.index<result.items.length-1){result.index++}
KB.dom(result.items[result.index]).addClass('active')}
function buildItems(items){var elements=[];for(var key in items){if(items.hasOwnProperty(key)){elements.push({'class':'select-dropdown-menu-item','text':items[key],'data-label':items[key],'data-value':key})}}
if(options.sortByKeys){elements.sort(function(a,b){var value1=a['data-value'].toLowerCase();var value2=b['data-value'].toLowerCase();return value1<value2?-1:(value1>value2?1:0)})}else{elements.sort(function(a,b){var value1=a['data-label'].toLowerCase();var value2=b['data-label'].toLowerCase();return value1<value2?-1:(value1>value2?1:0)})}
return elements}
function filterItems(text,items){var filteredItems=[];var hasActiveItem=!1;for(var i=0;i<items.length;i++){if(text.length===0||items[i]['data-label'].toLowerCase().indexOf(text.toLowerCase())>-1){var item=items[i];if(typeof options.defaultValue!=='undefined'&&String(options.defaultValue)===item['data-value']){item.class+=' active';hasActiveItem=!0}
filteredItems.push(item)}}
if(!hasActiveItem&&filteredItems.length>0){filteredItems[0].class+=' active'}
return filteredItems}
function buildDropdownMenu(){var itemElements=filterItems(inputElement.value,buildItems(options.items));var componentPosition=componentElement.getBoundingClientRect();var windowPosition=document.body.scrollTop||document.documentElement.scrollTop;if(itemElements.length===0){return null}
return KB.dom('ul').attr('id','select-dropdown-menu').style('top',(windowPosition+componentPosition.bottom)+'px').style('left',componentPosition.left+'px').style('width',componentPosition.width+'px').style('maxHeight',(window.innerHeight-componentPosition.bottom-20)+'px').mouseover(onItemMouseOver).click(onItemClick).for('li',itemElements).build()}
function destroyDropdownMenu(){var menuElement=KB.find('#select-dropdown-menu');if(menuElement!==null){menuElement.remove()}
document.removeEventListener('keydown',onKeyDown,!1);document.removeEventListener('click',onDocumentClick,!1)}
function renderDropdownMenu(){var element=buildDropdownMenu();if(element!==null){document.body.appendChild(element)}
document.addEventListener('keydown',onKeyDown,!1);document.addEventListener('click',onDocumentClick,!1)}
function getPlaceholderValue(){if(options.defaultValue&&options.defaultValue in options.items){return options.items[options.defaultValue]}
if(options.placeholder){return options.placeholder}
return''}
function getAriaLabelValue(){if(options.ariaLabel){return options.ariaLabel}
return''}
this.render=function(){KB.on('select.dropdown.loading.start',onLoadingStart);KB.on('select.dropdown.loading.stop',onLoadingStop);KB.on('modal.close',function(){KB.removeListener('select.dropdown.loading.start',onLoadingStart);KB.removeListener('select.dropdown.loading.stop',onLoadingStop)});chevronIconElement=KB.dom('i').attr('class','fa fa-chevron-down select-dropdown-chevron').click(toggleDropdownMenu).build();loadingIconElement=KB.dom('span').hide().addClass('select-loading-icon').add(KB.dom('i').attr('class','fa fa-spinner fa-pulse').build()).build();inputHiddenElement=KB.dom('input').attr('type','hidden').attr('name',options.name).attr('value',options.defaultValue||'').build();inputElement=KB.dom('input').attr('type','text').attr('placeholder',getPlaceholderValue()).attr('aria-label',getAriaLabelValue()).addClass('select-dropdown-input').on('focus',toggleDropdownMenu).on('input',onInputChanged,!0).build();componentElement=KB.dom('div').addClass('select-dropdown-input-container').add(inputHiddenElement).add(inputElement).add(chevronIconElement).add(loadingIconElement).build();containerElement.appendChild(componentElement);if(options.onFocus){options.onFocus.forEach(function(eventName){KB.on(eventName,function(){inputElement.focus()})})}
window.addEventListener('scroll',onScroll,!1)}});KB.interval(60,function(){var statusUrl=KB.find('body').data('statusUrl');var loginUrl=KB.find('body').data('loginUrl');if(KB.find('.form-login')===null){KB.http.get(statusUrl).authError(function(){window.location=loginUrl})}});KB.component('submit-buttons',function(containerElement,options){var isLoading=!1;var isDisabled=options.disabled||!1;var submitLabel=options.submitLabel;var formActionElement=null;var submitButtonElement=null;function onSubmit(){isLoading=!0;replaceButton();KB.trigger('modal.submit')}
function onCancel(){KB.trigger('modal.close')}
function onStop(){isLoading=!1;replaceButton()}
function onDisable(){isLoading=!1;isDisabled=!0;replaceButton()}
function onEnable(){isLoading=!1;isDisabled=!1;replaceButton()}
function onHide(){KB.dom(formActionElement).hide()}
function onUpdateSubmitLabel(eventData){submitLabel=eventData.submitLabel;replaceButton()}
function buildButton(){var button=KB.dom('button').attr('type','submit').attr('class','btn btn-'+(options.color||'blue'));if(KB.modal.isOpen()){button.click(onSubmit)}
if(options.tabindex){button.attr('tabindex',options.tabindex)}
if(isLoading){button.disable().add(KB.dom('i').attr('class','fa fa-spinner fa-pulse').build()).text(' ')}
if(isDisabled){button.disable()}
return button.text(submitLabel).build()}
function replaceButton(){var buttonElement=buildButton();KB.dom(submitButtonElement).replace(buttonElement);submitButtonElement=buttonElement}
this.render=function(){KB.on('modal.stop',onStop);KB.on('modal.disable',onDisable);KB.on('modal.enable',onEnable);KB.on('modal.hide',onHide);KB.on('modal.submit.label',onUpdateSubmitLabel);KB.on('modal.close',function(){KB.removeListener('modal.stop',onStop);KB.removeListener('modal.disable',onDisable);KB.removeListener('modal.enable',onEnable);KB.removeListener('modal.hide',onHide);KB.removeListener('modal.submit.label',onUpdateSubmitLabel)});submitButtonElement=buildButton();var formActionElementBuilder=KB.dom('div').attr('class','form-actions').add(submitButtonElement);if(KB.modal.isOpen()){formActionElementBuilder.text(' '+options.orLabel+' ').add(KB.dom('a').attr('href','#').click(onCancel).text(options.cancelLabel).build())}
formActionElement=formActionElementBuilder.build();containerElement.appendChild(formActionElement)}});(function(){function savePosition(subtaskId,position){var url=$(".subtasks-table").data("save-position-url");$.ajax({cache:!1,url:url,contentType:"application/json",type:"POST",processData:!1,data:JSON.stringify({"subtask_id":subtaskId,"position":position})})}
function bootstrap(){$(".draggable-row-handle").mouseenter(function(){$(this).parent().parent().addClass("draggable-item-hover")}).mouseleave(function(){$(this).parent().parent().removeClass("draggable-item-hover")});$(".subtasks-table tbody").sortable({forcePlaceholderSize:!0,handle:"td:first i",helper:function(e,ui){ui.children().each(function(){$(this).width($(this).width())});return ui},stop:function(event,ui){var subtask=ui.item;subtask.removeClass("draggable-item-selected");savePosition(subtask.data("subtask-id"),subtask.index()+1)},start:function(event,ui){ui.item.addClass("draggable-item-selected")}}).disableSelection()}
KB.on('dom.ready',bootstrap);KB.on('subtasks.reloaded',bootstrap)}());KB.on('dom.ready',function(){$(document).on('click','.js-subtask-toggle-status',function(e){var el=$(this);var url=el.attr('href');e.preventDefault();$.ajax({cache:!1,url:url,success:function(data){if(url.indexOf('fragment=table')!=-1){$('.subtasks-table').replaceWith(data)}else if(url.indexOf('fragment=rows')!=-1){$(el).closest('.task-list-subtasks').replaceWith(data)}else{$(el).closest('.subtask-title').replaceWith(data)}
KB.trigger('subtasks.reloaded')}})});$(document).on('click','.js-subtask-toggle-timer',function(e){var el=$(this);e.preventDefault();$.ajax({cache:!1,url:el.attr('href'),success:function(data){$(el).closest('.subtask-time-tracking').replaceWith(data)}})})});KB.component('suggest-menu',function(containerElement,options){function onKeyDown(e){switch(KB.utils.getKey(e)){case 'Escape':destroy();break;case 'ArrowUp':e.preventDefault();e.stopImmediatePropagation();moveUp();break;case 'ArrowDown':e.preventDefault();e.stopImmediatePropagation();moveDown();break;case 'Enter':e.preventDefault();e.stopImmediatePropagation();insertSelectedItem();break}}
function onClick(){insertSelectedItem()}
function onMouseOver(element){if(KB.dom(element).hasClass('suggest-menu-item')){KB.find('.suggest-menu-item.active').removeClass('active');KB.dom(element).addClass('active')}}
function insertSelectedItem(){containerElement.focus();var element=KB.find('.suggest-menu-item.active');var value=element.data('value');var trigger=element.data('trigger');var content=containerElement.value;var text=getLastWord(containerElement);var substitute=trigger+value+' ';var selectionPosition=KB.utils.getSelectionPosition(containerElement);var before=content.substring(0,selectionPosition.selectionStart-text.length);var after=content.substring(selectionPosition.selectionEnd);var position=before.length+substitute.length;containerElement.value=before+substitute+after;containerElement.setSelectionRange(position,position);destroy()}
function getLastWord(element){var lines=element.value.substring(0,element.selectionEnd).split("\n");var lastLine=lines[lines.length-1];var words=lastLine.split(' ');return words[words.length-1]}
function getParentElement(){var selectors=['#modal-content form','#modal-content','body'];for(var i=0;i<selectors.length;i++){var element=document.querySelector(selectors[i]);if(element!==null){return element}}
return null}
function resetSelection(){var elements=document.querySelectorAll('.suggest-menu-item');for(var i=0;i<elements.length;i++){if(KB.dom(elements[i]).hasClass('active')){KB.dom(elements[i]).removeClass('active');break}}
return{items:elements,index:i}}
function moveUp(){var result=resetSelection();if(result.index>0){result.index=result.index-1}
KB.dom(result.items[result.index]).addClass('active')}
function moveDown(){var result=resetSelection();if(result.index<result.items.length-1){result.index++}
KB.dom(result.items[result.index]).addClass('active')}
function destroy(){var element=KB.find('#suggest-menu');if(element!==null){element.remove()}
document.removeEventListener('keydown',onKeyDown,!1)}
function search(element){var text=getLastWord(element);var trigger=getTrigger(text,options.triggers);destroy();if(trigger!==null){fetchItems(trigger,text.substring(trigger.length),options.triggers[trigger])}}
function getTrigger(text,triggers){for(var trigger in triggers){if(triggers.hasOwnProperty(trigger)&&text.indexOf(trigger)===0){return trigger}}
return null}
function fetchItems(trigger,text,params){if(typeof params==='string'){var regex=new RegExp('SEARCH_TERM','g');var url=params.replace(regex,text);KB.http.get(url).success(function(response){onItemFetched(trigger,text,response)})}else{onItemFetched(trigger,text,params)}}
function onItemFetched(trigger,text,items){items=filterItems(text,items);if(items.length>0){renderMenu(buildItems(trigger,items))}}
function filterItems(text,items){var filteredItems=[];if(text.length===0){return items}
for(var i=0;i<items.length;i++){if(items[i].value.toLowerCase().indexOf(text.toLowerCase())===0){filteredItems.push(items[i])}}
return filteredItems}
function buildItems(trigger,items){var elements=[];for(var i=0;i<items.length;i++){var className='suggest-menu-item';if(i===0){className+=' active'}
elements.push({class:className,html:items[i].html,'data-value':items[i].value,'data-trigger':trigger})}
return elements}
function renderMenu(items){var parentElement=getParentElement();var caretPosition=getCaretCoordinates(containerElement,containerElement.selectionEnd);var left=caretPosition.left+containerElement.offsetLeft-containerElement.scrollLeft;var top=caretPosition.top+containerElement.offsetTop-containerElement.scrollTop+16;document.addEventListener('keydown',onKeyDown,!1);var menu=KB.dom('ul').attr('id','suggest-menu').click(onClick).mouseover(onMouseOver).style('left',left+'px').style('top',top+'px').for('li',items).build();parentElement.appendChild(menu)}
this.render=function(){containerElement.addEventListener('input',function(){search(this)})}});KB.component('task-move-position',function(containerElement,options){function getSelectedValue(id){var element=KB.dom(document).find('#'+id);if(element){return parseInt(element.options[element.selectedIndex].value)}
return null}
function getSwimlaneId(){var swimlaneId=getSelectedValue('form-swimlanes');return swimlaneId===null?options.board[0].id:swimlaneId}
function getColumnId(){var columnId=getSelectedValue('form-columns');return columnId===null?options.board[0].columns[0].id:columnId}
function getPosition(){var position=getSelectedValue('form-position');return position===null?1:position}
function getPositionChoice(){var element=KB.find('input[name=positionChoice]:checked');if(element){return element.value}
return'before'}
function onSwimlaneChanged(){var columnSelect=KB.dom(document).find('#form-columns');KB.dom(columnSelect).replace(buildColumnSelect());var taskSection=KB.dom(document).find('#form-tasks');KB.dom(taskSection).replace(buildTasks())}
function onColumnChanged(){var taskSection=KB.dom(document).find('#form-tasks');KB.dom(taskSection).replace(buildTasks())}
function onError(message){KB.trigger('modal.stop');KB.find('#message-container').replace(KB.dom('div').attr('id','message-container').attr('class','alert alert-error').text(message).build())}
function onSubmit(){var position=getPosition();var positionChoice=getPositionChoice();if(positionChoice==='after'){position++}
KB.find('#message-container').replace(KB.dom('div').attr('id','message-container').build());KB.http.postJson(options.saveUrl,{"column_id":getColumnId(),"swimlane_id":getSwimlaneId(),"position":position}).error(function(response){if(response){onError(response.message)}})}
function buildSwimlaneSelect(){var swimlanes=[];options.board.forEach(function(swimlane){var option={'value':swimlane.id,'text':swimlane.name};if(swimlane.id==options.task.swimlane_id){option.selected=""}
swimlanes.push(option)});return KB.dom('select').attr('id','form-swimlanes').change(onSwimlaneChanged).for('option',swimlanes).build()}
function buildColumnSelect(){var columns=[];var swimlaneId=getSwimlaneId();options.board.forEach(function(swimlane){if(swimlaneId===swimlane.id){swimlane.columns.forEach(function(column){var option={'value':column.id,'text':column.title};if(column.id==options.task.column_id){option.selected=""}
columns.push(option)})}});return KB.dom('select').attr('id','form-columns').change(onColumnChanged).for('option',columns).build()}
function buildTasks(){var tasks=[];var swimlaneId=getSwimlaneId();var columnId=getColumnId();var container=KB.dom('div').attr('id','form-tasks');options.board.forEach(function(swimlane){if(swimlaneId===swimlane.id){swimlane.columns.forEach(function(column){if(columnId===column.id){column.tasks.forEach(function(task){tasks.push({'value':task.position,'text':'#'+task.id+' - '+task.title})})}})}});if(tasks.length>0){container.add(KB.html.label(options.positionLabel,'form-position')).add(KB.dom('select').attr('id','form-position').for('option',tasks).build()).add(KB.html.radio(options.beforeLabel,'positionChoice','before')).add(KB.html.radio(options.afterLabel,'positionChoice','after'))}
return container.build()}
this.render=function(){KB.on('modal.submit',onSubmit);KB.on('modal.close',function(){KB.removeListener('modal.submit',onSubmit)});var form=KB.dom('div').add(KB.dom('div').attr('id','message-container').build()).add(KB.html.label(options.swimlaneLabel,'form-swimlanes')).add(buildSwimlaneSelect()).add(KB.html.label(options.columnLabel,'form-columns')).add(buildColumnSelect()).add(buildTasks()).build();containerElement.appendChild(form)}});KB.onClick('.js-template',function(e){var template=KB.dom(e.target).data('template');var target=KB.dom(e.target).data('templateTarget');var targetField=KB.find(target);if(targetField){targetField.build().value=template}
_KB.controllers.Dropdown.close()});KB.component('text-editor',function(containerElement,options){var textarea,viewModeElement,writeModeElement,previewElement,selectionStart,selectionEnd;this.render=function(){writeModeElement=buildWriteMode();viewModeElement=buildViewMode();containerElement.appendChild(KB.dom('div').attr('class','text-editor').add(viewModeElement).add(writeModeElement).build());if(options.autofocus){textarea.focus()}};function buildViewMode(){var toolbarElement=KB.dom('div').attr('class','text-editor-toolbar').for('a',[{href:'#',html:'<i class="fa fa-pencil-square-o fa-fw"></i> '+options.labelWrite,click:function(){toggleViewMode()}}]).build();previewElement=KB.dom('div').attr('class','text-editor-preview-area markdown').build();return KB.dom('div').attr('class','text-editor-view-mode').add(toolbarElement).add(previewElement).hide().build()}
function buildWriteMode(){var toolbarElement=KB.dom('div').attr('class','text-editor-toolbar').for('a',[{href:'#',html:'<i class="fa fa-eye fa-fw"></i> '+options.labelPreview,click:function(){toggleViewMode()}},{href:'#',html:'<i class="fa fa-bold fa-fw"></i>',click:function(){insertEnclosedTag('**')}},{href:'#',html:'<i class="fa fa-italic fa-fw"></i>',click:function(){insertEnclosedTag('_')}},{href:'#',html:'<i class="fa fa-strikethrough fa-fw"></i>',click:function(){insertEnclosedTag('~~')}},{href:'#',html:'<i class="fa fa-link fa-fw"></i>',click:function(){insertLinkTag()}},{href:'#',html:'<i class="fa fa-quote-right fa-fw"></i>',click:function(){insertPrependTag('> ')}},{href:'#',html:'<i class="fa fa-list-ul fa-fw"></i>',click:function(){insertPrependTag('* ')}},{href:'#',html:'<i class="fa fa-code fa-fw"></i>',click:function(){insertBlockTag('```')}}]).build();var textareaElement=KB.dom('textarea');textareaElement.attr('name',options.name);if(options.tabindex){textareaElement.attr('tabindex',options.tabindex)}
if(options.required){textareaElement.attr('required','required')}
if(options.ariaLabel){textareaElement.attr('aria-label',options.ariaLabel)}
var textWrapper=KB.dom(containerElement).find('script');textareaElement.html(textWrapper.innerHTML);if(options.placeholder){textareaElement.attr('placeholder',options.placeholder)}
textarea=textareaElement.build();if(options.suggestOptions){KB.getComponent('suggest-menu',textarea,options.suggestOptions).render()}
return KB.dom('div').attr('class','text-editor-write-mode').add(toolbarElement).add(textarea).build()}
function toggleViewMode(){$.ajax({cache:!1,type:'POST',url:options.previewUrl,data:{'text':textarea.value},success:function(data){KB.dom(previewElement).html(data)}});KB.dom(viewModeElement).toggle();KB.dom(writeModeElement).toggle()}
function getSelectedText(){return textarea.value.substring(textarea.selectionStart,textarea.selectionEnd)}
function replaceTextRange(s,start,end,substitute){return s.substring(0,start)+substitute+s.substring(end)}
function insertEnclosedTag(tag){var selectedText=getSelectedText();insertText(tag+selectedText+tag);setCursorBeforeClosingTag(tag)}
function insertBlockTag(tag){var selectedText=getSelectedText();insertText('\n'+tag+'\n'+selectedText+'\n'+tag);setCursorBeforeClosingTag(tag,2)}
function insertPrependTag(tag){var selectedText=getSelectedText();if(selectedText.indexOf('\n')===-1){insertText('\n'+tag+selectedText)}else{var lines=selectedText.split('\n');for(var i=0;i<lines.length;i++){if(lines[i].indexOf(tag)===-1){lines[i]=tag+lines[i]}}
insertText(lines.join('\n'))}
setCursorBeforeClosingTag(tag,1)}
function insertLinkTag(){var selectedText=getSelectedText();var linkLabel=options.labelTitle;var linkUrl='http://...';var selectionStartOffset=0;var selectionEndOffset=0;if(selectedText.startsWith('http')){linkUrl=selectedText;selectionStartOffset=-1*(linkUrl.length+3+linkLabel.length);selectionEndOffset=selectionStartOffset+linkLabel.length}else if(selectedText.length>0){linkLabel=selectedText;selectionStartOffset=-1*(linkUrl.length+1);selectionEndOffset=selectionStartOffset+linkUrl.length}
insertText('['+linkLabel+']('+linkUrl+')');var selectionPosition=KB.utils.getSelectionPosition(textarea);var currentSelectionStart=selectionPosition.selectionStart;textarea.setSelectionRange(currentSelectionStart+selectionStartOffset,currentSelectionStart+selectionEndOffset)}
function insertText(replacedText){textarea.focus();var result=!1;var selectionPosition=KB.utils.getSelectionPosition(textarea);selectionStart=selectionPosition.selectionStart;selectionEnd=selectionPosition.selectionEnd;if(document.queryCommandSupported('insertText')){result=document.execCommand('insertText',!1,replacedText)}
if(!result){try{document.execCommand('ms-beginUndoUnit')}catch(error){}
textarea.value=replaceTextRange(textarea.value,selectionStart,selectionEnd,replacedText);try{document.execCommand('ms-endUndoUnit')}catch(error){}}}
function setCursorBeforeClosingTag(tag,offset){offset=offset||0;var position=selectionEnd+tag.length+offset;textarea.setSelectionRange(position,position)}});document.addEventListener('DOMContentLoaded',function(){KB.render();KB.listen();KB.keyboardShortcuts();KB.trigger('dom.ready')});var Kanboard={};Kanboard.App=function(){this.controllers={}};Kanboard.App.prototype.get=function(controller){return this.controllers[controller]};Kanboard.App.prototype.execute=function(){for(var className in Kanboard){if(className!=="App"){var controller=new Kanboard[className](this);this.controllers[className]=controller;if(typeof controller.execute==="function"){controller.execute()}
if(typeof controller.listen==="function"){controller.listen()}
if(typeof controller.focus==="function"){controller.focus()}}}
this.focus();this.datePicker();this.autoComplete();this.tagAutoComplete()};Kanboard.App.prototype.focus=function(){$(document).on('focus','.auto-select',function(){$(this).select()});$(document).on('mouseup','.auto-select',function(e){e.preventDefault()})};Kanboard.App.prototype.datePicker=function(){var bodyElement=$("body");var dateFormat=bodyElement.data("js-date-format");var timeFormat=bodyElement.data("js-time-format");var lang=$("html").attr("lang");$.datepicker.setDefaults($.datepicker.regional[lang]);$.timepicker.setDefaults($.timepicker.regional[lang]);$(".form-date").datepicker({showOtherMonths:!0,selectOtherMonths:!0,dateFormat:dateFormat,constrainInput:!1});$(".form-datetime").datetimepicker({controlType:'select',dateFormat:dateFormat,timeFormat:timeFormat,constrainInput:!1,amNames:['am','AM'],pmNames:['pm','PM']})};Kanboard.App.prototype.tagAutoComplete=function(){$(".tag-autocomplete").select2({tags:!0})};Kanboard.App.prototype.autoComplete=function(){$(".autocomplete").each(function(){var input=$(this);var field=input.data("dst-field");var extraFields=input.data("dst-extra-fields");if($('#form-'+field).val()===''){input.parent().find("button[type=submit]").attr('disabled','disabled')}
input.autocomplete({source:input.data("search-url"),minLength:1,select:function(event,ui){$("input[name="+field+"]").val(ui.item.id);if(extraFields){var fields=extraFields.split(',');for(var i=0;i<fields.length;i++){var fieldName=fields[i].trim();$("input[name="+fieldName+"]").val(ui.item[fieldName])}}
input.parent().find("button[type=submit]").removeAttr('disabled')}})})};Kanboard.App.prototype.hasId=function(id){return!!document.getElementById(id)};Kanboard.App.prototype.showLoadingIcon=function(){$("body").append('<span id="app-loading-icon">&nbsp;<i class="fa fa-spinner fa-spin"></i></span>')};Kanboard.App.prototype.hideLoadingIcon=function(){$("#app-loading-icon").remove()};Kanboard.BoardCollapsedMode=function(app){this.app=app};Kanboard.BoardCollapsedMode.prototype.toggle=function(){var self=this;this.app.showLoadingIcon();$.ajax({cache:!1,url:$('.filter-display-mode:not([style="display: none;"]) a').attr('href'),success:function(data){$('.filter-display-mode').toggle();self.app.get("BoardDragAndDrop").refresh(data)}})};Kanboard.BoardColumnView=function(app){this.app=app};Kanboard.BoardColumnView.prototype.execute=function(){if(this.app.hasId("board")){this.render()}};Kanboard.BoardColumnView.prototype.listen=function(){var self=this;$(document).on("click",".board-toggle-column-view",function(){self.toggle($(this).data("column-id"))})};Kanboard.BoardColumnView.prototype.onBoardRendered=function(){this.render()};Kanboard.BoardColumnView.prototype.render=function(){var self=this;$(".board-column-header").each(function(){var columnId=$(this).data('column-id');if(localStorage.getItem("hidden_column_"+columnId)){self.hideColumn(columnId)}})};Kanboard.BoardColumnView.prototype.toggle=function(columnId){if(localStorage.getItem("hidden_column_"+columnId)){this.showColumn(columnId)}else{this.hideColumn(columnId)}
this.app.get("BoardDragAndDrop").dragAndDrop()};Kanboard.BoardColumnView.prototype.hideColumn=function(columnId){$(".board-column-"+columnId+" .board-column-expanded").hide();$(".board-column-"+columnId+" .board-column-collapsed").show();$(".board-column-header-"+columnId+" .board-column-expanded").hide();$(".board-column-header-"+columnId+" .board-column-collapsed").show();$(".board-column-header-"+columnId).each(function(){$(this).removeClass("board-column-compact");$(this).addClass("board-column-header-collapsed")});$(".board-column-"+columnId).each(function(){$(this).addClass("board-column-task-collapsed")});$(".board-column-"+columnId+" .board-rotation").each(function(){$(this).css("width",$(".board-column-"+columnId+"").height())});localStorage.setItem("hidden_column_"+columnId,1)};Kanboard.BoardColumnView.prototype.showColumn=function(columnId){$(".board-column-"+columnId+" .board-column-expanded").show();$(".board-column-"+columnId+" .board-column-collapsed").hide();$(".board-column-header-"+columnId+" .board-column-expanded").show();$(".board-column-header-"+columnId+" .board-column-collapsed").hide();$(".board-column-header-"+columnId).removeClass("board-column-header-collapsed");$(".board-column-"+columnId).removeClass("board-column-task-collapsed");if(localStorage.getItem("horizontal_scroll")==0){$(".board-column-header-"+columnId).addClass("board-column-compact")}
localStorage.removeItem("hidden_column_"+columnId)};Kanboard.BoardHorizontalScrolling=function(app){this.app=app};Kanboard.BoardHorizontalScrolling.prototype.execute=function(){if(this.app.hasId("board")){this.render()}};Kanboard.BoardHorizontalScrolling.prototype.listen=function(){var self=this;$(document).on('click',".filter-toggle-scrolling",function(e){e.preventDefault();self.toggle()})};Kanboard.BoardHorizontalScrolling.prototype.onBoardRendered=function(){this.render()};Kanboard.BoardHorizontalScrolling.prototype.toggle=function(){var scrolling=localStorage.getItem("horizontal_scroll")||1;localStorage.setItem("horizontal_scroll",scrolling==0?1:0);this.render()};Kanboard.BoardHorizontalScrolling.prototype.render=function(){if(localStorage.getItem("horizontal_scroll")==0){$(".filter-wide").show();$(".filter-compact").hide();$("#board-container").addClass("board-container-compact");$("#board th:not(.board-column-header-collapsed)").addClass("board-column-compact")}else{$(".filter-wide").hide();$(".filter-compact").show();$("#board-container").removeClass("board-container-compact");$("#board th").removeClass("board-column-compact")}};Kanboard.BoardPolling=function(app){this.app=app};Kanboard.BoardPolling.prototype.execute=function(){if(this.app.hasId("board")){var interval=parseInt($("#board").attr("data-check-interval"));if(interval>0){window.setInterval(this.check.bind(this),interval*1000)}}};Kanboard.BoardPolling.prototype.check=function(){if(KB.utils.isVisible()&&!this.app.get("BoardDragAndDrop").savingInProgress){var self=this;this.app.showLoadingIcon();$.ajax({cache:!1,url:$("#board").data("check-url"),statusCode:{200:function(data){self.app.get("BoardDragAndDrop").refresh(data)},304:function(){self.app.hideLoadingIcon()}}})}};Kanboard.BoardVerticalScrolling=function(app){this.app=app};Kanboard.BoardVerticalScrolling.prototype.execute=function(){if(this.app.hasId("board")){this.render()}};Kanboard.BoardVerticalScrolling.prototype.listen=function(){var self=this;$(document).on('click',".filter-vert-toggle-collapse",function(e){e.preventDefault();self.toggle()})};Kanboard.BoardVerticalScrolling.prototype.onBoardRendered=function(){this.render()};Kanboard.BoardVerticalScrolling.prototype.toggle=function(){var self=this;var scrolling=localStorage.getItem("vertical_scroll")||1;localStorage.setItem("vertical_scroll",scrolling==0?1:0);var task_lists=$(".board-task-list");task_lists.each(function(){$(this).css("min-height","")});this.render();self.app.get("BoardDragAndDrop").dragAndDrop()};Kanboard.BoardVerticalScrolling.prototype.render=function(){if(localStorage.getItem("vertical_scroll")==0){$(".filter-vert-expand").show();$(".filter-vert-collapse").hide();$("#board td .board-task-list").addClass("board-task-list-compact")}else{$(".filter-vert-expand").hide();$(".filter-vert-collapse").show();$("#board td .board-task-list").removeClass("board-task-list-compact")}};Kanboard.Column=function(app){this.app=app};Kanboard.Column.prototype.listen=function(){this.dragAndDrop()};Kanboard.Column.prototype.dragAndDrop=function(){var self=this;$(".draggable-row-handle").mouseenter(function(){$(this).parent().parent().addClass("draggable-item-hover")}).mouseleave(function(){$(this).parent().parent().removeClass("draggable-item-hover")});$(".columns-table tbody").sortable({forcePlaceholderSize:!0,handle:"td:first i",helper:function(e,ui){ui.children().each(function(){$(this).width($(this).width())});return ui},stop:function(event,ui){var column=ui.item;column.removeClass("draggable-item-selected");self.savePosition(column.data("column-id"),column.index()+1)},start:function(event,ui){ui.item.addClass("draggable-item-selected")}}).disableSelection()};Kanboard.Column.prototype.savePosition=function(columnId,position){var url=$(".columns-table").data("save-position-url");var self=this;this.app.showLoadingIcon();$.ajax({cache:!1,url:url,contentType:"application/json",type:"POST",processData:!1,data:JSON.stringify({"column_id":columnId,"position":position}),complete:function(){self.app.hideLoadingIcon()}})};Kanboard.Dropdown=function(app){this.app=app};Kanboard.Dropdown.prototype.listen=function(){var self=this;$(document).on('click',function(){self.close()});$(document).on('click','.active-dropdown-menu',function(){self.close()});$(document).on('click','.dropdown-menu',function(e){e.preventDefault();e.stopImmediatePropagation();self.close();$(this).removeClass('dropdown-menu');$(this).addClass('active-dropdown-menu');var submenu=$(this).next('ul');var offset=$(this).offset();$("body").append(jQuery("<div>",{"id":"dropdown"}));submenu.clone().appendTo("#dropdown");var clone=$("#dropdown ul");clone.addClass('dropdown-submenu-open');var submenuHeight=clone.outerHeight();var submenuWidth=clone.outerWidth();if(offset.top+submenuHeight-$(window).scrollTop()<$(window).height()||$(window).scrollTop()+offset.top<submenuHeight){clone.css('top',offset.top+$(this).height())}else{clone.css('top',offset.top-submenuHeight-5)}
if(offset.left+submenuWidth>$(window).width()){var newOffset=offset.left-submenuWidth+$(this).outerWidth();if(newOffset<0){newOffset=15}
clone.css('left',newOffset)}else{clone.css('left',offset.left)}
if(document.getElementById('dropdown')!==null){KB.trigger('dropdown.afterRender')}});$(document).on('click','.dropdown-submenu-open li',function(e){if($(e.target).is('li')){KB.trigger('dropdown.clicked');var element=$(this).find('a:visible');if(element.length>0){element[0].click()}}})};Kanboard.Dropdown.prototype.close=function(){if(document.getElementById('dropdown')!==null){KB.trigger('dropdown.beforeDestroy')}
$('.active-dropdown-menu').addClass('dropdown-menu');$('.active-dropdown-menu').removeClass('active-dropdown-menu');$("#dropdown").remove()};Kanboard.Search=function(app){this.app=app};Kanboard.Search.prototype.focus=function(){$(document).on("focus","#form-search",function(){var input=$("#form-search");if(input[0].setSelectionRange){var len=input.val().length*2;input[0].setSelectionRange(len,len)}})};Kanboard.Search.prototype.listen=function(){$(document).on("click",".filter-helper",function(e){e.preventDefault();var filter=$(this).data("filter");var appendFilter=$(this).data("append-filter");var uniqueFilter=$(this).data("unique-filter");var input=$("#form-search");if(uniqueFilter){var attribute=uniqueFilter.substr(0,uniqueFilter.indexOf(':'));filter=input.val().replace(new RegExp('('+attribute+':[#a-z0-9]+)','g'),'');filter=filter.replace(new RegExp('('+attribute+':"(.+)")','g'),'');filter=filter.trim();filter+=' '+uniqueFilter}else if(appendFilter){filter=input.val()+" "+appendFilter}
input.val(filter);$("form.search").submit()})};Kanboard.Swimlane=function(app){this.app=app};Kanboard.Swimlane.prototype.execute=function(){if($(".swimlanes-table").length){this.dragAndDrop()}
if($("#board").length){this.expandSingleSwimlane()}};Kanboard.Swimlane.prototype.listen=function(){var self=this;$(document).on('click',".board-swimlane-toggle",function(e){e.preventDefault();var swimlaneId=$(this).data('swimlane-id');if(self.isCollapsed(swimlaneId)){self.expand(swimlaneId)}else{self.collapse(swimlaneId)}})};Kanboard.Swimlane.prototype.onBoardRendered=function(){var swimlaneIds=this.getAllCollapsed();for(var i=0;i<swimlaneIds.length;i++){this.collapse(swimlaneIds[i])}};Kanboard.Swimlane.prototype.getStorageKey=function(){return"hidden_swimlanes_"+$("#board").data("project-id")};Kanboard.Swimlane.prototype.expand=function(swimlaneId){var swimlaneIds=this.getAllCollapsed();var index=swimlaneIds.indexOf(swimlaneId);if(index>-1){swimlaneIds.splice(index,1)}
localStorage.setItem(this.getStorageKey(),JSON.stringify(swimlaneIds));$('.board-swimlane-columns-'+swimlaneId).css('display','table-row');$('.board-swimlane-tasks-'+swimlaneId).css('display','table-row');$('.hide-icon-swimlane-'+swimlaneId).css('display','inline');$('.show-icon-swimlane-'+swimlaneId).css('display','none')};Kanboard.Swimlane.prototype.collapse=function(swimlaneId){var swimlaneIds=this.getAllCollapsed();if(swimlaneIds.indexOf(swimlaneId)<0){swimlaneIds.push(swimlaneId);localStorage.setItem(this.getStorageKey(),JSON.stringify(swimlaneIds))}
$('.board-swimlane-columns-'+swimlaneId+':not(:first-child)').css('display','none');$('.board-swimlane-tasks-'+swimlaneId).css('display','none');$('.hide-icon-swimlane-'+swimlaneId).css('display','none');$('.show-icon-swimlane-'+swimlaneId).css('display','inline')};Kanboard.Swimlane.prototype.isCollapsed=function(swimlaneId){return this.getAllCollapsed().indexOf(swimlaneId)>-1};Kanboard.Swimlane.prototype.getAllCollapsed=function(){return JSON.parse(localStorage.getItem(this.getStorageKey()))||[]};Kanboard.Swimlane.prototype.dragAndDrop=function(){var self=this;$(".draggable-row-handle").mouseenter(function(){$(this).parent().parent().addClass("draggable-item-hover")}).mouseleave(function(){$(this).parent().parent().removeClass("draggable-item-hover")});$(".swimlanes-table tbody").sortable({forcePlaceholderSize:!0,handle:"td:first i",helper:function(e,ui){ui.children().each(function(){$(this).width($(this).width())});return ui},stop:function(event,ui){var swimlane=ui.item;swimlane.removeClass("draggable-item-selected");self.savePosition(swimlane.data("swimlane-id"),swimlane.index()+1)},start:function(event,ui){ui.item.addClass("draggable-item-selected")}}).disableSelection()};Kanboard.Swimlane.prototype.savePosition=function(swimlaneId,position){var url=$(".swimlanes-table").data("save-position-url");var self=this;this.app.showLoadingIcon();$.ajax({cache:!1,url:url,contentType:"application/json",type:"POST",processData:!1,data:JSON.stringify({"swimlane_id":swimlaneId,"position":position}),complete:function(){self.app.hideLoadingIcon()}})};Kanboard.Swimlane.prototype.expandSingleSwimlane=function(){if($("tr.board-swimlane").length==1){localStorage.removeItem(this.getStorageKey())}}
Kanboard.Task=function(app){this.app=app};Kanboard.Task.prototype.onPopoverOpened=function(){var self=this;self.renderColorPicker();$(document).on("click",".assign-me",function(e){var currentId=$(this).data("current-id");var dropdownId="#modal-box #"+$(this).data("target-id");e.preventDefault();if($(dropdownId+' option[value='+currentId+']').length){$(dropdownId).val(currentId)}})};Kanboard.Task.prototype.renderColorPicker=function(){function renderColorOption(color){return $('<div class="color-picker-option">'+'<div class="color-picker-square color-'+color.id+'"></div>'+'<div class="color-picker-label">'+color.text+'</div>'+'</div>')}
$(".color-picker").select2({minimumResultsForSearch:Infinity,templateResult:renderColorOption,templateSelection:renderColorOption})};Kanboard.BoardDragAndDrop=function(app){this.app=app;this.savingInProgress=!1};Kanboard.BoardDragAndDrop.prototype.execute=function(){if(this.app.hasId("board")){this.executeListeners();this.dragAndDrop()}};Kanboard.BoardDragAndDrop.prototype.dragAndDrop=function(){var self=this;var dropzone=$(".board-task-list");var params={forcePlaceholderSize:!0,tolerance:"pointer",connectWith:".sortable-column:visible",placeholder:"draggable-placeholder",items:".draggable-item",stop:function(event,ui){var task=ui.item;var taskId=task.attr('data-task-id');var taskPosition=task.attr('data-position');var taskColumnId=task.attr('data-column-id');var taskSwimlaneId=task.attr('data-swimlane-id');var newColumnId=task.parent().attr("data-column-id");var newSwimlaneId=task.parent().attr('data-swimlane-id');var newPosition=task.index()+1;task.removeClass("draggable-item-selected");if(newColumnId!=taskColumnId||newSwimlaneId!=taskSwimlaneId||newPosition!=taskPosition){self.changeTaskState(taskId);self.save(taskId,taskColumnId,newColumnId,newPosition,newSwimlaneId)}},start:function(event,ui){ui.item.addClass("draggable-item-selected");ui.placeholder.height(ui.item.height())}};if(isMobile.any){$(".task-board-sort-handle").css("display","inline");params.handle=".task-board-sort-handle"}
dropzone.each(function(){$(this).css("min-height",$(this).parent().height())});dropzone.sortable(params)};Kanboard.BoardDragAndDrop.prototype.changeTaskState=function(taskId){var task=$("div[data-task-id="+taskId+"]");task.addClass('task-board-saving-state');task.find('.task-board-saving-icon').show()};Kanboard.BoardDragAndDrop.prototype.save=function(taskId,srcColumnId,dstColumnId,position,swimlaneId){var self=this;self.app.showLoadingIcon();self.savingInProgress=!0;$.ajax({cache:!1,url:$("#board").data("save-url"),contentType:"application/json",type:"POST",processData:!1,data:JSON.stringify({"task_id":taskId,"src_column_id":srcColumnId,"dst_column_id":dstColumnId,"swimlane_id":swimlaneId,"position":position}),success:function(data){self.refresh(data);self.savingInProgress=!1},error:function(){self.app.hideLoadingIcon();self.savingInProgress=!1},statusCode:{403:function(data){window.alert(data.responseJSON.message);document.location.reload(!0)}}})};Kanboard.BoardDragAndDrop.prototype.refresh=function(data){$("#board-container").replaceWith(data);this.app.hideLoadingIcon();this.executeListeners();this.dragAndDrop()};Kanboard.BoardDragAndDrop.prototype.executeListeners=function(){for(var className in this.app.controllers){var controller=this.app.get(className);if(typeof controller.onBoardRendered==="function"){controller.onBoardRendered()}}};var _KB=null;jQuery(document).ready(function(){_KB=new Kanboard.App();_KB.execute()})