import pymysql
import sqlite3
from datetime import datetime, timedelta
from decimal import Decimal


class SinkronModel:
    def __init__(self):
        self.mysql_conn = pymysql.connect(
            host='192.168.5.14',
            user='beta',
            password='beta556699',
            database='beta_main_sb_pos',
            charset='utf8',
            cursorclass=pymysql.cursors.DictCursor
        )
        # Koneksi SQLite
        import sys
        import os
        from utils.path_utils import get_db_path
        BASE_DIR = os.path.abspath(os.path.join(sys.path[0]))  # Ini akan menunjuk ke lokasi app.py saat app dijalankan
        DB_PATH = get_db_path() # os.path.join(BASE_DIR, 'db', 'beta_sb_pos_sqlite.db')
        print("DB Path sinkron model:", DB_PATH)        # conn_sqlite = sqlite3.connect(db_path)

        # self.sqlite_conn = sqlite3.connect("z:/beta_desktop/db/beta_sb_pos_sqlite.db")
        self.sqlite_conn = sqlite3.connect(DB_PATH)
        self.sqlite_conn.execute("PRAGMA foreign_keys = ON")

    def close_connections(self):
        self.mysql_conn.close()
        self.sqlite_conn.close()



    def sync_table_last_update(self, table_name, key_column='id'):
        print(f'butuh sinkron tabelnya {table_name} ')
        def parse_datetime_safe(dt_str):
            if dt_str in ("0000-00-00 00:00:00", None, ""):
                return None  # atau default datetime.now(), sesuai kebutuhanmu
            try:
                return datetime.strptime(dt_str, "%Y-%m-%d %H:%M:%S")
            except Exception as e:
                print(f"⚠️ Gagal parse datetime: {dt_str}, error: {e}")
                return None

        cursor_mysql = self.mysql_conn.cursor()
        cursor_sqlite = self.sqlite_conn.cursor()

        try:
            # Ambil semua data dari server
            cursor_mysql.execute(f"SELECT * FROM `{table_name}`")
            server_rows = cursor_mysql.fetchall()

            if not server_rows:
                return 0

            # Ambil id dan last_update dari lokal
            # kosongkan tabel dahulu (FULL SINKRON, untuk delta sinkron cukup di coment)
            # cursor_sqlite.execute(f"DELETE FROM `{table_name}`")

            try:
                cursor_sqlite.execute(f"SELECT {key_column}, last_update FROM `{table_name}`")
                local_rows = cursor_sqlite.fetchall()

                local_map = {}
                for row in local_rows:
                    row_id = row[0]
                    raw_time = row[1]
                    if not raw_time:
                        continue
                    try:
                        # parsed_time = datetime.strptime(raw_time, "%Y-%m-%d %H:%M:%S")
                        parsed_time = parse_datetime_safe(raw_time)

                    except ValueError:
                        try:
                            parsed_time = datetime.strptime(raw_time, "%Y-%m-%d")
                            parsed_time = parsed_time.replace(hour=0, minute=0, second=0)
                        except ValueError:
                            continue
                    local_map[row_id] = parsed_time

            except sqlite3.OperationalError:
                local_map = {}

            updated_rows = []
            for row in server_rows:
                row_id = row[key_column]
                server_last_update = row.get("last_update")
                if not server_last_update:
                    continue

                if isinstance(server_last_update, str):
                    server_last_update = datetime.strptime(server_last_update, "%Y-%m-%d %H:%M:%S")

                local_last_update = local_map.get(row_id)
                if not local_last_update or server_last_update > local_last_update:
                    row_values = []
                    for value in row.values():
                        if isinstance(value, Decimal):
                            value = float(value)
                        elif isinstance(value, timedelta):
                            value = str(value)
                        elif isinstance(value, datetime):
                            value = value.strftime("%Y-%m-%d %H:%M:%S")
                        row_values.append(value)
                    updated_rows.append(tuple(row_values))

            if updated_rows:
                keys = server_rows[0].keys()
                columns = ', '.join([f'"{k}"' for k in keys])
                placeholders = ', '.join(['?' for _ in keys])
                cursor_sqlite.executemany(
                    f'INSERT OR REPLACE INTO `{table_name}` ({columns}) VALUES ({placeholders})',
                    updated_rows
                )
                self.sqlite_conn.commit()

            print(f'ini lho jumlah yang di sinrkon = {len(updated_rows)}')
            return len(updated_rows)

        except Exception as e:
            self.sqlite_conn.rollback()
            raise e
        
    # def is_data_updated(self, table_name):
    #     try:
    #         mysql_cursor = self.mysql_conn.cursor()
    #         sqlite_cursor = self.sqlite_conn.cursor()

    #         query = f"SELECT MAX(last_update) FROM `{table_name}`"

    #         # Ambil nilai maksimum last_update dari lokal
    #         sqlite_cursor.execute(query)
    #         local_max = sqlite_cursor.fetchone()[0]

    #         # Ambil nilai maksimum last_update dari server
    #         mysql_cursor.execute(query)
    #         server_max = mysql_cursor.fetchone()[0]

    #         # Bersihkan nilai kosong/invalid
    #         def is_invalid_date(value):
    #             return (
    #                 not value or
    #                 str(value).strip() in ["", "0", "0000-00-00 00:00:00", "None", None]
    #             )

    #         if is_invalid_date(local_max):
    #             print(f"[INFO] Tabel lokal '{table_name}' kosong/invalid. Perlu sinkron.")
    #             return True

    #         if is_invalid_date(server_max):
    #             print(f"[INFO] Tabel server '{table_name}' kosong/invalid. Tidak ada data baru.")
    #             return False

    #         # Format standar
    #         fmt = "%Y-%m-%d %H:%M:%S"

    #         # Normalisasi waktu jika hanya tanggal saja
    #         if isinstance(local_max, str) and len(local_max) == 10:
    #             local_max += " 00:00:00"
    #         if isinstance(server_max, str) and len(server_max) == 10:
    #             server_max += " 00:00:00"

    #         local_time = datetime.strptime(str(local_max), fmt)
    #         server_time = datetime.strptime(str(server_max), fmt)

    #         if server_time > local_time:
    #             print(f"[PERLU SINKRON] {table_name} server lebih baru: {server_time} > {local_time}")
    #             return True
    #         else:
    #             print(f"[UP-TO-DATE] {table_name} tidak berubah. Server: {server_time}, Lokal: {local_time}")
    #             return False

    #     except Exception as e:
    #         print(f"[ERROR] Gagal cek update data '{table_name}': {e}")
    #         return False  # fallback: tidak perlu sinkron jika gagal parsing

    # def is_data_updated(self, table_name):
    #     try:
    #         mysql_cursor = self.mysql_conn.cursor()
    #         sqlite_cursor = self.sqlite_conn.cursor()

    #         query = f"SELECT MAX(last_update) FROM `{table_name}`"
    #         print('0')
    #         # Ambil nilai maksimum last_update dari SQLite (lokal)
    #         sqlite_cursor.execute(query)
    #         local_max = sqlite_cursor.fetchone()[0]
    #         print('1')
    #         # Ambil nilai maksimum last_update dari MySQL (server)
    #         print(query)
    #         mysql_cursor.execute(query)
    #         server_max = mysql_cursor.fetchone()[0]
    #         print(server_max)
    #         print('2')

    #         # if not local_max:
    #         #     print(f"[INFO] Tabel lokal {table_name} kosong. Perlu sinkron.")
    #         #     return True

    #         # if not server_max:
    #         #     print(f"[INFO] Tabel server {table_name} kosong. Tidak ada data untuk disinkron.")
    #         #     return False

    #         # Format waktu
    #         fmt = "%Y-%m-%d %H:%M:%S"
    #         if isinstance(local_max, str) and len(local_max) == 10:
    #             local_max += " 00:00:00"
    #         if isinstance(server_max, str) and len(server_max) == 10:
    #             server_max += " 00:00:00"

    #         # Parsing datetime
    #         local_time = datetime.strptime(str(local_max), fmt)
    #         server_time = datetime.strptime(str(server_max), fmt)

    #         # Bandingkan waktu
    #         if server_time > local_time:
    #             print(f"[PERLU SINKRON] Server lebih baru: {server_time} > {local_time}")
    #             return True
    #         else:
    #             print(f"[UP-TO-DATE] Server: {server_time}, Lokal: {local_time}")
    #             return False

    #     except Exception as e:
    #         # if e>0:
    #             print(f"[ERROR] Gagal cek update data '{table_name}': {e}")

    #             return True  # fallback: anggap perlu sinkronisasi jika terjadi error

            # else:
            #     return False

    # def is_data_updated(self, table_name):
    #     try:
    #         mysql_cursor = self.mysql_conn.cursor()
    #         sqlite_cursor = self.sqlite_conn.cursor()

    #         query = f"SELECT MAX(last_update) FROM `{table_name}`"

    #         sqlite_cursor.execute(query)
    #         local_max = sqlite_cursor.fetchone()[0]

    #         mysql_cursor.execute(query)
    #         server_max = mysql_cursor.fetchone()[0]

    #         if not local_max or not server_max:
    #             return True  # Jika salah satu kosong, anggap perlu sinkron

    #         fmt = "%Y-%m-%d %H:%M:%S"
    #         if len(local_max) == 10:
    #             local_max += " 00:00:00"
    #         if len(server_max) == 10:
    #             server_max += " 00:00:00"

    #         local_time = datetime.strptime(local_max, fmt)
    #         server_time = datetime.strptime(server_max, fmt)

    #         return server_time > local_time

    #     except Exception as e:
    #         print(f"[jumlah is_data_updated error] {e}")
    #         return True  # fallback: anggap perlu sinkron jika error , aslinya True , belum paham maksudnya 

# kreasi tim 2 , fungsi is_data_updated digunakan untuk mengecek perlu tidak nya background sinkron
    def is_data_updated(self, table_name, key_column='id'):
        print(f'mengecek apakah tabel {table_name} butuh disinkron tidak')
        def parse_datetime_safe(dt_str):
            if dt_str in ("0000-00-00 00:00:00", None, ""):
                return None  # atau default datetime.now(), sesuai kebutuhanmu
            try:
                return datetime.strptime(dt_str, "%Y-%m-%d %H:%M:%S")
            except Exception as e:
                print(f"⚠️ Gagal parse datetime: {dt_str}, error: {e}")
                return None

        cursor_mysql = self.mysql_conn.cursor()
        cursor_sqlite = self.sqlite_conn.cursor()

        try:
            # Ambil semua data dari server
            cursor_mysql.execute(f"SELECT * FROM `{table_name}`")
            server_rows = cursor_mysql.fetchall()

            if not server_rows:
                return 0


            try:
                cursor_sqlite.execute(f"SELECT {key_column}, last_update FROM `{table_name}`")
                local_rows = cursor_sqlite.fetchall()

                local_map = {}
                for row in local_rows:
                    row_id = row[0]
                    raw_time = row[1]
                    if not raw_time:
                        continue
                    try:
                        # parsed_time = datetime.strptime(raw_time, "%Y-%m-%d %H:%M:%S")
                        parsed_time = parse_datetime_safe(raw_time)

                    except ValueError:
                        try:
                            parsed_time = datetime.strptime(raw_time, "%Y-%m-%d")
                            parsed_time = parsed_time.replace(hour=0, minute=0, second=0)
                        except ValueError:
                            continue
                    local_map[row_id] = parsed_time

            except sqlite3.OperationalError:
                local_map = {}

            updated_rows = []
            for row in server_rows:
                row_id = row[key_column]
                server_last_update = row.get("last_update")
                if not server_last_update:
                    continue

                if isinstance(server_last_update, str):
                    server_last_update = datetime.strptime(server_last_update, "%Y-%m-%d %H:%M:%S")

                local_last_update = local_map.get(row_id)
                if not local_last_update or server_last_update > local_last_update:
                    row_values = []
                    for value in row.values():
                        if isinstance(value, Decimal):
                            value = float(value)
                        elif isinstance(value, timedelta):
                            value = str(value)
                        elif isinstance(value, datetime):
                            value = value.strftime("%Y-%m-%d %H:%M:%S")
                        row_values.append(value)
                    updated_rows.append(tuple(row_values))

            if updated_rows:
                return True
            else:
                return False

        except Exception as e:
            self.sqlite_conn.rollback()
            raise e
