import sqlite3
from datetime import datetime, time
import hashlib
from utils.mysql_connector import get_mysql_connection,lengkapi_data_mysql,lengkapi_detail_transaksi  # asumsi modul kamu namanya begitu


class SettlementModel:
    def __init__(self, db_path):
        self.db_path = db_path

    def connect(self):
        from utils.path_utils import get_db_path
        return sqlite3.connect(get_db_path())

    def get_transaksi_belum_settle(self):
        conn = self.connect()
        conn.row_factory = sqlite3.Row
        cursor = conn.cursor()

        today = datetime.now().strftime("%Y-%m-%d")
        batas_waktu = f"{today} 20:00:00"
        print(f'batas waktu = {batas_waktu}')
        query = """
        SELECT id, dtime as tanggal, customers_nama AS customer, transaksi_nilai AS total
        FROM transaksi
        WHERE settlement_id = 1
        AND datetime(dtime) < ?
        ORDER BY datetime(dtime) ASC
        """
        cursor.execute(query, (batas_waktu,))
        rows = cursor.fetchall()
        conn.close()
        # print(dict(row) for row in rows)
        return [dict(row) for row in rows]

    def get_detail_transaksi(self, transaksi_id):
        conn = self.connect()
        conn.row_factory = sqlite3.Row
        cursor = conn.cursor()

        query = """
        SELECT produk_nama AS nama, produk_ord_jml as jumlah, produk_ord_hrg AS total
        FROM transaksi_data
        WHERE transaksi_id = ?
        """
        cursor.execute(query, (transaksi_id,))
        rows = cursor.fetchall()
        conn.close()

        return [dict(row) for row in rows]

    def get_list_admin(self):
        conn = self.connect()
        cursor = conn.cursor()

        query = """
        SELECT nama
        FROM per_employee
        WHERE LOWER(nama) LIKE 'admin%'
        """
        cursor.execute(query)
        results = cursor.fetchall()
        conn.close()

        return [row[0] for row in results]

    def verifikasi_admin(self, nama_admin, password_input):
        conn = self.connect()
        cursor = conn.cursor()

        query = """
        SELECT password
        FROM per_employee
        WHERE nama = ?
        """
        cursor.execute(query, (nama_admin,))
        result = cursor.fetchone()
        conn.close()

        if result:
            password_db = result[0]
            # Ubah input jadi hash MD5 dulu
            password_input_hash = hashlib.md5(password_input.encode()).hexdigest()
            return password_input_hash == password_db

        return False
    

    def set_settlement(self, transaksi_ids):
        import sqlite3

        # SQLite: koneksi lokal
        conn = self.connect()
        conn.row_factory = sqlite3.Row  # pastikan fetchone() mengembalikan dict-like row
        cursor = conn.cursor()

        # MySQL: koneksi server
        conn_server = get_mysql_connection()
        cursor_server = conn_server.cursor()

        try:
            # Ambil semua nomer transaksi dari ID dalam 1 query
            query_nomer_batch = f"""
                SELECT id, nomer FROM transaksi
                WHERE id IN ({','.join(['?'] * len(transaksi_ids))})
            """
            cursor.execute(query_nomer_batch, transaksi_ids)
            rows = cursor.fetchall()

            for row in rows:
                transaksi_id = row['id']
                nomer_transaksi = row['nomer']

                # Update lokal
                cursor.execute("""
                    UPDATE transaksi SET settlement_id = 0 WHERE id = ?
                """, (transaksi_id,))

                # Update server berdasarkan nomer
                cursor_server.execute("""
                    UPDATE transaksi SET settlement_id = 0 WHERE nomer = %s
                """, (nomer_transaksi,))

            conn.commit()
            conn_server.commit()

        except Exception as e:
            print("❌ Terjadi kesalahan saat update settlement:", str(e))
            conn.rollback()
            conn_server.rollback()

        finally:
            conn.close()
            conn_server.close()

    def cek_transaksi_settlement(self):
        try:
            from utils.path_utils import get_db_path
            conn = sqlite3.connect(get_db_path())
            print("DB Path:", get_db_path())
            conn.row_factory = sqlite3.Row
            cursor = conn.cursor()

            query = """
                SELECT * FROM transaksi 
                WHERE jenis_label = 'invoice' 
                AND settlement_id = 1 
                AND datetime(dtime, '+10 hours') < datetime('now')
            """
            cursor.execute(query)
            hasil = cursor.fetchall()

            # Konversi hasil ke list of dict agar bisa diolah
            result = [dict(row) for row in hasil]
            return result

        except sqlite3.Error as db_err:
            print(f"Kesalahan koneksi atau query SQLite: {db_err}", flush=True)
            return []  # Kembalikan list kosong agar tidak error di len(data)

        finally:
            cursor.close()
            conn.close()

    # def cek_status_settlement(self):
    #     data = self.cek_transaksi_settlement()
    #     self.settlement_result(data)

    # def settlement_result(self, data):
    #     print(f'masuk settlement result , jumlah data = {len(data)}')
    #     if len(data) > 0:
    #         self.transaksi_modal.exec()
    #         # self.load_master_transaksi()
    #         self.nonaktifkan_form()
    #         QMessageBox.warning(
    #             self.form_widget,
    #             "Perhatian",
    #             "Ada transaksi yang belum diselesaikan. Silakan selesaikan terlebih dahulu."
    #         )
    #     else:
    #         self.aktifkan_form()

    # def nonaktifkan_form(self):
    #     widget_types = [QLineEdit, QComboBox, QPushButton]
    #     for widget_type in widget_types:
    #         for widget in self.form_widget.findChildren(widget_type):
    #             widget.setEnabled(False)

    # def aktifkan_form(self):
    #     widget_types = [QLineEdit, QComboBox, QPushButton]
    #     for widget_type in widget_types:
    #         for widget in self.form_widget.findChildren(widget_type):
    #             widget.setEnabled(True)
