from PySide6.QtCore import QDateTime
from views.settlement_dialog_view import SettlementDialogView
from models.settlement_model import SettlementModel
from PySide6.QtCore import Qt
from PySide6.QtWidgets import QTableWidgetItem

class SettlementController:
    def __init__(self, db_path, user_info, parent_window=None):
        self.model = SettlementModel(db_path)
        self.view = SettlementDialogView(self)
        # self.load_transaksi()  # pastikan ini dipanggil

# class SettlementController:
#     def __init__(self, view,db_path, user_info, parent_window=None):
        self.user_info = user_info
        self.db_path = db_path
        # self.parent = parent_window

        # self.model = SettlementModel(db_path)
        # self.view = SettlementDialogView(view)
        # self.view = SettlementDialogView(view, self,user_info)

        self.setup_events()

        self.transaksi_data = []  # simpan transaksi master untuk referensi id
        print('masuk controller settel')
        self.load_transaksi()

    def show(self):
        self.view.exec()

    def setup_events(self):
        # dinon aktifkan dulu untuk tampilkan detailnya 
        # self.view.table_transaksi.cellClicked.connect(self.tampilkan_detail)
        self.view.uang_input.textChanged.connect(self.aktifkan_admin_section)
        self.view.cancel_button.clicked.connect(self.view.close)
        self.view.settle_button.clicked.connect(self.proses_settlement)

    def load_transaksi(self):
        self.transaksi_data = self.model.get_transaksi_belum_settle()

        print(f'[DEBUG] Jumlah transaksi: {len(self.transaksi_data)}')
        
        table = self.view.table_transaksi
        table.setRowCount(len(self.transaksi_data))
        # table.setColumnCount(5)
        # table.setHorizontalHeaderLabels(["ID", "Tanggal", "Customer", "Total", "Detail"])

        for row, data in enumerate(self.transaksi_data):
            print(f"[DEBUG] Isi data baris {row}: {data}")
            table.setItem(row, 0, QTableWidgetItem(str(data['id'])))
            table.setItem(row, 1, QTableWidgetItem(str(data['tanggal'])))
            table.setItem(row, 2, QTableWidgetItem(str(data['customer'])))
            table.setItem(row, 3, QTableWidgetItem(f"{data['total']:,.0f}"))

    def make_item(self, text):
        item = QTableWidgetItem(str(text))
        item.setFlags(item.flags() & ~Qt.ItemIsEditable)
        return item

    def tampilkan_detail(self, row, col):
        transaksi_id = self.transaksi_data[row]['id']
        detail_list = self.model.get_detail_transaksi(transaksi_id)

        detail_text = "\n".join(
            f"{d['nama']} x{d['jumlah']} = {d['total']:,}" for d in detail_list
        )
        self.view.tampilkan_detail_transaksi(detail_text)

    def aktifkan_admin_section(self):
        try:
            nilai = int(self.view.uang_input.text())
            if nilai > 0:
                admin_list = self.model.get_list_admin()
                self.view.tampilkan_admin_section(admin_list)
                self.view.settle_button.setEnabled(True)
        except ValueError:
            self.view.settle_button.setEnabled(False)
            self.view.admin_group.setVisible(False)

    def proses_settlement(self):
        admin_nama = self.view.admin_combo.currentText()
        password = self.view.password_input.text()

        if not self.model.verifikasi_admin(admin_nama, password):
            self.view.tampilkan_error("Password admin salah.")
            return

        # Proses update settlement_id semua transaksi
        transaksi_ids = [t['id'] for t in self.transaksi_data]
        self.model.set_settlement(transaksi_ids)

        self.view.tampilkan_pesan("Settlement berhasil disimpan.")
        self.view.close()
