<?php

namespace VentureDrake\LaravelCrm\Traits;

trait HasCrmAccess
{
    public function hasCrmAccess()
    {
        return $this->crm_access;
    }

    public function isCrmOwner()
    {
        return config('laravel-crm.crm_owner') == $this->email;
    }

    public function emails()
    {
        return $this->morphMany(\VentureDrake\LaravelCrm\Models\Email::class, 'emailable');
    }

    public function getPrimaryEmail()
    {
        return $this->emails()->where('primary', 1)->first();
    }

    public function phones()
    {
        return $this->morphMany(\VentureDrake\LaravelCrm\Models\Phone::class, 'phoneable');
    }

    public function getPrimaryPhone()
    {
        return $this->phones()->where('primary', 1)->first();
    }

    public function addresses()
    {
        return $this->morphMany(\VentureDrake\LaravelCrm\Models\Address::class, 'addressable');
    }

    public function getPrimaryAddress()
    {
        return $this->addresses()->where('primary', 1)->first();
    }

    public function crmSettings()
    {
        return $this->hasMany(\VentureDrake\LaravelCrm\Models\Setting::class);
    }
}
